/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunConfigurationListManagerHelper;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001a\u001a\u00020\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\u001c\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\u0006\u0010!\u001a\u00020\u001bJ\u0014\u0010\"\u001a\u00020\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\u0014\u0010$\u001a\u00020\u001b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&J\b\u0010'\u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR&\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/intellij/execution/impl/RunConfigurationListManagerHelper;", "", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "(Lcom/intellij/execution/impl/RunManagerImpl;)V", "customOrder", "Lcom/intellij/util/containers/ObjectIntHashMap;", "", "idToSettings", "Ljava/util/LinkedHashMap;", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getIdToSettings", "()Ljava/util/LinkedHashMap;", "immutableSortedSettingsList", "", "getImmutableSortedSettingsList", "()Ljava/util/List;", "setImmutableSortedSettingsList", "(Ljava/util/List;)V", "value", "", "isCustomOrderApplied", "setCustomOrderApplied", "(Z)V", "getManager", "()Lcom/intellij/execution/impl/RunManagerImpl;", "afterMakeStable", "", "buildImmutableSortedSettingsList", "checkIfDependenciesAreStable", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "list", "requestSort", "setCustomOrder", "order", "setOrder", "comparator", "Ljava/util/Comparator;", "sortAlphabetically", "intellij.platform.lang.impl"})
public final class RunConfigurationListManagerHelper {
    @NotNull
    private final LinkedHashMap<String, RunnerAndConfigurationSettings> idToSettings;
    private final ObjectIntHashMap<String> customOrder;
    private boolean isCustomOrderApplied;
    @Nullable
    private volatile List<? extends RunnerAndConfigurationSettings> immutableSortedSettingsList;
    @NotNull
    private final RunManagerImpl manager;

    @NotNull
    public final LinkedHashMap<String, RunnerAndConfigurationSettings> getIdToSettings() {
        return this.idToSettings;
    }

    private final void setCustomOrderApplied(boolean value) {
        if (this.isCustomOrderApplied != value) {
            this.isCustomOrderApplied = value;
            if (!value) {
                this.immutableSortedSettingsList = null;
            }
        }
    }

    @Nullable
    public final List<RunnerAndConfigurationSettings> getImmutableSortedSettingsList() {
        return this.immutableSortedSettingsList;
    }

    public final void setImmutableSortedSettingsList(@Nullable List<? extends RunnerAndConfigurationSettings> list2) {
        this.immutableSortedSettingsList = list2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOrder(@NotNull Comparator<RunnerAndConfigurationSettings> comparator2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(comparator2, (String)"comparator");
        Iterable iterable = this.idToSettings.values();
        Iterable destination$iv = new ArrayList(this.idToSettings.size());
        for (Object element$iv : $receiver$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
            if (!(!(it.getType() instanceof UnknownConfigurationType))) continue;
            destination$iv.add(element$iv);
        }
        ArrayList sorted = (ArrayList)destination$iv;
        CollectionsKt.sortWith((List)sorted, comparator2);
        this.customOrder.clear();
        this.customOrder.ensureCapacity(sorted.size());
        $receiver$iv = sorted;
        destination$iv = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void index;
            void settings;
            int n = index$iv$iv++;
            RunnerAndConfigurationSettings $i$f$filterTo = (RunnerAndConfigurationSettings)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            Integer n3 = this.customOrder.put((Object)settings.getUniqueID(), (int)index);
            collection.add(n3);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.immutableSortedSettingsList = null;
        this.setCustomOrderApplied(false);
    }

    public final void requestSort() {
        if (this.customOrder.isEmpty()) {
            this.sortAlphabetically();
        } else {
            this.setCustomOrderApplied(false);
        }
        this.immutableSortedSettingsList = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCustomOrder(@NotNull List<String> order) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(order, (String)"order");
        this.customOrder.clear();
        this.customOrder.ensureCapacity(order.size());
        Iterable iterable = $receiver$iv = (Iterable)order;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void index;
            void id;
            int n = index$iv$iv++;
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            Integer n3 = this.customOrder.put((Object)id, (int)index);
            collection.add(n3);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final void sortAlphabetically() {
        if (this.idToSettings.isEmpty()) {
            return;
        }
        List list2 = CollectionsKt.sortedWith((Iterable)this.idToSettings.values(), (Comparator)sortAlphabetically.list.1.INSTANCE);
        this.idToSettings.clear();
        for (RunnerAndConfigurationSettings settings : list2) {
            this.idToSettings.put(settings.getUniqueID(), settings);
        }
    }

    @NotNull
    public final List<RunnerAndConfigurationSettings> buildImmutableSortedSettingsList() {
        List<RunnerAndConfigurationSettings> list2 = this.immutableSortedSettingsList;
        if (list2 != null) {
            List<RunnerAndConfigurationSettings> list3;
            List<RunnerAndConfigurationSettings> it = list3 = list2;
            return it;
        }
        if (this.idToSettings.isEmpty()) {
            this.immutableSortedSettingsList = CollectionsKt.emptyList();
            List<RunnerAndConfigurationSettings> list4 = this.immutableSortedSettingsList;
            if (list4 == null) {
                Intrinsics.throwNpe();
            }
            return list4;
        }
        if (!this.isCustomOrderApplied && !this.customOrder.isEmpty()) {
            Collection<RunnerAndConfigurationSettings> $receiver$iv;
            Collection<RunnerAndConfigurationSettings> collection = $receiver$iv = this.idToSettings.values();
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection<RunnerAndConfigurationSettings> thisCollection$iv = collection;
            RunnerAndConfigurationSettings[] runnerAndConfigurationSettingsArray = thisCollection$iv.toArray(new RunnerAndConfigurationSettings[0]);
            if (runnerAndConfigurationSettingsArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            RunnerAndConfigurationSettings[] list5 = runnerAndConfigurationSettingsArray;
            SmartList folderNames = new SmartList();
            int n = list5.length;
            for (int i = 0; i < n; ++i) {
                RunnerAndConfigurationSettings settings = list5[i];
                String folderName = settings.getFolderName();
                if (folderName == null || folderNames.contains((Object)folderName)) continue;
                folderNames.add((Object)folderName);
            }
            List list6 = (List)folderNames;
            Comparator comparator2 = NaturalComparator.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"NaturalComparator.INSTANCE");
            CollectionsKt.sortWith((List)list6, (Comparator)comparator2);
            folderNames.add(null);
            ArraysKt.sortWith((Object[])list5, (Comparator)new Comparator<RunnerAndConfigurationSettings>(this, folderNames){
                final /* synthetic */ RunConfigurationListManagerHelper this$0;
                final /* synthetic */ SmartList $folderNames;

                public final int compare(RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
                    int n;
                    boolean temporary2;
                    int i2;
                    int i1;
                    if (Intrinsics.areEqual((Object)o1.getFolderName(), (Object)o2.getFolderName()) ^ true && (i1 = this.$folderNames.indexOf((Object)o1.getFolderName())) != (i2 = this.$folderNames.indexOf((Object)o2.getFolderName()))) {
                        return i1 - i2;
                    }
                    boolean temporary1 = o1.isTemporary();
                    if (temporary1 == (temporary2 = o2.isTemporary())) {
                        int index1 = RunConfigurationListManagerHelper.access$getCustomOrder$p(this.this$0).get((Object)o1.getUniqueID());
                        int index2 = RunConfigurationListManagerHelper.access$getCustomOrder$p(this.this$0).get((Object)o2.getUniqueID());
                        if (index1 == -1 && index2 == -1) {
                            String string = o1.getName();
                            String string2 = o2.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"o2.name");
                            n = string.compareTo(string2);
                        } else {
                            n = index1 - index2;
                        }
                    } else {
                        n = temporary1 ? 1 : -1;
                    }
                    return n;
                }
                {
                    this.this$0 = runConfigurationListManagerHelper;
                    this.$folderNames = smartList;
                }
            });
            this.setCustomOrderApplied(true);
            this.idToSettings.clear();
            for (RunnerAndConfigurationSettings settings : list5) {
                this.idToSettings.put(settings.getUniqueID(), settings);
            }
        }
        List<RunnerAndConfigurationSettings> result2 = Collections.unmodifiableList(CollectionsKt.toList((Iterable)this.idToSettings.values()));
        this.immutableSortedSettingsList = result2;
        List<RunnerAndConfigurationSettings> list7 = result2;
        Intrinsics.checkExpressionValueIsNotNull(list7, (String)"result");
        return list7;
    }

    public final void afterMakeStable() {
        this.immutableSortedSettingsList = null;
        if (!this.customOrder.isEmpty()) {
            this.setCustomOrderApplied(false);
        }
    }

    public final void checkIfDependenciesAreStable(@NotNull RunConfiguration configuration, @NotNull List<? extends RunnerAndConfigurationSettings> list2) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        for (BeforeRunTask runTask : configuration.getBeforeRunTasks()) {
            RunnerAndConfigurationSettings runTaskSettings;
            BeforeRunTask beforeRunTask = runTask;
            if (!(beforeRunTask instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)) {
                beforeRunTask = null;
            }
            RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runConfigurableBeforeRunTask = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)beforeRunTask;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = runTaskSettings = runConfigurableBeforeRunTask != null ? runConfigurableBeforeRunTask.getSettings() : null;
            if (runnerAndConfigurationSettings == null) continue;
            if (!runnerAndConfigurationSettings.isTemporary()) continue;
            this.manager.makeStable(runTaskSettings);
            RunConfiguration runConfiguration = runTaskSettings.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)runConfiguration, (String)"runTaskSettings.configuration");
            this.checkIfDependenciesAreStable(runConfiguration, list2);
        }
        if (configuration instanceof CompoundRunConfiguration) {
            Map<RunConfiguration, ExecutionTarget> children2 = ((CompoundRunConfiguration)configuration).getConfigurationsWithTargets(this.manager);
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : list2) {
                RunConfiguration otherConfiguration;
                if (!runnerAndConfigurationSettings.isTemporary() || (otherConfiguration = runnerAndConfigurationSettings.getConfiguration()) == configuration || !ContainerUtil.containsIdentity((Iterable)children2.keySet(), (Object)otherConfiguration) || !runnerAndConfigurationSettings.isTemporary()) continue;
                this.manager.makeStable(runnerAndConfigurationSettings);
                RunConfiguration runConfiguration = otherConfiguration;
                Intrinsics.checkExpressionValueIsNotNull((Object)runConfiguration, (String)"otherConfiguration");
                this.checkIfDependenciesAreStable(runConfiguration, list2);
            }
        }
    }

    @NotNull
    public final RunManagerImpl getManager() {
        return this.manager;
    }

    public RunConfigurationListManagerHelper(@NotNull RunManagerImpl manager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)manager), (String)"manager");
        this.manager = manager;
        this.idToSettings = new LinkedHashMap();
        this.customOrder = new ObjectIntHashMap();
        this.isCustomOrderApplied = true;
        this.immutableSortedSettingsList = CollectionsKt.emptyList();
    }

    @NotNull
    public static final /* synthetic */ ObjectIntHashMap access$getCustomOrder$p(RunConfigurationListManagerHelper $this) {
        return $this.customOrder;
    }
}

