/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTestProxy
extends CompositePrintable {
    public static final DataKey<AbstractTestProxy> DATA_KEY = DataKey.create((String)"testProxy");
    public static final DataKey<AbstractTestProxy[]> DATA_KEYS = DataKey.create((String)"testProxies");
    protected Printer myPrinter = null;

    public abstract boolean isInProgress();

    public abstract boolean isDefect();

    public abstract boolean shouldRun();

    public abstract int getMagnitude();

    public abstract boolean isLeaf();

    public abstract boolean isInterrupted();

    public abstract boolean hasPassedTests();

    public abstract boolean isIgnored();

    public abstract boolean isPassed();

    public abstract String getName();

    public abstract boolean isConfig();

    public abstract Location getLocation(@NotNull Project var1, @NotNull GlobalSearchScope var2);

    public abstract Navigatable getDescriptor(@Nullable Location var1, @NotNull TestConsoleProperties var2);

    public abstract AbstractTestProxy getParent();

    public abstract List<? extends AbstractTestProxy> getChildren();

    public abstract List<? extends AbstractTestProxy> getAllTests();

    @Nullable
    public Long getDuration() {
        return null;
    }

    @Nullable
    public String getDurationString(TestConsoleProperties consoleProperties) {
        return null;
    }

    public abstract boolean shouldSkipRootNodeForExport();

    public void fireOnNewPrintable(@NotNull Printable printable) {
        if (printable == null) {
            AbstractTestProxy.$$$reportNull$$$0(0);
        }
        if (this.myPrinter != null) {
            this.myPrinter.onNewAvailable(printable);
        }
    }

    public void setPrinter(Printer printer) {
        this.myPrinter = printer;
        for (AbstractTestProxy abstractTestProxy : this.getChildren()) {
            abstractTestProxy.setPrinter(printer);
        }
    }

    @Override
    public void addLast(@NotNull Printable printable) {
        if (printable == null) {
            AbstractTestProxy.$$$reportNull$$$0(1);
        }
        super.addLast(printable);
        this.fireOnNewPrintable(printable);
    }

    @Override
    public void insert(@NotNull Printable printable, int i) {
        if (printable == null) {
            AbstractTestProxy.$$$reportNull$$$0(2);
        }
        super.insert(printable, i);
        this.fireOnNewPrintable(printable);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (AbstractTestProxy abstractTestProxy : this.getChildren()) {
            Disposer.dispose((Disposable)abstractTestProxy);
        }
    }

    @Deprecated
    public static void flushOutput(AbstractTestProxy testProxy) {
        testProxy.flush();
        for (AbstractTestProxy parent = testProxy.getParent(); parent != null; parent = parent.getParent()) {
            List<? extends AbstractTestProxy> children2 = parent.getChildren();
            if (testProxy.isInProgress() || !testProxy.equals(children2.get(children2.size() - 1))) break;
            parent.flush();
            testProxy = parent;
        }
    }

    @Override
    public int getExceptionMark() {
        if (this.myExceptionMark == 0 && this.getChildren().size() > 0) {
            return this.getChildren().get(0).getExceptionMark();
        }
        return this.myExceptionMark;
    }

    @NotNull
    public List<DiffHyperlink> getDiffViewerProviders() {
        DiffHyperlink provider = this.getDiffViewerProvider();
        List<Object> list2 = provider == null ? Collections.emptyList() : Collections.singletonList(provider);
        if (list2 == null) {
            AbstractTestProxy.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public DiffHyperlink getDiffViewerProvider() {
        return null;
    }

    @Nullable
    public String getLocationUrl() {
        return null;
    }

    @Nullable
    public String getMetainfo() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/AbstractTestProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/AbstractTestProxy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffViewerProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fireOnNewPrintable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addLast";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

