/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ArrayUtilRt;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class PsiCopyPasteManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.PsiCopyPasteManagerImpl");
    private MyData myRecentData;
    private final CopyPasteManagerEx myCopyPasteManager;
    private static final DataFlavor ourDataFlavor;

    public static PsiCopyPasteManager getInstance() {
        return (PsiCopyPasteManager)ServiceManager.getService(PsiCopyPasteManager.class);
    }

    public PsiCopyPasteManager(CopyPasteManager copyPasteManager) {
        this.myCopyPasteManager = (CopyPasteManagerEx)copyPasteManager;
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(Project project) {
                if (PsiCopyPasteManager.this.myRecentData != null && PsiCopyPasteManager.this.myRecentData.getProject() == project) {
                    PsiCopyPasteManager.this.myRecentData = null;
                }
                Transferable[] contents = PsiCopyPasteManager.this.myCopyPasteManager.getAllContents();
                for (int i = contents.length - 1; i >= 0; --i) {
                    Transferable t = contents[i];
                    if (!(t instanceof MyTransferable) || ((MyTransferable)t).myDataProxy.getProject() != project) continue;
                    PsiCopyPasteManager.this.myCopyPasteManager.removeContent(t);
                }
            }
        });
    }

    @Nullable
    public PsiElement[] getElements(boolean[] isCopied) {
        try {
            Object transferData = this.myCopyPasteManager.getContents(ourDataFlavor);
            if (!(transferData instanceof MyData)) {
                return null;
            }
            MyData dataProxy = (MyData)transferData;
            if (!Comparing.equal((Object)dataProxy, (Object)this.myRecentData)) {
                return null;
            }
            if (isCopied != null) {
                isCopied[0] = this.myRecentData.isCopied();
            }
            return this.myRecentData.getElements();
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    @Nullable
    static PsiElement[] getElements(Transferable content) {
        Object transferData;
        if (content == null) {
            return null;
        }
        try {
            transferData = content.getTransferData(ourDataFlavor);
        }
        catch (UnsupportedFlavorException | InvalidDnDOperationException | IOException e) {
            return null;
        }
        return transferData instanceof MyData ? ((MyData)transferData).getElements() : null;
    }

    public void clear() {
        this.myRecentData = null;
        this.myCopyPasteManager.setContents(new StringSelection(""));
    }

    public void setElements(PsiElement[] elements, boolean copied) {
        this.myRecentData = new MyData(elements, copied);
        this.myCopyPasteManager.setContents(new MyTransferable(this.myRecentData));
    }

    public boolean isCutElement(Object element) {
        if (this.myRecentData == null) {
            return false;
        }
        if (this.myRecentData.isCopied()) {
            return false;
        }
        PsiElement[] elements = this.myRecentData.getElements();
        if (elements == null) {
            return false;
        }
        for (PsiElement aElement : elements) {
            if (aElement != element) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static List<File> asFileList(PsiElement[] elements) {
        ArrayList<File> result2 = new ArrayList<File>();
        for (PsiElement element : elements) {
            VirtualFile vFile;
            PsiFileSystemItem psiFile;
            if (element instanceof PsiFileSystemItem) {
                psiFile = (PsiFileSystemItem)element;
            } else if (element instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories();
                if (directories.length == 0) {
                    LOG.error("No directories for " + element + " of " + element.getClass());
                    return null;
                }
                psiFile = directories[0];
            } else {
                psiFile = element.getContainingFile();
            }
            if (psiFile == null || (vFile = psiFile.getVirtualFile()) == null || !(vFile.getFileSystem() instanceof LocalFileSystem)) continue;
            result2.add(new File(vFile.getPath()));
        }
        return result2.isEmpty() ? null : result2;
    }

    static {
        try {
            Class<MyData> flavorClass = MyData.class;
            Thread currentThread = Thread.currentThread();
            ClassLoader currentLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(flavorClass.getClassLoader());
                ourDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + flavorClass.getName());
            }
            finally {
                currentThread.setContextClassLoader(currentLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MyTransferable
    implements Transferable {
        private static final DataFlavor[] DATA_FLAVORS_COPY = new DataFlavor[]{PsiCopyPasteManager.access$300(), DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor};
        private static final DataFlavor[] DATA_FLAVORS_CUT = new DataFlavor[]{PsiCopyPasteManager.access$300(), DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor, LinuxDragAndDropSupport.kdeCutMarkFlavor};
        private final MyData myDataProxy;

        public MyTransferable(MyData data) {
            this.myDataProxy = data;
        }

        public MyTransferable(PsiElement[] selectedValues) {
            this(new MyData(selectedValues, true));
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            Object result2 = this.getTransferDataOrNull(flavor);
            if (result2 == null) {
                throw new IOException();
            }
            return result2;
        }

        @Nullable
        private Object getTransferDataOrNull(DataFlavor flavor) throws UnsupportedFlavorException {
            if (ourDataFlavor.equals(flavor)) {
                return this.myDataProxy;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.getDataAsText();
            }
            if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                return this.getDataAsFileList();
            }
            if (flavor.equals(LinuxDragAndDropSupport.uriListFlavor)) {
                List<File> files = this.getDataAsFileList();
                return files == null ? null : LinuxDragAndDropSupport.toUriList(files);
            }
            if (flavor.equals(LinuxDragAndDropSupport.gnomeFileListFlavor)) {
                List<File> files = this.getDataAsFileList();
                if (files == null) {
                    return null;
                }
                String string = (this.myDataProxy.isCopied() ? "copy\n" : "cut\n") + LinuxDragAndDropSupport.toUriList(files);
                return new ByteArrayInputStream(string.getBytes(CharsetToolkit.UTF8_CHARSET));
            }
            if (flavor.equals(LinuxDragAndDropSupport.kdeCutMarkFlavor) && !this.myDataProxy.isCopied()) {
                return new ByteArrayInputStream("1".getBytes(CharsetToolkit.UTF8_CHARSET));
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Nullable
        private String getDataAsText() {
            return (String)ReadAction.compute(() -> {
                String names = Stream.of(this.myDataProxy.getElements()).filter(PsiNamedElement.class::isInstance).map(e -> ((PsiNamedElement)e).getName()).filter(Objects::nonNull).collect(Collectors.joining("\n"));
                return names.isEmpty() ? null : names;
            });
        }

        @Nullable
        private List<File> getDataAsFileList() {
            return (List)ReadAction.compute(() -> PsiCopyPasteManager.asFileList(this.myDataProxy.getElements()));
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.myDataProxy.isCopied() ? DATA_FLAVORS_COPY : DATA_FLAVORS_CUT;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ArrayUtilRt.find((Object[])this.getTransferDataFlavors(), (Object)flavor) != -1;
        }

        public PsiElement[] getElements() {
            return this.myDataProxy.getElements();
        }
    }

    public static class MyData {
        private PsiElement[] myElements;
        private final boolean myIsCopied;

        public MyData(PsiElement[] elements, boolean copied) {
            this.myElements = elements;
            this.myIsCopied = copied;
        }

        public PsiElement[] getElements() {
            if (this.myElements == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            ReadAction.run(() -> {
                int validElementsCount = 0;
                for (PsiElement element : this.myElements) {
                    if (!element.isValid()) continue;
                    ++validElementsCount;
                }
                if (validElementsCount != this.myElements.length) {
                    PsiElement[] validElements = new PsiElement[validElementsCount];
                    int j = 0;
                    for (PsiElement element : this.myElements) {
                        if (!element.isValid()) continue;
                        validElements[j++] = element;
                    }
                    this.myElements = validElements;
                }
            });
            return this.myElements;
        }

        public boolean isCopied() {
            return this.myIsCopied;
        }

        @Nullable
        public Project getProject() {
            if (this.myElements == null || this.myElements.length == 0) {
                return null;
            }
            PsiElement element = this.myElements[0];
            return element.isValid() ? element.getProject() : null;
        }
    }
}

