/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CustomChangelistTodoTreeStructure;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class CustomChangelistTodosTreeBuilder
extends TodoTreeBuilder {
    public static final TodoItem[] EMPTY_ITEMS = new TodoItem[0];
    private final Project myProject;
    private final String myTitle;
    private final MultiMap<PsiFile, TodoItem> myMap;
    private final Set<PsiFile> myIncludedFiles;
    private PsiTodoSearchHelper myPsiTodoSearchHelper;
    private final ChangeListManager myChangeListManager;

    public CustomChangelistTodosTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project, String title, List<TodoItem> list2) {
        super(tree, treeModel, project);
        this.myProject = project;
        this.myTitle = title;
        this.myMap = new MultiMap();
        this.myIncludedFiles = new HashSet<PsiFile>();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.initMap(list2);
        this.initHelper();
    }

    private void initMap(List<TodoItem> list2) {
        this.buildMap(list2);
        this.myIncludedFiles.addAll(this.myMap.keySet());
    }

    private void buildMap(List<TodoItem> list2) {
        for (TodoItem todoItem : list2) {
            this.myMap.putValue((Object)todoItem.getFile(), (Object)todoItem);
        }
    }

    private void initHelper() {
        this.myPsiTodoSearchHelper = new PsiTodoSearchHelper(){

            @NotNull
            public PsiFile[] findFilesWithTodoItems() {
                ArrayList<Change> changes = new ArrayList<Change>();
                List changeLists = CustomChangelistTodosTreeBuilder.this.myChangeListManager.getChangeLists();
                HashMap<VirtualFile, Change> allChanges = new HashMap<VirtualFile, Change>();
                for (LocalChangeList changeList : changeLists) {
                    Collection currChanges = changeList.getChanges();
                    for (Change currChange : currChanges) {
                        if (currChange.getAfterRevision() == null || currChange.getAfterRevision().getFile().getVirtualFile() == null) continue;
                        allChanges.put(currChange.getAfterRevision().getFile().getVirtualFile(), currChange);
                    }
                }
                for (PsiFile next : CustomChangelistTodosTreeBuilder.this.myIncludedFiles) {
                    Change change = (Change)allChanges.get(next.getVirtualFile());
                    if (change == null) continue;
                    changes.add(change);
                }
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(CustomChangelistTodosTreeBuilder.this.myProject, changes, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
                worker.execute();
                CustomChangelistTodosTreeBuilder.this.buildMap(worker.inOneList());
                Set files = CustomChangelistTodosTreeBuilder.this.myMap.keySet();
                PsiFile[] psiFileArray = files.toArray(PsiFile.EMPTY_ARRAY);
                if (psiFileArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiFileArray;
            }

            @NotNull
            public TodoItem[] findTodoItems(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                TodoItem[] todoItemArray = CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file2, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
                if (todoItemArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return todoItemArray;
            }

            @NotNull
            public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                TodoItem[] todoItemArray = this.findTodoItems(file2);
                if (todoItemArray == null) {
                    1.$$$reportNull$$$0(4);
                }
                return todoItemArray;
            }

            @NotNull
            public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2, int startOffset, int endOffset) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                TodoItem[] todoItemArray = this.findTodoItems(file2, startOffset, endOffset);
                if (todoItemArray == null) {
                    1.$$$reportNull$$$0(6);
                }
                return todoItemArray;
            }

            @NotNull
            public TodoItem[] findTodoItems(@NotNull PsiFile file2, int startOffset, int endOffset) {
                TodoItem[] todoItems;
                if (file2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((todoItems = this.findTodoItems(file2)).length == 0) {
                    if (todoItems == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return todoItems;
                }
                TextRange textRange = new TextRange(startOffset, endOffset);
                ArrayList<TodoItem> result2 = new ArrayList<TodoItem>();
                for (TodoItem todoItem : todoItems) {
                    if (!todoItem.getTextRange().contains(textRange)) continue;
                    result2.add(todoItem);
                }
                TodoItem[] todoItemArray = result2.isEmpty() ? EMPTY_ITEMS : result2.toArray(new TodoItem[0]);
                if (todoItemArray == null) {
                    1.$$$reportNull$$$0(9);
                }
                return todoItemArray;
            }

            public int getTodoItemsCount(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(10);
                }
                return this.findTodoItems(file2).length;
            }

            public int getTodoItemsCount(@NotNull PsiFile file2, @NotNull TodoPattern pattern) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (pattern == null) {
                    1.$$$reportNull$$$0(12);
                }
                TodoFilter filter2 = new TodoFilter();
                filter2.addTodoPattern(pattern);
                return CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file2, filter2).length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findFilesWithTodoItems";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1";
                        break;
                    }
                    case 2: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findTodoItems";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findTodoItemsLight";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "findTodoItems";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "findTodoItemsLight";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "getTodoItemsCount";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private TodoItem[] findPatternedTodoItems(PsiFile file2, TodoFilter todoFilter) {
        Collection todoItems;
        if (!this.myIncludedFiles.contains(file2)) {
            return EMPTY_ITEMS;
        }
        if (this.myDirtyFileSet.contains(file2.getVirtualFile())) {
            this.myMap.remove((Object)file2);
            Change change = this.myChangeListManager.getChange(file2.getVirtualFile());
            if (change != null) {
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, Collections.singletonList(change), todoFilter);
                worker.execute();
                List<TodoItem> todoItems2 = worker.inOneList();
                if (todoItems2 != null && !todoItems2.isEmpty()) {
                    for (TodoItem todoItem : todoItems2) {
                        this.myMap.putValue((Object)file2, (Object)todoItem);
                    }
                }
            }
        }
        return (todoItems = this.myMap.get((Object)file2)) == null || todoItems.isEmpty() ? EMPTY_ITEMS : todoItems.toArray(new TodoItem[0]);
    }

    @Override
    @NotNull
    protected TodoTreeStructure createTreeStructure() {
        CustomChangelistTodoTreeStructure customChangelistTodoTreeStructure = new CustomChangelistTodoTreeStructure(this.myProject, this.myPsiTodoSearchHelper);
        if (customChangelistTodoTreeStructure == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(0);
        }
        return customChangelistTodoTreeStructure;
    }

    @Override
    void rebuildCache() {
        this.myMap.clear();
        this.myFileTree.clear();
        this.myDirtyFileSet.clear();
        this.myFile2Highlighter.clear();
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        PsiFile[] psiFiles = this.myPsiTodoSearchHelper.findFilesWithTodoItems();
        for (int i = 0; i < psiFiles.length; ++i) {
            PsiFile psiFile = psiFiles[i];
            if (this.myPsiTodoSearchHelper.getTodoItemsCount(psiFile) <= 0 || !treeStructure.accept(psiFile)) continue;
            this.myFileTree.add(psiFile.getVirtualFile());
        }
        treeStructure.validateCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder", "createTreeStructure"));
    }
}

