/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaCheckBoxUI
extends MetalCheckBoxUI {
    private static final Icon DEFAULT_ICON = ((EmptyIcon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)19))).asUIResource();

    public static ComponentUI createUI(JComponent c) {
        if (UIUtil.getParentOfType(CellRendererPane.class, (Component)c) != null) {
            c.setBorder(null);
        }
        return new DarculaCheckBoxUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(JBUI.scale((int)4));
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        Dimension size = c.getSize();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)c.getInsets());
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        this.drawCheckIcon(c, g, b, iconRect, b.isSelected(), b.isEnabled());
        this.drawText(c, g, b, fm, textRect, text);
    }

    protected void drawCheckIcon(JComponent c, Graphics2D g, AbstractButton b, Rectangle iconRect, boolean selected, boolean enabled) {
        String iconName = this.isIndeterminate(b) ? "checkBoxIndeterminate" : "checkBox";
        Icon icon = MacIntelliJIconCache.getIcon(iconName, selected || this.isIndeterminate(b), c.hasFocus(), b.isEnabled());
        icon.paintIcon(c, g, iconRect.x, iconRect.y);
    }

    protected void drawText(JComponent c, Graphics2D g, AbstractButton b, FontMetrics fm, Rectangle textRect, String text) {
        if (text != null) {
            View view = (View)c.getClientProperty("html");
            if (view != null) {
                view.paint(g, textRect);
            } else {
                g.setColor(b.isEnabled() ? b.getForeground() : this.getDisabledTextColor());
                int mnemonicIndex = SystemInfo.isMac && !UIManager.getBoolean("Button.showMnemonics") ? -1 : b.getDisplayedMnemonicIndex();
                SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }

    protected boolean isIndeterminate(AbstractButton checkBox) {
        return "indeterminate".equals(checkBox.getClientProperty("JButton.selectedState")) || checkBox instanceof ThreeStateCheckBox && ((ThreeStateCheckBox)checkBox).getState() == ThreeStateCheckBox.State.DONT_CARE;
    }
}

