/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class DarculaSpinnerUI
extends BasicSpinnerUI {
    private static final int ARROW_WIDTH = 7;
    private static final int ARROW_HEIGHT = 5;
    protected JButton prevButton;
    protected JButton nextButton;
    private FocusAdapter myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            DarculaSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarculaSpinnerUI.this.spinner.repaint();
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarculaSpinnerUI();
    }

    private void addEditorFocusListener(JComponent editor) {
        if (editor != null) {
            editor.getComponents()[0].addFocusListener(this.myFocusListener);
        }
    }

    private void removeEditorFocusListener(JComponent editor) {
        if (editor != null) {
            editor.getComponents()[0].removeFocusListener(this.myFocusListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeEditorFocusListener(this.spinner.getEditor());
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        this.removeEditorFocusListener(oldEditor);
        this.addEditorFocusListener(newEditor);
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = super.createEditor();
        this.addEditorFocusListener(editor);
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float bw = DarculaUIUtil.bw();
            float arc = DarculaUIUtil.arc();
            g2.setColor(this.getBackground());
            g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getBackground() {
        return this.spinner.isEnabled() && this.spinner.getEditor() != null ? this.spinner.getEditor().getComponent(0).getBackground() : UIUtil.getPanelBackground();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        return this.getSizeWithButtons(c.getInsets(), size);
    }

    protected Dimension getSizeWithButtons(Insets i, Dimension size) {
        Dimension arrowSize = this.nextButton.getPreferredSize();
        Dimension minSize = new Dimension(i.left + JBUI.scale((int)20) + arrowSize.width, arrowSize.height * 2);
        size = DarculaUIUtil.isEmpty(size) ? minSize : new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        JBDimension editorSize = this.spinner.getEditor() != null ? this.spinner.getEditor().getPreferredSize() : JBUI.emptySize();
        return new Dimension(Math.max(size.width, i.left + editorSize.width + arrowSize.width), Math.max(size.height, i.top + editorSize.height + i.bottom));
    }

    protected JButton createButton(int direction, String name) {
        JButton button = this.createArrow(direction);
        button.setName(name);
        button.setBorder((Border)JBUI.Borders.empty());
        if (direction == 1) {
            this.installNextButtonListeners(button);
        } else {
            this.installPreviousButtonListeners(button);
        }
        return button;
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = this.createButton(5, "Spinner.previousButton");
        return this.prevButton;
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = this.createButton(1, "Spinner.nextButton");
        return this.nextButton;
    }

    @Override
    protected LayoutManager createLayout() {
        return new LayoutManagerDelegate(super.createLayout()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                DarculaSpinnerUI.this.layout();
            }
        };
    }

    protected void layout() {
        int w = this.spinner.getWidth();
        int h = this.spinner.getHeight();
        Dimension abSize = this.nextButton.getPreferredSize();
        this.nextButton.setBounds(w - abSize.width, JBUI.scale((int)1), abSize.width, h / 2);
        this.prevButton.setBounds(w - abSize.width, h / 2, abSize.width, h - h / 2);
    }

    protected void paintArrowButton(Graphics g, BasicArrowButton button, int direction) {
        Insets i = this.spinner.getInsets();
        int x = (button.getWidth() - i.right - JBUI.scale((int)7)) / 2;
        int y = direction == 1 ? button.getHeight() - JBUI.scale((int)2) : JBUI.scale((int)2);
        button.paintTriangle(g, x, y, 0, direction, this.spinner.isEnabled());
    }

    private JButton createArrow(int direction) {
        BasicArrowButton b = new BasicArrowButton(direction){

            @Override
            public void paint(Graphics g) {
                DarculaSpinnerUI.this.paintArrowButton(g, this, this.direction);
            }

            @Override
            public boolean isOpaque() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                    float lw = DarculaUIUtil.lw(g2);
                    float bw = DarculaUIUtil.bw();
                    g2.setColor(DarculaUIUtil.getArrowButtonFillColor(DarculaSpinnerUI.this.spinner.hasFocus(), isEnabled, DarculaSpinnerUI.this.spinner.getBackground()));
                    g2.fill(this.getInnerShape(lw, bw));
                    int h = this.getHeight() - JBUI.scale((int)1);
                    Rectangle2D.Float sideLine = direction == 1 ? new Rectangle2D.Float(0.0f, bw + lw, lw, (float)h - (bw + lw)) : new Rectangle2D.Float(0.0f, 0.0f, lw, (float)h - (bw + lw));
                    g2.setColor(DarculaUIUtil.getArrowButtonFillColor(DarculaSpinnerUI.this.spinner.hasFocus(), isEnabled, DarculaUIUtil.getOutlineColor(isEnabled)));
                    g2.fill(sideLine);
                    g2.translate(x, y);
                    g2.setColor((Color)new JBColor((Color)Gray._255, isEnabled ? this.getForeground() : DarculaUIUtil.getOutlineColor(false)));
                    g2.fill(this.getArrowShape());
                }
                finally {
                    g2.dispose();
                }
            }

            private Shape getInnerShape(float lw, float bw) {
                Path2D.Float shape = new Path2D.Float();
                int w = this.getWidth() - JBUI.scale((int)1);
                int h = this.getHeight() - JBUI.scale((int)1);
                float arc = DarculaUIUtil.arc() - bw - lw;
                switch (this.direction) {
                    case 5: {
                        ((Path2D)shape).moveTo(lw, 0.0);
                        ((Path2D)shape).lineTo((float)w - bw - lw, 0.0);
                        ((Path2D)shape).lineTo((float)w - bw - lw, (float)h - bw - lw - arc);
                        ((Path2D)shape).quadTo((float)w - bw - lw, (float)h - bw - lw, (float)w - bw - lw - arc, (float)h - bw - lw);
                        ((Path2D)shape).lineTo(lw, (float)h - bw - lw);
                        shape.closePath();
                        break;
                    }
                    case 1: {
                        ((Path2D)shape).moveTo(lw, bw + lw);
                        ((Path2D)shape).lineTo((float)w - bw - lw - arc, bw + lw);
                        ((Path2D)shape).quadTo((float)w - bw - lw, bw + lw, (float)w - bw - lw, bw + lw + arc);
                        ((Path2D)shape).lineTo((float)w - bw - lw, h);
                        ((Path2D)shape).lineTo(lw, h);
                        shape.closePath();
                        break;
                    }
                }
                return shape;
            }

            private Shape getArrowShape() {
                Path2D.Float arrow = new Path2D.Float();
                int aw = JBUI.scale((int)7);
                int ah = JBUI.scale((int)5);
                switch (this.direction) {
                    case 5: {
                        ((Path2D)arrow).moveTo(0.0, 0.0);
                        ((Path2D)arrow).lineTo(aw, 0.0);
                        ((Path2D)arrow).lineTo((double)aw / 2.0, ah);
                        arrow.closePath();
                        break;
                    }
                    case 1: {
                        ((Path2D)arrow).moveTo(0.0, 0.0);
                        ((Path2D)arrow).lineTo(aw, 0.0);
                        ((Path2D)arrow).lineTo((double)aw / 2.0, -ah);
                        arrow.closePath();
                        break;
                    }
                }
                return arrow;
            }

            @Override
            public Dimension getPreferredSize() {
                Insets i = DarculaSpinnerUI.this.spinner.getInsets();
                return new Dimension(JBUI.scale((int)12) + i.left, JBUI.scale((int)9) + (this.direction == 1 ? i.top : i.bottom));
            }
        };
        b.setInheritsPopupMenu(true);
        b.setBorder((Border)JBUI.Borders.empty());
        return b;
    }

    protected static class LayoutManagerDelegate
    implements LayoutManager {
        protected final LayoutManager myDelegate;

        public LayoutManagerDelegate(LayoutManager delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.myDelegate.addLayoutComponent(name, comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.myDelegate.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.myDelegate.preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.myDelegate.minimumLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.myDelegate.layoutContainer(parent);
        }
    }
}

