/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.ide.ui.laf.intellij.MacComboBoxBorder;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ui.Gray;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacIntelliJComboBoxUI
extends DarculaComboBoxUI {
    private static final Border ourDefaultEditorBorder = JBUI.Borders.empty((int)1, (int)0);
    private Icon DEFAULT_ICON;
    private PropertyChangeListener myEditorChangeListener;
    private PropertyChangeListener myEditorBorderChangeListener;
    private PropertyChangeListener myEditableChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.DEFAULT_ICON = EmptyIcon.create((Icon)MacIntelliJIconCache.getIcon("comboRight", this.comboBox.isEditable(), false, false, true));
        this.comboBox.setOpaque(false);
        this.comboBox.setBorder(new MacComboBoxBorder());
        this.myEditorBorderChangeListener = evt -> {
            Component component;
            Object value = evt.getNewValue();
            if (value == ourDefaultEditorBorder) {
                return;
            }
            ComboBoxEditor editor = ((JComboBox)c).getEditor();
            if (editor != null && (component = editor.getEditorComponent()) instanceof JComponent) {
                ((JComponent)component).setBorder(ourDefaultEditorBorder);
            }
        };
        this.myEditorChangeListener = evt -> {
            Component component;
            Object newValue;
            Component component2;
            Object oldValue = evt.getOldValue();
            if (oldValue instanceof ComboBoxEditor && (component2 = ((ComboBoxEditor)oldValue).getEditorComponent()) instanceof JComponent) {
                component2.removePropertyChangeListener("border", this.myEditorBorderChangeListener);
            }
            if ((newValue = evt.getNewValue()) instanceof ComboBoxEditor && (component = ((ComboBoxEditor)evt.getNewValue()).getEditorComponent()) instanceof JComponent) {
                JComponent comboBoxEditor = (JComponent)component;
                comboBoxEditor.setBorder(ourDefaultEditorBorder);
                comboBoxEditor.setOpaque(false);
                comboBoxEditor.addPropertyChangeListener("border", this.myEditorBorderChangeListener);
            }
        };
        c.addPropertyChangeListener("editor", this.myEditorChangeListener);
        this.myEditableChangeListener = evt -> {
            Boolean editable = (Boolean)evt.getNewValue();
            this.DEFAULT_ICON = EmptyIcon.create((Icon)MacIntelliJIconCache.getIcon("comboRight", editable, false, false, false));
            this.comboBox.invalidate();
        };
        c.addPropertyChangeListener("editable", this.myEditableChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        Component component;
        c.removePropertyChangeListener("editor", this.myEditorChangeListener);
        c.removePropertyChangeListener("editable", this.myEditableChangeListener);
        ComboBoxEditor editor = ((JComboBox)c).getEditor();
        if (editor != null && (component = editor.getEditorComponent()) instanceof JComponent) {
            component.removePropertyChangeListener("border", this.myEditorBorderChangeListener);
        }
        super.uninstallUI(c);
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.comboBox.getBackground();
        Color fg = this.comboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g) {
                Icon icon = MacIntelliJIconCache.getIcon("comboRight", MacIntelliJComboBoxUI.this.comboBox.isEditable(), false, false, MacIntelliJComboBoxUI.this.comboBox.isEnabled());
                if (this.getWidth() > icon.getIconWidth() || this.getHeight() > icon.getIconHeight()) {
                    Image image = IconUtil.toImage((Icon)icon);
                    UIUtil.drawImage((Graphics)g, (Image)image, (Rectangle)new Rectangle(0, 0, this.getWidth(), this.getHeight()), null, null);
                } else {
                    icon.paintIcon(this, g, 0, 0);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(MacIntelliJComboBoxUI.this.DEFAULT_ICON.getIconWidth(), MacIntelliJComboBoxUI.this.DEFAULT_ICON.getIconHeight());
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        return button;
    }

    @Override
    protected Dimension getSizeWithButton(Dimension d) {
        Insets i = this.comboBox.getInsets();
        int iconWidth = this.DEFAULT_ICON.getIconWidth() + i.right;
        int iconHeight = this.DEFAULT_ICON.getIconHeight() + i.top + i.bottom;
        int editorHeight = this.editor != null ? this.editor.getPreferredSize().height + i.top + i.bottom : 0;
        return new Dimension(Math.max(d.width + JBUI.scale((int)7), iconWidth), Math.max(Math.max(iconHeight, editorHeight), JBUI.scale((int)26)));
    }

    @Override
    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource comboBoxEditor = new BasicComboBoxEditor.UIResource(){

            @Override
            protected JTextField createEditorComponent() {
                return new JTextField(){
                    {
                        this.setOpaque(false);
                        this.setBorder(ourDefaultEditorBorder);
                    }

                    @Override
                    public Color getBackground() {
                        return MacIntelliJComboBoxUI.this.comboBox != null && !MacIntelliJComboBoxUI.this.comboBox.isEnabled() ? UIManager.getColor("ComboBox.disabledBackground") : super.getBackground();
                    }

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }

                    @Override
                    public Border getBorder() {
                        return ourDefaultEditorBorder;
                    }

                    @Override
                    public Insets getInsets() {
                        return ourDefaultEditorBorder.getBorderInsets(this);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension size = super.getPreferredSize();
                        return new Dimension(size.width, MacIntelliJComboBoxUI.this.DEFAULT_ICON.getIconHeight());
                    }
                };
            }
        };
        if (comboBoxEditor.getEditorComponent() != null) {
            comboBoxEditor.getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code2 = e.getKeyCode();
                    if ((code2 == 38 || code2 == 40) && e.getModifiers() == 0) {
                        MacIntelliJComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }
            });
            comboBoxEditor.getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.update();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.update();
                }

                void update() {
                    if (MacIntelliJComboBoxUI.this.comboBox != null) {
                        MacIntelliJComboBoxUI.this.comboBox.revalidate();
                        MacIntelliJComboBoxUI.this.comboBox.repaint();
                    }
                }
            });
        }
        return comboBoxEditor;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                Dimension size = cb.getMinimumSize();
                Rectangle bounds = cb.getBounds();
                bounds.height = bounds.height < size.height ? size.height : bounds.height;
                size = cb.getPreferredSize();
                bounds.height = bounds.height > size.height ? size.height : bounds.height;
                cb.setBounds(bounds);
                Insets cbInsets = cb.getInsets();
                if (MacIntelliJComboBoxUI.this.arrowButton != null) {
                    Dimension prefSize = MacIntelliJComboBoxUI.this.arrowButton.getPreferredSize();
                    int buttonHeight = bounds.height - (cbInsets.top + cbInsets.bottom);
                    double ar = (double)buttonHeight / (double)prefSize.height;
                    int buttonWidth = (int)Math.floor((double)prefSize.width * ar);
                    int offset = (int)Math.round(ar - 1.0);
                    MacIntelliJComboBoxUI.this.arrowButton.setBounds(bounds.width - buttonWidth - cbInsets.right + offset, cbInsets.top, buttonWidth, buttonHeight);
                }
                MacIntelliJComboBoxUI.this.layoutEditor();
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){

            @Override
            protected void configurePopup() {
                super.configurePopup();
                this.setBorderPainted(false);
                this.setBorder((Border)JBUI.Borders.empty());
                this.setBackground((Color)Gray.xFF);
            }

            @Override
            protected void configureList() {
                super.configureList();
                this.wrapRenderer();
            }

            @Override
            protected PropertyChangeListener createPropertyChangeListener() {
                final PropertyChangeListener listener2 = super.createPropertyChangeListener();
                return new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        listener2.propertyChange(evt);
                        if ("renderer".equals(evt.getPropertyName())) {
                            this.wrapRenderer();
                        }
                    }
                };
            }

            private void wrapRenderer() {
                ListCellRenderer<Object> renderer = this.list.getCellRenderer();
                if (!(renderer instanceof ComboBoxRendererWrapper) && renderer != null) {
                    this.list.setCellRenderer(new ComboBoxRendererWrapper(renderer));
                }
            }
        };
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle bounds = this.rectangleForCurrentValue();
        if (!this.comboBox.isEditable()) {
            this.listBox.setForeground(this.comboBox.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("Label.disabledForeground"));
            this.paintCurrentValue(g, bounds, this.comboBox.isPopupVisible());
        }
    }

    @Nullable
    Rectangle getArrowButtonBounds() {
        return this.arrowButton != null ? this.arrowButton.getBounds() : null;
    }

    private static class ComboBoxRendererWrapper
    implements ListCellRenderer<Object> {
        private final ListCellRenderer<Object> myRenderer;

        public ComboBoxRendererWrapper(@NotNull ListCellRenderer<Object> renderer) {
            if (renderer == null) {
                ComboBoxRendererWrapper.$$$reportNull$$$0(0);
            }
            this.myRenderer = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.myRenderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            BorderLayoutPanel panel2 = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)c).withBorder((Border)JBUI.Borders.empty((int)0, (int)8));
            panel2.setBackground(c.getBackground());
            return panel2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/ide/ui/laf/intellij/MacIntelliJComboBoxUI$ComboBoxRendererWrapper", "<init>"));
        }
    }
}

