/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import java.util.HashMap;
import javax.swing.Icon;

public class MacIntelliJIconCache {
    private static final HashMap<String, Icon> cache = new HashMap();

    public static Icon getIcon(String name, boolean editable, boolean selected, boolean focused, boolean enabled, boolean pressed) {
        String key = name;
        if (editable) {
            key = key + "Editable";
        }
        if (selected) {
            key = key + "Selected";
        }
        if (pressed) {
            key = key + "Pressed";
        } else if (focused) {
            key = key + "Focused";
        } else if (!enabled) {
            key = key + "Disabled";
        }
        String dir = "";
        if (UIUtil.isUnderDefaultMacTheme()) {
            dir = IntelliJLaf.isGraphite() ? "graphite/" : "";
        } else if (UIUtil.isUnderWin10LookAndFeel()) {
            dir = "win10/";
        } else if (UIUtil.isUnderDarcula()) {
            dir = "darcula/";
        } else if (UIUtil.isUnderIntelliJLaF()) {
            dir = "intellij/";
        }
        key = dir + key;
        Icon icon = cache.get(key);
        if (icon == null) {
            icon = IconLoader.findIcon((String)("/com/intellij/ide/ui/laf/icons/" + key + ".png"), MacIntelliJIconCache.class, (boolean)true);
            cache.put(key, icon);
        }
        return icon;
    }

    public static Icon getIcon(String name, boolean editable, boolean selected, boolean focused, boolean enabled) {
        return MacIntelliJIconCache.getIcon(name, editable, selected, focused, enabled, false);
    }

    public static Icon getIcon(String name, boolean selected, boolean focused, boolean enabled) {
        return MacIntelliJIconCache.getIcon(name, false, selected, focused, enabled);
    }

    public static Icon getIcon(String name, boolean selected, boolean focused) {
        return MacIntelliJIconCache.getIcon(name, false, selected, focused, true);
    }

    public static Icon getIcon(String name) {
        return MacIntelliJIconCache.getIcon(name, false, false, false, true);
    }
}

