/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.ApplicationInfoProvider;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaLogger
extends Log4jBasedLogger {
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static final ApplicationInfoProvider ourApplicationInfoProvider;
    private static final String ourCompilationTimestamp;
    private static final ThrowableRenderer ourThrowableRenderer;

    @Nullable
    public static String getOurCompilationTimestamp() {
        return ourCompilationTimestamp;
    }

    @NotNull
    public static ThrowableRenderer getThrowableRenderer() {
        ThrowableRenderer throwableRenderer = ourThrowableRenderer;
        if (throwableRenderer == null) {
            IdeaLogger.$$$reportNull$$$0(0);
        }
        return throwableRenderer;
    }

    IdeaLogger(@NotNull Logger logger) {
        if (logger == null) {
            IdeaLogger.$$$reportNull$$$0(1);
        }
        super(logger);
        LoggerRepository repository = this.myLogger.getLoggerRepository();
        if (repository instanceof ThrowableRendererSupport) {
            ((ThrowableRendererSupport)repository).setThrowableRenderer(ourThrowableRenderer);
        }
    }

    public void error(Object message) {
        if (message instanceof IdeaLoggingEvent) {
            this.myLogger.error(message);
        } else {
            super.error(message);
        }
    }

    public void error(String message, @Nullable Throwable t, Attachment ... attachments) {
        if (attachments == null) {
            IdeaLogger.$$$reportNull$$$0(2);
        }
        String trace = ExceptionUtil.getThrowableText((Throwable)(t != null ? t : new Throwable()));
        this.myLogger.error((Object)LogMessageEx.createEvent(message, trace, attachments));
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            IdeaLogger.$$$reportNull$$$0(3);
        }
        if (t instanceof ControlFlowException) {
            this.myLogger.error((Object)message, new Throwable("Control-flow exceptions (like " + t.getClass().getSimpleName() + ") should never be logged", t));
            ExceptionUtil.rethrow((Throwable)t);
        }
        String detailString = StringUtil.join((String[])details, (String)"\n");
        if (ourErrorsOccurred == null) {
            String s = message != null && !message.isEmpty() ? "Error message is '" + message + "'" : "";
            String mess = "Logger errors occurred. See IDEA logs for details. " + s;
            ourErrorsOccurred = new Exception(mess + (!detailString.isEmpty() ? "\nDetails: " + detailString : ""), t);
        }
        this.myLogger.error((Object)(message + (!detailString.isEmpty() ? "\nDetails: " + detailString : "")), t);
        this.logErrorHeader();
    }

    private void logErrorHeader() {
        String info = ourApplicationInfoProvider.getInfo();
        if (info != null) {
            this.myLogger.error((Object)info);
        }
        if (ourCompilationTimestamp != null) {
            this.myLogger.error((Object)("Internal version. Compiled " + ourCompilationTimestamp));
        }
        this.myLogger.error((Object)("JDK: " + System.getProperties().getProperty("java.version", "unknown")));
        this.myLogger.error((Object)("VM: " + System.getProperties().getProperty("java.vm.name", "unknown")));
        this.myLogger.error((Object)("Vendor: " + System.getProperties().getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + System.getProperties().getProperty("os.name", "unknown")));
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        if (application != null && application.isComponentsCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = CommandProcessor.getInstance()) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    static {
        ourApplicationInfoProvider = () -> {
            ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
            return info.getFullApplicationName() + "  Build #" + info.getBuild().asString();
        };
        String stamp = null;
        URL resource = com.intellij.openapi.diagnostic.Logger.class.getResource("/.compilation-timestamp");
        if (resource != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));){
                String s = reader.readLine();
                if (s != null) {
                    stamp = s.trim();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ourCompilationTimestamp = stamp;
        ourThrowableRenderer = t -> {
            int maxExtraSize;
            int maxStackSize;
            String[] lines2 = DefaultThrowableRenderer.render((Throwable)t);
            if (lines2.length > (maxStackSize = 1024) + (maxExtraSize = 256)) {
                String[] res = new String[maxStackSize + maxExtraSize + 1];
                System.arraycopy(lines2, 0, res, 0, maxStackSize);
                res[maxStackSize] = "\t...";
                System.arraycopy(lines2, lines2.length - maxExtraSize, res, maxStackSize + 1, maxExtraSize);
                return res;
            }
            return lines2;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/IdeaLogger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableRenderer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/IdeaLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

