/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000R\u0016\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\n\"\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0016\u0010\u001a\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u001e\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\n\"\u0004\b\u001d\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEvent;", "", "recorderId", "", "userUid", "sessionId", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "actionType", "getActionType", "()Ljava/lang/String;", "data", "", "getData", "()Ljava/util/Map;", "endTimestamp", "", "getEndTimestamp", "()J", "setEndTimestamp", "(J)V", "getRecorderId", "setRecorderId", "(Ljava/lang/String;)V", "sessionUid", "getSessionUid", "timestamp", "getTimestamp", "getUserUid", "setUserUid", "shouldMerge", "", "next", "intellij.platform.ide.impl"})
public class LogEvent {
    private final transient long timestamp;
    private transient long endTimestamp;
    @NotNull
    private final transient String sessionUid;
    @NotNull
    private final transient String actionType;
    @NotNull
    private final transient Map<String, Object> data;
    @NotNull
    private transient String recorderId;
    @NotNull
    private transient String userUid;

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final long getEndTimestamp() {
        return this.endTimestamp;
    }

    public final void setEndTimestamp(long l) {
        this.endTimestamp = l;
    }

    @NotNull
    public final String getSessionUid() {
        return this.sessionUid;
    }

    @NotNull
    public final String getActionType() {
        return this.actionType;
    }

    @NotNull
    public final Map<String, Object> getData() {
        return this.data;
    }

    public final boolean shouldMerge(@NotNull LogEvent next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        if (next.timestamp - this.endTimestamp > (long)10000) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.actionType, (Object)next.actionType) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.recorderId, (Object)next.recorderId) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.userUid, (Object)next.userUid) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.sessionUid, (Object)next.sessionUid) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.data, next.data) ^ true);
    }

    @NotNull
    public final String getRecorderId() {
        return this.recorderId;
    }

    public final void setRecorderId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.recorderId = string;
    }

    @NotNull
    public final String getUserUid() {
        return this.userUid;
    }

    public final void setUserUid(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.userUid = string;
    }

    public LogEvent(@NotNull String recorderId, @NotNull String userUid, @NotNull String sessionId, @NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Intrinsics.checkParameterIsNotNull((Object)userUid, (String)"userUid");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.recorderId = recorderId;
        this.userUid = userUid;
        this.timestamp = System.currentTimeMillis();
        this.endTimestamp = System.currentTimeMillis();
        this.sessionUid = sessionId;
        this.actionType = type;
        HashMap hashMap = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap()");
        this.data = hashMap;
    }
}

