/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.configurable.SendPeriod;
import com.intellij.internal.statistic.persistence.BasicSentUsagesPersistenceComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UsagesStatistic", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class UsageStatisticsPersistenceComponent
extends BasicSentUsagesPersistenceComponent
implements NamedComponent,
PersistentStateComponent<Element> {
    public static final String USAGE_STATISTICS_XML = "usage.statistics.xml";
    @NonNls
    private boolean isShowNotification = true;
    @NotNull
    private SendPeriod myPeriod = SendPeriod.DAILY;
    @NonNls
    private static final String DATA_ATTR = "data";
    @NonNls
    private static final String GROUP_TAG = "group";
    @NonNls
    private static final String GROUP_ID_ATTR = "id";
    @NonNls
    private static final String GROUP_PRIORITY_ATTR = "priority";
    @NonNls
    private static final String LAST_TIME_ATTR = "time";
    @NonNls
    private static final String IS_ALLOWED_ATTR = "allowed";
    @NonNls
    private static final String PERIOD_ATTR = "period";
    @NonNls
    private static final String SHOW_NOTIFICATION_ATTR = "show-notification";

    public static UsageStatisticsPersistenceComponent getInstance() {
        return (UsageStatisticsPersistenceComponent)ApplicationManager.getApplication().getComponent(UsageStatisticsPersistenceComponent.class);
    }

    public UsageStatisticsPersistenceComponent() {
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            this.isShowNotification = false;
        }
    }

    public void loadState(@NotNull Element element) {
        String isShowNotificationValue;
        if (element == null) {
            UsageStatisticsPersistenceComponent.$$$reportNull$$$0(0);
        }
        for (Element groupElement : element.getChildren(GROUP_TAG)) {
            String groupId = groupElement.getAttributeValue(GROUP_ID_ATTR);
            double groupPriority = UsageStatisticsPersistenceComponent.getPriority(groupElement.getAttributeValue(GROUP_PRIORITY_ATTR));
            String valueData = groupElement.getAttributeValue(DATA_ATTR);
            if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)valueData)) continue;
            try {
                this.getSentUsages().putAll(ConvertUsagesUtil.convertValueString(GroupDescriptor.create(groupId, groupPriority), valueData));
            }
            catch (AssertionError assertionError) {}
        }
        try {
            this.setSentTime(Long.parseLong(element.getAttributeValue(LAST_TIME_ATTR, "0")));
        }
        catch (NumberFormatException e) {
            this.setSentTime(0L);
        }
        String isAllowedValue = element.getAttributeValue(IS_ALLOWED_ATTR);
        if (!StringUtil.isEmptyOrSpaces((String)isAllowedValue) && Boolean.parseBoolean(isAllowedValue)) {
            this.setAllowed(true);
        }
        this.setShowNotification(StringUtil.isEmptyOrSpaces((String)(isShowNotificationValue = element.getAttributeValue(SHOW_NOTIFICATION_ATTR))) || Boolean.parseBoolean(isShowNotificationValue));
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry entry : ConvertUsagesUtil.sortDescriptorsByPriority(this.getSentUsages()).entrySet()) {
            Element projectElement = new Element(GROUP_TAG);
            projectElement.setAttribute(GROUP_ID_ATTR, entry.getKey().getId());
            projectElement.setAttribute(GROUP_PRIORITY_ATTR, Double.toString(entry.getKey().getPriority()));
            projectElement.setAttribute(DATA_ATTR, ConvertUsagesUtil.convertValueMap(entry.getValue()));
            element.addContent(projectElement);
        }
        long lastTimeSent = this.getLastTimeSent();
        if (lastTimeSent > 0L) {
            element.setAttribute(LAST_TIME_ATTR, String.valueOf(lastTimeSent));
        }
        if (!this.isShowNotification()) {
            element.setAttribute(SHOW_NOTIFICATION_ATTR, "false");
        }
        return element;
    }

    @NotNull
    public SendPeriod getPeriod() {
        SendPeriod sendPeriod = this.myPeriod;
        if (sendPeriod == null) {
            UsageStatisticsPersistenceComponent.$$$reportNull$$$0(1);
        }
        return sendPeriod;
    }

    public void setPeriod(@NotNull SendPeriod period) {
        if (period == null) {
            UsageStatisticsPersistenceComponent.$$$reportNull$$$0(2);
        }
        this.myPeriod = period;
    }

    @NotNull
    private static SendPeriod parsePeriod(@Nullable String periodAttrValue) {
        if (SendPeriod.DAILY.getName().equals(periodAttrValue)) {
            SendPeriod sendPeriod = SendPeriod.DAILY;
            if (sendPeriod == null) {
                UsageStatisticsPersistenceComponent.$$$reportNull$$$0(3);
            }
            return sendPeriod;
        }
        if (SendPeriod.MONTHLY.getName().equals(periodAttrValue)) {
            SendPeriod sendPeriod = SendPeriod.MONTHLY;
            if (sendPeriod == null) {
                UsageStatisticsPersistenceComponent.$$$reportNull$$$0(4);
            }
            return sendPeriod;
        }
        SendPeriod sendPeriod = SendPeriod.WEEKLY;
        if (sendPeriod == null) {
            UsageStatisticsPersistenceComponent.$$$reportNull$$$0(5);
        }
        return sendPeriod;
    }

    public void setAllowed(boolean allowed) {
        ConsentOptions.getInstance().setSendingUsageStatsAllowed(allowed);
    }

    @Override
    public boolean isAllowed() {
        return ConsentOptions.getInstance().isSendingUsageStatsAllowed() == ConsentOptions.Permission.YES;
    }

    public void setShowNotification(boolean showNotification2) {
        this.isShowNotification = showNotification2;
    }

    @Override
    public boolean isShowNotification() {
        return this.isShowNotification;
    }

    private static double getPriority(String priority) {
        if (StringUtil.isEmptyOrSpaces((String)priority)) {
            return 0.0;
        }
        return Double.parseDouble(priority);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("SentUsagesPersistenceComponent" == null) {
            UsageStatisticsPersistenceComponent.$$$reportNull$$$0(6);
        }
        return "SentUsagesPersistenceComponent";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = PERIOD_ATTR;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeriod";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePeriod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPeriod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

