/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.CommonBundle;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffModelListener;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.actions.popup.WarnOnDeletion;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffTableModel
extends AbstractTableModel
implements DirDiffModel,
Disposable {
    private static final Logger LOG = Logger.getInstance(DirDiffTableModel.class);
    public static final Key<JBLoadingPanel> DECORATOR_KEY = Key.create((String)"DIFF_TABLE_DECORATOR");
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_SIZE = "Size";
    public static final String COLUMN_DATE = "Date";
    public static final String EMPTY_STRING = StringUtil.repeatSymbol((char)' ', (int)50);
    @Nullable
    private final Project myProject;
    private final DirDiffSettings mySettings;
    private DiffElement mySource;
    private DiffElement myTarget;
    private DTree myTree;
    private final List<DirDiffElementImpl> myElements = new ArrayList<DirDiffElementImpl>();
    private final AtomicBoolean myUpdating = new AtomicBoolean(false);
    private JBTable myTable;
    private final AtomicReference<String> text = new AtomicReference<String>(DirDiffTableModel.prepareText(""));
    private Updater myUpdater;
    private List<DirDiffModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private TableSelectionConfig mySelectionConfig;
    private Map<String, BiMap<String, String>> mySourceToReplacingTarget = HashBiMap.create();
    private DirDiffPanel myPanel;
    private volatile boolean myDisposed;

    public DirDiffTableModel(@Nullable Project project, DiffElement source, DiffElement target2, DirDiffSettings settings) {
        UsageTrigger.trigger("diff.DirDiffTableModel");
        this.myProject = project;
        this.mySettings = settings;
        this.mySource = source;
        this.myTarget = target2;
    }

    public void stopUpdating() {
        if (this.myUpdating.get()) {
            this.myUpdating.set(false);
        }
    }

    public void applyRemove() {
        int index;
        List<DirDiffElementImpl> selectedElements = this.getSelectedElements();
        this.myUpdating.set(true);
        Iterator<DirDiffElementImpl> i = this.myElements.iterator();
        while (i.hasNext()) {
            DiffType type = i.next().getType();
            switch (type) {
                case SOURCE: {
                    if (this.mySettings.showNewOnSource) break;
                    i.remove();
                    break;
                }
                case TARGET: {
                    if (this.mySettings.showNewOnTarget) break;
                    i.remove();
                    break;
                }
                case SEPARATOR: {
                    break;
                }
                case CHANGED: {
                    if (this.mySettings.showDifferent) break;
                    i.remove();
                    break;
                }
                case EQUAL: {
                    if (this.mySettings.showEqual) break;
                    i.remove();
                    break;
                }
            }
        }
        boolean sep = true;
        for (int j = this.myElements.size() - 1; j >= 0; --j) {
            if (this.myElements.get(j).isSeparator()) {
                if (sep) {
                    this.myElements.remove(j);
                    continue;
                }
                sep = true;
                continue;
            }
            sep = false;
        }
        this.fireTableDataChanged();
        this.myUpdating.set(false);
        if (!selectedElements.isEmpty() && (index = this.myElements.indexOf(selectedElements.get(0))) != -1) {
            this.myTable.getSelectionModel().setSelectionInterval(index, index);
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        } else {
            this.selectFirstRow();
        }
        this.myPanel.update(true);
    }

    public void selectFirstRow() {
        if (this.myElements.size() > 0) {
            int row;
            int n = row = this.myElements.get(0).isSeparator() ? 1 : 0;
            if (row < this.myTable.getRowCount()) {
                this.myTable.getSelectionModel().setSelectionInterval(row, row);
                TableUtil.scrollSelectionToVisible((JTable)this.myTable);
            }
        }
    }

    public void setPanel(DirDiffPanel panel2) {
        this.myPanel = panel2;
    }

    public void updateFromUI() {
        this.getSettings().setFilter(this.myPanel.getFilter());
        this.myPanel.update(false);
    }

    public boolean isOperationsEnabled() {
        return !this.myDisposed && this.mySettings.enableOperations && this.mySource.isOperationsEnabled() && this.myTarget.isOperationsEnabled();
    }

    public List<DirDiffElementImpl> getElements() {
        return this.myElements;
    }

    public void setReplacement(DirDiffElementImpl source, @Nullable DirDiffElementImpl target2) {
        BiMap map = this.mySourceToReplacingTarget.computeIfAbsent(source.getParentNode().getPath(), p -> HashBiMap.create());
        if (target2 != null) {
            map.forcePut((Object)source.getSourceName(), (Object)target2.getTargetName());
        } else {
            map.remove((Object)source.getSourceName());
        }
    }

    public String getReplacementName(DirDiffElementImpl source) {
        BiMap<String, String> map = this.mySourceToReplacingTarget.get(source.getParentNode().getPath());
        return map != null ? (String)map.get((Object)source.getSourceName()) : null;
    }

    private static String prepareText(String text) {
        int LEN = EMPTY_STRING.length();
        String right = text == null ? EMPTY_STRING : (text.length() == LEN ? text : (text.length() < LEN ? text + EMPTY_STRING.substring(0, LEN - text.length()) : "..." + text.substring(text.length() - LEN + 2)));
        return "Loading... " + right;
    }

    void fireUpdateStarted() {
        for (DirDiffModelListener listener2 : this.myListeners) {
            listener2.updateStarted();
        }
    }

    void fireUpdateFinished() {
        for (DirDiffModelListener listener2 : this.myListeners) {
            listener2.updateFinished();
        }
    }

    void addModelListener(DirDiffModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void reloadModel(boolean userForcedRefresh) {
        this.fireUpdateStarted();
        this.myUpdating.set(true);
        this.myTable.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        JBLoadingPanel loadingPanel = this.getLoadingPanel();
        loadingPanel.startLoading();
        ModalityState modalityState = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator(modalityState);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                try {
                    if (this.myDisposed) {
                        return;
                    }
                    this.myUpdater = new Updater(loadingPanel, 100);
                    this.myUpdater.start();
                    this.text.set("Loading...");
                    this.myTree = new DTree(null, "", true);
                    this.mySource.refresh(userForcedRefresh);
                    this.myTarget.refresh(userForcedRefresh);
                    this.scan(this.mySource, this.myTree, true);
                    this.scan(this.myTarget, this.myTree, false);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    this.reportException(VcsBundle.message((String)"refresh.failed.message", (Object[])new Object[]{StringUtil.decapitalize((String)e.getLocalizedMessage())}));
                }
                finally {
                    if (this.myTree != null) {
                        this.myTree.setSource(this.mySource);
                        this.myTree.setTarget(this.myTarget);
                        this.myTree.update(this.mySettings);
                        ApplicationManager.getApplication().invokeLater(this::fireUpdateFinished, ModalityState.any());
                        this.applySettings();
                    }
                }
            }, (ProgressIndicator)indicator);
        });
    }

    public void reloadModelSynchronously() {
        this.myUpdating.set(true);
        try {
            this.fireUpdateStarted();
            this.myTree = new DTree(null, "", true);
            this.mySource.refresh(true);
            this.myTarget.refresh(true);
            this.scan(this.mySource, this.myTree, true);
            this.scan(this.myTarget, this.myTree, false);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.reportException(VcsBundle.message((String)"refresh.failed.message", (Object[])new Object[]{StringUtil.decapitalize((String)e.getLocalizedMessage())}));
        }
        finally {
            this.myTree.setSource(this.mySource);
            this.myTree.setTarget(this.myTarget);
            this.myTree.update(this.mySettings);
            ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>();
            this.fillElements(this.myTree, elements);
            this.myElements.clear();
            this.myElements.addAll(elements);
            this.myUpdating.set(false);
            this.fireUpdateFinished();
        }
    }

    private void reportException(@Nullable String htmlContent) {
        if (this.myDisposed || htmlContent == null) {
            return;
        }
        Runnable balloonShower = () -> {
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlContent, MessageType.WARNING, null).setShowCallout(false).setHideOnClickOutside(true).setHideOnAction(true).setHideOnFrameResize(true).setHideOnKeyOutside(true).createBalloon();
            Rectangle rect = this.myPanel.getPanel().getBounds();
            Point p = new Point(rect.x + rect.width - 100, rect.y + 50);
            RelativePoint point = new RelativePoint((Component)this.myPanel.getPanel(), p);
            balloon.show(point, Balloon.Position.below);
            Disposer.register((Disposable)(this.myProject != null ? this.myProject : ApplicationManager.getApplication()), (Disposable)balloon);
        };
        ApplicationManager.getApplication().invokeLater(balloonShower, o -> this.myProject != null && !this.myProject.isDefault() && !this.myProject.isOpen());
    }

    private JBLoadingPanel getLoadingPanel() {
        return (JBLoadingPanel)UIUtil.getClientProperty((Object)this.myTable, DECORATOR_KEY);
    }

    public void applySettings() {
        JBLoadingPanel loadingPanel;
        if (!this.myUpdating.get()) {
            this.myUpdating.set(true);
        }
        if (!(loadingPanel = this.getLoadingPanel()).isLoading()) {
            loadingPanel.startLoading();
            if (this.myUpdater == null) {
                this.myUpdater = new Updater(loadingPanel, 100);
                this.myUpdater.start();
            }
        }
        Application app = ApplicationManager.getApplication();
        app.executeOnPooledThread(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myTree.updateVisibility(this.mySettings);
            ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>();
            this.fillElements(this.myTree, elements);
            Runnable uiThread = () -> {
                if (this.myDisposed) {
                    return;
                }
                this.clear();
                this.myElements.addAll(elements);
                this.myUpdating.set(false);
                this.fireTableDataChanged();
                this.text.set("");
                if (loadingPanel.isLoading()) {
                    loadingPanel.stopLoading();
                }
                if (this.mySelectionConfig == null) {
                    this.selectFirstRow();
                } else {
                    this.mySelectionConfig.restore();
                }
                this.myPanel.update(true);
            };
            if (this.myProject == null || this.myProject.isDefault()) {
                SwingUtilities.invokeLater(uiThread);
            } else {
                app.invokeLater(uiThread, ModalityState.any());
            }
        });
    }

    private void fillElements(DTree tree, List<DirDiffElementImpl> elements) {
        if (!this.myUpdating.get()) {
            return;
        }
        boolean separatorAdded = tree.getParent() == null;
        this.text.set(DirDiffTableModel.prepareText(tree.getPath()));
        for (DTree child : tree.getChildren()) {
            if (!this.myUpdating.get()) {
                return;
            }
            if (!child.isContainer()) {
                DiffType type;
                if (!child.isVisible()) continue;
                if (!separatorAdded) {
                    elements.add(DirDiffElementImpl.createDirElement(tree, tree.getSource(), tree.getTarget(), tree.getPath()));
                    separatorAdded = true;
                }
                if ((type = child.getType()) != null) {
                    switch (type) {
                        case SOURCE: {
                            elements.add(DirDiffElementImpl.createSourceOnly(child, child.getSource()));
                            break;
                        }
                        case TARGET: {
                            elements.add(DirDiffElementImpl.createTargetOnly(child, child.getTarget()));
                            break;
                        }
                        case CHANGED: {
                            elements.add(DirDiffElementImpl.createChange(child, child.getSource(), child.getTarget(), this.mySettings.customSourceChooser));
                            break;
                        }
                        case EQUAL: {
                            elements.add(DirDiffElementImpl.createEqual(child, child.getSource(), child.getTarget()));
                            break;
                        }
                        case ERROR: {
                            elements.add(DirDiffElementImpl.createError(child, child.getSource(), child.getTarget()));
                        }
                    }
                    continue;
                }
                LOG.error(String.format("Element's type is null [Name: %s, Container: %s, Source: %s, Target: %s] ", child.getName(), child.isContainer(), child.getSource(), child.getTarget()));
                continue;
            }
            this.fillElements(child, elements);
        }
    }

    public void clear() {
        if (!this.myElements.isEmpty()) {
            int size = this.myElements.size();
            this.myElements.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    private void scan(DiffElement element, DTree root, boolean source) throws IOException {
        if (!this.myUpdating.get()) {
            return;
        }
        if (element.isContainer()) {
            DiffElement[] children2;
            this.text.set(DirDiffTableModel.prepareText(element.getPath()));
            for (DiffElement child : children2 = element.getChildren()) {
                if (!this.myUpdating.get()) {
                    return;
                }
                BiMap<String, String> replacing = this.mySourceToReplacingTarget.get(root.getPath());
                String replacementName = replacing != null ? (source ? (String)replacing.get((Object)child.getName()) : (String)replacing.inverse().get((Object)child.getName())) : null;
                DTree el = root.addChild(child, source, replacementName);
                this.scan(child, el, source);
            }
        }
    }

    public String getTitle() {
        if (this.myDisposed) {
            return "Diff";
        }
        if (this.mySource instanceof VirtualFileDiffElement && this.myTarget instanceof VirtualFileDiffElement) {
            VirtualFile srcFile = ((VirtualFileDiffElement)this.mySource).getValue();
            VirtualFile trgFile = ((VirtualFileDiffElement)this.myTarget).getValue();
            return DiffRequestFactory.getInstance().getTitle(srcFile, trgFile);
        }
        return IdeBundle.message((String)"diff.dialog.title", (Object[])new Object[]{this.mySource.getPresentablePath(), this.myTarget.getPresentablePath()});
    }

    @Nullable
    public DirDiffElementImpl getElementAt(int index) {
        return 0 <= index && index < this.myElements.size() ? this.myElements.get(index) : null;
    }

    public DiffElement getSourceDir() {
        return this.mySource;
    }

    public DiffElement getTargetDir() {
        return this.myTarget;
    }

    public void setSourceDir(DiffElement src) {
        this.mySource = src;
    }

    public void setTargetDir(DiffElement trg) {
        this.myTarget = trg;
    }

    @Override
    public int getRowCount() {
        return this.myElements.size();
    }

    @Override
    public int getColumnCount() {
        int count = 3;
        if (this.mySettings.showDate) {
            count += 2;
        }
        if (this.mySettings.showSize) {
            count += 2;
        }
        return count;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public void setTable(JBTable table) {
        this.myTable = table;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            boolean isSrc;
            DirDiffElementImpl element = this.myElements.get(rowIndex);
            if (element.isSeparator()) {
                return columnIndex == 0 ? element.getName() : null;
            }
            String name = this.getColumnName(columnIndex);
            boolean bl = isSrc = columnIndex < this.getColumnCount() / 2;
            if (name.equals(COLUMN_NAME)) {
                return isSrc ? element.getSourceName() : element.getTargetName();
            }
            if (name.equals(COLUMN_SIZE)) {
                return isSrc ? element.getSourceSize() : element.getTargetSize();
            }
            if (name.equals(COLUMN_DATE)) {
                return isSrc ? element.getSourceModificationDate() : element.getTargetModificationDate();
            }
            return "";
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> {
                this.myElements.clear();
                this.fireTableDataChanged();
                this.myTable.getEmptyText().setText("Data has been changed externally. Reloading data...");
                this.reloadModel(true);
                this.myTable.repaint();
            });
            return "";
        }
    }

    public List<DirDiffElementImpl> getSelectedElements() {
        int[] rows = this.myTable.getSelectedRows();
        ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>();
        for (int row : rows) {
            DirDiffElementImpl element = this.getElementAt(row);
            if (element == null || element.isSeparator()) continue;
            elements.add(element);
        }
        return elements;
    }

    @Override
    public String getColumnName(int column) {
        int count = (this.getColumnCount() - 1) / 2;
        if (column == count) {
            return "*";
        }
        if (column > count) {
            column = this.getColumnCount() - 1 - column;
        }
        switch (column) {
            case 0: {
                return COLUMN_NAME;
            }
            case 1: {
                return this.mySettings.showSize ? COLUMN_SIZE : COLUMN_DATE;
            }
            case 2: {
                return COLUMN_DATE;
            }
        }
        return "";
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isShowEqual() {
        return this.mySettings.showEqual;
    }

    public void setShowEqual(boolean show) {
        this.mySettings.showEqual = show;
    }

    public boolean isShowDifferent() {
        return this.mySettings.showDifferent;
    }

    public void setShowDifferent(boolean show) {
        this.mySettings.showDifferent = show;
    }

    public boolean isShowNewOnSource() {
        return this.mySettings.showNewOnSource;
    }

    public void setShowNewOnSource(boolean show) {
        this.mySettings.showNewOnSource = show;
    }

    public boolean isShowNewOnTarget() {
        return this.mySettings.showNewOnTarget;
    }

    public void setShowNewOnTarget(boolean show) {
        this.mySettings.showNewOnTarget = show;
    }

    public boolean isUpdating() {
        return this.myUpdating.get();
    }

    public DirDiffSettings.CompareMode getCompareMode() {
        return this.mySettings.compareMode;
    }

    public void setCompareMode(DirDiffSettings.CompareMode mode) {
        this.mySettings.compareMode = mode;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myListeners.clear();
        this.myElements.clear();
        this.mySource = null;
        this.myTarget = null;
        this.myTree = null;
    }

    public DirDiffSettings getSettings() {
        return this.mySettings;
    }

    public void performCopyTo(DirDiffElementImpl element) {
        DiffElement source = element.getSource();
        if (source != null) {
            String path = element.getParentNode().getPath();
            if (source instanceof AsyncDiffElement) {
                ((AsyncDiffElement)source).copyToAsync(this.myTarget, element.getTarget(), path).rejected(error -> this.reportException(error == null ? null : error.getMessage())).done(newElement -> {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    if (this.myDisposed) {
                        return;
                    }
                    if (newElement == null && element.getTarget() != null) {
                        int row = this.myElements.indexOf(element);
                        element.updateTargetData();
                        this.fireTableRowsUpdated(row, row);
                    }
                    this.refreshElementAfterCopyTo((DiffElement)newElement, element);
                });
            } else {
                WriteAction.run(() -> {
                    DiffElement diffElement = source.copyTo(this.myTarget, path);
                    this.refreshElementAfterCopyTo(diffElement, element);
                });
            }
        }
    }

    private void refreshElementAfterCopyTo(DiffElement newElement, DirDiffElementImpl element) {
        if (newElement != null) {
            DTree node = element.getNode();
            node.setType(DiffType.EQUAL);
            node.setTarget(newElement);
            int row = this.myElements.indexOf(element);
            if (this.getSettings().showEqual) {
                element.updateSourceFromTarget(newElement);
                this.fireTableRowsUpdated(row, row);
            } else {
                this.removeElement(element, false);
            }
        }
    }

    public void performCopyFrom(@NotNull DirDiffElementImpl element) {
        DiffElement target2;
        if (element == null) {
            DirDiffTableModel.$$$reportNull$$$0(0);
        }
        if ((target2 = element.getTarget()) != null) {
            String path = element.getParentNode().getPath();
            if (target2 instanceof AsyncDiffElement) {
                ((AsyncDiffElement)target2).copyToAsync(this.mySource, element.getSource(), path).rejected(error -> this.reportException(error == null ? null : error.getMessage())).done(newElement -> {
                    if (element == null) {
                        DirDiffTableModel.$$$reportNull$$$0(4);
                    }
                    if (this.myDisposed) {
                        return;
                    }
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    this.refreshElementAfterCopyFrom(element, (DiffElement)newElement);
                });
            } else {
                WriteAction.run(() -> {
                    if (element == null) {
                        DirDiffTableModel.$$$reportNull$$$0(3);
                    }
                    DiffElement diffElement = target2.copyTo(this.mySource, path);
                    this.refreshElementAfterCopyFrom(element, diffElement);
                });
            }
        }
    }

    private void refreshElementAfterCopyFrom(DirDiffElementImpl element, DiffElement newElement) {
        if (newElement != null) {
            DTree node = element.getNode();
            node.setType(DiffType.EQUAL);
            node.setSource(newElement);
            int row = this.myElements.indexOf(element);
            if (this.getSettings().showEqual) {
                element.updateTargetFromSource(newElement);
                this.fireTableRowsUpdated(row, row);
            } else {
                this.removeElement(element, false);
            }
        }
    }

    private void removeElement(DirDiffElementImpl element, boolean removeFromTree) {
        int row = this.myElements.indexOf(element);
        if (row != -1) {
            DTree node = element.getNode();
            if (removeFromTree) {
                DTree parentNode = element.getParentNode();
                parentNode.remove(node);
            }
            this.myElements.remove(row);
            int start = row;
            if (row > 0 && row == this.myElements.size() && this.myElements.get(row - 1).isSeparator() || row != this.myElements.size() && this.myElements.get(row).isSeparator() && row > 0 && this.myElements.get(row - 1).isSeparator()) {
                DirDiffElementImpl el = this.myElements.get(row - 1);
                if (removeFromTree) {
                    el.getParentNode().remove(el.getNode());
                }
                this.myElements.remove(row - 1);
                start = row - 1;
            }
            this.fireTableRowsDeleted(start, row);
        }
    }

    public void performDelete(@NotNull DirDiffElementImpl element) {
        if (element == null) {
            DirDiffTableModel.$$$reportNull$$$0(1);
        }
        DiffElement source = element.getSource();
        DiffElement target2 = element.getTarget();
        LOG.assertTrue(source == null || target2 == null);
        if (source instanceof AsyncDiffElement || target2 instanceof AsyncDiffElement) {
            ((AsyncDiffElement)(source != null ? source : target2)).deleteAsync().rejected(error -> this.reportException(error != null ? error.getMessage() : null)).done(result2 -> {
                if (element == null) {
                    DirDiffTableModel.$$$reportNull$$$0(2);
                }
                if (!this.myDisposed && this.myElements.indexOf(element) != -1) {
                    this.removeElement(element, true);
                }
            });
        } else {
            if (this.myElements.indexOf(element) != -1) {
                this.removeElement(element, true);
            }
            WriteAction.run(() -> (source != null ? source : target2).delete());
        }
    }

    public void synchronizeSelected() {
        List<DirDiffElementImpl> selectedElements = this.getSelectedElements();
        if (!this.checkCanDelete(selectedElements)) {
            return;
        }
        this.rememberSelection();
        for (DirDiffElementImpl element : selectedElements) {
            this.syncElement(element);
        }
        this.restoreSelection();
    }

    private void restoreSelection() {
        if (this.mySelectionConfig != null) {
            this.mySelectionConfig.restore();
        }
    }

    public void synchronizeAll() {
        ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>(this.myElements);
        if (!this.checkCanDelete(elements)) {
            return;
        }
        for (DirDiffElementImpl element : elements) {
            this.syncElement(element);
        }
        this.selectFirstRow();
    }

    private boolean checkCanDelete(List<DirDiffElementImpl> elements) {
        if (WarnOnDeletion.isWarnWhenDeleteItems()) {
            int count = 0;
            for (DirDiffElementImpl element : elements) {
                if (element.getOperation() != DirDiffOperation.DELETE) continue;
                ++count;
            }
            if (count > 0 && !this.confirmDeletion(count)) {
                return false;
            }
        }
        return true;
    }

    private boolean confirmDeletion(int count) {
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Confirm Delete", (String)("Delete " + count + " items?")).project(this.myProject)).yesText("Delete")).noText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0]))).doNotAsk(new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return WarnOnDeletion.isWarnWhenDeleteItems();
            }

            public void setToBeShown(boolean value, int exitCode) {
                WarnOnDeletion.setWarnWhenDeleteItems(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                if ("Do not ask me again" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Do not ask me again";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/dir/DirDiffTableModel$1", "getDoNotShowMessage"));
            }
        })).show() == 0;
    }

    private void syncElement(DirDiffElementImpl element) {
        DirDiffOperation operation = element.getOperation();
        if (operation == null) {
            return;
        }
        switch (operation) {
            case COPY_TO: {
                this.performCopyTo(element);
                break;
            }
            case COPY_FROM: {
                this.performCopyFrom(element);
                break;
            }
            case MERGE: {
                break;
            }
            case EQUAL: {
                break;
            }
            case NONE: {
                break;
            }
            case DELETE: {
                this.performDelete(element);
            }
        }
    }

    public void rememberSelection() {
        this.mySelectionConfig = new TableSelectionConfig();
    }

    public void clearWithMessage(String message) {
        this.myTable.getEmptyText().setText(message);
        this.myElements.clear();
        this.fireTableDataChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffTableModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopyFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performDelete";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$performDelete$15";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$performCopyFrom$13";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$performCopyFrom$12";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class TableSelectionConfig {
        private final int selectedRow;
        private final int rowCount;

        TableSelectionConfig() {
            this.selectedRow = DirDiffTableModel.this.myTable.getSelectedRow();
            this.rowCount = DirDiffTableModel.this.myTable.getRowCount();
        }

        void restore() {
            DirDiffElementImpl el;
            int newRowCount = DirDiffTableModel.this.myTable.getRowCount();
            if (newRowCount == 0) {
                return;
            }
            int row = Math.min(newRowCount < this.rowCount ? this.selectedRow : this.selectedRow + 1, newRowCount - 1);
            DirDiffElementImpl element = DirDiffTableModel.this.getElementAt(row);
            if (element != null && element.isSeparator()) {
                row = DirDiffTableModel.this.getElementAt(row + 1) != null ? ++row : --row;
            }
            row = (el = DirDiffTableModel.this.getElementAt(row)) == null || el.isSeparator() ? 0 : row;
            DirDiffTableModel.this.myTable.getSelectionModel().setSelectionInterval(row, row);
            TableUtil.scrollSelectionToVisible((JTable)DirDiffTableModel.this.myTable);
        }
    }

    class Updater
    extends Thread {
        private final JBLoadingPanel myLoadingPanel;
        private final int mySleep;

        Updater(JBLoadingPanel loadingPanel, int sleep) {
            super("Loading Updater");
            this.myLoadingPanel = loadingPanel;
            this.mySleep = sleep;
        }

        @Override
        public void run() {
            if (!DirDiffTableModel.this.myDisposed && this.myLoadingPanel.isLoading()) {
                TimeoutUtil.sleep((long)this.mySleep);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String s = (String)DirDiffTableModel.this.text.get();
                    if (s != null && this.myLoadingPanel.isLoading()) {
                        this.myLoadingPanel.setLoadingText(s);
                    }
                }, ModalityState.stateForComponent((Component)this.myLoadingPanel));
                DirDiffTableModel.this.myUpdater = new Updater(this.myLoadingPanel, this.mySleep);
                DirDiffTableModel.this.myUpdater.start();
            } else {
                DirDiffTableModel.this.myUpdater = null;
            }
        }
    }
}

