/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.FrameState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameWrapper
implements Disposable,
DataProvider {
    private String myDimensionKey = null;
    private JComponent myComponent = null;
    private JComponent myPreferredFocus = null;
    private String myTitle = "";
    private List<Image> myImages = null;
    private boolean myCloseOnEsc = false;
    private Window myFrame;
    private final Map<String, Object> myDataMap = ContainerUtil.newHashMap();
    private Project myProject;
    private final ProjectManagerListener myProjectListener = new MyProjectManagerListener();
    private FocusWatcher myFocusWatcher;
    private ActionCallback myFocusedCallback;
    private boolean myDisposing;
    private boolean myDisposed;
    protected StatusBar myStatusBar;
    private boolean myShown;
    private boolean myIsDialog;

    public FrameWrapper(Project project) {
        this(project, null);
    }

    public FrameWrapper(Project project, @Nullable @NonNls String dimensionServiceKey) {
        this(project, dimensionServiceKey, false);
    }

    public FrameWrapper(Project project, @Nullable @NonNls String dimensionServiceKey, boolean isDialog) {
        this.myDimensionKey = dimensionServiceKey;
        this.myIsDialog = isDialog;
        if (project != null) {
            this.setProject(project);
        }
    }

    public void setDimensionKey(String dimensionKey) {
        this.myDimensionKey = dimensionKey;
    }

    public void setData(String dataId, Object data) {
        this.myDataMap.put(dataId, data);
    }

    public void setProject(final @NotNull Project project) {
        if (project == null) {
            FrameWrapper.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.setData(CommonDataKeys.PROJECT.getName(), project);
        ProjectManager.getInstance().addProjectManagerListener(project, this.myProjectListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                ProjectManager.getInstance().removeProjectManagerListener(project, FrameWrapper.this.myProjectListener);
            }
        });
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean restoreBounds) {
        this.myFocusedCallback = new ActionCallback();
        if (this.myProject != null) {
            IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(this.myFocusedCallback);
        }
        final Window frame = this.getFrame();
        if (this.myStatusBar != null) {
            this.myStatusBar.install((IdeFrame)frame);
        }
        if (frame instanceof JFrame) {
            ((JFrame)frame).setDefaultCloseOperation(2);
        } else {
            ((JDialog)frame).setDefaultCloseOperation(2);
        }
        UIUtil.decorateFrame((JRootPane)((RootPaneContainer)((Object)frame)).getRootPane());
        final WindowAdapter focusListener = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                IdeFocusManager fm = IdeFocusManager.getInstance((Project)FrameWrapper.this.myProject);
                JComponent toFocus = FrameWrapper.this.getPreferredFocusedComponent();
                if (toFocus == null) {
                    toFocus = fm.getFocusTargetFor(FrameWrapper.this.myComponent);
                }
                if (toFocus != null) {
                    fm.requestFocus((Component)toFocus, true).notify(FrameWrapper.this.myFocusedCallback);
                } else {
                    FrameWrapper.this.myFocusedCallback.setRejected();
                }
            }
        };
        frame.addWindowListener(focusListener);
        if (Registry.is((String)"ide.perProjectModality")) {
            frame.setAlwaysOnTop(true);
        }
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                frame.removeWindowListener(focusListener);
            }
        });
        if (this.myCloseOnEsc) {
            this.addCloseOnEsc((RootPaneContainer)((Object)frame));
        }
        ((RootPaneContainer)((Object)frame)).getContentPane().add((Component)this.myComponent, "Center");
        if (frame instanceof JFrame) {
            ((JFrame)frame).setTitle(this.myTitle);
        } else {
            ((JDialog)frame).setTitle(this.myTitle);
        }
        if (this.myImages != null) {
            frame.setIconImages(ContainerUtil.map(this.myImages, ImageUtil::toBufferedImage));
        } else {
            AppUIUtil.updateWindowIcon(this.myFrame);
        }
        if (restoreBounds) {
            this.loadFrameState();
        }
        this.myFocusWatcher = new FocusWatcher();
        this.myFocusWatcher.install((Component)this.myComponent);
        this.myShown = true;
        frame.setVisible(true);
    }

    public void close() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Window frame = this.myFrame;
        StatusBar statusBar = this.myStatusBar;
        if (this.myShown && this.myDimensionKey != null) {
            WindowStateService.getInstance().saveStateFor((Object)this.myProject, this.myDimensionKey, (Component)frame);
        }
        this.myFrame = null;
        this.myPreferredFocus = null;
        this.myProject = null;
        this.myDataMap.clear();
        if (this.myComponent != null && this.myFocusWatcher != null) {
            this.myFocusWatcher.deinstall((Component)this.myComponent);
        }
        this.myFocusWatcher = null;
        this.myFocusedCallback = null;
        this.myComponent = null;
        this.myImages = null;
        this.myDisposed = true;
        if (statusBar != null) {
            Disposer.dispose((Disposable)statusBar);
        }
        if (frame != null) {
            frame.setVisible(false);
            JRootPane rootPane = ((RootPaneContainer)((Object)frame)).getRootPane();
            frame.removeAll();
            DialogWrapper.cleanupRootPane((JRootPane)rootPane);
            if (frame instanceof IdeFrame) {
                MouseGestureManager.getInstance().remove((IdeFrame)frame);
            }
            frame.dispose();
            DialogWrapper.cleanupWindowListeners((Window)frame);
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private void addCloseOnEsc(RootPaneContainer frame) {
        JRootPane rootPane = frame.getRootPane();
        ActionListener closeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PopupUtil.handleEscKeyEvent()) {
                    FrameWrapper.this.myFrame.setVisible(false);
                    FrameWrapper.this.close();
                }
            }
        };
        rootPane.registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 2);
        ActionUtil.registerForEveryKeyboardShortcut((JComponent)rootPane, (ActionListener)closeAction, (ShortcutSet)CommonShortcuts.getCloseActiveWindow());
    }

    public Window getFrame() {
        assert (!this.myDisposed) : "Already disposed!";
        if (this.myFrame == null) {
            IdeFrame parent = WindowManager.getInstance().getIdeFrame(this.myProject);
            this.myFrame = this.myIsDialog ? this.createJDialog(parent) : this.createJFrame(parent);
        }
        return this.myFrame;
    }

    protected JFrame createJFrame(IdeFrame parent) {
        return new MyJFrame(this, parent);
    }

    protected JDialog createJDialog(IdeFrame parent) {
        return new MyJDialog(this, parent);
    }

    protected IdeRootPaneNorthExtension getNorthExtension(String key) {
        return null;
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    @Nullable
    private Object getDataInner(String dataId) {
        Object data = this.getData(dataId);
        return data != null ? data : this.myDataMap.get(dataId);
    }

    public void setComponent(JComponent component) {
        this.myComponent = component;
    }

    public void setPreferredFocusedComponent(JComponent preferedFocus) {
        this.myPreferredFocus = preferedFocus;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocus;
    }

    public void closeOnEsc() {
        this.myCloseOnEsc = true;
    }

    public void setImage(Image image) {
        this.setImages(image != null ? Collections.singletonList(image) : Collections.emptyList());
    }

    public void setImages(List<Image> images) {
        this.myImages = images;
    }

    protected void loadFrameState() {
        IdeFrame ideFrame;
        Window frame = this.getFrame();
        if (this.myDimensionKey != null && !WindowStateService.getInstance().loadStateFor((Object)this.myProject, this.myDimensionKey, (Component)frame) && (ideFrame = WindowManagerEx.getInstanceEx().getIdeFrame(this.myProject)) != null) {
            frame.setBounds(ideFrame.suggestChildFrameBounds());
        }
        ((RootPaneContainer)((Object)frame)).getRootPane().revalidate();
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public void addDisposable(@NotNull Disposable disposable) {
        if (disposable == null) {
            FrameWrapper.$$$reportNull$$$0(1);
        }
        Disposer.register((Disposable)this, (Disposable)disposable);
    }

    protected void setStatusBar(StatusBar statusBar) {
        if (this.myStatusBar != null) {
            Disposer.dispose((Disposable)this.myStatusBar);
        }
        this.myStatusBar = statusBar;
    }

    public void setLocation(Point location) {
        this.getFrame().setLocation(location);
    }

    public void setSize(Dimension size) {
        this.getFrame().setSize(size);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/FrameWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addDisposable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyProjectManagerListener
    implements ProjectManagerListener {
        private MyProjectManagerListener() {
        }

        public void projectClosing(Project project) {
            if (project == FrameWrapper.this.myProject) {
                FrameWrapper.this.close();
            }
        }
    }

    private static class MyJDialog
    extends JDialog
    implements DataProvider,
    IdeFrame.Child {
        private FrameWrapper myOwner;
        private final IdeFrame myParent;

        private MyJDialog(FrameWrapper owner, IdeFrame parent) throws HeadlessException {
            super((JFrame)parent);
            this.myOwner = owner;
            this.myParent = parent;
            this.setGlassPane(new IdeGlassPaneImpl(this.getRootPane()));
            this.getRootPane().putClientProperty("Window.style", "small");
            this.setBackground(UIUtil.getPanelBackground());
            MouseGestureManager.getInstance().add((IdeFrame)this);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt());
            this.setDefaultCloseOperation(2);
        }

        public JComponent getComponent() {
            return this.getRootPane();
        }

        public StatusBar getStatusBar() {
            return null;
        }

        @Nullable
        public BalloonLayout getBalloonLayout() {
            return null;
        }

        public Rectangle suggestChildFrameBounds() {
            return this.myParent.suggestChildFrameBounds();
        }

        public Project getProject() {
            return this.myParent.getProject();
        }

        public void setFrameTitle(String title) {
            this.setTitle(title);
        }

        public void setFileTitle(String fileTitle, File ioFile) {
            this.setTitle(fileTitle);
        }

        public IdeRootPaneNorthExtension getNorthExtension(String key) {
            return null;
        }

        public IdeFrame getParentFrame() {
            return this.myParent;
        }

        @Override
        public void dispose() {
            FrameWrapper owner = this.myOwner;
            this.myOwner = null;
            if (owner == null || owner.myDisposing) {
                return;
            }
            owner.myDisposing = true;
            Disposer.dispose((Disposable)owner);
            super.dispose();
            this.rootPane = null;
        }

        public Object getData(String dataId) {
            if (IdeFrame.KEY.getName().equals(dataId)) {
                return this;
            }
            return this.myOwner == null ? null : this.myOwner.getDataInner(dataId);
        }

        @Override
        public void paint(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            super.paint(g);
        }
    }

    private static class MyJFrame
    extends JFrame
    implements DataProvider,
    IdeFrame.Child {
        private FrameWrapper myOwner;
        private final IdeFrame myParent;
        private String myFrameTitle;
        private String myFileTitle;
        private File myFile;

        private MyJFrame(FrameWrapper owner, IdeFrame parent) throws HeadlessException {
            String desktop;
            this.myOwner = owner;
            this.myParent = parent;
            FrameState.setFrameStateListener(this);
            this.setGlassPane(new IdeGlassPaneImpl(this.getRootPane(), true));
            boolean setMenuOnFrame = SystemInfo.isMac;
            if (SystemInfo.isLinux && ("Unity".equals(desktop = System.getenv("XDG_CURRENT_DESKTOP")) || "Unity:Unity7".equals(desktop))) {
                try {
                    Class.forName("com.jarego.jayatana.Agent");
                    setMenuOnFrame = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (setMenuOnFrame) {
                this.setJMenuBar(new IdeMenuBar(ActionManagerEx.getInstanceEx(), DataManager.getInstance()));
            }
            MouseGestureManager.getInstance().add((IdeFrame)this);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt());
            this.setDefaultCloseOperation(2);
        }

        public JComponent getComponent() {
            return this.getRootPane();
        }

        public StatusBar getStatusBar() {
            StatusBar ownerBar;
            StatusBar statusBar = ownerBar = this.myOwner != null ? this.myOwner.myStatusBar : null;
            return ownerBar != null ? ownerBar : (this.myParent != null ? this.myParent.getStatusBar() : null);
        }

        public Rectangle suggestChildFrameBounds() {
            return this.myParent.suggestChildFrameBounds();
        }

        public Project getProject() {
            return this.myParent.getProject();
        }

        public void setFrameTitle(String title) {
            this.myFrameTitle = title;
            this.updateTitle();
        }

        public void setFileTitle(String fileTitle, File ioFile) {
            this.myFileTitle = fileTitle;
            this.myFile = ioFile;
            this.updateTitle();
        }

        public IdeRootPaneNorthExtension getNorthExtension(String key) {
            return this.myOwner.getNorthExtension(key);
        }

        public BalloonLayout getBalloonLayout() {
            return null;
        }

        private void updateTitle() {
            IdeFrameImpl.updateTitle(this, this.myFrameTitle, this.myFileTitle, this.myFile);
        }

        public IdeFrame getParentFrame() {
            return this.myParent;
        }

        @Override
        public void dispose() {
            FrameWrapper owner = this.myOwner;
            this.myOwner = null;
            if (owner == null || owner.myDisposing) {
                return;
            }
            owner.myDisposing = true;
            Disposer.dispose((Disposable)owner);
            super.dispose();
            this.rootPane = null;
            this.setMenuBar(null);
        }

        public Object getData(String dataId) {
            if (IdeFrame.KEY.getName().equals(dataId)) {
                return this;
            }
            return this.myOwner == null ? null : this.myOwner.getDataInner(dataId);
        }

        @Override
        public void paint(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            super.paint(g);
        }
    }
}

