/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.DirtBuilderReader;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;

public class DirtBuilder
implements DirtBuilderReader {
    private final VcsGuess myGuess;
    private final FileTypeManager myFileTypeManager;
    private final MultiMap<AbstractVcs, FilePath> myFiles;
    private final MultiMap<AbstractVcs, FilePath> myDirs;
    private boolean myEverythingDirty;

    public DirtBuilder(VcsGuess guess) {
        this.myGuess = guess;
        this.myDirs = MultiMap.createSet();
        this.myFiles = MultiMap.createSet();
        this.myEverythingDirty = false;
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    public DirtBuilder(DirtBuilder builder) {
        this(builder.myGuess);
        this.myDirs.putAllValues(builder.myDirs);
        this.myFiles.putAllValues(builder.myFiles);
        this.myEverythingDirty = builder.myEverythingDirty;
    }

    public void reset() {
        this.myFiles.clear();
        this.myDirs.clear();
        this.myEverythingDirty = false;
    }

    public void everythingDirty() {
        this.myEverythingDirty = true;
    }

    public void addDirtyFile(@NotNull AbstractVcs vcs, @NotNull FilePath file2) {
        if (vcs == null) {
            DirtBuilder.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            DirtBuilder.$$$reportNull$$$0(1);
        }
        if (this.myFileTypeManager.isFileIgnored(file2.getName())) {
            return;
        }
        this.myFiles.putValue((Object)vcs, (Object)file2);
    }

    public void addDirtyDirRecursively(@NotNull AbstractVcs vcs, @NotNull FilePath dir) {
        if (vcs == null) {
            DirtBuilder.$$$reportNull$$$0(2);
        }
        if (dir == null) {
            DirtBuilder.$$$reportNull$$$0(3);
        }
        if (this.myFileTypeManager.isFileIgnored(dir.getName())) {
            return;
        }
        this.myDirs.putValue((Object)vcs, (Object)dir);
    }

    @Override
    public boolean isEverythingDirty() {
        return this.myEverythingDirty;
    }

    @Override
    @NotNull
    public MultiMap<AbstractVcs, FilePath> getFilesForVcs() {
        MultiMap<AbstractVcs, FilePath> multiMap = this.myFiles;
        if (multiMap == null) {
            DirtBuilder.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    @Override
    @NotNull
    public MultiMap<AbstractVcs, FilePath> getDirsForVcs() {
        MultiMap<AbstractVcs, FilePath> multiMap = this.myDirs;
        if (multiMap == null) {
            DirtBuilder.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    @Override
    public boolean isEmpty() {
        return this.myFiles.isEmpty() && this.myDirs.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/DirtBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/DirtBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesForVcs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirsForVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDirtyFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDirtyDirRecursively";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

