/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.ui.Refreshable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0004J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/BaseCommitExecutorAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "executorId", "", "getExecutorId", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getCommitDialog", "Lcom/intellij/openapi/vcs/changes/ui/CommitChangeListDialog;", "getCommitExecutor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "dialog", "isEnabled", "", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "executor", "update", "intellij.platform.vcs.impl"})
public abstract class BaseCommitExecutorAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        CommitChangeListDialog dialog2 = this.getCommitDialog(e);
        CommitExecutor executor = this.getCommitExecutor(dialog2);
        e.getPresentation().setVisible(dialog2 != null && executor != null);
        e.getPresentation().setEnabled(dialog2 != null && executor != null && this.isEnabled(dialog2, executor));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        CommitChangeListDialog commitChangeListDialog = this.getCommitDialog(e);
        if (commitChangeListDialog == null) {
            Intrinsics.throwNpe();
        }
        CommitChangeListDialog dialog2 = commitChangeListDialog;
        CommitExecutor commitExecutor = this.getCommitExecutor(dialog2);
        if (commitExecutor == null) {
            Intrinsics.throwNpe();
        }
        CommitExecutor executor = commitExecutor;
        dialog2.execute(executor);
    }

    @NotNull
    protected abstract String getExecutorId();

    @Nullable
    protected final CommitChangeListDialog getCommitDialog(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = Refreshable.PANEL_KEY.getData(e.getDataContext());
        if (!(object instanceof CommitChangeListDialog)) {
            object = null;
        }
        return (CommitChangeListDialog)((Object)object);
    }

    @Nullable
    protected final CommitExecutor getCommitExecutor(@Nullable CommitChangeListDialog dialog2) {
        CommitExecutor commitExecutor;
        Object object = dialog2;
        if (object != null && (object = object.getExecutors()) != null) {
            Object v1;
            block3: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)object;
                for (Object t : iterable2) {
                    CommitExecutor it = (CommitExecutor)t;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.getExecutorId())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            commitExecutor = v1;
        } else {
            commitExecutor = null;
        }
        return commitExecutor;
    }

    protected final boolean isEnabled(@NotNull CheckinProjectPanel dialog2, @NotNull CommitExecutor executor) {
        Intrinsics.checkParameterIsNotNull((Object)dialog2, (String)"dialog");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        return dialog2.hasDiffs() || executor instanceof CommitExecutorBase && !((CommitExecutorBase)executor).areChangesRequired();
    }

    public BaseCommitExecutorAction() {
        this.setEnabledInModalContext(true);
    }
}

