/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffShelvedChangesActionProvider
implements AnActionExtensionProvider {
    private static final String DIFF_WITH_BASE_ERROR = "Base content not found or not applicable.";
    public static final String SHELVED_VERSION = "Shelved Version";
    public static final String BASE_VERSION = "Base Version";
    public static final String CURRENT_VERSION = "Current Version";

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY) != null || e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(DiffShelvedChangesActionProvider.isEnabled(e.getDataContext()));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(2);
        }
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(e.getDataContext());
    }

    public static boolean isEnabled(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return false;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        return changeLists.size() == 1;
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(dc, false);
    }

    public static void showShelvedChangesDiff(DataContext dc, boolean withLocal) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        ShelvedChangeList changeList = (ShelvedChangeList)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(changeLists));
        List<ShelvedChange> textChanges = changeList.getChanges(project);
        List<ShelvedBinaryFile> binaryChanges = changeList.getBinaryFiles();
        ArrayList<MyDiffRequestProducer> diffRequestProducers = new ArrayList<MyDiffRequestProducer>();
        DiffShelvedChangesActionProvider.processTextChanges(project, textChanges, diffRequestProducers, withLocal);
        DiffShelvedChangesActionProvider.processBinaryFiles(project, binaryChanges, diffRequestProducers);
        Collections.sort(diffRequestProducers, ChangeDiffRequestComparator.getInstance());
        HashSet<Object> selectedChanges = new HashSet<Object>();
        selectedChanges.addAll(ShelvedChangesViewManager.getShelveChanges(dc));
        selectedChanges.addAll(ShelvedChangesViewManager.getBinaryShelveChanges(dc));
        int index = 0;
        for (int i = 0; i < diffRequestProducers.size(); ++i) {
            MyDiffRequestProducer producer = (MyDiffRequestProducer)diffRequestProducers.get(i);
            if (!selectedChanges.contains(producer.getBinaryChange()) && !selectedChanges.contains(producer.getTextChange())) continue;
            index = i;
            break;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(diffRequestProducers, index);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.FRAME);
    }

    private static void processBinaryFiles(final @NotNull Project project, @NotNull List<ShelvedBinaryFile> files, @NotNull List<MyDiffRequestProducer> diffRequestProducers) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(3);
        }
        if (files == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(4);
        }
        if (diffRequestProducers == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(5);
        }
        String base = project.getBasePath();
        for (final ShelvedBinaryFile shelvedChange : files) {
            File file2 = new File(base, shelvedChange.AFTER_PATH == null ? shelvedChange.BEFORE_PATH : shelvedChange.AFTER_PATH);
            FilePath filePath = VcsUtil.getFilePath((File)file2);
            diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                @NotNull
                public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (indicator == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Change change = shelvedChange.createChange(project);
                    DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project, change, this.getName(), context, indicator);
                    if (diffRequest == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return diffRequest;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "process";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "process";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }

    private static void processTextChanges(final @NotNull Project project, @NotNull List<ShelvedChange> changesFromFirstList, @NotNull List<MyDiffRequestProducer> diffRequestProducers, final boolean withLocal) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(6);
        }
        if (changesFromFirstList == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(7);
        }
        if (diffRequestProducers == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(8);
        }
        String base = project.getBasePath();
        final ApplyPatchContext patchContext = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        final PatchesPreloader preloader = new PatchesPreloader(project);
        final CommitContext commitContext = new CommitContext();
        for (final ShelvedChange shelvedChange : changesFromFirstList) {
            VirtualFile file2;
            final String beforePath = shelvedChange.getBeforePath();
            final String afterPath = shelvedChange.getAfterPath();
            FilePath filePath = VcsUtil.getFilePath((File)new File(base, afterPath == null ? beforePath : afterPath));
            final boolean isNewFile = FileStatus.ADDED.equals(shelvedChange.getFileStatus());
            try {
                file2 = ApplyFilePatchBase.findPatchTarget(patchContext, beforePath, afterPath, isNewFile);
                if (!(isNewFile || file2 != null && file2.exists())) {
                    throw new FileNotFoundException(beforePath);
                }
            }
            catch (IOException e) {
                diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                    @NotNull
                    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                        PatchDiffRequest patchDiffRequest;
                        if (context == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (indicator == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        try {
                            TextFilePatch patch = preloader.getPatch(shelvedChange, commitContext);
                            PatchDiffRequest patchDiffRequest2 = new PatchDiffRequest(DiffShelvedChangesActionProvider.createAppliedTextPatch(patch), this.getName(), VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]));
                            DiffUtil.addNotification(DiffNotifications.createNotification("Cannot find local file for '" + (String)ObjectUtils.chooseNotNull((Object)beforePath, (Object)afterPath) + "'"), (UserDataHolder)patchDiffRequest2);
                            patchDiffRequest = patchDiffRequest2;
                        }
                        catch (VcsException e) {
                            throw new DiffRequestProducerException("Can't show diff for '" + this.getName() + "'", (Throwable)e);
                        }
                        if (patchDiffRequest == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return patchDiffRequest;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$2";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "process";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "process";
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
                continue;
            }
            diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                @NotNull
                public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                    TextFilePatch patch;
                    if (context == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (indicator == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (!isNewFile && file2.getFileType() == UnknownFileType.INSTANCE) {
                        UnknownFileTypeDiffRequest unknownFileTypeDiffRequest = new UnknownFileTypeDiffRequest(file2, this.getName());
                        if (unknownFileTypeDiffRequest == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        return unknownFileTypeDiffRequest;
                    }
                    if (isNewFile) {
                        DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project, shelvedChange.getChange(project), this.getName(), context, indicator);
                        if (diffRequest == null) {
                            3.$$$reportNull$$$0(3);
                        }
                        return diffRequest;
                    }
                    try {
                        patch = preloader.getPatch(shelvedChange, commitContext);
                    }
                    catch (VcsException e) {
                        throw new DiffRequestProducerException("Can't show diff for '" + this.getName() + "'", (Throwable)e);
                    }
                    if (patch.isDeletedFile()) {
                        DiffRequest diffRequest = this.createDiffRequestForDeleted(patch);
                        if (diffRequest == null) {
                            3.$$$reportNull$$$0(4);
                        }
                        return diffRequest;
                    }
                    DiffRequest diffRequest = this.createDiffRequestForModified(patch, commitContext, context, indicator);
                    if (diffRequest == null) {
                        3.$$$reportNull$$$0(5);
                    }
                    return diffRequest;
                }

                @NotNull
                private DiffRequest createDiffRequestForDeleted(@NotNull TextFilePatch patch) {
                    if (patch == null) {
                        3.$$$reportNull$$$0(6);
                    }
                    assert (file2 != null);
                    DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                    DiffContent leftContent = withLocal ? contentFactory.create(project, file2) : contentFactory.create(project, patch.getSingleHunkPatchText(), file2);
                    SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)contentFactory.createEmpty(), withLocal ? DiffShelvedChangesActionProvider.CURRENT_VERSION : DiffShelvedChangesActionProvider.SHELVED_VERSION, null);
                    if (simpleDiffRequest == null) {
                        3.$$$reportNull$$$0(7);
                    }
                    return simpleDiffRequest;
                }

                @NotNull
                private DiffRequest createDiffRequestForModified(@NotNull TextFilePatch patch, @NotNull CommitContext commitContext2, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
                    DiffRequest diffRequest;
                    if (patch == null) {
                        3.$$$reportNull$$$0(8);
                    }
                    if (commitContext2 == null) {
                        3.$$$reportNull$$$0(9);
                    }
                    if (context == null) {
                        3.$$$reportNull$$$0(10);
                    }
                    if (indicator == null) {
                        3.$$$reportNull$$$0(11);
                    }
                    assert (file2 != null);
                    CharSequence baseContents = ((BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project, BaseRevisionTextPatchEP.class)).provideContent((String)ObjectUtils.chooseNotNull((Object)patch.getAfterName(), (Object)patch.getBeforeName()), commitContext2);
                    ApplyPatchForBaseRevisionTexts texts = ApplyPatchForBaseRevisionTexts.create(project, file2, patchContext.getPathBeforeRename(file2), patch, baseContents);
                    if (texts.isBaseRevisionLoaded()) {
                        assert (!texts.isAppliedSomehow());
                        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                        DiffContent leftContent = withLocal ? contentFactory.create(project, file2) : contentFactory.create(project, (String)ObjectUtils.assertNotNull((Object)texts.getBase()), file2);
                        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)contentFactory.create(project, texts.getPatched(), file2), withLocal ? DiffShelvedChangesActionProvider.CURRENT_VERSION : DiffShelvedChangesActionProvider.BASE_VERSION, DiffShelvedChangesActionProvider.SHELVED_VERSION);
                        if (simpleDiffRequest == null) {
                            3.$$$reportNull$$$0(12);
                        }
                        return simpleDiffRequest;
                    }
                    DiffRequest diffRequest2 = diffRequest = shelvedChange.isConflictingChange(project) ? PatchDiffRequestFactory.createConflictDiffRequest(project, file2, patch, DiffShelvedChangesActionProvider.SHELVED_VERSION, texts, this.getName()) : PatchDiffRequestFactory.createDiffRequest(project, shelvedChange.getChange(project), this.getName(), context, indicator);
                    if (!withLocal) {
                        DiffUtil.addNotification(DiffNotifications.createNotification("Base content not found or not applicable. Showing difference with local version"), (UserDataHolder)diffRequest);
                    }
                    DiffRequest diffRequest3 = diffRequest;
                    if (diffRequest3 == null) {
                        3.$$$reportNull$$$0(13);
                    }
                    return diffRequest3;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 12: 
                        case 13: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 12: 
                        case 13: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 1: 
                        case 11: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 12: 
                        case 13: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3";
                            break;
                        }
                        case 6: 
                        case 8: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "patch";
                            break;
                        }
                        case 9: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "commitContext";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "process";
                            break;
                        }
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createDiffRequestForDeleted";
                            break;
                        }
                        case 12: 
                        case 13: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createDiffRequestForModified";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "process";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 12: 
                        case 13: {
                            break;
                        }
                        case 6: {
                            objectArray = objectArray;
                            objectArray[2] = "createDiffRequestForDeleted";
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            objectArray = objectArray;
                            objectArray[2] = "createDiffRequestForModified";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 12: 
                        case 13: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }

    @NotNull
    static AppliedTextPatch createAppliedTextPatch(@NotNull TextFilePatch patch) {
        if (patch == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(9);
        }
        GenericPatchApplier applier = new GenericPatchApplier("", patch.getHunks());
        applier.execute();
        AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
        if (appliedTextPatch == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(10);
        }
        return appliedTextPatch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffRequestProducers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesFromFirstList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppliedTextPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTextChanges";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAppliedTextPatch";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MyDiffRequestProducer
    implements ChangeDiffRequestChain.Producer {
        @Nullable
        private final ShelvedChange myTextChange;
        @Nullable
        private final ShelvedBinaryFile myBinaryChange;
        @NotNull
        private final FilePath myFilePath;

        public MyDiffRequestProducer(@NotNull ShelvedChange textChange, @NotNull FilePath filePath) {
            if (textChange == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(1);
            }
            this.myBinaryChange = null;
            this.myTextChange = textChange;
            this.myFilePath = filePath;
        }

        public MyDiffRequestProducer(@NotNull ShelvedBinaryFile binaryChange, @NotNull FilePath filePath) {
            if (binaryChange == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (filePath == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(3);
            }
            this.myBinaryChange = binaryChange;
            this.myTextChange = null;
            this.myFilePath = filePath;
        }

        @Nullable
        public ShelvedChange getTextChange() {
            return this.myTextChange;
        }

        @Nullable
        public ShelvedBinaryFile getBinaryChange() {
            return this.myBinaryChange;
        }

        @NotNull
        public String getName() {
            String string = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
            if (string == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            if (this.myTextChange != null) {
                FileStatus fileStatus = this.myTextChange.getFileStatus();
                if (fileStatus == null) {
                    MyDiffRequestProducer.$$$reportNull$$$0(5);
                }
                return fileStatus;
            }
            assert (this.myBinaryChange != null);
            FileStatus fileStatus = this.myBinaryChange.getFileStatus();
            if (fileStatus == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return fileStatus;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(7);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textChange";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryChange";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class PatchesPreloader {
        private final Project myProject;
        private final SoftHardCacheMap<String, PatchInfo> myFilePatchesMap = new SoftHardCacheMap(5, 5);
        private final ReadWriteLock myLock = new ReentrantReadWriteLock(true);

        PatchesPreloader(Project project) {
            this.myProject = project;
        }

        @NotNull
        public TextFilePatch getPatch(ShelvedChange shelvedChange, @Nullable CommitContext commitContext) throws VcsException {
            PatchInfo patchInfo;
            String patchPath = shelvedChange.getPatchPath();
            if (this.getInfoFromCache(patchPath) == null || this.isPatchFileChanged(patchPath)) {
                this.readFilePatchAndUpdateCaches(patchPath, commitContext);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) != null) {
                for (TextFilePatch textFilePatch : patchInfo.myTextFilePatches) {
                    if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                    TextFilePatch textFilePatch2 = textFilePatch;
                    if (textFilePatch2 == null) {
                        PatchesPreloader.$$$reportNull$$$0(0);
                    }
                    return textFilePatch2;
                }
            }
            throw new VcsException("Can not find patch for " + shelvedChange.getBeforePath() + " in patch file.");
        }

        private PatchInfo getInfoFromCache(@NotNull String patchPath) {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(1);
            }
            try {
                this.myLock.readLock().lock();
                PatchInfo patchInfo = this.myFilePatchesMap.get(patchPath);
                return patchInfo;
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        private void readFilePatchAndUpdateCaches(@NotNull String patchPath, @Nullable CommitContext commitContext) throws VcsException {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(2);
            }
            try {
                this.myLock.writeLock().lock();
                this.myFilePatchesMap.put(patchPath, new PatchInfo(ShelveChangesManager.loadPatches(this.myProject, patchPath, commitContext), new File(patchPath).lastModified()));
            }
            catch (PatchSyntaxException | IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        public boolean isPatchFileChanged(@NotNull String patchPath) {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(3);
            }
            PatchInfo patchInfo = this.getInfoFromCache(patchPath);
            long lastModified = new File(patchPath).lastModified();
            return patchInfo != null && lastModified != patchInfo.myLoadedTimeStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatch";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getInfoFromCache";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "readFilePatchAndUpdateCaches";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isPatchFileChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class PatchInfo {
            private final long myLoadedTimeStamp;
            @NotNull
            private final List<TextFilePatch> myTextFilePatches;

            public PatchInfo(@NotNull List<TextFilePatch> patches, long loadedTimeStamp) {
                if (patches == null) {
                    PatchInfo.$$$reportNull$$$0(0);
                }
                this.myTextFilePatches = patches;
                this.myLoadedTimeStamp = loadedTimeStamp;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader$PatchInfo", "<init>"));
            }
        }
    }

    private static class ChangeDiffRequestComparator
    implements Comparator<DiffRequestProducer> {
        private static final ChangeDiffRequestComparator ourInstance = new ChangeDiffRequestComparator();

        private ChangeDiffRequestComparator() {
        }

        public static ChangeDiffRequestComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(DiffRequestProducer o1, DiffRequestProducer o2) {
            return FilePathsHelper.convertPath((String)o1.getName()).compareTo(FilePathsHelper.convertPath((String)o2.getName()));
        }
    }
}

