/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTree
extends Tree
implements DataProvider {
    @NotNull
    protected final Project myProject;
    private final boolean myShowCheckboxes;
    private final int myCheckboxWidth;
    private boolean myShowFlatten;
    private boolean myIsModelFlat;
    @NotNull
    private Set<Object> myIncludedChanges;
    @NotNull
    private Runnable myDoubleClickHandler;
    private boolean myKeepTreeState;
    @NonNls
    private static final String FLATTEN_OPTION_KEY = "ChangesBrowser.SHOW_FLATTEN";
    @Nullable
    private Runnable myInclusionListener;
    @NotNull
    private final CopyProvider myTreeCopyProvider;
    private TreeState myNonFlatTreeState;

    public ChangesTree(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            ChangesTree.$$$reportNull$$$0(0);
        }
        super((TreeNode)ChangesBrowserNode.createRoot(project));
        this.myIncludedChanges = new THashSet();
        this.myDoubleClickHandler = EmptyRunnable.getInstance();
        this.myKeepTreeState = false;
        this.myProject = project;
        this.myShowCheckboxes = showCheckboxes;
        this.myCheckboxWidth = new JCheckBox().getPreferredSize().width;
        this.setHorizontalAutoScrollingEnabled(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        new TreeSpeedSearch(this, ChangesBrowserNode.TO_TEXT_CONVERTER);
        ChangesBrowserNodeRenderer nodeRenderer = new ChangesBrowserNodeRenderer(this.myProject, () -> this.myShowFlatten, highlightProblems);
        this.setCellRenderer(new MyTreeCellRenderer(nodeRenderer));
        new MyToggleSelectionAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangesTree.this.myDoubleClickHandler.run();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode() && e.getModifiers() == 0) {
                    if (ChangesTree.this.getSelectionCount() <= 1) {
                        Object lastPathComponent = ChangesTree.this.getLastSelectedPathComponent();
                        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                            return;
                        }
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
                        if (!node.isLeaf()) {
                            return;
                        }
                    }
                    ChangesTree.this.myDoubleClickHandler.run();
                    e.consume();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TreePath clickPath;
                TreePath treePath = clickPath = ChangesTree.this.getUI() instanceof WideSelectionTreeUI ? ChangesTree.this.getClosestPathForLocation(e.getX(), e.getY()) : ChangesTree.this.getPathForLocation(e.getX(), e.getY());
                if (clickPath == null) {
                    return false;
                }
                int row = ChangesTree.this.getRowForLocation(e.getPoint().x, e.getPoint().y);
                if (row >= 0 && ChangesTree.this.myShowCheckboxes) {
                    Rectangle baseRect = ChangesTree.this.getRowBounds(row);
                    baseRect.setSize(ChangesTree.this.myCheckboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        return false;
                    }
                }
                ChangesTree.this.myDoubleClickHandler.run();
                return true;
            }
        }.installOn((Component)((Object)this));
        new TreeLinkMouseListener(nodeRenderer){

            @Override
            protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree, @NotNull TreePath path) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (tree == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (path == null) {
                    4.$$$reportNull$$$0(2);
                }
                int x = super.getRendererRelativeX(e, tree, path);
                return !ChangesTree.this.myShowCheckboxes ? x : x - ChangesTree.this.myCheckboxWidth;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!ChangesTree.this.isEmpty()) {
                    super.mouseMoved(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tree";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$4";
                objectArray[2] = "getRendererRelativeX";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.installOn((Component)((Object)this));
        SmartExpander.installOn((JTree)((Object)this));
        this.myShowFlatten = PropertiesComponent.getInstance((Project)this.myProject).isTrueValue(FLATTEN_OPTION_KEY);
        String emptyText = StringUtil.capitalize((String)DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        this.setEmptyText(emptyText);
        this.myTreeCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
    }

    public void setEmptyText(@NotNull String emptyText) {
        if (emptyText == null) {
            ChangesTree.$$$reportNull$$$0(1);
        }
        this.getEmptyText().setText(emptyText);
    }

    public void addSelectionListener(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ChangesTree.$$$reportNull$$$0(2);
        }
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                runnable2.run();
            }
        });
    }

    public void setInclusionListener(@Nullable Runnable runnable2) {
        this.myInclusionListener = runnable2;
    }

    public void setDoubleClickHandler(@NotNull Runnable doubleClickHandler) {
        if (doubleClickHandler == null) {
            ChangesTree.$$$reportNull$$$0(3);
        }
        this.myDoubleClickHandler = doubleClickHandler;
    }

    public void installPopupHandler(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)this), (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    public JComponent getPreferredFocusedComponent() {
        return this;
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    public boolean isShowCheckboxes() {
        return this.myShowCheckboxes;
    }

    public void setShowFlatten(boolean showFlatten) {
        if (this.myShowFlatten == showFlatten) {
            return;
        }
        List<Object> oldSelection = this.getSelectedUserObjects();
        if (this.myKeepTreeState && showFlatten) {
            this.myNonFlatTreeState = TreeState.createOn((JTree)((Object)this), this.getRoot());
        }
        this.myShowFlatten = showFlatten;
        this.rebuildTree();
        if (this.myKeepTreeState && !showFlatten && this.myNonFlatTreeState != null) {
            this.myNonFlatTreeState.applyTo((JTree)((Object)this), this.getRoot());
        }
        this.setSelectedChanges(oldSelection);
    }

    private void setChildIndent(boolean isFlat) {
        BasicTreeUI treeUI = (BasicTreeUI)this.getUI();
        treeUI.setLeftChildIndent(!isFlat ? UIUtil.getTreeLeftChildIndent() : 0);
        treeUI.setRightChildIndent(!isFlat ? UIUtil.getTreeRightChildIndent() : 0);
    }

    private boolean isCurrentModelFlat() {
        boolean isFlat = true;
        Enumeration<TreeNode> enumeration = this.getRoot().depthFirstEnumeration();
        while (isFlat && enumeration.hasMoreElements()) {
            isFlat = ((ChangesBrowserNode)enumeration.nextElement()).getLevel() <= 1;
        }
        return isFlat;
    }

    public abstract void rebuildTree();

    protected void updateTreeModel(@NotNull DefaultTreeModel model) {
        if (model == null) {
            ChangesTree.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreeState state = null;
        if (this.myKeepTreeState) {
            state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        }
        this.setModel(model);
        this.myIsModelFlat = this.isCurrentModelFlat();
        this.setChildIndent(this.myShowFlatten && this.myIsModelFlat);
        if (this.myKeepTreeState) {
            state.applyTo((JTree)((Object)this), this.getRoot());
        } else {
            this.resetTreeState();
        }
    }

    private void resetTreeState() {
        TreeUtil.expandAll((JTree)((Object)this));
        int selectedTreeRow = -1;
        if (this.myShowCheckboxes && this.myIncludedChanges.size() > 0) {
            ChangesBrowserNode node;
            ChangesBrowserNode<?> root = this.getRoot();
            Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (node == root || this.getNodeStatus(node) != ThreeStateCheckBox.State.NOT_SELECTED) continue;
                this.collapsePath(new TreePath(node.getPath()));
            }
            enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (!node.isLeaf() || this.getNodeStatus(node) != ThreeStateCheckBox.State.SELECTED) continue;
                selectedTreeRow = this.getRowForPath(new TreePath(node.getPath()));
                break;
            }
        }
        if (selectedTreeRow >= 0) {
            this.setSelectionRow(selectedTreeRow);
        }
        TreeUtil.showRowCentered((JTree)((Object)this), (int)selectedTreeRow, (boolean)false);
    }

    public void selectFile(@Nullable VirtualFile toSelect2) {
        if (toSelect2 != null) {
            int rowInTree = this.findRowContainingFile(this.getRoot(), toSelect2);
            if (rowInTree == -1) {
                return;
            }
            this.setSelectionRow(rowInTree);
            TreeUtil.showRowCentered((JTree)((Object)this), (int)rowInTree, (boolean)false);
        }
    }

    private int findRowContainingFile(@NotNull TreeNode root, @NotNull VirtualFile toSelect2) {
        if (root == null) {
            ChangesTree.$$$reportNull$$$0(5);
        }
        if (toSelect2 == null) {
            ChangesTree.$$$reportNull$$$0(6);
        }
        Ref row = Ref.create((Object)-1);
        TreeUtil.traverse((TreeNode)root, node -> {
            Object userObject;
            if (toSelect2 == null) {
                ChangesTree.$$$reportNull$$$0(17);
            }
            if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Change && ChangesTree.matches((Change)userObject, toSelect2)) {
                Object[] path = ((DefaultMutableTreeNode)node).getPath();
                row.set((Object)this.getRowForPath(new TreePath(path)));
            }
            return (Integer)row.get() == -1;
        });
        return (Integer)row.get();
    }

    private static boolean matches(@NotNull Change change, @NotNull VirtualFile file2) {
        VirtualFile virtualFile;
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ChangesTree.$$$reportNull$$$0(8);
        }
        return (virtualFile = change.getVirtualFile()) != null && virtualFile.equals(file2) || ChangesTree.seemsToBeMoved(change, file2);
    }

    private static boolean seemsToBeMoved(Change change, VirtualFile toSelect2) {
        ContentRevision afterRevision = change.getAfterRevision();
        if (afterRevision == null) {
            return false;
        }
        FilePath file2 = afterRevision.getFile();
        return FileUtil.pathsEqual((String)file2.getPath(), (String)toSelect2.getPath());
    }

    @NotNull
    private List<Object> getAllUserObjects() {
        List<Object> list2 = VcsTreeModelData.all((JTree)((Object)this)).userObjects();
        if (list2 == null) {
            ChangesTree.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    private List<Object> getUserObjectsUnder(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(10);
        }
        List<Object> list2 = VcsTreeModelData.children(node).userObjects();
        if (list2 == null) {
            ChangesTree.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    private List<Object> getSelectedUserObjects() {
        List<Object> list2 = VcsTreeModelData.selected((JTree)((Object)this)).userObjects();
        if (list2 == null) {
            ChangesTree.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    ChangesBrowserNode<?> getRoot() {
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)this.getModel().getRoot();
        if (changesBrowserNode == null) {
            ChangesTree.$$$reportNull$$$0(13);
        }
        return changesBrowserNode;
    }

    private void notifyInclusionListener() {
        if (this.myInclusionListener != null) {
            this.myInclusionListener.run();
        }
    }

    public void setInclusionHashingStrategy(@NotNull TObjectHashingStrategy<Object> strategy) {
        if (strategy == null) {
            ChangesTree.$$$reportNull$$$0(14);
        }
        Set<Object> oldInclusion = this.myIncludedChanges;
        this.myIncludedChanges = new THashSet(strategy);
        this.myIncludedChanges.addAll(oldInclusion);
    }

    public void setIncludedChanges(Collection<?> changes) {
        this.myIncludedChanges.clear();
        this.myIncludedChanges.addAll(changes);
        this.repaint();
    }

    public void includeChange(Object change) {
        this.includeChanges(Collections.singleton(change));
    }

    public void includeChanges(Collection<?> changes) {
        this.myIncludedChanges.addAll(changes);
        this.notifyInclusionListener();
        this.repaint();
    }

    public void excludeChange(Object change) {
        this.excludeChanges(Collections.singleton(change));
    }

    public void excludeChanges(Collection<?> changes) {
        this.myIncludedChanges.removeAll(changes);
        this.notifyInclusionListener();
        this.repaint();
    }

    protected void toggleChanges(Collection<?> changes) {
        boolean hasExcluded = false;
        for (Object value : changes) {
            if (this.myIncludedChanges.contains(value)) continue;
            hasExcluded = true;
            break;
        }
        if (hasExcluded) {
            this.includeChanges(changes);
        } else {
            this.excludeChanges(changes);
        }
    }

    public boolean isIncluded(Object change) {
        return this.myIncludedChanges.contains(change);
    }

    @NotNull
    public Set<Object> getIncludedSet() {
        Set<Object> set2 = Collections.unmodifiableSet(this.myIncludedChanges);
        if (set2 == null) {
            ChangesTree.$$$reportNull$$$0(15);
        }
        return set2;
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public AnAction[] getTreeActions() {
        ToggleShowDirectoriesAction directoriesAction = new ToggleShowDirectoriesAction();
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)((Object)this)){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(!ChangesTree.this.myShowFlatten || !ChangesTree.this.myIsModelFlat);
            }
        };
        CollapseAllAction collapseAllAction = new CollapseAllAction((JTree)((Object)this)){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(!ChangesTree.this.myShowFlatten || !ChangesTree.this.myIsModelFlat);
            }
        };
        AnAction[] actions = new AnAction[]{directoriesAction, expandAllAction, collapseAllAction};
        directoriesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, SystemInfo.isMac ? 256 : 128)), (JComponent)((Object)this));
        expandAllAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ExpandAll"), (JComponent)((Object)this));
        collapseAllAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CollapseAll"), (JComponent)((Object)this));
        return actions;
    }

    public void setSelectionMode(@JdkConstants.TreeSelectionMode int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    private ThreeStateCheckBox.State getNodeStatus(ChangesBrowserNode<?> node) {
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        for (Object change : this.getUserObjectsUnder(node)) {
            if (this.myIncludedChanges.contains(change)) {
                hasIncluded = true;
                continue;
            }
            hasExcluded = true;
        }
        if (hasIncluded && hasExcluded) {
            return ThreeStateCheckBox.State.DONT_CARE;
        }
        if (hasIncluded) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        return ThreeStateCheckBox.State.NOT_SELECTED;
    }

    protected boolean isNodeEnabled(ChangesBrowserNode<?> node) {
        return this.getNodeStatus(node) != ThreeStateCheckBox.State.DONT_CARE;
    }

    public void setSelectedChanges(@NotNull Collection<?> changes) {
        if (changes == null) {
            ChangesTree.$$$reportNull$$$0(16);
        }
        HashSet changesSet = new HashSet(changes);
        ArrayList treeSelection = new ArrayList(changes.size());
        TreeUtil.traverse(this.getRoot(), node -> {
            DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
            if (changesSet.contains(mutableNode.getUserObject())) {
                treeSelection.add(new TreePath(mutableNode.getPath()));
            }
            return true;
        });
        this.setSelectionPaths(treeSelection.toArray(new TreePath[0]));
        if (treeSelection.size() == 1) {
            this.scrollPathToVisible((TreePath)treeSelection.get(0));
        }
    }

    public void setKeepTreeState(boolean keepTreeState) {
        this.myKeepTreeState = keepTreeState;
    }

    @Nullable
    public Object getData(String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myTreeCopyProvider;
        }
        return null;
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public Color getFileColorFor(Object object) {
        VirtualFile file2 = object instanceof FilePath ? ((FilePath)object).getVirtualFile() : (object instanceof Change ? ((Change)object).getVirtualFile() : (VirtualFile)ObjectUtils.tryCast((Object)object, VirtualFile.class));
        if (file2 != null) {
            return FileColorManager.getInstance((Project)this.myProject).getFileColor(file2);
        }
        return super.getFileColorFor(object);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            if (!this.isEnabled()) {
                return;
            }
            int row = this.getRowForLocation(e.getX(), e.getY());
            if (row >= 0) {
                Rectangle baseRect = this.getRowBounds(row);
                baseRect.setSize(this.myCheckboxWidth, baseRect.height);
                if (baseRect.contains(e.getPoint())) {
                    this.setSelectionRow(row);
                    this.toggleChanges(this.getSelectedUserObjects());
                }
            }
        }
        super.processMouseEvent(e);
    }

    public int getToggleClickCount() {
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubleClickHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUserObjects";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserObjectsUnder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUserObjects";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDoubleClickHandler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRowContainingFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserObjectsUnder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setInclusionHashingStrategy";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedChanges";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRowContainingFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ToggleShowDirectoriesAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowDirectoriesAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !ChangesTree.this.isShowFlatten();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            PropertiesComponent.getInstance((Project)ChangesTree.this.myProject).setValue(ChangesTree.FLATTEN_OPTION_KEY, String.valueOf(!state));
            ChangesTree.this.setShowFlatten(!state);
        }
    }

    private class MyToggleSelectionAction
    extends AnAction
    implements DumbAware {
        private MyToggleSelectionAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            List changes = ChangesTree.this.getSelectedUserObjects();
            if (changes.isEmpty()) {
                changes = ChangesTree.this.getAllUserObjects();
            }
            ChangesTree.this.toggleChanges(changes);
        }
    }

    private class MyTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final ChangesBrowserNodeRenderer myTextRenderer;
        private final JCheckBox myCheckBox;

        public MyTreeCellRenderer(ChangesBrowserNodeRenderer textRenderer) {
            if (textRenderer == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myCheckBox = new JCheckBox();
            this.myTextRenderer = textRenderer;
            if (ChangesTree.this.myShowCheckboxes) {
                this.add((Component)this.myCheckBox, "West");
            }
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (UIUtil.isUnderGTKLookAndFeel()) {
                NonOpaquePanel.setTransparent((JComponent)this);
                NonOpaquePanel.setTransparent((JComponent)this.myCheckBox);
            } else {
                this.setBackground(null);
                this.myCheckBox.setBackground(null);
                this.myCheckBox.setOpaque(false);
            }
            this.myTextRenderer.setOpaque(false);
            this.myTextRenderer.setTransparentIconBackground(true);
            this.myTextRenderer.setToolTipText(null);
            this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (ChangesTree.this.myShowCheckboxes) {
                ThreeStateCheckBox.State state = ChangesTree.this.getNodeStatus((ChangesBrowserNode)value);
                this.myCheckBox.setSelected(state != ThreeStateCheckBox.State.NOT_SELECTED);
                this.myCheckBox.setEnabled(tree.isEnabled() && ChangesTree.this.isNodeEnabled((ChangesBrowserNode)value));
                this.revalidate();
                return this;
            }
            return this.myTextRenderer;
        }

        @Override
        public String getToolTipText() {
            return this.myTextRenderer.getToolTipText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRenderer", "com/intellij/openapi/vcs/changes/ui/ChangesTree$MyTreeCellRenderer", "<init>"));
        }
    }
}

