/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ReadonlyStatusHandler", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ReadonlyStatusHandlerImpl
extends ReadonlyStatusHandler
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl");
    private final Project myProject;
    private final WritingAccessProvider[] myAccessProviders;
    protected boolean myClearReadOnlyInTests;
    private State myState = new State();

    public ReadonlyStatusHandlerImpl(Project project) {
        this.myProject = project;
        this.myAccessProviders = WritingAccessProvider.getProvidersForProject((Project)this.myProject);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    /*
     * WARNING - void declaration
     */
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(VirtualFile ... files) {
        if (files == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(1);
        }
        if (files.length == 0) {
            return new OperationStatusImpl(VirtualFile.EMPTY_ARRAY);
        }
        ReadonlyStatusHandlerImpl.checkThreading();
        THashSet realFiles = new THashSet(files.length);
        for (VirtualFile virtualFile : files) {
            void var6_6;
            void var6_9;
            VirtualFile originalFile;
            if (virtualFile instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)virtualFile).getOriginalFile()) != null) {
                VirtualFile virtualFile2 = originalFile;
            }
            if (var6_9 instanceof VirtualFileWindow) {
                VirtualFile virtualFile3 = ((VirtualFileWindow)var6_9).getDelegate();
            }
            if (var6_6 == null) continue;
            realFiles.add(var6_6);
        }
        files = VfsUtilCore.toVirtualFileArray((Collection)realFiles);
        for (VirtualFile virtualFile : this.myAccessProviders) {
            Collection denied = ContainerUtil.filter((Object[])files, arg_0 -> ReadonlyStatusHandlerImpl.lambda$ensureFilesWritable$0((WritingAccessProvider)virtualFile, arg_0));
            if (denied.isEmpty()) {
                denied = virtualFile.requestWriting(files);
            }
            if (denied.isEmpty()) continue;
            return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray((Collection)denied));
        }
        FileInfo[] fileInfos = this.createFileInfos(files);
        if (fileInfos.length == 0) {
            return ReadonlyStatusHandlerImpl.createResultStatus(files);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myClearReadOnlyInTests) {
                ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(Arrays.asList(fileInfos)), null);
            }
            return ReadonlyStatusHandlerImpl.createResultStatus(files);
        }
        int savedEventCount = IdeEventQueue.getInstance().getEventCount();
        if (this.myState.SHOW_DIALOG) {
            new ReadOnlyStatusDialog(this.myProject, fileInfos).show();
        } else {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(Arrays.asList(fileInfos)), null);
        }
        IdeEventQueue.getInstance().setEventCount(savedEventCount);
        return ReadonlyStatusHandlerImpl.createResultStatus(files);
    }

    private static void checkThreading() {
        Application app = ApplicationManager.getApplication();
        app.assertIsDispatchThread();
        if (!app.isWriteAccessAllowed()) {
            return;
        }
        if (app.isUnitTestMode() && Registry.is((String)"tests.assert.clear.read.only.status.outside.write.action")) {
            LOG.error("ensureFilesWritable should be called outside write action");
        }
    }

    private static ReadonlyStatusHandler.OperationStatus createResultStatus(VirtualFile[] files) {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            if (!file2.exists() || file2.isWritable()) continue;
            readOnlyFiles.add(file2);
        }
        return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
    }

    private FileInfo[] createFileInfos(VirtualFile[] files) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (VirtualFile file2 : files) {
            if (file2 == null || file2.isWritable() || !file2.isInLocalFileSystem()) continue;
            fileInfos.add(new FileInfo(file2, this.myProject));
        }
        return fileInfos.toArray(new FileInfo[0]);
    }

    public static void processFiles(List<FileInfo> fileInfos, @Nullable String changelist) {
        FileInfo[] copy = fileInfos.toArray(new FileInfo[0]);
        MultiValuesMap handleTypeToFile = new MultiValuesMap();
        for (FileInfo fileInfo : copy) {
            handleTypeToFile.put((Object)fileInfo.getSelectedHandleType(), (Object)fileInfo.getFile());
        }
        for (HandleType handleType : handleTypeToFile.keySet()) {
            handleType.processFiles(handleTypeToFile.get((Object)handleType), changelist);
        }
        for (FileInfo fileInfo : copy) {
            if (fileInfo.getFile().exists() && !fileInfo.getFile().isWritable()) continue;
            fileInfos.remove(fileInfo);
        }
    }

    public void setClearReadOnlyInTests(boolean clearReadOnlyInTests) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myClearReadOnlyInTests = clearReadOnlyInTests;
    }

    private static /* synthetic */ boolean lambda$ensureFilesWritable$0(WritingAccessProvider accessProvider, VirtualFile virtualFile) {
        return !accessProvider.isPotentiallyWritable(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureFilesWritable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;

        OperationStatusImpl(VirtualFile[] readonlyFiles) {
            this.myReadonlyFiles = readonlyFiles;
        }

        @NotNull
        public VirtualFile[] getReadonlyFiles() {
            if (this.myReadonlyFiles == null) {
                OperationStatusImpl.$$$reportNull$$$0(0);
            }
            return this.myReadonlyFiles;
        }

        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        @NotNull
        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                StringBuilder buf = new StringBuilder();
                if (this.myReadonlyFiles.length > 1) {
                    for (VirtualFile file2 : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file2.getPresentableUrl());
                    }
                    String string = CommonBundle.message((String)"failed.to.make.the.following.files.writable.error.message", (Object[])new Object[]{buf.toString()});
                    if (string == null) {
                        OperationStatusImpl.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = CommonBundle.message((String)"failed.to.make.file.writeable.error.message", (Object[])new Object[]{this.myReadonlyFiles[0].getPresentableUrl()});
                if (string == null) {
                    OperationStatusImpl.$$$reportNull$$$0(2);
                }
                return string;
            }
            throw new RuntimeException("No readonly files");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl$OperationStatusImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFiles";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFilesMessage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class State {
        public boolean SHOW_DIALOG = true;
    }
}

