/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class VcsHandleType
extends HandleType {
    private static final Function<LocalChangeList, String> FUNCTION = list2 -> list2.getName();
    private final AbstractVcs myVcs;
    private final ChangeListManager myChangeListManager;
    private final Function<VirtualFile, Change> myChangeFunction;

    public VcsHandleType(AbstractVcs vcs) {
        super(VcsBundle.message((String)"handle.ro.file.status.type.using.vcs", (Object[])new Object[]{vcs.getDisplayName()}), true);
        this.myVcs = vcs;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myVcs.getProject());
        this.myChangeFunction = file2 -> this.myChangeListManager.getChange(file2);
    }

    @Override
    public void processFiles(Collection<VirtualFile> files, @Nullable String changelist) {
        try {
            EditFileProvider provider = this.myVcs.getEditFileProvider();
            assert (provider != null);
            provider.editFiles(VfsUtilCore.toVirtualFileArray(files));
        }
        catch (VcsException e) {
            Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.cannot.edit.file", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.edit.files", (Object[])new Object[0]));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile file2 : files) {
                file2.refresh(false, false);
            }
        });
        if (changelist != null) {
            this.myChangeListManager.invokeAfterUpdate(() -> {
                LocalChangeList list2 = this.myChangeListManager.findChangeList(changelist);
                if (list2 != null) {
                    List changes = ContainerUtil.mapNotNull((Collection)files, this.myChangeFunction);
                    this.myChangeListManager.moveChangesTo(list2, changes.toArray(new Change[0]));
                }
            }, InvokeAfterUpdateMode.SILENT, "", ModalityState.NON_MODAL);
        }
    }

    @Override
    public List<String> getChangelists() {
        return ContainerUtil.map((Collection)this.myChangeListManager.getChangeLists(), FUNCTION);
    }

    @Override
    public String getDefaultChangelist() {
        return this.myChangeListManager.getDefaultListName();
    }
}

