/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Encoding", storages={@Storage(value="encodings.xml")})
public class EncodingProjectManagerImpl
extends EncodingProjectManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String PROJECT_URL = "PROJECT";
    private final Project myProject;
    private final EncodingManagerImpl myIdeEncodingManager;
    private boolean myNative2AsciiForPropertiesFiles;
    private Charset myDefaultCharsetForPropertiesFiles;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    private BOMForNewUTF8Files myBOMForNewUTF8Files = BOMForNewUTF8Files.NEVER;
    private final Map<VirtualFile, Charset> myMapping = ContainerUtil.newConcurrentMap();
    private volatile Charset myProjectCharset;
    private static final ThreadLocal<Boolean> SUPPRESS_RELOAD = new ThreadLocal();

    public EncodingProjectManagerImpl(Project project, EncodingManager ideEncodingManager) {
        this.myProject = project;
        this.myIdeEncodingManager = (EncodingManagerImpl)ideEncodingManager;
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(this::reloadAlreadyLoadedDocuments);
    }

    public Element getState() {
        Element element = new Element("x");
        if (!this.myMapping.isEmpty()) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myMapping.keySet());
            ContainerUtil.quickSort(files, Comparator.comparing(VirtualFile::getPath));
            for (VirtualFile file2 : files) {
                Charset charset = this.myMapping.get(file2);
                Element child = new Element("file");
                element.addContent(child);
                child.setAttribute("url", file2.getUrl());
                child.setAttribute("charset", charset.name());
            }
        }
        if (this.myProjectCharset != null) {
            Element child = new Element("file");
            element.addContent(child);
            child.setAttribute("url", PROJECT_URL);
            child.setAttribute("charset", this.myProjectCharset.name());
        }
        if (this.myNative2AsciiForPropertiesFiles) {
            element.setAttribute("native2AsciiForPropertiesFiles", Boolean.toString(true));
        }
        if (this.myDefaultCharsetForPropertiesFiles != null) {
            element.setAttribute("defaultCharsetForPropertiesFiles", this.myDefaultCharsetForPropertiesFiles.name());
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(0);
        }
        this.myMapping.clear();
        List files = element.getChildren("file");
        if (!files.isEmpty()) {
            THashMap mapping = new THashMap();
            for (Element fileElement : files) {
                String url = fileElement.getAttributeValue("url");
                String charsetName = fileElement.getAttributeValue("charset");
                Charset charset = CharsetToolkit.forName((String)charsetName);
                if (charset == null) continue;
                if (url.equals(PROJECT_URL)) {
                    this.myProjectCharset = charset;
                    continue;
                }
                VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file2 == null) continue;
                mapping.put(file2, charset);
            }
            this.myMapping.putAll((Map<VirtualFile, Charset>)mapping);
        }
        this.myNative2AsciiForPropertiesFiles = Boolean.parseBoolean(element.getAttributeValue("native2AsciiForPropertiesFiles"));
        this.myDefaultCharsetForPropertiesFiles = CharsetToolkit.forName((String)element.getAttributeValue("defaultCharsetForPropertiesFiles"));
        this.myModificationTracker.incModificationCount();
    }

    private void reloadAlreadyLoadedDocuments() {
        for (VirtualFile file2 : this.myMapping.keySet()) {
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (cachedDocument == null) continue;
            EncodingProjectManagerImpl.reload(file2);
        }
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile, boolean useParentDefaults) {
        for (VirtualFile parent = virtualFile; parent != null; parent = parent.getParent()) {
            Charset charset = this.myMapping.get(parent);
            if (charset == null && useParentDefaults) continue;
            return charset;
        }
        return this.getDefaultCharset();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(1);
        }
        return simpleModificationTracker;
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Charset oldCharset;
        if (virtualFileOrDir == null) {
            oldCharset = this.myProjectCharset;
            this.myProjectCharset = charset;
        } else {
            oldCharset = charset == null ? this.myMapping.remove(virtualFileOrDir) : this.myMapping.put(virtualFileOrDir, charset);
        }
        if (!Comparing.equal((Object)oldCharset, (Object)charset) || virtualFileOrDir != null && !Comparing.equal((Object)virtualFileOrDir.getCharset(), (Object)charset)) {
            this.myModificationTracker.incModificationCount();
            if (virtualFileOrDir != null) {
                virtualFileOrDir.setCharset(virtualFileOrDir.getBOM() == null ? charset : null);
            }
            this.reloadAllFilesUnder(virtualFileOrDir);
        }
    }

    private static void clearAndReload(@NotNull VirtualFile virtualFileOrDir) {
        if (virtualFileOrDir == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(2);
        }
        virtualFileOrDir.setCharset(null);
        EncodingProjectManagerImpl.reload(virtualFileOrDir);
    }

    private static void reload(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (virtualFile == null) {
                EncodingProjectManagerImpl.$$$reportNull$$$0(22);
            }
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            ((VirtualFileListener)documentManager).contentsChanged(new VirtualFileEvent(null, virtualFile, virtualFile.getName(), virtualFile.getParent()));
        });
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        Set<Charset> result2 = EncodingProjectManagerImpl.widelyKnownCharsets();
        result2.addAll(this.myMapping.values());
        result2.add(this.getDefaultCharset());
        Set<Charset> set2 = result2;
        if (set2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    static Set<Charset> widelyKnownCharsets() {
        HashSet<Charset> result2 = new HashSet<Charset>();
        result2.add(CharsetToolkit.UTF8_CHARSET);
        result2.add(CharsetToolkit.getDefaultSystemCharset());
        result2.add(CharsetToolkit.UTF_16_CHARSET);
        result2.add(CharsetToolkit.forName((String)"ISO-8859-1"));
        result2.add(CharsetToolkit.forName((String)"US-ASCII"));
        result2.add(EncodingManager.getInstance().getDefaultCharset());
        result2.add(EncodingManager.getInstance().getDefaultCharsetForPropertiesFiles(null));
        result2.remove(null);
        HashSet<Charset> hashSet = result2;
        if (hashSet == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    public Map<VirtualFile, Charset> getAllMappings() {
        Map<VirtualFile, Charset> map = this.myMapping;
        if (map == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(6);
        }
        return map;
    }

    public void setMapping(@NotNull Map<VirtualFile, Charset> mapping) {
        if (mapping == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        THashMap newMap = new THashMap(mapping.size());
        THashMap oldMap = new THashMap(this.myMapping);
        EncodingProjectManagerImpl.suppressReloadDuring(() -> this.lambda$setMapping$1(mapping, (Map)oldMap, (Map)newMap));
        this.myMapping.clear();
        this.myMapping.putAll((Map<VirtualFile, Charset>)newMap);
        HashSet changed = new HashSet(oldMap.keySet());
        for (Map.Entry entry : newMap.entrySet()) {
            VirtualFile file2 = (VirtualFile)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            Charset oldCharset = (Charset)oldMap.get(file2);
            if (!Comparing.equal((Object)oldCharset, (Object)charset)) continue;
            changed.remove(file2);
        }
        HashSet added = new HashSet(newMap.keySet());
        added.removeAll(oldMap.keySet());
        HashSet removed = new HashSet(oldMap.keySet());
        removed.removeAll(newMap.keySet());
        changed.addAll(added);
        changed.addAll(removed);
        changed.remove(null);
        if (!changed.isEmpty()) {
            Processor<VirtualFile> reloadProcessor = EncodingProjectManagerImpl.createChangeCharsetProcessor();
            this.tryStartReloadWithProgress(() -> {
                THashSet processed2 = new THashSet();
                block0: for (VirtualFile changedFile : changed) {
                    for (VirtualFile processedFile : processed2) {
                        if (!VfsUtilCore.isAncestor((VirtualFile)processedFile, (VirtualFile)changedFile, (boolean)false)) continue;
                        continue block0;
                    }
                    this.processSubFiles(changedFile, reloadProcessor);
                    processed2.add(changedFile);
                }
            });
        }
        this.myModificationTracker.incModificationCount();
    }

    private static Processor<VirtualFile> createChangeCharsetProcessor() {
        return file2 -> {
            if (!(file2 instanceof VirtualFileSystemEntry)) {
                return false;
            }
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (cachedDocument == null) {
                return true;
            }
            ProgressManager.progress((String)"Reloading files...", (String)file2.getPresentableUrl());
            TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> EncodingProjectManagerImpl.clearAndReload(file2));
            return true;
        };
    }

    private boolean processSubFiles(@Nullable(value="null means all in the project") VirtualFile file2, final @NotNull Processor<VirtualFile> processor2) {
        if (processor2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            for (VirtualFile virtualFile : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
                if (this.processSubFiles(virtualFile, processor2)) continue;
                return false;
            }
            return true;
        }
        return VirtualFileVisitor.CONTINUE == VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processor2.process((Object)file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$1", "visitFile"));
            }
        });
    }

    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.myProjectCharset;
        Charset charset2 = charset == null ? this.myIdeEncodingManager.getDefaultCharset() : charset;
        if (charset2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(9);
        }
        return charset2;
    }

    @Nullable
    public Charset getConfiguredDefaultCharset() {
        return this.myProjectCharset;
    }

    static void suppressReloadDuring(@NotNull Runnable action) {
        if (action == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(10);
        }
        Boolean old = SUPPRESS_RELOAD.get();
        try {
            SUPPRESS_RELOAD.set(Boolean.TRUE);
            action.run();
        }
        finally {
            SUPPRESS_RELOAD.set(old);
        }
    }

    private void tryStartReloadWithProgress(@NotNull Runnable reloadAction) {
        Boolean suppress;
        if (reloadAction == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(11);
        }
        if ((suppress = SUPPRESS_RELOAD.get()) == Boolean.TRUE) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (reloadAction == null) {
                EncodingProjectManagerImpl.$$$reportNull$$$0(20);
            }
            EncodingProjectManagerImpl.suppressReloadDuring(reloadAction);
        }, "Reload Files", false, this.myProject);
    }

    private void reloadAllFilesUnder(@Nullable VirtualFile root) {
        this.tryStartReloadWithProgress(() -> this.processSubFiles(root, (Processor<VirtualFile>)((Processor)file2 -> {
            if (!(file2 instanceof VirtualFileSystemEntry)) {
                return true;
            }
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (cachedDocument != null) {
                ProgressManager.progress((String)"Reloading file...", (String)file2.getPresentableUrl());
                TransactionGuard.submitTransaction((Disposable)this.myProject, () -> EncodingProjectManagerImpl.reload(file2));
            } else if (file2.isCharsetSet() && !file2.equals(root)) {
                file2.setCharset(null);
            }
            return true;
        })));
    }

    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(12);
        }
        return virtualFile.getFileType() == StdFileTypes.PROPERTIES && this.myNative2AsciiForPropertiesFiles;
    }

    public boolean isNative2AsciiForPropertiesFiles() {
        return this.myNative2AsciiForPropertiesFiles;
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii) {
        if (this.myNative2AsciiForPropertiesFiles != native2Ascii) {
            this.myNative2AsciiForPropertiesFiles = native2Ascii;
            this.myIdeEncodingManager.firePropertyChange(null, "native2ascii", !native2Ascii, native2Ascii);
        }
    }

    @NotNull
    public String getDefaultCharsetName() {
        Charset charset = this.getEncoding(null, false);
        String string = charset == null ? "" : charset.name();
        if (string == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setDefaultCharsetName(@NotNull String name) {
        if (name == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(14);
        }
        this.setEncoding(null, name.isEmpty() ? null : CharsetToolkit.forName((String)name));
    }

    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile) {
        return this.myDefaultCharsetForPropertiesFiles;
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, @Nullable Charset charset) {
        Charset old = this.myDefaultCharsetForPropertiesFiles;
        if (!Comparing.equal((Object)old, (Object)charset)) {
            this.myDefaultCharsetForPropertiesFiles = charset;
            this.myIdeEncodingManager.firePropertyChange(null, "propertiesFilesEncoding", old, charset);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(15);
        }
        if (parentDisposable == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(16);
        }
        this.myIdeEncodingManager.addPropertyChangeListener(listener2, parentDisposable);
    }

    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        if (document == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(17);
        }
        return this.myIdeEncodingManager.getCachedCharsetFromContent(document);
    }

    void setBOMForNewUtf8Files(@NotNull BOMForNewUTF8Files option) {
        if (option == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(18);
        }
        this.myBOMForNewUTF8Files = option;
    }

    @NotNull
    BOMForNewUTF8Files getBOMForNewUTF8Files() {
        BOMForNewUTF8Files bOMForNewUTF8Files = this.myBOMForNewUTF8Files;
        if (bOMForNewUTF8Files == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(19);
        }
        return bOMForNewUTF8Files;
    }

    public boolean shouldAddBOMForNewUtf8File() {
        switch (this.myBOMForNewUTF8Files) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case WINDOWS_ONLY: {
                return SystemInfo.isWindows;
            }
        }
        throw new IllegalStateException(this.myBOMForNewUTF8Files.toString());
    }

    private /* synthetic */ void lambda$setMapping$1(@NotNull Map mapping, Map oldMap, Map newMap) {
        if (mapping == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(21);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (Map.Entry entry : mapping.entrySet()) {
            VirtualFile virtualFile = (VirtualFile)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            if (charset == null) {
                throw new IllegalArgumentException("Null charset for " + virtualFile + "; mapping: " + mapping);
            }
            if (virtualFile == null) {
                this.myProjectCharset = charset;
                continue;
            }
            if (!fileIndex.isInContent(virtualFile)) continue;
            if (!virtualFile.isDirectory() && !Comparing.equal((Object)charset, oldMap.get(virtualFile))) {
                byte[] bytes;
                Document document;
                try {
                    document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    if (document == null) {
                        throw new IOException();
                    }
                    bytes = virtualFile.contentsToByteArray();
                }
                catch (IOException e) {
                    continue;
                }
                boolean changed = new ChangeFileEncodingAction().chosen(document, null, virtualFile, bytes, charset);
                if (!changed) continue;
            }
            newMap.put(virtualFile, charset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileOrDir";
                break;
            }
            case 3: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadAction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavorites";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "widelyKnownCharsets";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMappings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBOMForNewUTF8Files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearAndReload";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reload";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSubFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suppressReloadDuring";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryStartReloadWithProgress";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNative2Ascii";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultCharsetName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCharsetFromContent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setBOMForNewUtf8Files";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryStartReloadWithProgress$5";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setMapping$1";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reload$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum BOMForNewUTF8Files {
        ALWAYS("with BOM"),
        NEVER("with NO BOM"),
        WINDOWS_ONLY("with BOM under Windows, with no BOM otherwise");

        private final String name;

        private BOMForNewUTF8Files(String name) {
            if (name == null) {
                BOMForNewUTF8Files.$$$reportNull$$$0(0);
            }
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$BOMForNewUTF8Files", "<init>"));
        }
    }
}

