/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.IdentityVirtualFilePointer;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerManagerImpl
extends VirtualFilePointerManager
implements Disposable,
BulkFileListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl");
    private final TempFileSystem TEMP_FILE_SYSTEM;
    private final LocalFileSystem LOCAL_FILE_SYSTEM;
    private final JarFileSystem JAR_FILE_SYSTEM;
    private final Map<VirtualFilePointerListener, FilePointerPartNode> myPointers;
    private final Set<VirtualFilePointerContainerImpl> myContainers;
    @NotNull
    private final VirtualFileManager myVirtualFileManager;
    @NotNull
    private final MessageBus myBus;
    private static final Comparator<String> URL_COMPARATOR = SystemInfo.isFileSystemCaseSensitive ? String::compareTo : String::compareToIgnoreCase;
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity;
    private List<EventDescriptor> myEvents;
    private List<FilePointerPartNode> myNodesToUpdateUrl;
    private List<FilePointerPartNode> myNodesToFire;

    VirtualFilePointerManagerImpl(@NotNull VirtualFileManager virtualFileManager, @NotNull MessageBus bus, @NotNull TempFileSystem tempFileSystem, @NotNull LocalFileSystem localFileSystem, @NotNull JarFileSystem jarFileSystem) {
        if (virtualFileManager == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(1);
        }
        if (tempFileSystem == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(2);
        }
        if (localFileSystem == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(3);
        }
        if (jarFileSystem == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(4);
        }
        this.myPointers = new LinkedHashMap<VirtualFilePointerListener, FilePointerPartNode>();
        this.myContainers = ContainerUtil.newIdentityTroveSet();
        this.myUrlToIdentity = new THashMap();
        this.myEvents = Collections.emptyList();
        this.myNodesToUpdateUrl = Collections.emptyList();
        this.myNodesToFire = Collections.emptyList();
        this.myVirtualFileManager = virtualFileManager;
        this.myBus = bus;
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        this.TEMP_FILE_SYSTEM = tempFileSystem;
        this.LOCAL_FILE_SYSTEM = localFileSystem;
        this.JAR_FILE_SYSTEM = jarFileSystem;
    }

    public void dispose() {
        this.assertAllPointersDisposed();
    }

    @NotNull
    private static VirtualFilePointer[] toPointers(@NotNull List<FilePointerPartNode> nodes) {
        if (nodes == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(5);
        }
        if (nodes.isEmpty()) {
            if (VirtualFilePointer.EMPTY_ARRAY == null) {
                VirtualFilePointerManagerImpl.$$$reportNull$$$0(6);
            }
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        ArrayList list2 = new ArrayList(nodes.size());
        for (FilePointerPartNode node : nodes) {
            node.addAllPointersTo(list2);
        }
        VirtualFilePointer[] virtualFilePointerArray = list2.toArray(VirtualFilePointer.EMPTY_ARRAY);
        if (virtualFilePointerArray == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(7);
        }
        return virtualFilePointerArray;
    }

    synchronized VirtualFilePointer[] getPointersUnder(VirtualFile parent, String childName) {
        ArrayList<FilePointerPartNode> nodes = new ArrayList<FilePointerPartNode>();
        this.addRelevantPointers(parent, true, childName, nodes);
        return VirtualFilePointerManagerImpl.toPointers(nodes);
    }

    private void addRelevantPointers(VirtualFile parent, boolean separator, @NotNull CharSequence childName, @NotNull List<FilePointerPartNode> out) {
        if (childName == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(8);
        }
        if (out == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(9);
        }
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.addRelevantPointersFrom(parent, separator, childName, out);
        }
    }

    @NotNull
    public synchronized VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(10);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(11);
        }
        VirtualFilePointer virtualFilePointer = this.create(null, url, parent, listener2);
        if (virtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(12);
        }
        return virtualFilePointer;
    }

    @NotNull
    public synchronized VirtualFilePointer create(@NotNull VirtualFile file2, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (file2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(13);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(14);
        }
        VirtualFilePointer virtualFilePointer = this.create(file2, null, parent, listener2);
        if (virtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(15);
        }
        return virtualFilePointer;
    }

    @NotNull
    private VirtualFilePointer create(@Nullable(value="null means the pointer will be created from the (not null) url") VirtualFile file2, @Nullable(value="null means url has to be computed from the (not-null) file path") String url, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        boolean isJar;
        String path;
        VirtualFileSystem fileSystem;
        String protocol;
        if (parentDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            int protocolEnd = url.indexOf("://");
            if (protocolEnd == -1) {
                protocol = null;
                fileSystem = null;
                path = url;
            } else {
                protocol = url.substring(0, protocolEnd);
                fileSystem = this.myVirtualFileManager.getFileSystem(protocol);
                path = url.substring(protocolEnd + "://".length());
            }
        } else {
            fileSystem = file2.getFileSystem();
            protocol = fileSystem.getProtocol();
            path = file2.getPath();
            url = VirtualFileManager.constructUrl((String)protocol, (String)path);
        }
        if (fileSystem == this.TEMP_FILE_SYSTEM) {
            VirtualFile found = file2 == null ? VirtualFileManager.getInstance().findFileByUrl(url) : file2;
            LightFilePointer lightFilePointer = found == null ? new LightFilePointer(url) : new LightFilePointer(found);
            if (lightFilePointer == null) {
                VirtualFilePointerManagerImpl.$$$reportNull$$$0(17);
            }
            return lightFilePointer;
        }
        boolean bl = isJar = fileSystem == this.JAR_FILE_SYSTEM;
        if (fileSystem != this.LOCAL_FILE_SYSTEM && !isJar) {
            VirtualFile found = fileSystem == null ? null : (file2 != null ? file2 : VirtualFileManager.getInstance().findFileByUrl(url));
            IdentityVirtualFilePointer identityVirtualFilePointer = this.getOrCreateIdentity(url, found, parentDisposable, listener2);
            if (identityVirtualFilePointer == null) {
                VirtualFilePointerManagerImpl.$$$reportNull$$$0(18);
            }
            return identityVirtualFilePointer;
        }
        if (file2 == null) {
            String cleanPath = VirtualFilePointerManagerImpl.cleanupPath(path, isJar);
            if (cleanPath != path) {
                url = VirtualFileManager.constructUrl((String)protocol, (String)cleanPath);
                path = cleanPath;
            }
            if (url.contains("..") && (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) != null) {
                url = file2.getUrl();
                path = file2.getPath();
            }
        }
        VirtualFilePointerImpl pointer = this.getOrCreate(path, file2, url, listener2);
        DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        VirtualFilePointerImpl virtualFilePointerImpl = pointer;
        if (virtualFilePointerImpl == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(19);
        }
        return virtualFilePointerImpl;
    }

    @NotNull
    private IdentityVirtualFilePointer getOrCreateIdentity(final @NotNull String url, @Nullable VirtualFile found, @NotNull Disposable parentDisposable, VirtualFilePointerListener listener2) {
        IdentityVirtualFilePointer pointer;
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(20);
        }
        if (parentDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(21);
        }
        if ((pointer = this.myUrlToIdentity.get(url)) == null) {
            pointer = new IdentityVirtualFilePointer(found, url, listener2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispose() {
                    VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = VirtualFilePointerManagerImpl.this;
                    synchronized (virtualFilePointerManagerImpl) {
                        super.dispose();
                        VirtualFilePointerManagerImpl.this.myUrlToIdentity.remove(url);
                    }
                }
            };
            this.myUrlToIdentity.put(url, pointer);
            DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        }
        pointer.incrementUsageCount(1);
        IdentityVirtualFilePointer identityVirtualFilePointer = pointer;
        if (identityVirtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(22);
        }
        return identityVirtualFilePointer;
    }

    @NotNull
    private static String cleanupPath(@NotNull String path, boolean isJar) {
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(23);
        }
        path = FileUtil.normalize((String)path);
        String string = path = VirtualFilePointerManagerImpl.trimTrailingSeparators(path, isJar);
        if (string == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static String trimTrailingSeparators(@NotNull String path, boolean isJar) {
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(25);
        }
        while (!(!StringUtil.endsWithChar((CharSequence)path, (char)'/') || isJar && path.endsWith("!/"))) {
            path = StringUtil.trimEnd((String)path, (String)"/");
        }
        return path;
    }

    @NotNull
    private VirtualFilePointerImpl getOrCreate(@NotNull String path, @Nullable VirtualFile file2, @NotNull String url, @Nullable VirtualFilePointerListener listener2) {
        FilePointerPartNode node;
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(26);
        }
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(27);
        }
        FilePointerPartNode root = this.myPointers.get(listener2);
        Pair fileAndUrl = Pair.create((Object)file2, (Object)url);
        if (root == null) {
            root = new FilePointerPartNode(path, null, (Pair<VirtualFile, String>)fileAndUrl, 1);
            this.myPointers.put(listener2, root);
            node = root;
        } else {
            node = root.findPointerOrCreate(path, 0, (Pair<VirtualFile, String>)fileAndUrl, 1);
        }
        VirtualFilePointerImpl pointer = node.getAnyPointer();
        if (pointer == null) {
            pointer = new VirtualFilePointerImpl(listener2);
            node.associate((Object)pointer, (Pair<VirtualFile, String>)fileAndUrl);
        }
        pointer.incrementUsageCount(1);
        root.checkConsistency();
        VirtualFilePointerImpl virtualFilePointerImpl = pointer;
        if (virtualFilePointerImpl == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(28);
        }
        return virtualFilePointerImpl;
    }

    @NotNull
    public synchronized VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        VirtualFile file2;
        if (pointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(29);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(30);
        }
        VirtualFilePointer virtualFilePointer = (file2 = pointer.getFile()) == null ? this.create(pointer.getUrl(), parent, listener2) : this.create(file2, parent, listener2);
        if (virtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(31);
        }
        return virtualFilePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void assertAllPointersDisposed() {
        for (Map.Entry<VirtualFilePointerListener, FilePointerPartNode> entry : this.myPointers.entrySet()) {
            FilePointerPartNode root = entry.getValue();
            ArrayList<FilePointerPartNode> left = new ArrayList<FilePointerPartNode>();
            root.addRelevantPointersFrom(null, false, "", left);
            ArrayList pointers = new ArrayList();
            for (FilePointerPartNode node : left) {
                node.addAllPointersTo(pointers);
            }
            if (pointers.isEmpty()) continue;
            VirtualFilePointerImpl p = (VirtualFilePointerImpl)((Object)pointers.get(0));
            try {
                p.throwDisposalError("Not disposed pointer: " + (Object)((Object)p));
            }
            finally {
                for (VirtualFilePointerImpl pointer : pointers) {
                    pointer.dispose();
                }
            }
        }
        Set<VirtualFilePointerContainerImpl> set2 = this.myContainers;
        synchronized (set2) {
            if (!this.myContainers.isEmpty()) {
                VirtualFilePointerContainerImpl container = this.myContainers.iterator().next();
                container.throwDisposalError("Not disposed container");
            }
        }
    }

    synchronized void addAllPointersTo(@NotNull Collection<VirtualFilePointerImpl> pointers) {
        if (pointers == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(32);
        }
        ArrayList<FilePointerPartNode> out = new ArrayList<FilePointerPartNode>();
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.addRelevantPointersFrom(null, false, "", out);
        }
        for (FilePointerPartNode node : out) {
            node.addAllPointersTo(pointers);
        }
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(33);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.createContainer(parent, null);
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(34);
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public synchronized VirtualFilePointerContainer createContainer(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(35);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.registerContainer(parent, new VirtualFilePointerContainerImpl(this, parent, listener2));
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(36);
        }
        return virtualFilePointerContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VirtualFilePointerContainer registerContainer(@NotNull Disposable parent, final @NotNull VirtualFilePointerContainerImpl virtualFilePointerContainer) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(37);
        }
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(38);
        }
        Set<VirtualFilePointerContainerImpl> set2 = this.myContainers;
        synchronized (set2) {
            this.myContainers.add(virtualFilePointerContainer);
        }
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                boolean removed;
                Disposer.dispose((Disposable)virtualFilePointerContainer);
                Set set2 = VirtualFilePointerManagerImpl.this.myContainers;
                synchronized (set2) {
                    removed = VirtualFilePointerManagerImpl.this.myContainers.remove((Object)virtualFilePointerContainer);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) assert (removed);
            }

            @NonNls
            @NotNull
            public String toString() {
                String string = "Disposing container " + (Object)((Object)virtualFilePointerContainer);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$2", "toString"));
            }
        });
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = virtualFilePointerContainer;
        if (virtualFilePointerContainerImpl == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(39);
        }
        return virtualFilePointerContainerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(@NotNull List<? extends VFileEvent> events) {
        Object[] toFirePointers;
        ArrayList<EventDescriptor> eventList;
        if (events == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(40);
        }
        ArrayList<FilePointerPartNode> toFireEvents = new ArrayList<FilePointerPartNode>();
        ArrayList<FilePointerPartNode> toUpdateUrl = new ArrayList<FilePointerPartNode>();
        Object object = this;
        synchronized (object) {
            this.incModificationCount();
            for (VFileEvent vFileEvent : events) {
                VFilePropertyChangeEvent change;
                VirtualFile eventFile;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                    this.addRelevantPointers(deleteEvent.getFile(), false, "", toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileCreateEvent) {
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    this.addRelevantPointers(createEvent.getParent(), true, createEvent.getChildName(), toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.addRelevantPointers(copyEvent.getNewParent(), true, copyEvent.getFile().getName(), toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    eventFile = moveEvent.getFile();
                    this.addRelevantPointers(moveEvent.getNewParent(), true, eventFile.getName(), toFireEvents);
                    ArrayList<FilePointerPartNode> nodes = new ArrayList<FilePointerPartNode>();
                    this.addRelevantPointers(eventFile, false, "", nodes);
                    toFireEvents.addAll(nodes);
                    for (FilePointerPartNode node : nodes) {
                        VirtualFilePointerImpl pointer2 = node.getAnyPointer();
                        VirtualFile file2 = pointer2 == null ? null : pointer2.getFile();
                        if (file2 == null) continue;
                        toUpdateUrl.add(node);
                    }
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((change = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) || Comparing.equal((Object)change.getOldValue(), (Object)change.getNewValue())) continue;
                eventFile = change.getFile();
                VirtualFile parent = eventFile.getParent();
                this.addRelevantPointers(parent, true, change.getNewValue().toString(), toFireEvents);
                ArrayList<FilePointerPartNode> nodes = new ArrayList<FilePointerPartNode>();
                this.addRelevantPointers(eventFile, false, "", nodes);
                for (FilePointerPartNode node : nodes) {
                    VirtualFilePointerImpl pointer3 = node.getAnyPointer();
                    VirtualFile file3 = pointer3 == null ? null : pointer3.getFile();
                    if (file3 == null) continue;
                    toUpdateUrl.add(node);
                }
            }
            eventList = new ArrayList<EventDescriptor>();
            this.myEvents = eventList;
            toFirePointers = VirtualFilePointerManagerImpl.toPointers(toFireEvents);
            for (VirtualFilePointerListener virtualFilePointerListener : this.myPointers.keySet()) {
                List filtered;
                if (virtualFilePointerListener == null || (filtered = ContainerUtil.filter((Object[])toFirePointers, pointer -> ((VirtualFilePointerImpl)((Object)((Object)pointer))).getListener() == listener2)).isEmpty()) continue;
                EventDescriptor event = new EventDescriptor(virtualFilePointerListener, filtered.toArray(VirtualFilePointer.EMPTY_ARRAY));
                this.myEvents.add(event);
            }
        }
        for (EventDescriptor descriptor : eventList) {
            descriptor.fireBefore();
        }
        if (!toFireEvents.isEmpty()) {
            ((VirtualFilePointerListener)this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).beforeValidityChanged((VirtualFilePointer[])toFirePointers);
        }
        object = this;
        synchronized (object) {
            this.myNodesToFire = toFireEvents;
            this.myNodesToUpdateUrl = toUpdateUrl;
        }
        this.assertConsistency();
    }

    synchronized void assertConsistency() {
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.checkConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(41);
        }
        this.incModificationCount();
        VirtualFilePointer[] virtualFilePointerArray = this;
        synchronized (this) {
            for (FilePointerPartNode node : this.myNodesToUpdateUrl) {
                String urlBefore = (String)node.myFileAndUrl.second;
                Pair<VirtualFile, String> after = node.update();
                assert (after != null) : "can't invalidate inside modification";
                String urlAfter = (String)after.second;
                if (URL_COMPARATOR.compare(urlBefore, urlAfter) == 0 && urlAfter.endsWith(node.part)) continue;
                SmartList myPointers = new SmartList();
                node.addAllPointersTo((Collection<? super VirtualFilePointerImpl>)myPointers);
                int useCount = node.useCount;
                FilePointerPartNode root = node.remove();
                FilePointerPartNode newNode = root.findPointerOrCreate(VfsUtilCore.urlToPath((String)urlAfter), 0, after, myPointers.size());
                VirtualFilePointerImpl existingPointer = newNode.getAnyPointer();
                if (existingPointer != null) {
                    FilePointerPartNode n = newNode;
                    while (n != null) {
                        n.pointersUnder += myPointers.size();
                        n = n.parent;
                    }
                }
                newNode.addAllPointersTo((Collection<? super VirtualFilePointerImpl>)myPointers);
                Object newMyPointers = myPointers.size() == 1 ? myPointers.get(0) : myPointers.toArray(new VirtualFilePointerImpl[0]);
                newNode.associate(newMyPointers, after);
                newNode.incrementUsageCount(useCount);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Object object = this;
            synchronized (this) {
                VirtualFilePointer[] pointersToFireArray = VirtualFilePointerManagerImpl.toPointers(this.myNodesToFire);
                List<EventDescriptor> eventList = this.myEvents;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                for (VirtualFilePointer pointer : pointersToFireArray) {
                    ((VirtualFilePointerImpl)pointer).myNode.update();
                }
                for (EventDescriptor event : eventList) {
                    event.fireAfter();
                }
                if (pointersToFireArray.length != 0) {
                    ((VirtualFilePointerListener)this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).validityChanged(pointersToFireArray);
                }
                object = this;
                synchronized (this) {
                    this.myNodesToUpdateUrl = Collections.emptyList();
                    this.myEvents = Collections.emptyList();
                    this.myNodesToFire = Collections.emptyList();
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    this.assertConsistency();
                    return;
                }
            }
        }
    }

    synchronized void removeNode(@NotNull FilePointerPartNode node, VirtualFilePointerListener listener2) {
        boolean rootNodeEmpty;
        if (node == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(42);
        }
        FilePointerPartNode root = node.remove();
        boolean bl = rootNodeEmpty = root.children.length == 0;
        if (rootNodeEmpty) {
            this.myPointers.remove(listener2);
        }
        this.assertConsistency();
    }

    public long getModificationCount() {
        return super.getModificationCount() + (long)PersistentFS.getInstance().getStructureModificationCount();
    }

    @NotNull
    public synchronized VirtualFilePointer createDirectoryPointer(@NotNull String url, boolean recursively, @NotNull Disposable parent, @NotNull VirtualFilePointerListener listener2) {
        VirtualFilePointer pointer;
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(43);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(44);
        }
        if (listener2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(45);
        }
        if ((pointer = this.create(null, url, parent, listener2)) instanceof VirtualFilePointerImpl) {
            ((VirtualFilePointerImpl)pointer).recursive = true;
        }
        VirtualFilePointer virtualFilePointer = pointer;
        if (virtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(46);
        }
        return virtualFilePointer;
    }

    synchronized int numberOfPointers() {
        int number = 0;
        for (FilePointerPartNode root : this.myPointers.values()) {
            number = root.numberOfPointersUnder();
        }
        return number;
    }

    synchronized int numberOfListeners() {
        return this.myPointers.keySet().size();
    }

    synchronized int numberOfCachedUrlToIdentity() {
        return this.myUrlToIdentity.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shelveAllPointersIn(@NotNull Runnable runnable2) {
        LinkedHashMap<VirtualFilePointerListener, FilePointerPartNode> shelvedPointers;
        if (runnable2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(47);
        }
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            shelvedPointers = new LinkedHashMap<VirtualFilePointerListener, FilePointerPartNode>(this.myPointers);
            this.myPointers.clear();
        }
        try {
            runnable2.run();
        }
        finally {
            virtualFilePointerManagerImpl = this;
            synchronized (virtualFilePointerManagerImpl) {
                this.myPointers.clear();
                this.myPointers.putAll(shelvedPointers);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFileSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileSystem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFileSystem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 10: 
            case 20: 
            case 27: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: 
            case 14: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFilePointerContainer";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toPointers";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIdentity";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "duplicate";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainer";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "registerContainer";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toPointers";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 46: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRelevantPointers";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateIdentity";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "cleanupPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailingSeparators";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "duplicate";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersTo";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "registerContainer";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "before";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryPointer";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "shelveAllPointersIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegatingDisposable
    implements Disposable {
        private static final ConcurrentMap<Disposable, DelegatingDisposable> ourInstances = ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy());
        private final TObjectIntHashMap<VirtualFilePointerImpl> myCounts;
        private final Disposable myParent;

        private DelegatingDisposable(@NotNull Disposable parent) {
            if (parent == null) {
                DelegatingDisposable.$$$reportNull$$$0(0);
            }
            this.myCounts = new TObjectIntHashMap();
            this.myParent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void registerDisposable(@NotNull Disposable parentDisposable, @NotNull VirtualFilePointerImpl pointer) {
            DelegatingDisposable newDisposable;
            DelegatingDisposable result2;
            if (parentDisposable == null) {
                DelegatingDisposable.$$$reportNull$$$0(1);
            }
            if (pointer == null) {
                DelegatingDisposable.$$$reportNull$$$0(2);
            }
            if ((result2 = (DelegatingDisposable)ourInstances.get(parentDisposable)) == null && (result2 = (DelegatingDisposable)ConcurrencyUtil.cacheOrGet(ourInstances, (Object)parentDisposable, (Object)(newDisposable = new DelegatingDisposable(parentDisposable)))) == newDisposable) {
                Disposer.register((Disposable)parentDisposable, (Disposable)result2);
            }
            DelegatingDisposable delegatingDisposable = result2;
            synchronized (delegatingDisposable) {
                result2.myCounts.put((Object)pointer, result2.myCounts.get((Object)pointer) + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ourInstances.remove(this.myParent);
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                this.myCounts.forEachEntry((pointer, disposeCount) -> {
                    int after = pointer.incrementUsageCount(-disposeCount + 1);
                    LOG.assertTrue(after > 0, (Object)after);
                    pointer.dispose();
                    return true;
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerDisposable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EventDescriptor {
        @NotNull
        private final VirtualFilePointerListener myListener;
        @NotNull
        private final VirtualFilePointer[] myPointers;

        private EventDescriptor(@NotNull VirtualFilePointerListener listener2, @NotNull VirtualFilePointer[] pointers) {
            if (listener2 == null) {
                EventDescriptor.$$$reportNull$$$0(0);
            }
            if (pointers == null) {
                EventDescriptor.$$$reportNull$$$0(1);
            }
            this.myListener = listener2;
            this.myPointers = pointers;
        }

        private void fireBefore() {
            if (this.myPointers.length != 0) {
                this.myListener.beforeValidityChanged(this.myPointers);
            }
        }

        private void fireAfter() {
            if (this.myPointers.length != 0) {
                this.myListener.validityChanged(this.myPointers);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pointers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

