/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.TimedOutCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusManagerImpl
extends IdeFocusManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FocusManagerImpl.class);
    private static final UiActivity FOCUS = new UiActivity.Focus(new String[]{"awtFocusRequest"});
    private static final UiActivity TYPEAHEAD = new UiActivity.Focus(new String[]{"typeahead"});
    private final Application myApp;
    private final boolean isInternalMode = ApplicationManagerEx.getApplicationEx().isInternal();
    private final LinkedList<FocusRequestInfo> myRequests = new LinkedList();
    private final IdeEventQueue myQueue;
    private final EdtAlarm myFocusedComponentAlarm;
    private final EdtAlarm myForcedFocusRequestsAlarm;
    private final Set<FurtherRequestor> myValidFurtherRequestors = new HashSet<FurtherRequestor>();
    private final Set<ActionCallback> myTypeAheadRequestors = new HashSet<ActionCallback>();
    private final UiActivityMonitor myActivityMonitor;
    private boolean myTypeaheadEnabled = true;
    private final Map<IdeFrame, Component> myLastFocused = ContainerUtil.createWeakValueMap();
    private final Map<IdeFrame, Component> myLastFocusedAtDeactivation = ContainerUtil.createWeakValueMap();
    private DataContext myRunContext;
    private IdeFrame myLastFocusedFrame;

    public FocusManagerImpl(ServiceManagerImpl serviceManager, WindowManager wm, UiActivityMonitor monitor) {
        this.myApp = ApplicationManager.getApplication();
        this.myQueue = IdeEventQueue.getInstance();
        this.myActivityMonitor = monitor;
        this.myFocusedComponentAlarm = new EdtAlarm();
        this.myForcedFocusRequestsAlarm = new EdtAlarm();
        AppListener myAppListener = new AppListener();
        this.myApp.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)myAppListener);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof FocusEvent) {
                FocusEvent fe = (FocusEvent)e;
                Component c = fe.getComponent();
                if (c instanceof Window || c == null) {
                    return false;
                }
                Component parent = UIUtil.findUltimateParent((Component)c);
                if (parent instanceof IdeFrame) {
                    this.myLastFocused.put((IdeFrame)parent, c);
                }
            } else if (e instanceof WindowEvent) {
                Window wnd = ((WindowEvent)e).getWindow();
                if (e.getID() == 202 && wnd instanceof IdeFrame) {
                    this.myLastFocused.remove(wnd);
                    this.myLastFocusedAtDeactivation.remove(wnd);
                }
            }
            return false;
        }, this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof IdeFrame) {
                    FocusManagerImpl.this.myLastFocusedFrame = (IdeFrame)evt.getNewValue();
                }
            }
        });
    }

    public IdeFrame getLastFocusedFrame() {
        return this.myLastFocusedFrame;
    }

    public ActionCallback requestFocusInProject(@NotNull Component c, @Nullable Project project) {
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(0);
        }
        if (ApplicationManagerEx.getApplicationEx().isActive() || !Registry.is((String)"suppress.focus.stealing")) {
            c.requestFocus();
        } else {
            c.requestFocusInWindow();
        }
        return ActionCallback.DONE;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(1);
        }
        c.requestFocus();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            FocusManagerImpl.$$$reportNull$$$0(2);
        }
        return actionCallback;
    }

    @NotNull
    public List<FocusRequestInfo> getRequests() {
        LinkedList<FocusRequestInfo> linkedList = this.myRequests;
        if (linkedList == null) {
            FocusManagerImpl.$$$reportNull$$$0(3);
        }
        return linkedList;
    }

    public void recordFocusRequest(Component c, boolean forced) {
        this.myRequests.add(new FocusRequestInfo(c, new Throwable(), forced));
        if (this.myRequests.size() > 200) {
            this.myRequests.removeFirst();
        }
    }

    public static FocusManagerImpl getInstance() {
        return (FocusManagerImpl)((Object)ApplicationManager.getApplication().getComponent(IdeFocusManager.class));
    }

    public void dispose() {
        this.myForcedFocusRequestsAlarm.cancelAllRequests();
        this.myFocusedComponentAlarm.cancelAllRequests();
        for (FurtherRequestor requestor : this.myValidFurtherRequestors) {
            Disposer.dispose((Disposable)requestor);
        }
        this.myValidFurtherRequestors.clear();
    }

    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable2) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(4);
        }
        this.doWhenFocusSettlesDown((Runnable)runnable2);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(5);
        }
        this.myQueue.executeWhenAllFocusEventsLeftTheQueue(runnable2);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2, @NotNull ModalityState modality) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(6);
        }
        if (modality == null) {
            FocusManagerImpl.$$$reportNull$$$0(7);
        }
        this.doWhenFocusSettlesDown(runnable2);
    }

    public void setTypeaheadEnabled(boolean enabled) {
        this.myTypeaheadEnabled = enabled;
    }

    private boolean isTypeaheadEnabled() {
        return Registry.is((String)"actionSystem.fixLostTyping") && this.myTypeaheadEnabled;
    }

    public void typeAheadUntil(@NotNull ActionCallback callback, final @NotNull String cause) {
        ActionCallback done2;
        if (callback == null) {
            FocusManagerImpl.$$$reportNull$$$0(8);
        }
        if (cause == null) {
            FocusManagerImpl.$$$reportNull$$$0(9);
        }
        if (!this.isTypeaheadEnabled()) {
            return;
        }
        final long currentTime = System.currentTimeMillis();
        if (!Registry.is((String)"type.ahead.logging.enabled")) {
            done2 = callback;
        } else {
            String id = new Exception().getStackTrace()[2].getClassName();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:ss:SSS", Locale.US);
            LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tStarted:  " + id);
            done2 = new ActionCallback();
            callback.doWhenDone(() -> {
                done2.setDone();
                LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tDone:     " + id);
            });
            callback.doWhenRejected(() -> {
                done2.setRejected();
                LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tRejected: " + id);
            });
        }
        FocusManagerImpl.assertDispatchThread();
        this.myTypeAheadRequestors.add(done2);
        done2.notify(new TimedOutCallback((long)Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Typeahead request blocked", (Throwable)new Exception(){

            @Override
            public String getMessage() {
                return "Time: " + (System.currentTimeMillis() - currentTime) + "; cause: " + cause + "; runnable waiting for the focus change: " + IdeEventQueue.getInstance().runnablesWaitingForFocusChangeState();
            }
        }, true).doWhenProcessed(() -> this.myTypeAheadRequestors.remove(done2)));
    }

    private void revalidateFurtherRequestors() {
        Iterator<FurtherRequestor> requestorIterator = this.myValidFurtherRequestors.iterator();
        while (requestorIterator.hasNext()) {
            FurtherRequestor each = requestorIterator.next();
            if (!each.isExpired()) continue;
            requestorIterator.remove();
            Disposer.dispose((Disposable)each);
        }
    }

    public Component getFocusOwner() {
        FocusManagerImpl.assertDispatchThread();
        Component result2 = null;
        if (!ApplicationManager.getApplication().isActive()) {
            result2 = this.myLastFocusedAtDeactivation.get(this.getLastFocusedFrame());
        } else if (this.myRunContext != null) {
            result2 = (Component)this.myRunContext.getData(PlatformDataKeys.CONTEXT_COMPONENT.getName());
        }
        if (result2 == null) {
            result2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (result2 == null) {
            Component permOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (permOwner != null) {
                result2 = permOwner;
            }
            if (UIUtil.isMeaninglessFocusOwner((Component)result2)) {
                result2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            }
        }
        return result2;
    }

    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable2) {
        if (context == null) {
            FocusManagerImpl.$$$reportNull$$$0(10);
        }
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(11);
        }
        FocusManagerImpl.assertDispatchThread();
        this.myRunContext = context;
        try {
            runnable2.run();
        }
        finally {
            this.myRunContext = null;
        }
    }

    public Component getLastFocusedFor(IdeFrame frame) {
        FocusManagerImpl.assertDispatchThread();
        return this.myLastFocused.get(frame);
    }

    public void setLastFocusedAtDeactivation(@NotNull IdeFrame frame, @NotNull Component c) {
        if (frame == null) {
            FocusManagerImpl.$$$reportNull$$$0(12);
        }
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(13);
        }
        this.myLastFocusedAtDeactivation.put(frame, c);
    }

    public void toFront(JComponent c) {
        FocusManagerImpl.assertDispatchThread();
        if (c == null) {
            return;
        }
        Window window = (Window)UIUtil.getParentOfType(Window.class, (Component)c);
        if (window != null && window.isShowing()) {
            this.doWhenFocusSettlesDown(() -> {
                if (ApplicationManager.getApplication().isActive()) {
                    if (window instanceof JFrame && ((JFrame)window).getState() == 1) {
                        ((JFrame)window).setState(0);
                    } else {
                        window.toFront();
                    }
                }
            });
        }
    }

    @Nullable
    private static Component getComponent(@NotNull Map<IdeFrame, Component> map, IdeFrame frame) {
        if (map == null) {
            FocusManagerImpl.$$$reportNull$$$0(14);
        }
        return map.get(frame);
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            FocusManagerImpl.$$$reportNull$$$0(15);
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(comp);
    }

    public List<JBPopup> getChildPopups(@NotNull Component component) {
        if (component == null) {
            FocusManagerImpl.$$$reportNull$$$0(16);
        }
        return AbstractPopup.all.toStrongList().stream().filter(popup2 -> {
            if (component == null) {
                FocusManagerImpl.$$$reportNull$$$0(19);
            }
            for (Component owner = popup2.getOwner(); owner != null; owner = owner.getParent()) {
                if (!owner.equals(component)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public Component getFocusedDescendantFor(Component comp) {
        Component focused = this.getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        List<JBPopup> popups = this.getChildPopups(comp);
        for (JBPopup each : popups) {
            if (!each.isFocused()) continue;
            return focused;
        }
        return null;
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        Component toFocus;
        block9: {
            Window[] windows;
            block8: {
                toFocus = null;
                if (this.myLastFocusedFrame == null) break block8;
                toFocus = this.myLastFocused.get(this.myLastFocusedFrame);
                if (toFocus != null && toFocus.isShowing()) break block9;
                toFocus = this.getFocusTargetFor(this.myLastFocusedFrame.getComponent());
                break block9;
            }
            for (Window each : windows = Window.getWindows()) {
                if (!each.isActive()) continue;
                if (each instanceof JFrame) {
                    toFocus = this.getFocusTargetFor(((JFrame)each).getRootPane());
                    break;
                }
                if (each instanceof JDialog) {
                    toFocus = this.getFocusTargetFor(((JDialog)each).getRootPane());
                    break;
                }
                if (!(each instanceof JWindow)) continue;
                toFocus = this.getFocusTargetFor(((JWindow)each).getRootPane());
                break;
            }
        }
        if (toFocus != null) {
            if (ApplicationManagerEx.getApplicationEx().isActive() || !Registry.is((String)"suppress.focus.stealing")) {
                toFocus.requestFocus();
            } else {
                toFocus.requestFocusInWindow();
            }
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                FocusManagerImpl.$$$reportNull$$$0(17);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            FocusManagerImpl.$$$reportNull$$$0(18);
        }
        return actionCallback;
    }

    public boolean isFocusTransferEnabled() {
        if (Registry.is((String)"focus.fix.lost.cursor")) {
            return true;
        }
        return this.myApp.isActive() || !Registry.is((String)"actionSystem.suspendFocusTransferIfApplicationInactive");
    }

    private static void assertDispatchThread() {
        if (Registry.is((String)"actionSystem.assertFocusAccessFromEdt")) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/FocusManagerImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/FocusManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequests";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "requestDefaultFocus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestFocusInProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doWhenFocusSettlesDown";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "typeAheadUntil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runOnOwnContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLastFocusedAtDeactivation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFocusTargetFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildPopups";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChildPopups$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AppListener
    implements ApplicationActivationListener {
        private AppListener() {
        }

        public void delayedApplicationDeactivated(IdeFrame ideFrame) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component parent = UIUtil.findUltimateParent((Component)owner);
            if (parent == ideFrame) {
                FocusManagerImpl.this.myLastFocusedAtDeactivation.put(ideFrame, owner);
            }
        }

        private void focusLastFocusedComponent(IdeFrame ideFrame) {
            KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (mgr.getFocusOwner() == null) {
                Component c = FocusManagerImpl.getComponent(FocusManagerImpl.this.myLastFocusedAtDeactivation, ideFrame);
                if (c == null || !c.isShowing()) {
                    c = FocusManagerImpl.getComponent(FocusManagerImpl.this.myLastFocusedAtDeactivation, ideFrame);
                }
                boolean mouseEventAhead = IdeEventQueue.isMouseEventAhead(null);
                if (c != null && c.isShowing() && !mouseEventAhead) {
                    LayoutFocusTraversalPolicyExt policy = LayoutFocusTraversalPolicyExt.findWindowPolicy(c);
                    if (policy != null) {
                        policy.setNoDefaultComponent(true, (Object)FocusManagerImpl.this);
                    }
                    FocusManagerImpl.this.requestFocus(c, false).doWhenProcessed(() -> {
                        if (policy != null) {
                            policy.setNoDefaultComponent(false, (Object)FocusManagerImpl.this);
                        }
                    });
                }
            }
            FocusManagerImpl.this.myLastFocusedAtDeactivation.remove(ideFrame);
        }
    }

    static class EdtAlarm {
        private final Set<EdtRunnable> myRequests = new HashSet<EdtRunnable>();

        EdtAlarm() {
        }

        public void cancelAllRequests() {
            for (EdtRunnable each : this.myRequests) {
                each.expire();
            }
            this.myRequests.clear();
        }

        public void addRequest(@NotNull EdtRunnable runnable2, int delay) {
            if (runnable2 == null) {
                EdtAlarm.$$$reportNull$$$0(0);
            }
            this.myRequests.add(runnable2);
            EdtExecutorService.getScheduledExecutorInstance().schedule((Runnable)runnable2, (long)delay, TimeUnit.MILLISECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/FocusManagerImpl$EdtAlarm", "addRequest"));
        }
    }

    private static class FurtherRequestor
    implements FocusRequestor {
        private final IdeFocusManager myManager;
        private final Expirable myExpirable;
        private Throwable myAllocation;
        private boolean myDisposed;

        private FurtherRequestor(@NotNull IdeFocusManager manager, @NotNull Expirable expirable) {
            if (manager == null) {
                FurtherRequestor.$$$reportNull$$$0(0);
            }
            if (expirable == null) {
                FurtherRequestor.$$$reportNull$$$0(1);
            }
            this.myManager = manager;
            this.myExpirable = expirable;
            if (Registry.is((String)"ide.debugMode")) {
                this.myAllocation = new Exception();
            }
        }

        @NotNull
        public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
            if (c == null) {
                FurtherRequestor.$$$reportNull$$$0(2);
            }
            ActionCallback result2 = this.isExpired() ? ActionCallback.REJECTED : this.myManager.requestFocus(c, forced);
            result2.doWhenProcessed(() -> Disposer.dispose((Disposable)this));
            ActionCallback actionCallback = result2;
            if (actionCallback == null) {
                FurtherRequestor.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }

        private boolean isExpired() {
            return this.myExpirable.isExpired() || this.myDisposed;
        }

        public void dispose() {
            this.myDisposed = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expirable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "requestFocus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "requestFocus";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

