/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.FrameStateManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.MaximizeActiveDialogAction;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.FrameEditorComponentProvider;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ActiveStack;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.SideStack;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.WindowedDecorator;
import com.intellij.openapi.wm.impl.Windows;
import com.intellij.openapi.wm.impl.commands.ApplyWindowInfoCmd;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.openapi.wm.impl.commands.InvokeLaterCmd;
import com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd;
import com.intellij.openapi.wm.impl.commands.UpdateRootPaneCmd;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ToolWindowManager", defaultStateAsResource=true, storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)})
public final class ToolWindowManagerImpl
extends ToolWindowManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
    private final Project myProject;
    private final WindowManagerEx myWindowManager;
    private final EventDispatcher<ToolWindowManagerListener> myDispatcher = EventDispatcher.create(ToolWindowManagerListener.class);
    private final DesktopLayout myLayout = new DesktopLayout();
    private final Map<String, InternalDecorator> myId2InternalDecorator = new HashMap<String, InternalDecorator>();
    private final Map<String, FloatingDecorator> myId2FloatingDecorator = new HashMap<String, FloatingDecorator>();
    private final Map<String, WindowedDecorator> myId2WindowedDecorator = new HashMap<String, WindowedDecorator>();
    private final Map<String, StripeButton> myId2StripeButton = new HashMap<String, StripeButton>();
    private final Map<String, FocusWatcher> myId2FocusWatcher = new HashMap<String, FocusWatcher>();
    private final MyToolWindowPropertyChangeListener myToolWindowPropertyChangeListener = new MyToolWindowPropertyChangeListener();
    private final InternalDecoratorListener myInternalDecoratorListener = new MyInternalDecoratorListener();
    private final ActiveStack myActiveStack = new ActiveStack();
    private final SideStack mySideStack = new SideStack();
    private ToolWindowsPane myToolWindowsPane;
    private IdeFrameImpl myFrame;
    private DesktopLayout myLayoutToRestoreLater;
    @NonNls
    private static final String EDITOR_ELEMENT = "editor";
    @NonNls
    private static final String ACTIVE_ATTR_VALUE = "active";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String X_ATTR = "x";
    @NonNls
    private static final String Y_ATTR = "y";
    @NonNls
    private static final String WIDTH_ATTR = "width";
    @NonNls
    private static final String HEIGHT_ATTR = "height";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    @NonNls
    private static final String LAYOUT_TO_RESTORE = "layout-to-restore";
    private final Map<String, Balloon> myWindow2Balloon = new HashMap<String, Balloon>();
    private KeyState myCurrentState = KeyState.waiting;
    private final Alarm myWaiterForSecondPress = new Alarm();
    private final Runnable mySecondPressRunnable = () -> {
        if (this.myCurrentState != KeyState.hold) {
            this.resetHoldState();
        }
    };
    private final Alarm myUpdateHeadersAlarm = new Alarm();
    private final CommandProcessor myCommandProcessor = new CommandProcessor();

    boolean isToolWindowRegistered(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(0);
        }
        return this.myLayout.isToolWindowRegistered(id);
    }

    public ToolWindowManagerImpl(Project project, WindowManagerEx windowManagerEx, ActionManager actionManager) {
        this.myProject = project;
        this.myWindowManager = windowManagerEx;
        if (project.isDefault()) {
            return;
        }
        actionManager.addAnActionListener((action, dataContext, event) -> {
            if (this.myCurrentState != KeyState.hold) {
                this.resetHoldState();
            }
        }, (Disposable)project);
        MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project) {
                if (project == ToolWindowManagerImpl.this.myProject) {
                    ToolWindowManagerImpl.this.init();
                }
            }

            public void projectClosed(Project project) {
                if (project == ToolWindowManagerImpl.this.myProject) {
                    ToolWindowManagerImpl.this.projectClosed();
                }
            }
        });
        this.myLayout.copyFrom(windowManagerEx.getLayout());
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(ToolWindowManagerImpl.this.myProject){

                    public void run() {
                        if (!ToolWindowManagerImpl.this.hasOpenEditorFiles()) {
                            ToolWindowManagerImpl.this.focusToolWindowByDefault(null);
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$2";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        PropertyChangeListener focusListener = it -> {
            if ("focusOwner".equals(it.getPropertyName())) {
                this.myUpdateHeadersAlarm.cancelAllRequests();
                this.myUpdateHeadersAlarm.addRequest(this::updateToolWindowHeaders, 50);
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(focusListener);
        Disposer.register((Disposable)this, () -> KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(focusListener));
        Predicate<AWTEvent> predicate = event -> event.getID() == 1005 || event.getID() == 1004 || event.getID() == 501 || event.getID() == 401;
        Windows.toolWindows();
        Windows.ToolWindowFilter.filterBySignal(new Windows.Signal(predicate)).withEscAction(actionManager).handleDocked(toolWindowId -> {}).handleFloating(toolWindowId -> {}).handleFocusLostOnPinned(toolWindowId -> {
            ArrayList<FinalizableCommand> commands = new ArrayList<FinalizableCommand>();
            this.deactivateToolWindowImpl((String)toolWindowId, true, (List<FinalizableCommand>)commands);
            this.myCommandProcessor.execute(commands, this.myProject.getDisposed());
        }).handleWindowed(toolWindowId -> {}).handleDeactivatingShortcut(toolWindowId -> {
            EditorWithProviderComposite editor;
            EditorWindow window;
            JComponent defaultFocusedComponentInEditor = null;
            EditorsSplitters splittersToFocus = this.getSplittersToFocus();
            if (splittersToFocus != null && (window = splittersToFocus.getCurrentWindow()) != null && (editor = window.getSelectedEditor()) != null && (defaultFocusedComponentInEditor = editor.getPreferredFocusedComponent()) != null) {
                defaultFocusedComponentInEditor.requestFocus();
            }
        }).bind(this.myProject);
    }

    private void updateToolWindowHeaders() {
        this.getFocusManager().doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(this.myProject){

            public void run() {
                WindowInfoImpl[] infos;
                for (WindowInfoImpl each : infos = ToolWindowManagerImpl.this.myLayout.getInfos()) {
                    InternalDecorator decorator;
                    ToolWindow tw;
                    if (!each.isVisible() || !((tw = ToolWindowManagerImpl.this.getToolWindow(each.getId())) instanceof ToolWindowImpl) || (decorator = ((ToolWindowImpl)tw).getDecorator()) == null) continue;
                    decorator.repaint();
                }
            }
        });
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(1);
        }
        if (e.getKeyCode() != 17 && e.getKeyCode() != 18 && e.getKeyCode() != 16 && e.getKeyCode() != 157) {
            if (e.getModifiers() == 0) {
                this.resetHoldState();
            }
            return false;
        }
        if (e.getID() != 401 && e.getID() != 402) {
            return false;
        }
        Component parent = UIUtil.findUltimateParent((Component)e.getComponent());
        if (parent instanceof IdeFrame && ((IdeFrame)parent).getProject() != this.myProject) {
            this.resetHoldState();
            return false;
        }
        Set<Integer> vks = ToolWindowManagerImpl.getActivateToolWindowVKs();
        if (vks.isEmpty()) {
            this.resetHoldState();
            return false;
        }
        if (vks.contains(e.getKeyCode())) {
            boolean pressed = e.getID() == 401;
            int modifiers = e.getModifiers();
            int mouseMask = 7168;
            if ((e.getModifiersEx() & mouseMask) == 0) {
                if (ToolWindowManagerImpl.areAllModifiersPressed(modifiers, vks) || !pressed) {
                    this.processState(pressed);
                } else {
                    this.resetHoldState();
                }
            }
        }
        return false;
    }

    private static boolean areAllModifiersPressed(@JdkConstants.InputEventMask int modifiers, Set<Integer> modifierCodes) {
        int mask = 0;
        for (Integer each : modifierCodes) {
            if (each == 16) {
                mask |= 1;
            }
            if (each == 17) {
                mask |= 2;
            }
            if (each == 157) {
                mask |= 4;
            }
            if (each != 18) continue;
            mask |= 8;
        }
        return (modifiers ^ mask) == 0;
    }

    @NotNull
    private static Set<Integer> getActivateToolWindowVKs() {
        KeyStroke keyStroke;
        Shortcut each;
        if (ApplicationManager.getApplication() == null) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (hashSet == null) {
                ToolWindowManagerImpl.$$$reportNull$$$0(2);
            }
            return hashSet;
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] baseShortcut = keymap.getShortcuts("ActivateProjectToolWindow");
        int baseModifiers = SystemInfo.isMac ? 4 : 8;
        Shortcut[] shortcutArray = baseShortcut;
        int n = shortcutArray.length;
        for (int i = 0; !(i >= n || (each = shortcutArray[i]) instanceof KeyboardShortcut && (baseModifiers = (keyStroke = ((KeyboardShortcut)each).getFirstKeyStroke()).getModifiers()) > 0); ++i) {
        }
        Set<Integer> set2 = ToolWindowManagerImpl.getModifiersVKs(baseModifiers);
        if (set2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    private static Set<Integer> getModifiersVKs(int mask) {
        THashSet codes = new THashSet();
        if ((mask & 1) > 0) {
            codes.add(16);
        }
        if ((mask & 2) > 0) {
            codes.add(17);
        }
        if ((mask & 4) > 0) {
            codes.add(157);
        }
        if ((mask & 8) > 0) {
            codes.add(18);
        }
        THashSet tHashSet = codes;
        if (tHashSet == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(4);
        }
        return tHashSet;
    }

    private void resetHoldState() {
        this.myCurrentState = KeyState.waiting;
        this.processHoldState();
    }

    private void processState(boolean pressed) {
        if (pressed) {
            if (this.myCurrentState == KeyState.waiting) {
                this.myCurrentState = KeyState.pressed;
            } else if (this.myCurrentState == KeyState.released) {
                this.myCurrentState = KeyState.hold;
                this.processHoldState();
            }
        } else if (this.myCurrentState == KeyState.pressed) {
            this.myCurrentState = KeyState.released;
            this.restartWaitingForSecondPressAlarm();
        } else {
            this.resetHoldState();
        }
    }

    private void processHoldState() {
        if (this.myToolWindowsPane != null) {
            this.myToolWindowsPane.setStripesOverlayed(this.myCurrentState == KeyState.hold);
        }
    }

    private void restartWaitingForSecondPressAlarm() {
        this.myWaiterForSecondPress.cancelAllRequests();
        this.myWaiterForSecondPress.addRequest(this.mySecondPressRunnable, Registry.intValue((String)"actionSystem.keyGestureDblClickTime"));
    }

    private boolean hasOpenEditorFiles() {
        return FileEditorManager.getInstance((Project)this.myProject).getOpenFiles().length > 0;
    }

    private static IdeFocusManager getFocusManagerImpl(Project project) {
        return IdeFocusManager.getInstance((Project)project);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(5);
        }
        return project;
    }

    public void dispose() {
        for (String id : new ArrayList<String>(this.myId2StripeButton.keySet())) {
            this.unregisterToolWindow(id);
        }
        assert (this.myId2StripeButton.isEmpty());
    }

    public void init() {
        if (this.myToolWindowsPane != null) {
            return;
        }
        this.myFrame = this.myWindowManager.allocateFrame(this.myProject);
        LOG.assertTrue(this.myFrame != null);
        this.myToolWindowsPane = new ToolWindowsPane(this.myFrame, this);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myToolWindowsPane);
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(this.myToolWindowsPane);
        this.myFrame.setTitle(FrameTitleBuilder.getInstance().getProjectTitle(this.myProject));
        ((IdeRootPane)this.myFrame.getRootPane()).updateToolbar();
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof KeyEvent) {
                this.dispatchKeyEvent((KeyEvent)e);
            }
            if (e instanceof WindowEvent && e.getID() == 208 && e.getSource() == this.myFrame) {
                this.resetHoldState();
            }
            return false;
        }, (Disposable)this.myProject);
        UIUtil.putClientProperty((JComponent)((Object)this.myToolWindowsPane), (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<JComponent>(){

            @Override
            public Iterator<JComponent> iterator() {
                return JBIterable.of((Object[])ToolWindowManagerImpl.this.myLayout.getInfos()).map(info -> ToolWindowManagerImpl.this.getInternalDecorator(info.getId())).filter(decorator -> decorator.getParent() == null).iterator();
            }
        });
    }

    private void initAll(List<FinalizableCommand> commandsList) {
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        JComponent editorComponent = ToolWindowManagerImpl.createEditorComponent(this.myProject);
        editorComponent.setFocusable(false);
        this.appendSetEditorComponentCmd(editorComponent, commandsList);
    }

    private static JComponent createEditorComponent(@NotNull Project project) {
        if (project == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(6);
        }
        return ((FrameEditorComponentProvider[])FrameEditorComponentProvider.EP.getExtensions())[0].createEditorComponent(project);
    }

    private void registerToolWindowsFromBeans(List<FinalizableCommand> list2) {
        ToolWindowEP[] beans;
        for (final ToolWindowEP bean : beans = (ToolWindowEP[])Extensions.getExtensions((ExtensionPointName)ToolWindowEP.EP_NAME)) {
            list2.add(new FinalizableCommand(EmptyRunnable.INSTANCE){

                @Override
                public void run() {
                    ToolWindowManagerImpl.this.initToolWindow(bean);
                }
            });
        }
    }

    @Override
    public void initToolWindow(@NotNull ToolWindowEP bean) {
        WindowInfoImpl info;
        Condition condition;
        if (bean == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(7);
        }
        if ((condition = bean.getCondition()) != null && !condition.value((Object)this.myProject)) {
            return;
        }
        WindowInfoImpl before = this.myLayout.getInfo(bean.id, false);
        boolean visible = before != null && before.isVisible();
        JLabel label = ToolWindowManagerImpl.createInitializingLabel();
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.fromText((String)bean.anchor);
        ToolWindowFactory factory = bean.getToolWindowFactory();
        ToolWindow window = this.registerToolWindow(bean.id, label, toolWindowAnchor, false, bean.canCloseContents, DumbService.isDumbAware((Object)factory), factory.shouldBeAvailable(this.myProject));
        ToolWindowImpl toolWindow = (ToolWindowImpl)this.registerDisposable(bean.id, (Disposable)this.myProject, window);
        toolWindow.setContentFactory(factory);
        if (bean.icon != null && toolWindow.getIcon() == null) {
            Icon icon = IconLoader.findIcon((String)bean.icon, factory.getClass());
            if (icon == null) {
                try {
                    icon = IconLoader.getIcon((String)bean.icon);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            toolWindow.setIcon(icon);
        }
        if (!(info = this.getInfo(bean.id)).isSplit() && bean.secondary && !info.wasRead()) {
            toolWindow.setSplitMode(true, null);
        }
        toolWindow.setActivation(new ActionCallback()).setDone();
        DumbAwareRunnable runnable2 = () -> {
            if (toolWindow.isDisposed()) {
                return;
            }
            toolWindow.ensureContentInitialized();
        };
        if (visible) {
            runnable2.run();
        } else {
            UiNotifyConnector.doWhenFirstShown((JComponent)label, () -> ApplicationManager.getApplication().invokeLater((Runnable)runnable2));
        }
    }

    @NotNull
    private static JLabel createInitializingLabel() {
        JLabel label = new JLabel("Initializing...", 0);
        label.setOpaque(true);
        Color treeBg = UIManager.getColor("Tree.background");
        label.setBackground(ColorUtil.toAlpha((Color)treeBg, (int)180));
        Color treeFg = UIUtil.getTreeForeground();
        label.setForeground(ColorUtil.toAlpha((Color)treeFg, (int)180));
        JLabel jLabel = label;
        if (jLabel == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(8);
        }
        return jLabel;
    }

    public void projectClosed() {
        if (this.myFrame == null) {
            return;
        }
        String[] ids = this.getToolWindowIds();
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(null);
        this.myWindowManager.releaseFrame(this.myFrame);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        for (String id : ids) {
            this.deactivateToolWindowImpl(id, true, commandsList);
        }
        this.appendSetEditorComponentCmd(null, commandsList);
        this.execute(commandsList);
        this.myFrame = null;
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        if (listener2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(9);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(11);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        if (listener2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(12);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void execute(@NotNull List<FinalizableCommand> commandList) {
        if (commandList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(13);
        }
        for (FinalizableCommand each : commandList) {
            if (!each.willChangeState()) continue;
            this.fireStateChanged();
            break;
        }
        for (FinalizableCommand each : commandList) {
            each.beforeExecute(this);
        }
        this.myCommandProcessor.execute(commandList, this.myProject.getDisposed());
    }

    private void flushCommands() {
        this.myCommandProcessor.flush();
    }

    public void activateEditorComponent() {
    }

    private void deactivateWindows(@Nullable String idToIgnore, @NotNull List<FinalizableCommand> commandList) {
        WindowInfoImpl[] infos;
        if (commandList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(14);
        }
        for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
            if (idToIgnore != null && idToIgnore.equals(info.getId())) continue;
            this.deactivateToolWindowImpl(info.getId(), ToolWindowManagerImpl.isToHideOnDeactivation(info), commandList);
        }
    }

    private static boolean isToHideOnDeactivation(@NotNull WindowInfoImpl info) {
        if (info == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(15);
        }
        if (info.isFloating() || info.isWindowed()) {
            return false;
        }
        return info.isAutoHide() || info.isSliding();
    }

    private void showAndActivate(@NotNull String id, boolean dirtyMode, @NotNull List<FinalizableCommand> commandsList, boolean autoFocusContents, boolean forcedFocusRequest) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(16);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(17);
        }
        if (!this.getToolWindow(id).isAvailable()) {
            return;
        }
        WindowInfoImpl info = this.getInfo(id);
        boolean toApplyInfo = false;
        if (!info.isActive()) {
            info.setActive(true);
            toApplyInfo = true;
        }
        this.showToolWindowImpl(id, dirtyMode, commandsList);
        if (toApplyInfo) {
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.myActiveStack.push(id);
        }
        if (autoFocusContents && ApplicationManager.getApplication().isActive()) {
            this.appendRequestFocusInToolWindowCmd(id, commandsList, forcedFocusRequest);
        }
    }

    void activateToolWindow(@NotNull String id, boolean forced, boolean autoFocusContents) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(18);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.activateToolWindowImpl(id, commandList, forced, autoFocusContents);
        this.execute(commandList);
    }

    private void activateToolWindowImpl(@NotNull String id, @NotNull List<FinalizableCommand> commandList, boolean forced, boolean autoFocusContents) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(19);
        }
        if (commandList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(20);
        }
        autoFocusContents &= forced;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindowImpl(" + id + ")");
        }
        if (!this.getToolWindow(id).isAvailable()) {
            InternalDecorator decorator = this.getInternalDecorator(id);
            if (!decorator.hasFocus() && autoFocusContents) {
                this.appendRequestFocusInToolWindowCmd(id, commandList, forced);
            }
            return;
        }
        this.deactivateWindows(id, commandList);
        this.showAndActivate(id, false, commandList, autoFocusContents, forced);
    }

    private void checkId(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(21);
        }
        if (!this.myLayout.isToolWindowRegistered(id)) {
            throw new IllegalStateException("window with id=\"" + id + "\" isn't registered");
        }
    }

    private void deactivateToolWindowImpl(@NotNull String id, boolean shouldHide, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(22);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(23);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: deactivateToolWindowImpl(" + id + "," + shouldHide + ")");
        }
        WindowInfoImpl info = this.getInfo(id);
        if (shouldHide && info.isVisible()) {
            this.applyInfo(id, info, commandsList);
        }
        info.setActive(false);
        this.appendApplyWindowInfoCmd(info, commandsList);
    }

    @NotNull
    public String[] getToolWindowIds() {
        WindowInfoImpl[] infos = this.myLayout.getInfos();
        String[] ids = ArrayUtil.newStringArray((int)infos.length);
        for (int i = 0; i < infos.length; ++i) {
            ids[i] = infos[i].getId();
        }
        if (ids == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(24);
        }
        return ids;
    }

    public String getActiveToolWindowId() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout.getActiveId();
    }

    @Override
    public String getLastActiveToolWindowId() {
        return this.getLastActiveToolWindowId(null);
    }

    @Override
    @Nullable
    public String getLastActiveToolWindowId(@Nullable Condition<JComponent> condition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String lastActiveToolWindowId = null;
        for (int i = 0; i < this.myActiveStack.getPersistentSize(); ++i) {
            String id = this.myActiveStack.peekPersistent(i);
            ToolWindow toolWindow = this.getToolWindow(id);
            LOG.assertTrue(toolWindow != null);
            if (!toolWindow.isAvailable() || condition != null && !condition.value((Object)toolWindow.getComponent())) continue;
            lastActiveToolWindowId = id;
            break;
        }
        return lastActiveToolWindowId;
    }

    private FloatingDecorator getFloatingDecorator(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(25);
        }
        return this.myId2FloatingDecorator.get(id);
    }

    private WindowedDecorator getWindowedDecorator(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(26);
        }
        return this.myId2WindowedDecorator.get(id);
    }

    private InternalDecorator getInternalDecorator(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(27);
        }
        return this.myId2InternalDecorator.get(id);
    }

    StripeButton getStripeButton(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(28);
        }
        return this.myId2StripeButton.get(id);
    }

    private WindowInfoImpl getInfo(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(29);
        }
        return this.myLayout.getInfo(id, true);
    }

    @Override
    @NotNull
    public List<String> getIdsOn(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(30);
        }
        List<String> list2 = this.myLayout.getVisibleIdsOn(anchor2, this);
        if (list2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @Nullable
    public ToolWindow getToolWindow(@Nullable String id) {
        if (id == null || !this.myLayout.isToolWindowRegistered(id)) {
            return null;
        }
        InternalDecorator decorator = this.getInternalDecorator(id);
        return decorator != null ? decorator.getToolWindow() : null;
    }

    void showToolWindow(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(32);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: showToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.showToolWindowImpl(id, false, commandList);
        this.execute(commandList);
    }

    @Override
    public void hideToolWindow(@NotNull String id, boolean hideSide) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(33);
        }
        this.hideToolWindow(id, hideSide, true);
    }

    public void hideToolWindow(@NotNull String id, boolean hideSide, boolean moveFocus) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (!info.isVisible()) {
            return;
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        boolean wasActive = info.isActive();
        this.deactivateToolWindowImpl(id, true, commandList);
        if (hideSide && !info.isFloating() && !info.isWindowed()) {
            String[] all;
            List<String> ids = this.myLayout.getVisibleIdsOn(info.getAnchor(), this);
            for (String string : ids) {
                this.myActiveStack.remove(string, true);
            }
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                this.mySideStack.pop(info.getAnchor());
            }
            for (String eachId : all = this.getToolWindowIds()) {
                WindowInfoImpl eachInfo = this.getInfo(eachId);
                if (!eachInfo.isVisible() || eachInfo.getAnchor() != info.getAnchor()) continue;
                this.deactivateToolWindowImpl(eachId, true, commandList);
            }
        } else if (ToolWindowManagerImpl.isStackEnabled()) {
            WindowInfoImpl info2 = null;
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                WindowInfoImpl storedInfo = this.mySideStack.pop(info.getAnchor());
                if (storedInfo.isSplit() != info.isSplit()) continue;
                WindowInfoImpl windowInfoImpl = this.getInfo(storedInfo.getId());
                LOG.assertTrue(windowInfoImpl != null);
                if (storedInfo.getAnchor() != windowInfoImpl.getAnchor() || storedInfo.getType() != windowInfoImpl.getType() || storedInfo.isAutoHide() != windowInfoImpl.isAutoHide()) continue;
                info2 = storedInfo;
                break;
            }
            if (info2 != null) {
                this.showToolWindowImpl(info2.getId(), false, commandList);
            }
            this.myActiveStack.remove(id, false);
            if (wasActive && moveFocus && !this.myActiveStack.isEmpty()) {
                String toBeActivatedId = this.myActiveStack.pop();
                if (this.getInfo(toBeActivatedId).isVisible() || ToolWindowManagerImpl.isStackEnabled()) {
                    this.activateToolWindowImpl(toBeActivatedId, commandList, false, true);
                } else {
                    this.focusToolWindowByDefault(id);
                }
            }
        }
        this.execute(commandList);
    }

    private static boolean isStackEnabled() {
        return Registry.is((String)"ide.enable.toolwindow.stack");
    }

    private void showToolWindowImpl(@NotNull String id, boolean dirtyMode, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(35);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(36);
        }
        WindowInfoImpl toBeShownInfo = this.getInfo(id);
        ToolWindow window = this.getToolWindow(id);
        if (window != null && toBeShownInfo.isWindowed()) {
            UIUtil.toFront((Window)UIUtil.getWindow((Component)window.getComponent()));
        }
        if (toBeShownInfo.isVisible() || window == null || !window.isAvailable()) {
            return;
        }
        toBeShownInfo.setVisible(true);
        InternalDecorator decorator = this.getInternalDecorator(id);
        if (toBeShownInfo.isFloating()) {
            commandsList.add(new AddFloatingDecoratorCmd(decorator, toBeShownInfo));
        } else if (toBeShownInfo.isWindowed()) {
            commandsList.add(new AddWindowedDecoratorCmd(decorator, toBeShownInfo));
        } else {
            WindowInfoImpl[] infos;
            for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
                if (id.equals(info.getId()) || !info.isVisible() || info.getType() != toBeShownInfo.getType() || info.getAnchor() != toBeShownInfo.getAnchor() || info.isSplit() != toBeShownInfo.isSplit()) continue;
                info.setVisible(false);
                this.appendRemoveDecoratorCmd(info.getId(), false, commandsList);
                if (info.isActive()) {
                    info.setActive(false);
                }
                this.appendApplyWindowInfoCmd(info, commandsList);
                if (!info.isDocked() || info.isAutoHide()) continue;
                this.mySideStack.push(info);
            }
            this.appendAddDecoratorCmd(decorator, toBeShownInfo, dirtyMode, commandsList);
            this.mySideStack.remove(id);
        }
        if (!toBeShownInfo.isShowStripeButton()) {
            toBeShownInfo.setShowStripeButton(true);
        }
        this.appendApplyWindowInfoCmd(toBeShownInfo, commandsList);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(37);
        }
        if (component == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(38);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(39);
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor2, false, false, false, true);
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(40);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(41);
        }
        if (component == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(42);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(43);
        }
        if (parentDisposable == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(44);
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor2, parentDisposable, false, false);
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(45);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(46);
        }
        if (component == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(47);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(48);
        }
        if (parentDisposable == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(49);
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor2, parentDisposable, canWorkInDumbMode, false);
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(50);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean canCloseContents) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(51);
        }
        if (component == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(52);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(53);
        }
        if (parentDisposable == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(54);
        }
        ToolWindow toolWindow = this.registerDisposable(id, parentDisposable, this.registerToolWindow(id, component, anchor2, false, canCloseContents, canWorkInDumbMode, true));
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(55);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(56);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(57);
        }
        ToolWindow toolWindow = this.registerToolWindow(id, null, anchor2, false, canCloseContent, false, true);
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(58);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, boolean secondary) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(59);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(60);
        }
        ToolWindow toolWindow = this.registerToolWindow(id, null, anchor2, secondary, canCloseContent, false, true);
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(61);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(62);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(63);
        }
        if (parentDisposable == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(64);
        }
        ToolWindow toolWindow = this.registerToolWindow(id, canCloseContent, anchor2, parentDisposable, canWorkInDumbMode, false);
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(65);
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean secondary) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(66);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(67);
        }
        if (parentDisposable == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(68);
        }
        ToolWindow window = this.registerToolWindow(id, null, anchor2, secondary, canCloseContent, canWorkInDumbMode, true);
        ToolWindow toolWindow = this.registerDisposable(id, parentDisposable, window);
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(69);
        }
        return toolWindow;
    }

    @NotNull
    private ToolWindow registerToolWindow(@NotNull String id, @Nullable JComponent component, @NotNull ToolWindowAnchor anchor2, boolean sideTool, boolean canCloseContent, boolean canWorkInDumbMode, boolean shouldBeAvailable) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(70);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(71);
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: installToolWindow(" + id + "," + component + "," + anchor2 + "\")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean known = this.myLayout.isToolWindowUnregistered(id);
        if (this.myLayout.isToolWindowRegistered(id)) {
            throw new IllegalArgumentException("window with id=\"" + id + "\" is already registered");
        }
        WindowInfoImpl info = this.myLayout.register(id, anchor2, sideTool);
        boolean wasActive = info.isActive();
        boolean wasVisible = info.isVisible();
        info.setActive(false);
        info.setVisible(false);
        if (!known) {
            info.setShowStripeButton(shouldBeAvailable);
        }
        ToolWindowImpl toolWindow = new ToolWindowImpl(this, id, canCloseContent, component);
        InternalDecorator decorator = new InternalDecorator(this.myProject, info.copy(), toolWindow, canWorkInDumbMode);
        ActivateToolWindowAction.ensureToolWindowActionRegistered(toolWindow);
        this.myId2InternalDecorator.put(id, decorator);
        decorator.addInternalDecoratorListener(this.myInternalDecoratorListener);
        toolWindow.addPropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myId2FocusWatcher.put(id, new ToolWindowFocusWatcher(toolWindow));
        StripeButton button = new StripeButton(decorator, this.myToolWindowsPane);
        this.myId2StripeButton.put(id, button);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.appendAddButtonCmd(button, info, commandsList);
        if (!info.isAutoHide() && (info.isDocked() || info.isFloating())) {
            if (wasActive) {
                this.activateToolWindowImpl(info.getId(), commandsList, true, true);
            } else if (wasVisible) {
                this.showToolWindowImpl(info.getId(), false, commandsList);
            }
        }
        this.execute(commandsList);
        this.fireToolWindowRegistered(id);
        ToolWindowImpl toolWindowImpl = toolWindow;
        if (toolWindowImpl == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(72);
        }
        return toolWindowImpl;
    }

    @NotNull
    private ToolWindow registerDisposable(@NotNull String id, @NotNull Disposable parentDisposable, @NotNull ToolWindow window) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(73);
        }
        if (parentDisposable == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(74);
        }
        if (window == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(75);
        }
        Disposer.register((Disposable)parentDisposable, () -> {
            if (id == null) {
                ToolWindowManagerImpl.$$$reportNull$$$0(154);
            }
            this.unregisterToolWindow(id);
        });
        ToolWindow toolWindow = window;
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(76);
        }
        return toolWindow;
    }

    public void unregisterToolWindow(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(77);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: unregisterToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myLayout.isToolWindowRegistered(id)) {
            return;
        }
        WindowInfoImpl info = this.getInfo(id);
        ToolWindowEx toolWindow = (ToolWindowEx)this.getToolWindow(id);
        this.myLayout.unregister(id);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        if (info.isVisible()) {
            this.applyInfo(id, info, commandsList);
        }
        this.appendRemoveButtonCmd(id, commandsList);
        this.appendApplyWindowInfoCmd(info, commandsList);
        this.execute(commandsList);
        assert (toolWindow != null);
        toolWindow.removePropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myActiveStack.remove(id, true);
        this.mySideStack.remove(id);
        StripeButton button = this.getStripeButton(id);
        Disposer.dispose((Disposable)button);
        this.myId2StripeButton.remove(id);
        ToolWindowFocusWatcher watcher = (ToolWindowFocusWatcher)this.myId2FocusWatcher.remove(id);
        watcher.deinstall();
        InternalDecorator decorator = this.getInternalDecorator(id);
        decorator.dispose();
        decorator.removeInternalDecoratorListener(this.myInternalDecoratorListener);
        this.myId2InternalDecorator.remove(id);
    }

    private void applyInfo(@NotNull String id, WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(78);
        }
        info.setVisible(false);
        if (info.isFloating()) {
            this.appendRemoveFloatingDecoratorCmd(info, commandsList);
        } else if (info.isWindowed()) {
            this.appendRemoveWindowedDecoratorCmd(info, commandsList);
        } else {
            this.appendRemoveDecoratorCmd(id, false, commandsList);
        }
    }

    @Override
    public DesktopLayout getLayout() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout;
    }

    @Override
    public void setLayoutToRestoreLater(DesktopLayout layout) {
        this.myLayoutToRestoreLater = layout;
    }

    @Override
    public DesktopLayout getLayoutToRestoreLater() {
        return this.myLayoutToRestoreLater;
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
        WindowInfoImpl info;
        WindowInfoImpl[] currentInfos;
        if (layout == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(79);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        for (WindowInfoImpl currentInfo : currentInfos = this.myLayout.getInfos()) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || !currentInfo.isVisible() || info.isVisible()) continue;
            this.deactivateToolWindowImpl(currentInfo.getId(), true, commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.getAnchor() == info.getAnchor() && currentInfo.getOrder() == info.getOrder()) continue;
            this.setToolWindowAnchorImpl(currentInfo.getId(), info.getAnchor(), info.getOrder(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.getType() == info.getType()) continue;
            this.setToolWindowTypeImpl(currentInfo.getId(), info.getType(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.isAutoHide() == info.isAutoHide()) continue;
            this.setToolWindowAutoHideImpl(currentInfo.getId(), info.isAutoHide(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || !info.isVisible()) continue;
            this.showToolWindowImpl(currentInfo.getId(), false, commandList);
        }
        this.execute(commandList);
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(80);
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        commandList.add(new InvokeLaterCmd(runnable2, this.myCommandProcessor));
        this.execute(commandList);
    }

    @NotNull
    public IdeFocusManager getFocusManager() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (ideFocusManager == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(81);
        }
        return ideFocusManager;
    }

    public boolean canShowNotification(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(82);
        }
        if (!Arrays.asList(this.getToolWindowIds()).contains(toolWindowId)) {
            return false;
        }
        Stripe stripe = this.myToolWindowsPane.getStripeFor(toolWindowId);
        return stripe != null && stripe.getButtonFor(toolWindowId) != null;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String htmlBody) {
        if (toolWindowId == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(83);
        }
        if (type == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(84);
        }
        if (htmlBody == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(85);
        }
        this.notifyByBalloon(toolWindowId, type, htmlBody, null, null);
    }

    public void notifyByBalloon(final @NotNull String toolWindowId, final @NotNull MessageType type, final @NotNull String text, @Nullable Icon icon, @Nullable HyperlinkListener listener2) {
        Stripe stripe;
        if (toolWindowId == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(86);
        }
        if (type == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(87);
        }
        if (text == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(88);
        }
        this.checkId(toolWindowId);
        Balloon existing = this.myWindow2Balloon.get(toolWindowId);
        if (existing != null) {
            existing.hide();
        }
        if ((stripe = this.myToolWindowsPane.getStripeFor(toolWindowId)) == null) {
            return;
        }
        ToolWindowImpl window = this.getInternalDecorator(toolWindowId).getToolWindow();
        if (!window.isAvailable()) {
            window.setPlaceholderMode(true);
            stripe.updatePresentation();
            stripe.revalidate();
            stripe.repaint();
        }
        final ToolWindowAnchor anchor2 = this.getInfo(toolWindowId).getAnchor();
        final Ref position = Ref.create((Object)Balloon.Position.below);
        if (ToolWindowAnchor.TOP == anchor2) {
            position.set((Object)Balloon.Position.below);
        } else if (ToolWindowAnchor.BOTTOM == anchor2) {
            position.set((Object)Balloon.Position.above);
        } else if (ToolWindowAnchor.LEFT == anchor2) {
            position.set((Object)Balloon.Position.atRight);
        } else if (ToolWindowAnchor.RIGHT == anchor2) {
            position.set((Object)Balloon.Position.atLeft);
        }
        BalloonHyperlinkListener listenerWrapper = new BalloonHyperlinkListener(listener2);
        final Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text.replace("\n", "<br>"), icon, type.getPopupBackground(), (HyperlinkListener)listenerWrapper).setHideOnClickOutside(false).setHideOnFrameResize(false).createBalloon();
        FrameStateManager.getInstance().getApplicationActive().doWhenDone(() -> {
            Alarm alarm = new Alarm();
            alarm.addRequest(() -> {
                ((BalloonImpl)balloon).setHideOnClickOutside(true);
                Disposer.dispose((Disposable)alarm);
            }, 100);
        });
        listenerWrapper.myBalloon = balloon;
        this.myWindow2Balloon.put(toolWindowId, balloon);
        Disposer.register((Disposable)balloon, () -> {
            if (toolWindowId == null) {
                ToolWindowManagerImpl.$$$reportNull$$$0(153);
            }
            window.setPlaceholderMode(false);
            stripe.updatePresentation();
            stripe.revalidate();
            stripe.repaint();
            this.myWindow2Balloon.remove(toolWindowId);
        });
        Disposer.register((Disposable)this.getProject(), (Disposable)balloon);
        this.execute(new ArrayList<FinalizableCommand>(Collections.singletonList(new FinalizableCommand(null){

            @Override
            public void run() {
                StripeButton button = stripe.getButtonFor(toolWindowId);
                LOG.assertTrue(button != null, (Object)("Button was not found, popup won't be shown. Toolwindow id: " + toolWindowId + ", message: " + text + ", message type: " + type));
                if (button == null) {
                    return;
                }
                Runnable show = () -> {
                    if (toolWindowId == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    PositionTracker<Balloon> tracker = button.isShowing() ? new PositionTracker<Balloon>((Component)button){

                        @Nullable
                        public RelativePoint recalculateLocation(Balloon object) {
                            StripeButton twButton;
                            Stripe twStripe = ToolWindowManagerImpl.this.myToolWindowsPane.getStripeFor(toolWindowId);
                            StripeButton stripeButton = twButton = twStripe != null ? twStripe.getButtonFor(toolWindowId) : null;
                            if (twButton == null) {
                                return null;
                            }
                            if (ToolWindowManagerImpl.this.getToolWindow(toolWindowId).getAnchor() != anchor2) {
                                object.hide();
                                return null;
                            }
                            Point point = new Point(twButton.getBounds().width / 2, twButton.getHeight() / 2 - 2);
                            return new RelativePoint((Component)twButton, point);
                        }
                    } : new PositionTracker<Balloon>((Component)((Object)ToolWindowManagerImpl.this.myToolWindowsPane)){

                        public RelativePoint recalculateLocation(Balloon object) {
                            Rectangle bounds = ToolWindowManagerImpl.this.myToolWindowsPane.getBounds();
                            Point target2 = UIUtil.getCenterPoint((Rectangle)bounds, (Dimension)new Dimension(1, 1));
                            if (ToolWindowAnchor.TOP == anchor2) {
                                target2.y = 0;
                            } else if (ToolWindowAnchor.BOTTOM == anchor2) {
                                target2.y = bounds.height - 3;
                            } else if (ToolWindowAnchor.LEFT == anchor2) {
                                target2.x = 0;
                            } else if (ToolWindowAnchor.RIGHT == anchor2) {
                                target2.x = bounds.width;
                            }
                            return new RelativePoint((Component)((Object)ToolWindowManagerImpl.this.myToolWindowsPane), target2);
                        }
                    };
                    if (!balloon.isDisposed()) {
                        balloon.show((PositionTracker)tracker, (Balloon.Position)position.get());
                    }
                };
                if (!button.isValid()) {
                    SwingUtilities.invokeLater(show);
                } else {
                    show.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$6", "lambda$run$0"));
            }
        })));
    }

    public Balloon getToolWindowBalloon(String id) {
        return this.myWindow2Balloon.get(id);
    }

    public boolean isEditorComponentActive() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Component owner = this.getFocusManager().getFocusOwner();
        EditorsSplitters splitters = (EditorsSplitters)((Object)UIUtil.getParentOfType(EditorsSplitters.class, (Component)owner));
        return splitters != null;
    }

    @NotNull
    ToolWindowAnchor getToolWindowAnchor(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(89);
        }
        this.checkId(id);
        ToolWindowAnchor toolWindowAnchor = this.getInfo(id).getAnchor();
        if (toolWindowAnchor == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(90);
        }
        return toolWindowAnchor;
    }

    void setToolWindowAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor2) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(91);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(92);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setToolWindowAnchor(id, anchor2, -1);
    }

    private void setToolWindowAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor2, int order) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(93);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(94);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAnchorImpl(id, anchor2, order, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAnchorImpl(@NotNull String id, @NotNull ToolWindowAnchor anchor2, int order, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(95);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(96);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(97);
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (anchor2 == info.getAnchor() && order == info.getOrder()) {
            return;
        }
        if (!info.isVisible() || anchor2 == info.getAnchor() || info.isFloating() || info.isWindowed()) {
            WindowInfoImpl[] infos;
            this.appendRemoveButtonCmd(id, commandsList);
            this.myLayout.setAnchor(id, anchor2, order);
            for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
        } else {
            WindowInfoImpl[] infos;
            info.setVisible(false);
            this.appendRemoveDecoratorCmd(id, false, commandsList);
            this.appendRemoveButtonCmd(id, commandsList);
            this.myLayout.setAnchor(id, anchor2, order);
            for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
            this.showToolWindowImpl(id, false, commandsList);
            if (info.isActive()) {
                this.appendRequestFocusInToolWindowCmd(id, commandsList, true);
            }
        }
    }

    boolean isSplitMode(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(98);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isSplit();
    }

    @NotNull
    ToolWindowContentUiType getContentUiType(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(99);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        ToolWindowContentUiType toolWindowContentUiType = this.getInfo(id).getContentUiType();
        if (toolWindowContentUiType == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(100);
        }
        return toolWindowContentUiType;
    }

    void setSideTool(@NotNull String id, boolean isSide) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(101);
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setSplitModeImpl(id, isSide, commandList);
        this.execute(commandList);
    }

    void setContentUiType(@NotNull String id, @NotNull ToolWindowContentUiType type) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(102);
        }
        if (type == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(103);
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        info.setContentUiType(type);
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.appendApplyWindowInfoCmd(info, commandList);
        this.execute(commandList);
    }

    void setSideToolAndAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor2, int order, boolean isSide) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(104);
        }
        if (anchor2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(105);
        }
        this.hideToolWindow(id, false);
        this.myLayout.setSplitMode(id, isSide);
        this.setToolWindowAnchor(id, anchor2, order);
        this.activateToolWindow(id, false, false);
    }

    private void setSplitModeImpl(@NotNull String id, boolean isSplit, @NotNull List<FinalizableCommand> commandList) {
        WindowInfoImpl[] infos;
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(106);
        }
        if (commandList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(107);
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (isSplit == info.isSplit()) {
            return;
        }
        this.myLayout.setSplitMode(id, isSplit);
        boolean wasActive = info.isActive();
        boolean wasVisible = info.isVisible();
        if (wasActive || wasVisible) {
            this.hideToolWindow(id, false);
        }
        for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
            this.appendApplyWindowInfoCmd(info1, commandList);
        }
        if (wasVisible || wasActive) {
            this.showToolWindowImpl(id, true, commandList);
        }
        if (wasActive) {
            this.activateToolWindowImpl(id, commandList, true, true);
        }
        commandList.add(this.myToolWindowsPane.createUpdateButtonPositionCmd(id, this.myCommandProcessor));
    }

    ToolWindowType getToolWindowInternalType(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(108);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).getInternalType();
    }

    ToolWindowType getToolWindowType(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(109);
        }
        this.checkId(id);
        return this.getInfo(id).getType();
    }

    private void fireToolWindowRegistered(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(110);
        }
        ((ToolWindowManagerListener)this.myDispatcher.getMulticaster()).toolWindowRegistered(id);
    }

    private void fireStateChanged() {
        ((ToolWindowManagerListener)this.myDispatcher.getMulticaster()).stateChanged();
    }

    boolean isToolWindowActive(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(111);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isActive();
    }

    boolean isToolWindowAutoHide(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(112);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isAutoHide();
    }

    boolean isToolWindowVisible(@NotNull String id) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(113);
        }
        this.checkId(id);
        return this.getInfo(id).isVisible();
    }

    void setToolWindowAutoHide(@NotNull String id, boolean autoHide) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(114);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAutoHideImpl(id, autoHide, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAutoHideImpl(@NotNull String id, boolean autoHide, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(115);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(116);
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (info.isAutoHide() == autoHide) {
            return;
        }
        info.setAutoHide(autoHide);
        this.appendApplyWindowInfoCmd(info, commandsList);
        if (info.isVisible()) {
            this.deactivateWindows(id, commandsList);
            this.showAndActivate(id, false, commandsList, true, true);
        }
    }

    void setToolWindowType(@NotNull String id, @NotNull ToolWindowType type) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(117);
        }
        if (type == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(118);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowTypeImpl(id, type, commandList);
        this.execute(commandList);
    }

    private void setToolWindowTypeImpl(@NotNull String id, @NotNull ToolWindowType type, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(119);
        }
        if (type == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(120);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(121);
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (info.getType() == type) {
            return;
        }
        if (info.isVisible()) {
            boolean dirtyMode = info.isDocked() || info.isSliding();
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else if (info.isWindowed()) {
                this.appendRemoveWindowedDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, dirtyMode, commandsList);
            }
            info.setType(type);
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.deactivateWindows(id, commandsList);
            this.showAndActivate(id, dirtyMode, commandsList, true, true);
            this.appendUpdateToolWindowsPaneCmd(commandsList);
        } else {
            info.setType(type);
            this.appendApplyWindowInfoCmd(info, commandsList);
        }
    }

    private void appendApplyWindowInfoCmd(@NotNull WindowInfoImpl info, @NotNull List<FinalizableCommand> commandsList) {
        if (info == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(122);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(123);
        }
        StripeButton button = this.getStripeButton(info.getId());
        InternalDecorator decorator = this.getInternalDecorator(info.getId());
        commandsList.add(new ApplyWindowInfoCmd(info, button, decorator, this.myCommandProcessor));
    }

    private void appendAddDecoratorCmd(@NotNull InternalDecorator decorator, @NotNull WindowInfoImpl info, boolean dirtyMode, @NotNull List<FinalizableCommand> commandsList) {
        if (decorator == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(124);
        }
        if (info == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(125);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(126);
        }
        commandsList.add(this.myToolWindowsPane.createAddDecoratorCmd(decorator, info, dirtyMode, this.myCommandProcessor));
    }

    private void appendRemoveDecoratorCmd(@NotNull String id, boolean dirtyMode, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(127);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(128);
        }
        commandsList.add(this.myToolWindowsPane.createRemoveDecoratorCmd(id, dirtyMode, this.myCommandProcessor));
    }

    private void appendRemoveFloatingDecoratorCmd(@NotNull WindowInfoImpl info, @NotNull List<FinalizableCommand> commandsList) {
        if (info == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(129);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(130);
        }
        commandsList.add(new RemoveFloatingDecoratorCmd(info));
    }

    private void appendRemoveWindowedDecoratorCmd(@NotNull WindowInfoImpl info, @NotNull List<FinalizableCommand> commandsList) {
        if (info == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(131);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(132);
        }
        commandsList.add(new RemoveWindowedDecoratorCmd(info));
    }

    private void appendAddButtonCmd(StripeButton button, @NotNull WindowInfoImpl info, @NotNull List<FinalizableCommand> commandsList) {
        if (info == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(133);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(134);
        }
        Comparator<StripeButton> comparator2 = this.myLayout.comparator(info.getAnchor());
        commandsList.add(this.myToolWindowsPane.createAddButtonCmd(button, info, comparator2, this.myCommandProcessor));
    }

    private void appendRemoveButtonCmd(@NotNull String id, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(135);
        }
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(136);
        }
        commandsList.add(this.myToolWindowsPane.createRemoveButtonCmd(id, this.myCommandProcessor));
    }

    private void appendRequestFocusInToolWindowCmd(String id, List<FinalizableCommand> commandList, boolean forced) {
        ToolWindowImpl toolWindow = (ToolWindowImpl)this.getToolWindow(id);
        FocusWatcher focusWatcher = this.myId2FocusWatcher.get(id);
        commandList.add(new RequestFocusInToolWindowCmd(this.getFocusManager(), toolWindow, focusWatcher, this.myCommandProcessor, this.myProject));
    }

    private void appendSetEditorComponentCmd(@Nullable JComponent component, @NotNull List<FinalizableCommand> commandsList) {
        if (commandsList == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(137);
        }
        commandsList.add(this.myToolWindowsPane.createSetEditorComponentCmd(component, this.myCommandProcessor));
    }

    private void appendUpdateToolWindowsPaneCmd(List<FinalizableCommand> commandsList) {
        JRootPane rootPane = this.myFrame.getRootPane();
        if (rootPane != null) {
            commandsList.add(new UpdateRootPaneCmd(rootPane, this.myCommandProcessor));
        }
    }

    private EditorsSplitters getSplittersToFocus() {
        IdeFrame frame;
        Window activeWindow = this.myWindowManager.getMostRecentFocusedWindow();
        if (activeWindow instanceof FloatingDecorator) {
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            activeWindow = (Window)ObjectUtils.notNull((Object)lastFocusedWindow, (Object)activeWindow);
        }
        if ((frame = FocusManagerImpl.getInstance().getLastFocusedFrame()) != null && frame instanceof IdeFrameImpl && ((IdeFrameImpl)frame).isActive()) {
            FileEditorManagerEx fem = FileEditorManagerEx.getInstanceEx(frame.getProject());
            EditorsSplitters splitters = activeWindow != null ? fem.getSplittersFor(activeWindow) : null;
            return splitters != null ? splitters : fem.getSplitters();
        }
        return null;
    }

    @Override
    public void clearSideStack() {
        this.mySideStack.clear();
    }

    @Nullable
    public Element getState() {
        Element layoutToRestoreElement;
        Element layoutElement;
        if (this.myFrame == null) {
            return null;
        }
        for (String id : this.getToolWindowIds()) {
            WindowInfoImpl info = this.getInfo(id);
            if (!info.isVisible()) continue;
            InternalDecorator decorator = this.getInternalDecorator(id);
            LOG.assertTrue(decorator != null);
            decorator.fireResized();
        }
        Element element = new Element("state");
        Rectangle frameBounds = this.myFrame.getBounds();
        Element frameElement = new Element(FRAME_ELEMENT);
        element.addContent(frameElement);
        frameElement.setAttribute(X_ATTR, Integer.toString(frameBounds.x));
        frameElement.setAttribute(Y_ATTR, Integer.toString(frameBounds.y));
        frameElement.setAttribute(WIDTH_ATTR, Integer.toString(frameBounds.width));
        frameElement.setAttribute(HEIGHT_ATTR, Integer.toString(frameBounds.height));
        frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(this.myFrame.getExtendedState()));
        if (this.isEditorComponentActive()) {
            Element editorElement = new Element(EDITOR_ELEMENT);
            editorElement.setAttribute(ACTIVE_ATTR_VALUE, "true");
            element.addContent(editorElement);
        }
        if ((layoutElement = this.myLayout.writeExternal("layout")) != null) {
            element.addContent(layoutElement);
        }
        Element element2 = layoutToRestoreElement = this.myLayoutToRestoreLater == null ? null : this.myLayoutToRestoreLater.writeExternal(LAYOUT_TO_RESTORE);
        if (layoutToRestoreElement != null) {
            element.addContent(layoutToRestoreElement);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(138);
        }
        for (Element e : state.getChildren()) {
            if ("layout".equals(e.getName())) {
                this.myLayout.readExternal(e);
                continue;
            }
            if (!LAYOUT_TO_RESTORE.equals(e.getName())) continue;
            this.myLayoutToRestoreLater = new DesktopLayout();
            this.myLayoutToRestoreLater.readExternal(e);
        }
    }

    public void setDefaultState(@NotNull ToolWindowImpl toolWindow, @Nullable ToolWindowAnchor anchor2, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
        WindowInfoImpl info;
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(139);
        }
        if ((info = this.getInfo(toolWindow.getId())).wasRead()) {
            return;
        }
        if (floatingBounds != null) {
            info.setFloatingBounds(floatingBounds);
        }
        if (anchor2 != null) {
            toolWindow.setAnchor(anchor2, null);
        }
        if (type != null) {
            toolWindow.setType(type, null);
        }
    }

    void setDefaultContentUiType(@NotNull ToolWindowImpl toolWindow, @NotNull ToolWindowContentUiType type) {
        WindowInfoImpl info;
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(140);
        }
        if (type == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(141);
        }
        if ((info = this.getInfo(toolWindow.getId())).wasRead()) {
            return;
        }
        toolWindow.setContentUiType(type, null);
    }

    void stretchWidth(@NotNull ToolWindowImpl toolWindow, int value) {
        if (toolWindow == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(142);
        }
        this.myToolWindowsPane.stretchWidth(toolWindow, value);
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        if (wnd == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(143);
        }
        return this.myToolWindowsPane.isMaximized(wnd);
    }

    public void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
        if (wnd == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(144);
        }
        if (wnd.getType() == ToolWindowType.FLOATING && wnd instanceof ToolWindowImpl) {
            MaximizeActiveDialogAction.doMaximize(this.getFloatingDecorator(((ToolWindowImpl)wnd).getId()));
            return;
        }
        if (wnd.getType() == ToolWindowType.WINDOWED && wnd instanceof ToolWindowImpl) {
            Frame frame;
            WindowedDecorator decorator = this.getWindowedDecorator(((ToolWindowImpl)wnd).getId());
            Frame frame2 = frame = decorator != null && decorator.getFrame() instanceof Frame ? (Frame)decorator.getFrame() : null;
            if (frame != null) {
                int state = frame.getState();
                if (state == 0) {
                    frame.setState(6);
                } else if (state == 6) {
                    frame.setState(0);
                }
            }
            return;
        }
        this.myToolWindowsPane.setMaximized(wnd, maximized);
    }

    void stretchHeight(ToolWindowImpl toolWindow, int value) {
        this.myToolWindowsPane.stretchHeight(toolWindow, value);
    }

    @NotNull
    private static Rectangle getRootBounds(JFrame frame) {
        JRootPane rootPane = frame.getRootPane();
        Rectangle bounds = rootPane.getBounds();
        bounds.setLocation(frame.getX() + rootPane.getX(), frame.getY() + rootPane.getY());
        Rectangle rectangle = bounds;
        if (rectangle == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(145);
        }
        return rectangle;
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(146);
        }
        return actionCallback;
    }

    private void focusToolWindowByDefault(@Nullable String idToIgnore) {
        String toFocus = null;
        for (String each : this.myActiveStack.getStack()) {
            if (idToIgnore != null && idToIgnore.equalsIgnoreCase(each) || !this.getInfo(each).isVisible()) continue;
            toFocus = each;
            break;
        }
        if (toFocus == null) {
            for (String each : this.myActiveStack.getPersistentStack()) {
                if (idToIgnore != null && idToIgnore.equalsIgnoreCase(each) || !this.getInfo(each).isVisible()) continue;
                toFocus = each;
                break;
            }
        }
        if (toFocus != null && !ApplicationManager.getApplication().isDisposeInProgress() && !ApplicationManager.getApplication().isDisposed()) {
            this.activateToolWindow(toFocus, false, true);
        }
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(147);
        }
        ActionCallback actionCallback = IdeFocusManager.getInstance((Project)this.myProject).requestFocus(c, forced);
        if (actionCallback == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(148);
        }
        return actionCallback;
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(149);
        }
        IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(runnable2);
    }

    void setShowStripeButton(@NotNull String id, boolean visibleOnPanel) {
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(150);
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (visibleOnPanel == info.isShowStripeButton()) {
            return;
        }
        info.setShowStripeButton(visibleOnPanel);
        ToolWindowManagerImpl.triggerUsage("StripeButton[" + id + "]." + (visibleOnPanel ? "shown" : "hidden"));
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.appendApplyWindowInfoCmd(info, commandList);
        this.execute(commandList);
    }

    boolean isShowStripeButton(@NotNull String id) {
        WindowInfoImpl info;
        if (id == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(151);
        }
        return (info = this.getInfo(id)) == null || info.isShowStripeButton();
    }

    private static void triggerUsage(@NotNull String feature) {
        if (feature == null) {
            ToolWindowManagerImpl.$$$reportNull$$$0(152);
        }
        UsageTrigger.trigger(ConvertUsagesUtil.escapeDescriptorName(feature));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 24: 
            case 31: 
            case 40: 
            case 45: 
            case 50: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 69: 
            case 72: 
            case 76: 
            case 81: 
            case 90: 
            case 100: 
            case 145: 
            case 146: 
            case 148: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 24: 
            case 31: 
            case 40: 
            case 45: 
            case 50: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 69: 
            case 72: 
            case 76: 
            case 81: 
            case 90: 
            case 100: 
            case 145: 
            case 146: 
            case 148: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 24: 
            case 31: 
            case 40: 
            case 45: 
            case 50: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 69: 
            case 72: 
            case 76: 
            case 81: 
            case 90: 
            case 100: 
            case 145: 
            case 146: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 44: 
            case 49: 
            case 54: 
            case 64: 
            case 68: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 13: 
            case 14: 
            case 20: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandList";
                break;
            }
            case 15: 
            case 122: 
            case 125: 
            case 129: 
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: 
            case 23: 
            case 36: 
            case 97: 
            case 116: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandsList";
                break;
            }
            case 30: 
            case 39: 
            case 43: 
            case 48: 
            case 53: 
            case 57: 
            case 60: 
            case 63: 
            case 67: 
            case 71: 
            case 92: 
            case 94: 
            case 96: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 38: 
            case 42: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 80: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 82: 
            case 83: 
            case 86: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 84: 
            case 87: 
            case 103: 
            case 118: 
            case 120: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlBody";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 139: 
            case 140: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 143: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wnd";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivateToolWindowVKs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersVKs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitializingLabel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIds";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdsOn";
                break;
            }
            case 40: 
            case 45: 
            case 50: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 69: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "registerToolWindow";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "registerDisposable";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusManager";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowAnchor";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentUiType";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootBounds";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "requestDefaultFocus";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isToolWindowRegistered";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dispatchKeyEvent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 24: 
            case 31: 
            case 40: 
            case 45: 
            case 50: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 69: 
            case 72: 
            case 76: 
            case 81: 
            case 90: 
            case 100: 
            case 145: 
            case 146: 
            case 148: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addToolWindowManagerListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeToolWindowManagerListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deactivateWindows";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isToHideOnDeactivation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showAndActivate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "activateToolWindow";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "activateToolWindowImpl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkId";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deactivateToolWindowImpl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFloatingDecorator";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getWindowedDecorator";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getInternalDecorator";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getStripeButton";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getIdsOn";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "showToolWindow";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hideToolWindow";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showToolWindowImpl";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "registerToolWindow";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "registerDisposable";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "unregisterToolWindow";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "applyInfo";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "setLayout";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "canShowNotification";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "notifyByBalloon";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowAnchor";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowAnchor";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowAnchorImpl";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isSplitMode";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getContentUiType";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "setSideTool";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "setContentUiType";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "setSideToolAndAnchor";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "setSplitModeImpl";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowInternalType";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowType";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "fireToolWindowRegistered";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isToolWindowActive";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "isToolWindowAutoHide";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isToolWindowVisible";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowAutoHide";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowAutoHideImpl";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowType";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowTypeImpl";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "appendApplyWindowInfoCmd";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "appendAddDecoratorCmd";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "appendRemoveDecoratorCmd";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "appendRemoveFloatingDecoratorCmd";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "appendRemoveWindowedDecoratorCmd";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "appendAddButtonCmd";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "appendRemoveButtonCmd";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "appendSetEditorComponentCmd";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultState";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultContentUiType";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "stretchWidth";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isMaximized";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "setMaximized";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "doWhenFocusSettlesDown";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "setShowStripeButton";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "isShowStripeButton";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "triggerUsage";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifyByBalloon$16";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerDisposable$13";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 24: 
            case 31: 
            case 40: 
            case 45: 
            case 50: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 69: 
            case 72: 
            case 76: 
            case 81: 
            case 90: 
            case 100: 
            case 145: 
            case 146: 
            case 148: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InitToolWindowsActivity
    implements StartupActivity,
    DumbAware {
        public void runActivity(@NotNull Project project) {
            ToolWindowManagerEx ex;
            if (project == null) {
                InitToolWindowsActivity.$$$reportNull$$$0(0);
            }
            if ((ex = ToolWindowManagerEx.getInstanceEx(project)) instanceof ToolWindowManagerImpl) {
                ToolWindowManagerImpl manager = (ToolWindowManagerImpl)ex;
                ArrayList list2 = new ArrayList();
                manager.registerToolWindowsFromBeans(list2);
                manager.initAll(list2);
                EdtInvocationManager.getInstance().invokeLater(() -> {
                    manager.execute(list2);
                    manager.flushCommands();
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$InitToolWindowsActivity", "runActivity"));
        }
    }

    private final class MyInternalDecoratorListener
    implements InternalDecoratorListener {
        private MyInternalDecoratorListener() {
        }

        @Override
        public void anchorChanged(@NotNull InternalDecorator source, @NotNull ToolWindowAnchor anchor2) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(0);
            }
            if (anchor2 == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(1);
            }
            ToolWindowManagerImpl.this.setToolWindowAnchor(source.getToolWindow().getId(), anchor2);
        }

        @Override
        public void autoHideChanged(@NotNull InternalDecorator source, boolean autoHide) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(2);
            }
            ToolWindowManagerImpl.this.setToolWindowAutoHide(source.getToolWindow().getId(), autoHide);
        }

        @Override
        public void hidden(@NotNull InternalDecorator source) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(3);
            }
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), false);
        }

        @Override
        public void hiddenSide(@NotNull InternalDecorator source) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(4);
            }
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), true);
        }

        @Override
        public void contentUiTypeChanges(@NotNull InternalDecorator source, @NotNull ToolWindowContentUiType type) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(5);
            }
            if (type == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(6);
            }
            ToolWindowManagerImpl.this.setContentUiType(source.getToolWindow().getId(), type);
        }

        @Override
        public void resized(@NotNull InternalDecorator source) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(7);
            }
            if (!source.isShowing()) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(source.getToolWindow().getId());
            if (info.isFloating()) {
                Window owner = SwingUtilities.getWindowAncestor(source);
                if (owner != null) {
                    info.setFloatingBounds(owner.getBounds());
                }
            } else if (info.isWindowed()) {
                Window frame;
                WindowedDecorator decorator = ToolWindowManagerImpl.this.getWindowedDecorator(info.getId());
                Window window = frame = decorator != null ? decorator.getFrame() : null;
                if (frame == null || !frame.isShowing()) {
                    return;
                }
                info.setFloatingBounds(ToolWindowManagerImpl.getRootBounds((JFrame)frame));
            } else {
                ToolWindowAnchor anchor2 = info.getAnchor();
                InternalDecorator another = null;
                if (source.getParent() instanceof Splitter) {
                    float sizeInSplit = anchor2.isSplitVertically() ? (float)source.getHeight() : (float)source.getWidth();
                    Splitter splitter = (Splitter)source.getParent();
                    if (splitter.getSecondComponent() == source) {
                        sizeInSplit += (float)splitter.getDividerWidth();
                        another = (InternalDecorator)splitter.getFirstComponent();
                    } else {
                        another = (InternalDecorator)splitter.getSecondComponent();
                    }
                    if (anchor2.isSplitVertically()) {
                        info.setSideWeight(sizeInSplit / (float)splitter.getHeight());
                    } else {
                        info.setSideWeight(sizeInSplit / (float)splitter.getWidth());
                    }
                }
                float paneWeight = anchor2.isHorizontal() ? (float)source.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight() : (float)source.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                info.setWeight(paneWeight);
                if (another != null && anchor2.isSplitVertically()) {
                    paneWeight = anchor2.isHorizontal() ? (float)another.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight() : (float)another.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                    another.getWindowInfo().setWeight(paneWeight);
                }
            }
        }

        @Override
        public void activated(@NotNull InternalDecorator source) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(8);
            }
            ToolWindowManagerImpl.this.activateToolWindow(source.getToolWindow().getId(), true, true);
        }

        @Override
        public void typeChanged(@NotNull InternalDecorator source, @NotNull ToolWindowType type) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(9);
            }
            if (type == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(10);
            }
            ToolWindowManagerImpl.this.setToolWindowType(source.getToolWindow().getId(), type);
        }

        @Override
        public void sideStatusChanged(@NotNull InternalDecorator source, boolean isSideTool) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(11);
            }
            ToolWindowManagerImpl.this.setSideTool(source.getToolWindow().getId(), isSideTool);
        }

        @Override
        public void visibleStripeButtonChanged(@NotNull InternalDecorator source, boolean visible) {
            if (source == null) {
                MyInternalDecoratorListener.$$$reportNull$$$0(12);
            }
            ToolWindowManagerImpl.this.setShowStripeButton(source.getToolWindow().getId(), visible);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "anchorChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "autoHideChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hidden";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hiddenSide";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentUiTypeChanges";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resized";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "activated";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "typeChanged";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sideStatusChanged";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visibleStripeButtonChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyToolWindowPropertyChangeListener
    implements PropertyChangeListener {
        private MyToolWindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            StripeButton button;
            ToolWindowImpl toolWindow = (ToolWindowImpl)e.getSource();
            if ("available".equals(e.getPropertyName())) {
                WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(toolWindow.getId());
                if (!toolWindow.isAvailable() && info.isVisible()) {
                    ToolWindowManagerImpl.this.hideToolWindow(toolWindow.getId(), false);
                }
            }
            if ((button = (StripeButton)ToolWindowManagerImpl.this.myId2StripeButton.get(toolWindow.getId())) != null) {
                button.updatePresentation();
            }
            ActivateToolWindowAction.updateToolWindowActionPresentation(toolWindow);
        }
    }

    private final class ToolWindowFocusWatcher
    extends FocusWatcher {
        private final String myId;
        private final ToolWindowImpl myToolWindow;

        private ToolWindowFocusWatcher(ToolWindowImpl toolWindow) {
            if (toolWindow == null) {
                ToolWindowFocusWatcher.$$$reportNull$$$0(0);
            }
            this.myId = toolWindow.getId();
            this.install(toolWindow.getComponent());
            this.myToolWindow = toolWindow;
        }

        public void deinstall() {
            this.deinstall(this.myToolWindow.getComponent());
        }

        protected boolean isFocusedComponentChangeValid(Component comp, AWTEvent cause) {
            return ToolWindowManagerImpl.this.myCommandProcessor.getCommandCount() == 0 && comp != null;
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            if (ToolWindowManagerImpl.this.myCommandProcessor.getCommandCount() > 0 || component == null) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(this.myId);
            if (!info.isActive()) {
                ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new EdtRunnable(){

                    public void runEdt() {
                        WindowInfoImpl windowInfo = ToolWindowManagerImpl.this.myLayout.getInfo(ToolWindowFocusWatcher.this.myId, true);
                        if (windowInfo == null || !windowInfo.isVisible()) {
                            return;
                        }
                        ToolWindowManagerImpl.this.activateToolWindow(ToolWindowFocusWatcher.this.myId, false, false);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$ToolWindowFocusWatcher", "<init>"));
        }
    }

    private final class RemoveWindowedDecoratorCmd
    extends FinalizableCommand {
        private final WindowedDecorator myWindowedDecorator;

        private RemoveWindowedDecoratorCmd(WindowInfoImpl info) {
            if (info == null) {
                RemoveWindowedDecoratorCmd.$$$reportNull$$$0(0);
            }
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myWindowedDecorator = ToolWindowManagerImpl.this.getWindowedDecorator(info.getId());
            ToolWindowManagerImpl.this.myId2WindowedDecorator.remove(info.getId());
            Window frame = this.myWindowedDecorator.getFrame();
            if (!frame.isShowing()) {
                return;
            }
            Rectangle bounds = ToolWindowManagerImpl.getRootBounds((JFrame)frame);
            info.setFloatingBounds(bounds);
        }

        @Override
        public void run() {
            try {
                Disposer.dispose((Disposable)this.myWindowedDecorator);
            }
            finally {
                this.finish();
            }
        }

        @Override
        @NotNull
        public Condition getExpireCondition() {
            Condition condition = ApplicationManager.getApplication().getDisposed();
            if (condition == null) {
                RemoveWindowedDecoratorCmd.$$$reportNull$$$0(1);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$RemoveWindowedDecoratorCmd";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$RemoveWindowedDecoratorCmd";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpireCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class AddWindowedDecoratorCmd
    extends FinalizableCommand {
        private final WindowedDecorator myWindowedDecorator;

        private AddWindowedDecoratorCmd(@NotNull InternalDecorator decorator, WindowInfoImpl info) {
            if (decorator == null) {
                AddWindowedDecoratorCmd.$$$reportNull$$$0(0);
            }
            if (info == null) {
                AddWindowedDecoratorCmd.$$$reportNull$$$0(1);
            }
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myWindowedDecorator = new WindowedDecorator(ToolWindowManagerImpl.this.myProject, info.copy(), decorator);
            Window window = this.myWindowedDecorator.getFrame();
            Rectangle bounds = info.getFloatingBounds();
            if (bounds != null && bounds.width > 0 && bounds.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds.x, bounds.y, bounds.width)) {
                window.setBounds(new Rectangle(bounds));
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                window.setSize(size);
                window.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
            ToolWindowManagerImpl.this.myId2WindowedDecorator.put(info.getId(), this.myWindowedDecorator);
            this.myWindowedDecorator.addDisposable(() -> {
                if (info == null) {
                    AddWindowedDecoratorCmd.$$$reportNull$$$0(2);
                }
                if (ToolWindowManagerImpl.this.myId2WindowedDecorator.get(info.getId()) != null) {
                    ToolWindowManagerImpl.this.hideToolWindow(info.getId(), false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.myWindowedDecorator.show(false);
                Window window = this.myWindowedDecorator.getFrame();
                JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                Rectangle rootPaneBounds = rootPane.getBounds();
                Point point = rootPane.getLocationOnScreen();
                Rectangle windowBounds = window.getBounds();
                window.setLocation(2 * windowBounds.x - point.x, 2 * windowBounds.y - point.y);
                window.setSize(2 * windowBounds.width - rootPaneBounds.width, 2 * windowBounds.height - rootPaneBounds.height);
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decorator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$AddWindowedDecoratorCmd";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private RemoveFloatingDecoratorCmd(WindowInfoImpl info) {
            if (info == null) {
                RemoveFloatingDecoratorCmd.$$$reportNull$$$0(0);
            }
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myFloatingDecorator = ToolWindowManagerImpl.this.getFloatingDecorator(info.getId());
            ToolWindowManagerImpl.this.myId2FloatingDecorator.remove(info.getId());
            info.setFloatingBounds(this.myFloatingDecorator.getBounds());
        }

        @Override
        public void run() {
            try {
                this.myFloatingDecorator.dispose();
            }
            finally {
                this.finish();
            }
        }

        @Override
        @NotNull
        public Condition getExpireCondition() {
            Condition condition = ApplicationManager.getApplication().getDisposed();
            if (condition == null) {
                RemoveFloatingDecoratorCmd.$$$reportNull$$$0(1);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$RemoveFloatingDecoratorCmd";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$RemoveFloatingDecoratorCmd";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpireCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class AddFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private AddFloatingDecoratorCmd(@NotNull InternalDecorator decorator, WindowInfoImpl info) {
            if (decorator == null) {
                AddFloatingDecoratorCmd.$$$reportNull$$$0(0);
            }
            if (info == null) {
                AddFloatingDecoratorCmd.$$$reportNull$$$0(1);
            }
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myFloatingDecorator = new FloatingDecorator(ToolWindowManagerImpl.this.myFrame, info.copy(), decorator);
            ToolWindowManagerImpl.this.myId2FloatingDecorator.put(info.getId(), this.myFloatingDecorator);
            Rectangle bounds = info.getFloatingBounds();
            if (bounds != null && bounds.width > 0 && bounds.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds.x, bounds.y, bounds.width)) {
                this.myFloatingDecorator.setBounds(new Rectangle(bounds));
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                this.myFloatingDecorator.setSize(size);
                this.myFloatingDecorator.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
        }

        @Override
        public void run() {
            try {
                this.myFloatingDecorator.show();
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "decorator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$AddFloatingDecoratorCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BalloonHyperlinkListener
    implements HyperlinkListener {
        private Balloon myBalloon;
        private final HyperlinkListener myListener;

        BalloonHyperlinkListener(HyperlinkListener listener2) {
            this.myListener = listener2;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (this.myBalloon != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.myBalloon.hide();
            }
            if (this.myListener != null) {
                this.myListener.hyperlinkUpdate(e);
            }
        }
    }

    private static enum KeyState {
        waiting,
        pressed,
        released,
        hold;

    }
}

