/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalStarter;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.RegionPainter;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.hyperlinks.HyperlinkFilter;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.model.hyperlinks.LinkResult;
import com.jediterm.terminal.model.hyperlinks.LinkResultItem;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class JBTerminalWidget
extends JediTermWidget
implements Disposable {
    private final Project myProject;
    private final JBTerminalSystemSettingsProviderBase mySettingsProvider;

    public JBTerminalWidget(Project project, JBTerminalSystemSettingsProviderBase settingsProvider, Disposable parent) {
        this(project, 80, 24, settingsProvider, parent);
    }

    public JBTerminalWidget(Project project, int columns, int lines2, JBTerminalSystemSettingsProviderBase settingsProvider, Disposable parent) {
        super(columns, lines2, (SettingsProvider)settingsProvider);
        this.myProject = project;
        this.mySettingsProvider = settingsProvider;
        this.setName("terminal");
        Disposer.register((Disposable)parent, (Disposable)this);
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])ConsoleFilterProvider.FILTER_PROVIDERS.getExtensions()) {
            for (Filter filter2 : eachProvider.getDefaultFilters(project)) {
                this.addMessageFilter(project, filter2);
            }
        }
    }

    protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(0);
        }
        if (styleState == null) {
            JBTerminalWidget.$$$reportNull$$$0(1);
        }
        if (textBuffer == null) {
            JBTerminalWidget.$$$reportNull$$$0(2);
        }
        JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState);
        Disposer.register((Disposable)this, (Disposable)panel2);
        return panel2;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
        return new JBTerminalStarter((Terminal)terminal, connector);
    }

    protected JScrollBar createScrollBar() {
        final JBScrollBar bar = new JBScrollBar();
        bar.putClientProperty(JBScrollPane.Alignment.class, (Object)JBScrollPane.Alignment.RIGHT);
        bar.putClientProperty((Object)JBScrollBar.TRACK, (Object)new RegionPainter<Object>(){

            public void paint(Graphics2D g, int x, int y, int width, int height, Object object) {
                SubstringFinder.FindResult result2 = JBTerminalWidget.this.myTerminalPanel.getFindResult();
                if (result2 != null) {
                    int modelHeight = bar.getModel().getMaximum() - bar.getModel().getMinimum();
                    int anchorHeight = Math.max(2, height / modelHeight);
                    Color color = JBTerminalWidget.this.mySettingsProvider.getTerminalColorPalette().getColor(JBTerminalWidget.this.mySettingsProvider.getFoundPatternColor().getBackground());
                    g.setColor(color);
                    for (SubstringFinder.FindResult.FindItem r : result2.getItems()) {
                        int where = height * r.getStart().y / modelHeight;
                        g.fillRect(x, y + where, width, anchorHeight);
                    }
                }
            }
        });
        return bar;
    }

    public List<TerminalAction> getActions() {
        List actions = super.getActions();
        if (!this.mySettingsProvider.overrideIdeShortcuts()) {
            actions.add(new TerminalAction("EditorEscape", new KeyStroke[]{KeyStroke.getKeyStroke(27, 0)}, input -> {
                if (!this.myTerminalPanel.getTerminalTextBuffer().isUsingAlternateBuffer()) {
                    ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
                    return true;
                }
                return false;
            }).withHidden(true));
        }
        return actions;
    }

    public void dispose() {
    }

    protected JediTermWidget.SearchComponent createSearchComponent() {
        return new JediTermWidget.SearchComponent(){
            private final SearchTextField myTextField = new SearchTextField(false);

            public String getText() {
                return this.myTextField.getText();
            }

            public JComponent getComponent() {
                this.myTextField.setOpaque(false);
                return this.myTextField;
            }

            public void addDocumentChangeListener(DocumentListener listener2) {
                this.myTextField.addDocumentListener(listener2);
            }

            public void addKeyListener(KeyListener listener2) {
                this.myTextField.addKeyboardListener(listener2);
            }

            public void onResultUpdated(SubstringFinder.FindResult result2) {
            }

            public void nextFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }

            public void prevFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }
        };
    }

    public void addMessageFilter(final Project project, final Filter filter2) {
        this.addHyperlinkFilter(new HyperlinkFilter(){

            public LinkResult apply(String line) {
                Filter.Result r = filter2.applyFilter(line, line.length());
                if (r != null) {
                    return new LinkResult(r.getResultItems().stream().map(item -> new LinkResultItem(item.getHighlightStartOffset(), item.getHighlightEndOffset(), new LinkInfo(() -> item.getHyperlinkInfo().navigate(project)))).collect(Collectors.toList()));
                }
                return null;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settingsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "styleState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "textBuffer";
                break;
            }
        }
        objectArray[1] = "com/intellij/terminal/JBTerminalWidget";
        objectArray[2] = "createTerminalPanel";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

