/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.content.impl.ContentManagerImpl");
    private ContentUI myUI;
    private final List<Content> myContents;
    private final EventDispatcher<ContentManagerListener> myDispatcher;
    private final List<Content> mySelection;
    private final boolean myCanCloseContents;
    private MyNonOpaquePanel myComponent;
    private final Set<Content> myContentWithChangedComponent;
    private boolean myDisposed;
    private final Project myProject;
    private final List<DataProvider> dataProviders;
    private ArrayList<Content> mySelectionHistory;

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project) {
        if (contentUI == null) {
            ContentManagerImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ContentManagerImpl.$$$reportNull$$$0(1);
        }
        this.myContents = new ArrayList<Content>();
        this.myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        this.mySelection = new ArrayList<Content>();
        this.myContentWithChangedComponent = new HashSet<Content>();
        this.dataProviders = new SmartList();
        this.mySelectionHistory = new ArrayList();
        this.myProject = project;
        this.myCanCloseContents = canCloseContents;
        this.myUI = contentUI;
        this.myUI.setManager((ContentManager)this);
        Disposer.register((Disposable)project, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)contentUI);
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyNonOpaquePanel();
            NonOpaquePanel contentComponent = new NonOpaquePanel();
            contentComponent.setContent(this.myUI.getComponent());
            this.myComponent.add((Component)contentComponent, "Center");
        }
        MyNonOpaquePanel myNonOpaquePanel = this.myComponent;
        if (myNonOpaquePanel == null) {
            ContentManagerImpl.$$$reportNull$$$0(2);
        }
        return myNonOpaquePanel;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        Content selected;
        if (requestor == null) {
            ContentManagerImpl.$$$reportNull$$$0(3);
        }
        if ((selected = this.getSelectedContent()) == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }
        BusyObject busyObject = selected.getBusyObject();
        ActionCallback actionCallback = busyObject != null ? busyObject.getReady(requestor) : ActionCallback.DONE;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(5);
        }
        return actionCallback;
    }

    public void addContent(@NotNull Content content, int order) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(6);
        }
        this.doAddContent(content, order);
    }

    public void addContent(@NotNull Content content) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(7);
        }
        this.doAddContent(content, -1);
    }

    public void addContent(@NotNull Content content, Object constraints) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(8);
        }
        this.doAddContent(content, -1);
    }

    private void doAddContent(@NotNull Content content, int index) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContents.contains(content)) {
            this.myContents.remove(content);
            this.myContents.add(index == -1 ? this.myContents.size() : index, content);
            return;
        }
        ((ContentImpl)content).setManager(this);
        int insertIndex = index == -1 ? this.myContents.size() : index;
        this.myContents.add(insertIndex, content);
        content.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content, insertIndex);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content);
            } else {
                this.addSelectedContent(content);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content);
    }

    public boolean removeContent(@NotNull Content content, boolean dispose2) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(10);
        }
        return this.removeContent(content, true, dispose2).isDone();
    }

    @NotNull
    public ActionCallback removeContent(@NotNull Content content, boolean dispose2, boolean trackFocus, boolean forcedFocus) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(11);
        }
        ActionCallback result2 = new ActionCallback();
        this.removeContent(content, true, dispose2).doWhenDone(() -> {
            if (trackFocus) {
                Content current = this.getSelectedContent();
                if (current != null) {
                    this.setSelectedContent(current, true, true, !forcedFocus).notify(result2);
                } else {
                    result2.setDone();
                }
            } else {
                result2.setDone();
            }
        });
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(12);
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ActionCallback removeContent(@NotNull Content content, boolean trackSelection, boolean dispose2) {
        block28: {
            block27: {
                int newSize;
                int indexToSelect;
                int indexToBeRemoved;
                block26: {
                    int selectedIndex;
                    block25: {
                        if (content == null) {
                            ContentManagerImpl.$$$reportNull$$$0(13);
                        }
                        ApplicationManager.getApplication().assertIsDispatchThread();
                        indexToBeRemoved = this.getIndexOfContent(content);
                        if (indexToBeRemoved == -1) {
                            ActionCallback actionCallback = ActionCallback.REJECTED;
                            if (actionCallback == null) {
                                ContentManagerImpl.$$$reportNull$$$0(14);
                            }
                            return actionCallback;
                        }
                        Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
                        int n = selectedIndex = selection != null ? this.myContents.indexOf(selection) : -1;
                        if (!this.fireContentRemoveQuery(content, indexToBeRemoved, ContentManagerEvent.ContentOperation.undefined)) {
                            ActionCallback actionCallback = ActionCallback.REJECTED;
                            ActionCallback actionCallback2 = actionCallback;
                            if (actionCallback2 == null) {
                                ContentManagerImpl.$$$reportNull$$$0(15);
                            }
                            return actionCallback2;
                        }
                        if (!content.isValid()) {
                            ActionCallback actionCallback = ActionCallback.REJECTED;
                            ActionCallback actionCallback3 = actionCallback;
                            if (actionCallback3 == null) {
                                ContentManagerImpl.$$$reportNull$$$0(16);
                            }
                            return actionCallback3;
                        }
                        boolean wasSelected = this.isSelected(content);
                        if (wasSelected) {
                            this.removeFromSelection(content);
                        }
                        indexToSelect = -1;
                        if (!wasSelected) break block25;
                        int i = indexToBeRemoved - 1;
                        if (i >= 0) {
                            indexToSelect = i;
                            break block26;
                        } else if (this.getContentCount() > 1) {
                            indexToSelect = 0;
                        }
                        break block26;
                    }
                    if (selectedIndex > indexToBeRemoved) {
                        indexToSelect = selectedIndex - 1;
                    }
                }
                this.mySelectionHistory.remove(content);
                this.myContents.remove(content);
                content.removePropertyChangeListener((PropertyChangeListener)this);
                this.fireContentRemoved(content, indexToBeRemoved);
                ((ContentImpl)content).setManager(null);
                if (dispose2) {
                    Disposer.dispose((Disposable)content);
                }
                if ((newSize = this.myContents.size()) <= 0 || !trackSelection) break block27;
                if (indexToSelect > -1) {
                    Content toSelect2;
                    Content content2 = toSelect2 = this.mySelectionHistory.size() > 0 ? this.mySelectionHistory.get(0) : this.myContents.get(indexToSelect);
                    if (!this.isSelected(toSelect2)) {
                        if (this.myUI.isSingleSelection()) {
                            ActionCallback result2 = new ActionCallback();
                            this.setSelectedContentCB(toSelect2).notify(result2);
                            ActionCallback actionCallback = result2;
                            ActionCallback actionCallback4 = actionCallback;
                            if (actionCallback4 == null) {
                                ContentManagerImpl.$$$reportNull$$$0(17);
                            }
                            return actionCallback4;
                        }
                        this.addSelectedContent(toSelect2);
                    }
                }
                break block28;
            }
            this.mySelection.clear();
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        ActionCallback actionCallback5 = actionCallback;
        if (actionCallback5 == null) {
            ContentManagerImpl.$$$reportNull$$$0(18);
        }
        return actionCallback5;
        finally {
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myDisposed) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose2) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            this.removeContent(content, dispose2);
        }
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    @NotNull
    public Content[] getContents() {
        Content[] contentArray = this.myContents.toArray(new Content[0]);
        if (contentArray == null) {
            ContentManagerImpl.$$$reportNull$$$0(19);
        }
        return contentArray;
    }

    public Content findContent(String displayName) {
        for (Content content : this.myContents) {
            if (!content.getDisplayName().equals(displayName)) continue;
            return content;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.myContents.size() ? this.myContents.get(index) : null;
    }

    public Content getContent(JComponent component) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            if (!Comparing.equal((Object)component, (Object)content.getComponent())) continue;
            return content;
        }
        return null;
    }

    public int getIndexOfContent(Content content) {
        return this.myContents.indexOf(content);
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.myUI.getCloseActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.myUI.getCloseAllButThisActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.myUI.getPreviousContentActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.myUI.getNextContentActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    public List<AnAction> getAdditionalPopupActions(@NotNull Content content) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(24);
        }
        return null;
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content : this.myContents) {
            if (!content.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(25);
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, false)) {
            return;
        }
        if (this.getIndexOfContent(content) == -1) {
            throw new IllegalArgumentException("content not found: " + content);
        }
        if (!this.isSelected(content)) {
            this.mySelection.add(content);
            this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(Content content, boolean implicit) {
        if (!this.myUI.canChangeSelectionTo(content, implicit)) {
            return false;
        }
        boolean result2 = !this.isSelected(content) || this.myContentWithChangedComponent.contains(content);
        this.myContentWithChangedComponent.remove(content);
        return result2;
    }

    public void removeFromSelection(@NotNull Content content) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(26);
        }
        if (!this.isSelected(content)) {
            return;
        }
        this.mySelection.remove(content);
        this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(27);
        }
        return this.mySelection.contains(content);
    }

    @NotNull
    public Content[] getSelectedContents() {
        Content[] contentArray = this.mySelection.toArray(new Content[0]);
        if (contentArray == null) {
            ContentManagerImpl.$$$reportNull$$$0(28);
        }
        return contentArray;
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(29);
        }
        this.setSelectedContentCB(content, requestFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(30);
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content, requestFocus, true);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(31);
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(32);
        }
        this.setSelectedContentCB(content, requestFocus, forcedFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(33);
        }
        ActionCallback actionCallback = this.setSelectedContent(content, requestFocus, forcedFocus, false);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(34);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback setSelectedContent(final @NotNull Content content, final boolean requestFocus, boolean forcedFocus, boolean implicit) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(35);
        }
        this.mySelectionHistory.remove(content);
        this.mySelectionHistory.add(0, content);
        if (this.isSelected(content) && requestFocus) {
            ActionCallback actionCallback = this.requestFocus(content, forcedFocus);
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(36);
            }
            return actionCallback;
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, implicit)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(37);
            }
            return actionCallback;
        }
        if (!this.myContents.contains(content)) {
            throw new IllegalArgumentException("Cannot find content:" + content.getDisplayName());
        }
        boolean focused = this.isSelectionHoldsFocus();
        final Content[] old = this.getSelectedContents();
        ActiveRunnable selection = new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                if (ContentManagerImpl.this.myDisposed || ContentManagerImpl.this.getIndexOfContent(content) == -1) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actionCallback;
                }
                for (Content each : old) {
                    ContentManagerImpl.this.removeFromSelection(each);
                }
                ContentManagerImpl.this.addSelectedContent(content);
                if (requestFocus) {
                    content.getComponent().transferFocus();
                }
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$1", "run"));
            }
        };
        ActionCallback result2 = new ActionCallback();
        boolean enabledFocus = this.getFocusManager().isFocusTransferEnabled();
        if ((focused || requestFocus) && enabledFocus) {
            ActionCallback actionCallback = this.getFocusManager().requestFocus((Component)((Object)this.myComponent), true).doWhenProcessed(() -> selection.run().notify(result2));
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(38);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = selection.run().notify(result2);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(39);
        }
        return actionCallback;
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!UIUtil.isFocusAncestor((JComponent)each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(40);
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content, false);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(41);
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(42);
        }
        this.setSelectedContentCB(content);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            ContentManagerImpl.$$$reportNull$$$0(43);
        }
        this.myDispatcher.getListeners().add(0, l);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            ContentManagerImpl.$$$reportNull$$$0(44);
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireContentAdded(@NotNull Content content, int newIndex) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(45);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, newIndex, ContentManagerEvent.ContentOperation.add);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
    }

    private void fireContentRemoved(@NotNull Content content, int oldIndex) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(46);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, oldIndex, ContentManagerEvent.ContentOperation.remove);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
    }

    private void fireSelectionChanged(@NotNull Content content, ContentManagerEvent.ContentOperation operation) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(47);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.getIndexOfContent(content), operation);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
    }

    private boolean fireContentRemoveQuery(@NotNull Content content, int oldIndex, ContentManagerEvent.ContentOperation operation) {
        if (content == null) {
            ContentManagerImpl.$$$reportNull$$$0(48);
        }
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, oldIndex, operation);
        for (ContentManagerListener listener2 : this.myDispatcher.getListeners()) {
            listener2.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ActionCallback requestFocus(Content content, boolean forced) {
        Content toSelect2;
        Content content2 = toSelect2 = content == null ? this.getSelectedContent() : content;
        if (toSelect2 == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(49);
            }
            return actionCallback;
        }
        assert (this.myContents.contains(toSelect2));
        JComponent preferredFocusableComponent = toSelect2.getPreferredFocusableComponent();
        ActionCallback actionCallback = preferredFocusableComponent != null ? this.getFocusManager().requestFocusInProject((Component)preferredFocusableComponent, this.myProject) : ActionCallback.REJECTED;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(50);
        }
        return actionCallback;
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    private static ActionCallback doRequestFocus(Content toSelect2) {
        JComponent toFocus = ContentManagerImpl.computeWillFocusComponent(toSelect2);
        if (toFocus != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)toFocus, true));
        }
        return ActionCallback.DONE;
    }

    private static JComponent computeWillFocusComponent(Content toSelect2) {
        JComponent toFocus = toSelect2.getPreferredFocusableComponent();
        if (toFocus != null) {
            toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(toFocus);
        }
        if (toFocus == null) {
            toFocus = toSelect2.getPreferredFocusableComponent();
        }
        return toFocus;
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            ContentManagerImpl.$$$reportNull$$$0(51);
        }
        this.dataProviders.add(provider);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            ContentManagerImpl.$$$reportNull$$$0(52);
        }
        if ("component".equals(event.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)event.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        if (contentFactory == null) {
            ContentManagerImpl.$$$reportNull$$$0(53);
        }
        return contentFactory;
    }

    public void beforeTreeDispose() {
        this.myUI.beforeDispose();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myContents.clear();
        this.mySelection.clear();
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myDispatcher.getListeners().clear();
        this.dataProviders.clear();
        this.myComponent = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 49: 
            case 50: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 49: 
            case 50: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentUI";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 49: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/content/impl/ContentManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 40: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/content/impl/ContentManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "removeContent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseActionName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseAllButThisActionName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousContentActionName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextContentActionName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedContents";
                break;
            }
            case 31: 
            case 34: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectedContentCB";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectedContent";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 49: 
            case 50: 
            case 53: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doAddContent";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeContent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupActions";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addSelectedContent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeFromSelection";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 29: 
            case 32: 
            case 35: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContent";
                break;
            }
            case 30: 
            case 33: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContentCB";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addContentManagerListener";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removeContentManagerListener";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fireContentAdded";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "fireContentRemoved";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "fireSelectionChanged";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "fireContentRemoveQuery";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addDataProvider";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 49: 
            case 50: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyNonOpaquePanel
    extends NonOpaquePanel
    implements DataProvider {
        public MyNonOpaquePanel() {
            super((LayoutManager)new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.CONTENT_MANAGER.is(dataId) || PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && ContentManagerImpl.this.getContentCount() > 1) {
                return ContentManagerImpl.this;
            }
            for (DataProvider dataProvider : ContentManagerImpl.this.dataProviders) {
                Object data = dataProvider.getData(dataId);
                if (data == null) continue;
                return data;
            }
            if (ContentManagerImpl.this.myUI instanceof DataProvider) {
                return ((DataProvider)ContentManagerImpl.this.myUI).getData(dataId);
            }
            DataProvider provider = DataManager.getDataProvider((JComponent)((Object)this));
            return provider == null ? null : provider.getData(dataId);
        }
    }
}

