/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.BalloonPopupBuilderImpl;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.mock.MockConfirmation;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupFactoryImpl
extends JBPopupFactory {
    public static final Key<VisualPosition> ANCHOR_POPUP_POSITION = Key.create((String)"popup.anchor.position");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupFactoryImpl");
    private final Map<Disposable, List<Balloon>> myStorage = ContainerUtil.createWeakMap();

    @NotNull
    public ListPopup createConfirmation(String title, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), onYes, defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(0);
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createConfirmation(String title, String yesText, String noText, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, yesText, noText, onYes, EmptyRunnable.getInstance(), defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(1);
        }
        return listPopup;
    }

    @NotNull
    public JBPopup createMessage(String text) {
        ListPopup listPopup = this.createListPopup((ListPopupStep)new BaseListPopupStep(null, (Object[])new String[]{text}));
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    public Balloon getParentBalloonFor(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            Object balloon;
            if (!(eachParent instanceof JComponent) || !((balloon = ((JComponent)eachParent).getClientProperty("Balloon.property")) instanceof Balloon)) continue;
            return (Balloon)balloon;
        }
        return null;
    }

    @NotNull
    public ListPopup createConfirmation(String title, final String yesText, String noText, final Runnable onYes, final Runnable onNo, int defaultOptionIndex) {
        BaseListPopupStep<String> step = new BaseListPopupStep<String>(title, new String[]{yesText, noText}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(selectedValue.equals(yesText) ? onYes : onNo);
            }

            public void canceled() {
                onNo.run();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step.setDefaultOptionIndex(defaultOptionIndex);
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        ListPopupImpl listPopupImpl = app == null || !app.isUnitTestMode() ? new ListPopupImpl((ListPopupStep)step) : new MockConfirmation((ListPopupStep)step, yesText);
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(3);
        }
        return listPopupImpl;
    }

    private static ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(5);
        }
        return PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, null, null);
    }

    public ListPopup createActionGroupPopup(String title, ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount) {
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(6);
        }
        return this.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, null);
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid aid, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(8);
        }
        ActionGroupPopup actionGroupPopup = new ActionGroupPopup(title, actionGroup, dataContext, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING || aid == JBPopupFactory.ActionSelectionAid.NUMBERING, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, aid == JBPopupFactory.ActionSelectionAid.MNEMONICS, disposeCallback, maxRowCount, preselectActionCondition, actionPlace);
        if (actionGroupPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(9);
        }
        return actionGroupPopup;
    }

    private static ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(10);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(11);
        }
        return new ActionGroupPopup(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace);
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(12);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(13);
        }
        ListPopup listPopup = PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, true, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, null);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(14);
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid selectionAidMethod, boolean showDisabledActions) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(15);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(16);
        }
        ListPopup listPopup = PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod == JBPopupFactory.ActionSelectionAid.NUMBERING || selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, selectionAidMethod == JBPopupFactory.ActionSelectionAid.MNEMONICS, null, -1);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(17);
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid selectionAidMethod, boolean showDisabledActions, @Nullable String actionPlace) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(18);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(19);
        }
        ListPopup listPopup = this.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod, showDisabledActions, null, -1, null, actionPlace);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(20);
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid selectionAidMethod, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(21);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(22);
        }
        ListPopup listPopup = this.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod, showDisabledActions, disposeCallback, maxRowCount, null, null);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(23);
        }
        return listPopup;
    }

    @NotNull
    public ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(24);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(25);
        }
        ListPopupStep listPopupStep = this.createActionsStep(actionGroup, dataContext, showNumbers, showDisabledActions, title, component, honorActionMnemonics, 0, false);
        if (listPopupStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(26);
        }
        return listPopupStep;
    }

    private static ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(27);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(28);
        }
        List<ActionItem> items = PopupFactoryImpl.makeActionItemsFromActionGroup(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        return new ActionPopupStep(items, title, component, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), (Condition<AnAction>)((Condition)action -> defaultOptionIndex >= 0 && defaultOptionIndex < items.size() && ((ActionItem)items.get(defaultOptionIndex)).getAction().equals(action)), autoSelectionEnabled, showDisabledActions);
    }

    @NotNull
    private static List<ActionItem> makeActionItemsFromActionGroup(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(29);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(30);
        }
        ActionStepBuilder builder = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        builder.buildGroup(actionGroup);
        List<ActionItem> list2 = builder.getItems();
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @NotNull
    private static ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, Condition<AnAction> preselectActionCondition, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(32);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(33);
        }
        List<ActionItem> items = PopupFactoryImpl.makeActionItemsFromActionGroup(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        ActionPopupStep actionPopupStep = new ActionPopupStep(items, title, component, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), preselectActionCondition, autoSelectionEnabled, showDisabledActions);
        if (actionPopupStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(34);
        }
        return actionPopupStep;
    }

    @NotNull
    public ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(35);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(36);
        }
        ListPopupStep listPopupStep = PopupFactoryImpl.createActionsStep(actionGroup, dataContext, showNumbers, true, showDisabledActions, title, component, honorActionMnemonics, defaultOptionIndex, autoSelectionEnabled);
        if (listPopupStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(37);
        }
        return listPopupStep;
    }

    private static boolean itemsHaveMnemonics(List<ActionItem> items) {
        for (ActionItem item : items) {
            if (item.getAction().getTemplatePresentation().getMnemonic() == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ListPopup createWizardStep(@NotNull PopupStep step) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(38);
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl((ListPopupStep)step);
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(39);
        }
        return listPopupImpl;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(40);
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl(step);
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(41);
        }
        return listPopupImpl;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step, int maxRowCount) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(42);
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl(step, maxRowCount);
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(43);
        }
        return listPopupImpl;
    }

    @NotNull
    public TreePopup createTree(JBPopup parent, @NotNull TreePopupStep aStep, Object parentValue) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(44);
        }
        TreePopupImpl treePopupImpl = new TreePopupImpl(parent, aStep, parentValue);
        if (treePopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(45);
        }
        return treePopupImpl;
    }

    @NotNull
    public TreePopup createTree(@NotNull TreePopupStep aStep) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(46);
        }
        TreePopupImpl treePopupImpl = new TreePopupImpl(aStep);
        if (treePopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(47);
        }
        return treePopupImpl;
    }

    @NotNull
    public ComponentPopupBuilder createComponentPopupBuilder(@NotNull JComponent content, JComponent prefferableFocusComponent) {
        if (content == null) {
            PopupFactoryImpl.$$$reportNull$$$0(48);
        }
        ComponentPopupBuilderImpl componentPopupBuilderImpl = new ComponentPopupBuilderImpl(content, prefferableFocusComponent);
        if (componentPopupBuilderImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(49);
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull DataContext dataContext) {
        Point point;
        Component component;
        JComponent focusOwner;
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(50);
        }
        JComponent jComponent = focusOwner = (component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext)) instanceof JComponent ? (JComponent)component : null;
        if (focusOwner == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            IdeFrameImpl frame = project == null ? null : ((WindowManagerEx)WindowManager.getInstance()).getFrame(project);
            JComponent jComponent2 = focusOwner = frame == null ? null : frame.getRootPane();
            if (focusOwner == null) {
                throw new IllegalArgumentException("focusOwner cannot be null");
            }
        }
        if ((point = (Point)PlatformDataKeys.CONTEXT_MENU_POINT.getData(dataContext)) != null) {
            RelativePoint relativePoint = new RelativePoint((Component)focusOwner, point);
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(51);
            }
            return relativePoint;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && focusOwner == editor.getContentComponent()) {
            RelativePoint relativePoint = this.guessBestPopupLocation(editor);
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(52);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = this.guessBestPopupLocation(focusOwner);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(53);
        }
        return relativePoint;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull JComponent component) {
        if (component == null) {
            PopupFactoryImpl.$$$reportNull$$$0(54);
        }
        Point popupMenuPoint = null;
        Rectangle visibleRect = component.getVisibleRect();
        if (component instanceof JList) {
            int[] selectedIndices;
            JList list2 = (JList)component;
            int firstVisibleIndex = list2.getFirstVisibleIndex();
            int lastVisibleIndex = list2.getLastVisibleIndex();
            for (int index : selectedIndices = list2.getSelectedIndices()) {
                if (firstVisibleIndex > index || index > lastVisibleIndex) continue;
                Rectangle cellBounds = list2.getCellBounds(index, index);
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height);
                break;
            }
        } else if (component instanceof JTree) {
            JTree tree = (JTree)component;
            int[] selectionRows = tree.getSelectionRows();
            if (selectionRows != null) {
                Arrays.sort(selectionRows);
                for (int row : selectionRows) {
                    Rectangle rowBounds = tree.getRowBounds(row);
                    if (!visibleRect.contains(rowBounds)) continue;
                    popupMenuPoint = new Point(rowBounds.x + 2, rowBounds.y + rowBounds.height - 1);
                    break;
                }
                if (popupMenuPoint == null) {
                    Point visibleCenter = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
                    double minDistance = Double.POSITIVE_INFINITY;
                    int bestRow = -1;
                    for (int row : selectionRows) {
                        Rectangle rowBounds = tree.getRowBounds(row);
                        Point rowCenter = new Point(rowBounds.x + rowBounds.width / 2, rowBounds.y + rowBounds.height / 2);
                        double distance = visibleCenter.distance(rowCenter);
                        if (!(minDistance > distance)) continue;
                        minDistance = distance;
                        bestRow = row;
                    }
                    if (bestRow != -1) {
                        Rectangle rowBounds = tree.getRowBounds(bestRow);
                        tree.scrollRectToVisible(new Rectangle(rowBounds.x, rowBounds.y, Math.min(visibleRect.width, rowBounds.width), rowBounds.height));
                        popupMenuPoint = new Point(rowBounds.x + 2, rowBounds.y + rowBounds.height - 1);
                    }
                }
            }
        } else if (component instanceof JTable) {
            JTable table = (JTable)component;
            int column = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int row = Math.max(table.getSelectionModel().getLeadSelectionIndex(), table.getSelectionModel().getAnchorSelectionIndex());
            Rectangle rect = table.getCellRect(row, column, false);
            if (!visibleRect.intersects(rect)) {
                table.scrollRectToVisible(rect);
            }
            popupMenuPoint = new Point(rect.x, rect.y + rect.height);
        } else if (component instanceof PopupOwner) {
            popupMenuPoint = ((PopupOwner)((Object)component)).getBestPopupPosition();
        }
        if (popupMenuPoint == null) {
            popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        }
        RelativePoint relativePoint = new RelativePoint((Component)component, popupMenuPoint);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(55);
        }
        return relativePoint;
    }

    public boolean isBestPopupLocationVisible(@NotNull Editor editor) {
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(56);
        }
        return PopupFactoryImpl.getVisibleBestPopupLocation(editor) != null;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull Editor editor) {
        Point p;
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(57);
        }
        if ((p = PopupFactoryImpl.getVisibleBestPopupLocation(editor)) == null) {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            p = new Point(visibleArea.x + visibleArea.width / 3, visibleArea.y + visibleArea.height / 2);
        }
        RelativePoint relativePoint = new RelativePoint((Component)editor.getContentComponent(), p);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(58);
        }
        return relativePoint;
    }

    @Nullable
    private static Point getVisibleBestPopupLocation(@NotNull Editor editor) {
        VisualPosition visualPosition;
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(59);
        }
        if ((visualPosition = (VisualPosition)editor.getUserData(ANCHOR_POPUP_POSITION)) == null) {
            CaretModel caretModel = editor.getCaretModel();
            visualPosition = caretModel.isUpToDate() ? caretModel.getVisualPosition() : editor.offsetToVisualPosition(caretModel.getOffset());
        }
        int lineHeight = editor.getLineHeight();
        Point p = editor.visualPositionToXY(visualPosition);
        p.y += lineHeight;
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        return !visibleArea.contains(p) && !visibleArea.contains(p.x, p.y - lineHeight) ? null : p;
    }

    public Point getCenterOf(JComponent container, JComponent content) {
        return AbstractPopup.getCenterOf((Component)container, content);
    }

    @NotNull
    public List<JBPopup> getChildPopups(@NotNull Component component) {
        if (component == null) {
            PopupFactoryImpl.$$$reportNull$$$0(60);
        }
        List<JBPopup> list2 = AbstractPopup.all.toStrongList().stream().filter(popup2 -> {
            if (component == null) {
                PopupFactoryImpl.$$$reportNull$$$0(70);
            }
            for (Component owner = popup2.getOwner(); owner != null; owner = owner.getParent()) {
                if (!owner.equals(component)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(61);
        }
        return list2;
    }

    public boolean isPopupActive() {
        return IdeEventQueue.getInstance().isPopupActive();
    }

    @NotNull
    public BalloonBuilder createBalloonBuilder(@NotNull JComponent content) {
        if (content == null) {
            PopupFactoryImpl.$$$reportNull$$$0(62);
        }
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = new BalloonPopupBuilderImpl(this.myStorage, content);
        if (balloonPopupBuilderImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(63);
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder createDialogBalloonBuilder(@NotNull JComponent content, String title) {
        if (content == null) {
            PopupFactoryImpl.$$$reportNull$$$0(64);
        }
        BalloonPopupBuilderImpl builder = new BalloonPopupBuilderImpl(this.myStorage, content);
        Color bg = UIManager.getColor("Panel.background");
        Color borderOriginal = Color.darkGray;
        Color border = ColorUtil.toAlpha((Color)borderOriginal, (int)75);
        builder.setDialogMode(true).setTitle(title).setAnimationCycle(200).setFillColor(bg).setBorderColor(border).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnAction(false).setCloseButtonEnabled(true).setShadow(true);
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = builder;
        if (balloonPopupBuilderImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(65);
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @Nullable Icon icon, Color fillColor, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(66);
        }
        JEditorPane text = IdeTooltipManager.initPane(htmlContent, new HintHint().setAwtTooltip(true), null);
        if (listener2 != null) {
            text.addHyperlinkListener(listener2);
        }
        text.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)text);
        text.setBorder(null);
        JLabel label = new JLabel();
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label.getIconTextGap() * 1.5), (int)((double)label.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        JScrollPane scrolledText = ScrollPaneFactory.createScrollPane((Component)text, (boolean)true);
        scrolledText.setBackground(fillColor);
        scrolledText.getViewport().setBackground(fillColor);
        textWrapper.add((Component)scrolledText);
        content.add((Component)textWrapper, "Center");
        NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
        north.add((Component)new JLabel(icon), (Object)"North");
        content.add((Component)north, "West");
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        BalloonBuilder builder = this.createBalloonBuilder((JComponent)content);
        builder.setFillColor(fillColor);
        BalloonBuilder balloonBuilder = builder;
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(67);
        }
        return balloonBuilder;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, MessageType messageType, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(68);
        }
        BalloonBuilder balloonBuilder = this.createHtmlTextBalloonBuilder(htmlContent, messageType.getDefaultIcon(), messageType.getPopupBackground(), listener2);
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(69);
        }
        return balloonBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 48: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 54: 
            case 60: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 56: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfirmation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroupPopup";
                break;
            }
            case 26: 
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsStep";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "makeActionItemsFromActionGroup";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createWizardStep";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createListPopup";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponentPopupBuilder";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBestPopupLocation";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPopups";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloonBuilder";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialogBalloonBuilder";
                break;
            }
            case 67: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlTextBalloonBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroupPopup";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createActionsStep";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "makeActionItemsFromActionGroup";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createWizardStep";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createListPopup";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createComponentPopupBuilder";
                break;
            }
            case 50: 
            case 54: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "guessBestPopupLocation";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isBestPopupLocationVisible";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleBestPopupLocation";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getChildPopups";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonBuilder";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createDialogBalloonBuilder";
                break;
            }
            case 66: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlTextBalloonBuilder";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChildPopups$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionStepBuilder
    extends PresentationFactory {
        private final List<ActionItem> myListModel;
        private final DataContext myDataContext;
        private final boolean myShowNumbers;
        private final boolean myUseAlphaAsNumbers;
        private final boolean myShowDisabled;
        private int myCurrentNumber;
        private boolean myPrependWithSeparator;
        private String mySeparatorText;
        private final boolean myHonorActionMnemonics;
        private Icon myEmptyIcon;
        private int myMaxIconWidth;
        private int myMaxIconHeight;
        @NotNull
        private String myActionPlace;

        private ActionStepBuilder(@NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabled, boolean honorActionMnemonics) {
            if (dataContext == null) {
                ActionStepBuilder.$$$reportNull$$$0(0);
            }
            this.myMaxIconWidth = -1;
            this.myMaxIconHeight = -1;
            this.myUseAlphaAsNumbers = useAlphaAsNumbers;
            this.myListModel = new ArrayList<ActionItem>();
            this.myDataContext = dataContext;
            this.myShowNumbers = showNumbers;
            this.myShowDisabled = showDisabled;
            this.myCurrentNumber = 0;
            this.myPrependWithSeparator = false;
            this.mySeparatorText = null;
            this.myHonorActionMnemonics = honorActionMnemonics;
            this.myActionPlace = "unknown";
        }

        public void setActionPlace(@NotNull String actionPlace) {
            if (actionPlace == null) {
                ActionStepBuilder.$$$reportNull$$$0(1);
            }
            this.myActionPlace = actionPlace;
        }

        @NotNull
        public List<ActionItem> getItems() {
            List<ActionItem> list2 = this.myListModel;
            if (list2 == null) {
                ActionStepBuilder.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public void buildGroup(@NotNull ActionGroup actionGroup) {
            if (actionGroup == null) {
                ActionStepBuilder.$$$reportNull$$$0(3);
            }
            this.calcMaxIconSize(actionGroup);
            this.myEmptyIcon = this.myMaxIconHeight != -1 && this.myMaxIconWidth != -1 ? EmptyIcon.create((int)this.myMaxIconWidth, (int)this.myMaxIconHeight) : null;
            this.appendActionsFromGroup(actionGroup);
            if (this.myListModel.isEmpty()) {
                this.myListModel.add(new ActionItem(Utils.EMPTY_MENU_FILLER, "Nothing here", null, false, null, null, false, null));
            }
        }

        private void calcMaxIconSize(ActionGroup actionGroup) {
            AnAction[] actions;
            for (AnAction action : actions = actionGroup.getChildren(this.createActionEvent((AnAction)actionGroup))) {
                ActionGroup group;
                if (action == null) continue;
                if (action instanceof ActionGroup && !(group = (ActionGroup)action).isPopup()) {
                    this.calcMaxIconSize(group);
                    continue;
                }
                Icon icon = action.getTemplatePresentation().getIcon();
                if (icon == null && action instanceof Toggleable) {
                    icon = PlatformIcons.CHECK_ICON;
                }
                if (icon == null) continue;
                int width = icon.getIconWidth();
                int height = icon.getIconHeight();
                if (this.myMaxIconWidth < width) {
                    this.myMaxIconWidth = width;
                }
                if (this.myMaxIconHeight >= height) continue;
                this.myMaxIconHeight = height;
            }
        }

        @NotNull
        private AnActionEvent createActionEvent(@NotNull AnAction actionGroup) {
            if (actionGroup == null) {
                ActionStepBuilder.$$$reportNull$$$0(4);
            }
            AnActionEvent actionEvent = new AnActionEvent(null, this.myDataContext, this.myActionPlace, this.getPresentation(actionGroup), ActionManager.getInstance(), 0);
            actionEvent.setInjectedContext(actionGroup.isInInjectedContext());
            AnActionEvent anActionEvent = actionEvent;
            if (anActionEvent == null) {
                ActionStepBuilder.$$$reportNull$$$0(5);
            }
            return anActionEvent;
        }

        private void appendActionsFromGroup(@NotNull ActionGroup actionGroup) {
            if (actionGroup == null) {
                ActionStepBuilder.$$$reportNull$$$0(6);
            }
            ArrayList newVisibleActions = ContainerUtil.newArrayListWithCapacity((int)100);
            Utils.expandActionGroup(false, actionGroup, newVisibleActions, this, this.myDataContext, this.myActionPlace, ActionManager.getInstance());
            for (AnAction action : newVisibleActions) {
                if (action == null) {
                    LOG.error("null action in group " + actionGroup);
                    continue;
                }
                if (action instanceof Separator) {
                    this.myPrependWithSeparator = true;
                    this.mySeparatorText = ((Separator)action).getText();
                    continue;
                }
                this.appendAction(action);
            }
        }

        private void appendAction(@NotNull AnAction action) {
            if (action == null) {
                ActionStepBuilder.$$$reportNull$$$0(7);
            }
            Presentation presentation = this.getPresentation(action);
            AnActionEvent event = this.createActionEvent(action);
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action, (AnActionEvent)event, (boolean)true);
            boolean enabled = presentation.isEnabled();
            if ((this.myShowDisabled || enabled) && presentation.isVisible()) {
                boolean prependSeparator;
                String text = presentation.getText();
                if (this.myShowNumbers) {
                    if (this.myCurrentNumber < 9) {
                        text = "&" + (this.myCurrentNumber + 1) + ". " + text;
                    } else if (this.myCurrentNumber == 9) {
                        text = "&0. " + text;
                    } else if (this.myUseAlphaAsNumbers) {
                        text = "&" + (char)(65 + this.myCurrentNumber - 10) + ". " + text;
                    }
                    ++this.myCurrentNumber;
                } else if (this.myHonorActionMnemonics) {
                    text = Presentation.restoreTextWithMnemonic((String)text, (int)action.getTemplatePresentation().getMnemonic());
                }
                Icon icon = presentation.getIcon();
                Icon selectedIcon = presentation.getSelectedIcon();
                Icon disabledIcon = presentation.getDisabledIcon();
                if (icon == null && selectedIcon == null) {
                    String actionId = ActionManager.getInstance().getId(action);
                    if (actionId != null && actionId.startsWith("QuickList.")) {
                        icon = AllIcons.Actions.QuickList;
                    } else if (action instanceof Toggleable && Boolean.TRUE.equals(presentation.getClientProperty("selected"))) {
                        icon = MacIntelliJIconCache.getIcon("checkmark", false, false, true);
                        selectedIcon = MacIntelliJIconCache.getIcon("checkmark", true, false, true);
                        disabledIcon = MacIntelliJIconCache.getIcon("checkmark", false, false, false);
                    }
                }
                if (!enabled) {
                    icon = disabledIcon != null ? disabledIcon : IconLoader.getDisabledIcon((Icon)icon);
                    Icon icon2 = selectedIcon = disabledIcon != null ? disabledIcon : IconLoader.getDisabledIcon((Icon)selectedIcon);
                }
                if (icon == null) {
                    icon = selectedIcon != null ? selectedIcon : this.myEmptyIcon;
                }
                boolean bl = prependSeparator = (!this.myListModel.isEmpty() || this.mySeparatorText != null) && this.myPrependWithSeparator;
                assert (text != null) : action + " has no presentation";
                this.myListModel.add(new ActionItem(action, text, (String)presentation.getClientProperty("ToolTipText"), enabled, icon, selectedIcon, prependSeparator, this.mySeparatorText));
                this.myPrependWithSeparator = false;
                this.mySeparatorText = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPlace";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActionEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionPlace";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createActionEvent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "appendActionsFromGroup";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "appendAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionPopupStep
    implements ListPopupStepEx<ActionItem>,
    MnemonicNavigationFilter<ActionItem>,
    SpeedSearchFilter<ActionItem> {
        private final List<ActionItem> myItems;
        private final String myTitle;
        private final Component myContext;
        private final boolean myEnableMnemonics;
        private final int myDefaultOptionIndex;
        private final boolean myAutoSelectionEnabled;
        private final boolean myShowDisabledActions;
        private Runnable myFinalRunnable;
        @Nullable
        private final Condition<AnAction> myPreselectActionCondition;

        public ActionPopupStep(@NotNull List<ActionItem> items, String title, Component context, boolean enableMnemonics, @Nullable Condition<AnAction> preselectActionCondition, boolean autoSelection, boolean showDisabledActions) {
            if (items == null) {
                ActionPopupStep.$$$reportNull$$$0(0);
            }
            this.myItems = items;
            this.myTitle = title;
            this.myContext = context;
            this.myEnableMnemonics = enableMnemonics;
            this.myDefaultOptionIndex = ActionPopupStep.getDefaultOptionIndexFromSelectCondition(preselectActionCondition, items);
            this.myPreselectActionCondition = preselectActionCondition;
            this.myAutoSelectionEnabled = autoSelection;
            this.myShowDisabledActions = showDisabledActions;
        }

        private static int getDefaultOptionIndexFromSelectCondition(@Nullable Condition<AnAction> preselectActionCondition, @NotNull List<ActionItem> items) {
            if (items == null) {
                ActionPopupStep.$$$reportNull$$$0(1);
            }
            int defaultOptionIndex = 0;
            if (preselectActionCondition != null) {
                for (int i = 0; i < items.size(); ++i) {
                    AnAction action = items.get(i).getAction();
                    if (!preselectActionCondition.value((Object)action)) continue;
                    defaultOptionIndex = i;
                    break;
                }
            }
            return defaultOptionIndex;
        }

        @NotNull
        public List<ActionItem> getValues() {
            List<ActionItem> list2 = this.myItems;
            if (list2 == null) {
                ActionPopupStep.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public boolean isSelectable(ActionItem value) {
            return value.isEnabled();
        }

        public int getMnemonicPos(ActionItem value) {
            String text = this.getTextFor(value);
            int i = text.indexOf(27);
            if (i < 0) {
                i = text.indexOf(38);
            }
            if (i < 0) {
                i = text.indexOf(95);
            }
            return i;
        }

        public Icon getIconFor(ActionItem aValue) {
            return aValue.getIcon(false);
        }

        public Icon getSelectedIconFor(ActionItem value) {
            return value.getIcon(true);
        }

        @NotNull
        public String getTextFor(ActionItem value) {
            String string = value.getText();
            if (string == null) {
                ActionPopupStep.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public String getTooltipTextFor(ActionItem value) {
            return value.getDescription();
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            if (emptyText == null) {
                ActionPopupStep.$$$reportNull$$$0(4);
            }
        }

        public ListSeparator getSeparatorAbove(ActionItem value) {
            return value.isPrependWithSeparator() ? new ListSeparator(value.getSeparatorText()) : null;
        }

        public int getDefaultOptionIndex() {
            return this.myDefaultOptionIndex;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public PopupStep onChosen(ActionItem actionChoice, boolean finalChoice) {
            return this.onChosen(actionChoice, finalChoice, 0);
        }

        public PopupStep onChosen(ActionItem actionChoice, boolean finalChoice, int eventModifiers) {
            DataContext dataContext;
            if (!actionChoice.isEnabled()) {
                return FINAL_CHOICE;
            }
            AnAction action = actionChoice.getAction();
            DataManager mgr = DataManager.getInstance();
            DataContext dataContext2 = dataContext = this.myContext != null ? mgr.getDataContext(this.myContext) : mgr.getDataContext();
            if (!(!(action instanceof ActionGroup) || finalChoice && ((ActionGroup)action).canBePerformed(dataContext))) {
                return PopupFactoryImpl.createActionsStep((ActionGroup)action, dataContext, this.myEnableMnemonics, true, this.myShowDisabledActions, null, this.myContext, false, (Condition<AnAction>)this.myPreselectActionCondition, false);
            }
            this.myFinalRunnable = () -> this.performAction(action, eventModifiers);
            return FINAL_CHOICE;
        }

        public void performAction(@NotNull AnAction action, int modifiers) {
            if (action == null) {
                ActionPopupStep.$$$reportNull$$$0(5);
            }
            this.performAction(action, modifiers, null);
        }

        public void performAction(@NotNull AnAction action, int modifiers, InputEvent inputEvent) {
            if (action == null) {
                ActionPopupStep.$$$reportNull$$$0(6);
            }
            DataManager mgr = DataManager.getInstance();
            DataContext dataContext = this.myContext != null ? mgr.getDataContext(this.myContext) : mgr.getDataContext();
            AnActionEvent event = new AnActionEvent(inputEvent, dataContext, "unknown", action.getTemplatePresentation().clone(), ActionManager.getInstance(), modifiers);
            event.setInjectedContext(action.isInInjectedContext());
            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false)) {
                ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
            }
        }

        public Runnable getFinalRunnable() {
            return this.myFinalRunnable;
        }

        public boolean hasSubstep(ActionItem selectedValue) {
            return selectedValue != null && selectedValue.isEnabled() && selectedValue.getAction() instanceof ActionGroup;
        }

        public void canceled() {
        }

        public boolean isMnemonicsNavigationEnabled() {
            return this.myEnableMnemonics;
        }

        public MnemonicNavigationFilter<ActionItem> getMnemonicNavigationFilter() {
            return this;
        }

        public boolean canBeHidden(ActionItem value) {
            return true;
        }

        public String getIndexedString(ActionItem value) {
            return this.getTextFor(value);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return this.myAutoSelectionEnabled;
        }

        public SpeedSearchFilter<ActionItem> getSpeedSearchFilter() {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyText";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultOptionIndexFromSelectCondition";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setEmptyText";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionItem
    implements ShortcutProvider {
        private final AnAction myAction;
        private String myText;
        private final boolean myIsEnabled;
        private final Icon myIcon;
        private final Icon mySelectedIcon;
        private final boolean myPrependWithSeparator;
        private final String mySeparatorText;
        private final String myDescription;

        private ActionItem(@NotNull AnAction action, @NotNull String text, @Nullable String description, boolean enabled, @Nullable Icon icon, @Nullable Icon selectedIcon, boolean prependWithSeparator, String separatorText) {
            if (action == null) {
                ActionItem.$$$reportNull$$$0(0);
            }
            if (text == null) {
                ActionItem.$$$reportNull$$$0(1);
            }
            this.myAction = action;
            this.myText = text;
            this.myIsEnabled = enabled;
            this.myIcon = icon;
            this.mySelectedIcon = selectedIcon;
            this.myPrependWithSeparator = prependWithSeparator;
            this.mySeparatorText = separatorText;
            this.myDescription = description;
            this.myAction.getTemplatePresentation().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "text") {
                        myText = myAction.getTemplatePresentation().getText();
                    }
                }
            });
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                ActionItem.$$$reportNull$$$0(2);
            }
            return anAction;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ActionItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public Icon getIcon(boolean selected) {
            return selected && this.mySelectedIcon != null ? this.mySelectedIcon : this.myIcon;
        }

        public boolean isPrependWithSeparator() {
            return this.myPrependWithSeparator;
        }

        public String getSeparatorText() {
            return this.mySeparatorText;
        }

        public boolean isEnabled() {
            return this.myIsEnabled;
        }

        public String getDescription() {
            return this.myDescription;
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction.getShortcutSet();
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionGroupPopup
    extends ListPopupImpl {
        private final Runnable myDisposeCallback;
        private final Component myComponent;
        private final String myActionPlace;

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(1);
            }
            this(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace, false);
        }

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(2);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(3);
            }
            this(null, ActionGroupPopup.createStep(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, preselectActionCondition, actionPlace, autoSelection), disposeCallback, dataContext, actionPlace, maxRowCount);
        }

        protected ActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep step, @Nullable Runnable disposeCallback, @NotNull DataContext dataContext, @Nullable String actionPlace, int maxRowCount) {
            if (step == null) {
                ActionGroupPopup.$$$reportNull$$$0(4);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(5);
            }
            super(aParent, step, maxRowCount);
            this.myDisposeCallback = disposeCallback;
            this.myComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            this.myActionPlace = actionPlace == null ? "unknown" : actionPlace;
            this.registerAction("handleActionToggle1", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleToggleAction();
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    JList list2 = (JList)e.getSource();
                    ActionItem actionItem = (ActionItem)list2.getSelectedValue();
                    if (actionItem == null) {
                        return;
                    }
                    Presentation presentation = this.updateActionItem(actionItem);
                    ActionMenu.showDescriptionInStatusBar(true, myComponent, presentation.getDescription());
                }
            });
        }

        @NotNull
        private Presentation updateActionItem(@NotNull ActionItem actionItem) {
            if (actionItem == null) {
                ActionGroupPopup.$$$reportNull$$$0(6);
            }
            AnAction action = actionItem.getAction();
            Presentation presentation = new Presentation();
            presentation.setDescription(action.getTemplatePresentation().getDescription());
            AnActionEvent actionEvent = new AnActionEvent(null, DataManager.getInstance().getDataContext(this.myComponent), this.myActionPlace, presentation, ActionManager.getInstance(), 0);
            actionEvent.setInjectedContext(action.isInInjectedContext());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action, (AnActionEvent)actionEvent, (boolean)false);
            Presentation presentation2 = presentation;
            if (presentation2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(7);
            }
            return presentation2;
        }

        private static ListPopupStep createStep(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(8);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(9);
            }
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            LOG.assertTrue(component != null, (Object)"dataContext has no component for new ListPopupStep");
            List<ActionItem> items = ActionGroupPopup.getActionItems(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace);
            return new ActionPopupStep(items, title, component, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), preselectActionCondition, autoSelection, showDisabledActions);
        }

        @NotNull
        public static List<ActionItem> getActionItems(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(10);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(11);
            }
            ActionStepBuilder builder = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
            if (actionPlace != null) {
                builder.setActionPlace(actionPlace);
            }
            builder.buildGroup(actionGroup);
            List<ActionItem> list2 = builder.getItems();
            if (list2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(12);
            }
            return list2;
        }

        @Override
        public void dispose() {
            if (this.myDisposeCallback != null) {
                this.myDisposeCallback.run();
            }
            ActionMenu.showDescriptionInStatusBar(true, this.myComponent, null);
            super.dispose();
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            KeepingPopupOpenAction dontClosePopupAction;
            Object selectedValue = this.getList().getSelectedValue();
            ActionPopupStep actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class);
            if (actionPopupStep != null && (dontClosePopupAction = ActionGroupPopup.getActionByClass(selectedValue, actionPopupStep, KeepingPopupOpenAction.class)) != null) {
                actionPopupStep.performAction((AnAction)dontClosePopupAction, e != null ? e.getModifiers() : 0, e);
                for (ActionItem item : actionPopupStep.myItems) {
                    this.updateActionItem(item);
                }
                this.getList().repaint();
                return;
            }
            super.handleSelect(handleFinalChoices, e);
        }

        protected void handleToggleAction() {
            Object[] selectedValues = this.getList().getSelectedValues();
            ListPopupStep<Object> listStep = this.getListStep();
            ActionPopupStep actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(listStep, ActionPopupStep.class);
            if (actionPopupStep == null) {
                return;
            }
            List filtered = ContainerUtil.mapNotNull((Object[])selectedValues, o -> ActionGroupPopup.getActionByClass(o, actionPopupStep, ToggleAction.class));
            for (ToggleAction action : filtered) {
                actionPopupStep.performAction((AnAction)action, 0);
            }
            for (ActionItem item : actionPopupStep.myItems) {
                this.updateActionItem(item);
            }
            this.getList().repaint();
        }

        @Nullable
        private static <T> T getActionByClass(@Nullable Object value, @NotNull ActionPopupStep actionPopupStep, @NotNull Class<T> actionClass) {
            ActionItem item;
            if (actionPopupStep == null) {
                ActionGroupPopup.$$$reportNull$$$0(13);
            }
            if (actionClass == null) {
                ActionGroupPopup.$$$reportNull$$$0(14);
            }
            ActionItem actionItem = item = value instanceof ActionItem ? (ActionItem)value : null;
            if (item == null) {
                return null;
            }
            if (!actionPopupStep.isSelectable(item)) {
                return null;
            }
            return actionClass.isInstance(item.getAction()) ? (T)actionClass.cast(item.getAction()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionItem";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPopupStep";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateActionItem";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateActionItem";
                    break;
                }
                case 7: 
                case 12: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionItems";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionByClass";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

