/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexDataGetter {
    private static final Logger LOG = Logger.getInstance(IndexDataGetter.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;

    public IndexDataGetter(@NotNull Project project, @NotNull Set<VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage indexStorage, @NotNull VcsLogStorage logStorage, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        if (project == null) {
            IndexDataGetter.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            IndexDataGetter.$$$reportNull$$$0(1);
        }
        if (indexStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(2);
        }
        if (logStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(3);
        }
        if (fatalErrorsConsumer == null) {
            IndexDataGetter.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myRoots = roots;
        this.myIndexStorage = indexStorage;
        this.myLogStorage = logStorage;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
    }

    @Nullable
    public String getFullMessage(int index) {
        return (String)this.executeAndCatch(() -> (String)this.myIndexStorage.messages.get((Object)index));
    }

    @NotNull
    public Set<FilePath> getFileNames(@NotNull FilePath path, int commit) {
        Set result2;
        VirtualFile root;
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(5);
        }
        if (this.myRoots.contains(root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path)) && (result2 = (Set)this.executeAndCatch(() -> {
            if (path == null) {
                IndexDataGetter.$$$reportNull$$$0(36);
            }
            return this.myIndexStorage.paths.getFileNames(path, commit);
        })) != null) {
            Set set2 = result2;
            if (set2 == null) {
                IndexDataGetter.$$$reportNull$$$0(6);
            }
            return set2;
        }
        Set<FilePath> set3 = Collections.emptySet();
        if (set3 == null) {
            IndexDataGetter.$$$reportNull$$$0(7);
        }
        return set3;
    }

    @NotNull
    public FileNamesData buildFileNamesData(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(8);
        }
        MyFileNamesData result2 = new MyFileNamesData();
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        if (this.myRoots.contains(root)) {
            this.executeAndCatch(() -> {
                if (path == null) {
                    IndexDataGetter.$$$reportNull$$$0(35);
                }
                this.myIndexStorage.paths.iterateCommits(path, (changes, commit) -> this.executeAndCatch(() -> {
                    List parents = (List)this.myIndexStorage.parents.get((Object)commit);
                    if (parents == null) {
                        throw new CorruptedDataException("No parents for commit " + commit);
                    }
                    result2.add(commit, (FilePath)changes.first, (List)changes.second, parents);
                    return null;
                }));
                return null;
            });
        }
        MyFileNamesData myFileNamesData = result2;
        if (myFileNamesData == null) {
            IndexDataGetter.$$$reportNull$$$0(9);
        }
        return myFileNamesData;
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(10);
        }
        try {
            return (T)computable.compute();
        }
        catch (StorageException | CorruptedDataException | IOException e) {
            this.myIndexStorage.markCorrupted();
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public List<Hash> getParents(int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<VcsUser> users) {
        TIntHashSet tIntHashSet;
        if (users == null) {
            IndexDataGetter.$$$reportNull$$$0(15);
        }
        try {
            tIntHashSet = this.myIndexStorage.users.getCommitsForUsers(users);
        }
        catch (StorageException | IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(16);
        }
        return tIntHashSet;
        TIntHashSet tIntHashSet2 = new TIntHashSet();
        if (tIntHashSet2 == null) {
            IndexDataGetter.$$$reportNull$$$0(17);
        }
        return tIntHashSet2;
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<FilePath> paths) {
        TIntHashSet tIntHashSet;
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(18);
        }
        try {
            tIntHashSet = this.myIndexStorage.paths.getCommitsForPaths(paths);
        }
        catch (StorageException | IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(19);
        }
        return tIntHashSet;
        TIntHashSet tIntHashSet2 = new TIntHashSet();
        if (tIntHashSet2 == null) {
            IndexDataGetter.$$$reportNull$$$0(20);
        }
        return tIntHashSet2;
    }

    @NotNull
    private TIntHashSet filterMessages(@NotNull VcsLogTextFilter filter2) {
        block6: {
            TIntHashSet tIntHashSet;
            if (filter2 == null) {
                IndexDataGetter.$$$reportNull$$$0(21);
            }
            try {
                TIntHashSet commitsForSearch;
                if (filter2.isRegex() || (commitsForSearch = this.myIndexStorage.trigrams.getCommitsForSubstring(filter2.getText())) == null) break block6;
                TIntHashSet result2 = new TIntHashSet();
                commitsForSearch.forEach(commit -> {
                    if (filter2 == null) {
                        IndexDataGetter.$$$reportNull$$$0(34);
                    }
                    try {
                        String value = (String)this.myIndexStorage.messages.get((Object)commit);
                        if (value != null && VcsLogTextFilterImpl.matches(filter2, value)) {
                            result2.add(commit);
                        }
                    }
                    catch (IOException e) {
                        this.myFatalErrorsConsumer.consume(this, e);
                        return false;
                    }
                    return true;
                });
                tIntHashSet = result2;
            }
            catch (StorageException e) {
                this.myFatalErrorsConsumer.consume(this, e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            if (tIntHashSet == null) {
                IndexDataGetter.$$$reportNull$$$0(22);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = this.filter(this.myIndexStorage.messages, message -> {
            if (filter2 == null) {
                IndexDataGetter.$$$reportNull$$$0(33);
            }
            return VcsLogTextFilterImpl.matches(filter2, message);
        });
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(23);
        }
        return tIntHashSet;
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map, @NotNull Condition<T> condition) {
        if (map == null) {
            IndexDataGetter.$$$reportNull$$$0(24);
        }
        if (condition == null) {
            IndexDataGetter.$$$reportNull$$$0(25);
        }
        TIntHashSet result2 = new TIntHashSet();
        try {
            Processor processor2 = integer -> {
                if (map == null) {
                    IndexDataGetter.$$$reportNull$$$0(31);
                }
                if (condition == null) {
                    IndexDataGetter.$$$reportNull$$$0(32);
                }
                try {
                    Object value = map.get(integer);
                    if (value != null && condition.value(value)) {
                        result2.add(integer.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            };
            if (this.myIndexStorage.messages instanceof PersistentHashMap) {
                ((PersistentHashMap)this.myIndexStorage.messages).processKeysWithExistingMapping(processor2);
            } else {
                this.myIndexStorage.messages.processKeys(processor2);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(26);
        }
        return tIntHashSet;
    }

    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            IndexDataGetter.$$$reportNull$$$0(27);
        }
        if (filters.isEmpty()) {
            return false;
        }
        for (VcsLogDetailsFilter filter2 : filters) {
            if (filter2 instanceof VcsLogTextFilter || filter2 instanceof VcsLogUserFilter || filter2 instanceof VcsLogStructureFilter) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(28);
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter);
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile root : this.myRoots) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        Set<Integer> set2 = TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
        if (set2 == null) {
            IndexDataGetter.$$$reportNull$$$0(29);
        }
        return set2;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            IndexDataGetter.$$$reportNull$$$0(30);
        }
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        this.myIndexStorage.markCorrupted();
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorsConsumer";
                break;
            }
            case 5: 
            case 8: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 21: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFileNamesData";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUsers";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPaths";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMessages";
                break;
            }
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildFileNamesData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAndCatch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterUsers";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterPaths";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "filterMessages";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canFilter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processRuntimeException";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filter$7";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterMessages$6";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterMessages$5";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildFileNamesData$4";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFileNames$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CorruptedDataException
    extends RuntimeException {
        public CorruptedDataException(@NotNull String message) {
            if (message == null) {
                CorruptedDataException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/data/index/IndexDataGetter$CorruptedDataException", "<init>"));
        }
    }

    public static abstract class FileNamesData {
        @NotNull
        private final TIntObjectHashMap<Map<FilePath, Map<Integer, VcsLogPathsIndex.ChangeData>>> myCommitToPathAndChanges = new TIntObjectHashMap();
        private boolean myHasRenames = false;

        protected abstract FilePath getPathById(int var1);

        public boolean hasRenames() {
            return this.myHasRenames;
        }

        public void add(int commit, @NotNull FilePath path, @NotNull List<VcsLogPathsIndex.ChangeData> changes, @NotNull List<Integer> parents) {
            Map parentToChangesMap;
            Map pathToChanges;
            if (path == null) {
                FileNamesData.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                FileNamesData.$$$reportNull$$$0(1);
            }
            if (parents == null) {
                FileNamesData.$$$reportNull$$$0(2);
            }
            if ((pathToChanges = (Map)this.myCommitToPathAndChanges.get(commit)) == null) {
                pathToChanges = ContainerUtil.newHashMap();
                this.myCommitToPathAndChanges.put(commit, (Object)pathToChanges);
            }
            if (!this.myHasRenames) {
                for (VcsLogPathsIndex.ChangeData data : changes) {
                    if (data == null || !data.isRename()) continue;
                    this.myHasRenames = true;
                    break;
                }
            }
            if ((parentToChangesMap = (Map)pathToChanges.get(path)) == null) {
                parentToChangesMap = ContainerUtil.newHashMap();
            }
            if (!parents.isEmpty()) {
                LOG.assertTrue(parents.size() == changes.size());
                for (int i = 0; i < changes.size(); ++i) {
                    VcsLogPathsIndex.ChangeData existing = (VcsLogPathsIndex.ChangeData)parentToChangesMap.get(parents.get(i));
                    if (existing != null && existing.isRename()) continue;
                    parentToChangesMap.put(parents.get(i), changes.get(i));
                }
            } else {
                LOG.assertTrue(changes.size() == 1);
                parentToChangesMap.put(-1, changes.get(0));
            }
            pathToChanges.put(path, parentToChangesMap);
        }

        @Nullable
        public FilePath getPathInParentRevision(int commit, int parent, @NotNull FilePath childPath) {
            if (childPath == null) {
                FileNamesData.$$$reportNull$$$0(3);
            }
            Map filesToChangesMap = (Map)this.myCommitToPathAndChanges.get(commit);
            LOG.assertTrue(filesToChangesMap != null, (Object)("Missing commit " + commit));
            Map changes = (Map)filesToChangesMap.get(childPath);
            if (changes == null) {
                return childPath;
            }
            VcsLogPathsIndex.ChangeData change = (VcsLogPathsIndex.ChangeData)changes.get(parent);
            if (change == null) {
                LOG.assertTrue(changes.size() > 1);
                return childPath;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM)) {
                return null;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_TO)) {
                return this.getPathById(change.otherPath);
            }
            return childPath;
        }

        @Nullable
        public FilePath getPathInChildRevision(int commit, int parentIndex, @NotNull FilePath parentPath) {
            if (parentPath == null) {
                FileNamesData.$$$reportNull$$$0(4);
            }
            Map filesToChangesMap = (Map)this.myCommitToPathAndChanges.get(commit);
            LOG.assertTrue(filesToChangesMap != null, (Object)("Missing commit " + commit));
            Map changes = (Map)filesToChangesMap.get(parentPath);
            if (changes == null) {
                return parentPath;
            }
            VcsLogPathsIndex.ChangeData change = (VcsLogPathsIndex.ChangeData)changes.get(parentIndex);
            if (change == null) {
                return parentPath;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_TO)) {
                return null;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM)) {
                return this.getPathById(change.otherPath);
            }
            return parentPath;
        }

        public boolean affects(int id, @NotNull FilePath path) {
            if (path == null) {
                FileNamesData.$$$reportNull$$$0(5);
            }
            return this.myCommitToPathAndChanges.containsKey(id) && ((Map)this.myCommitToPathAndChanges.get(id)).containsKey(path);
        }

        @NotNull
        public Set<Integer> getCommits() {
            HashSet result2 = ContainerUtil.newHashSet();
            this.myCommitToPathAndChanges.forEach(result2::add);
            HashSet hashSet = result2;
            if (hashSet == null) {
                FileNamesData.$$$reportNull$$$0(6);
            }
            return hashSet;
        }

        @NotNull
        public Map<Integer, FilePath> buildPathsMap() {
            HashMap result2 = ContainerUtil.newHashMap();
            this.myCommitToPathAndChanges.forEachEntry((commit, filesToChanges) -> {
                if (filesToChanges.size() == 1) {
                    result2.put(commit, ContainerUtil.getFirstItem(filesToChanges.keySet()));
                } else {
                    for (Map.Entry fileToChange : filesToChanges.entrySet()) {
                        VcsLogPathsIndex.ChangeData changeData = (VcsLogPathsIndex.ChangeData)ContainerUtil.find(((Map)fileToChange.getValue()).values(), ch -> ch != null && !ch.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM));
                        if (changeData == null) continue;
                        result2.put(commit, fileToChange.getKey());
                        break;
                    }
                }
                return true;
            });
            HashMap hashMap = result2;
            if (hashMap == null) {
                FileNamesData.$$$reportNull$$$0(7);
            }
            return hashMap;
        }

        public boolean isTrivialMerge(int commit, @NotNull FilePath path) {
            if (path == null) {
                FileNamesData.$$$reportNull$$$0(8);
            }
            if (!this.myCommitToPathAndChanges.containsKey(commit)) {
                return false;
            }
            Map data = (Map)((Map)this.myCommitToPathAndChanges.get(commit)).get(path);
            return data != null && data.size() > 1 && data.containsValue(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parents";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childPath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentPath";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommits";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildPathsMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathInParentRevision";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathInChildRevision";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "affects";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isTrivialMerge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyFileNamesData
    extends FileNamesData {
        private MyFileNamesData() {
        }

        @Override
        protected FilePath getPathById(int pathId) {
            return VcsUtil.getFilePath((String)((IndexDataGetter)IndexDataGetter.this).myIndexStorage.paths.getPath(pathId));
        }
    }
}

