/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.frame.ReferencesPanel;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitPanel
extends JBPanel {
    public static final int BOTTOM_BORDER = 2;
    private static final int REFERENCES_BORDER = 12;
    private static final int TOP_BORDER = 4;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final ReferencesPanel myBranchesPanel;
    @NotNull
    private final ReferencesPanel myTagsPanel;
    @NotNull
    private final DataPanel myDataPanel;
    @NotNull
    private final BranchesPanel myContainingBranchesPanel;
    @NotNull
    private final RootPanel myRootPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final Consumer<CommitId> myNavigate;
    @Nullable
    private CommitId myCommit;

    public CommitPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Consumer<CommitId> navigate2) {
        if (logData == null) {
            CommitPanel.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            CommitPanel.$$$reportNull$$$0(1);
        }
        if (navigate2 == null) {
            CommitPanel.$$$reportNull$$$0(2);
        }
        this.myLogData = logData;
        this.myColorManager = colorManager;
        this.myNavigate = navigate2;
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.setOpaque(false);
        this.myRootPanel = new RootPanel();
        this.myBranchesPanel = new ReferencesPanel();
        this.myBranchesPanel.setBorder((Border)JBUI.Borders.emptyTop((int)12));
        this.myTagsPanel = new ReferencesPanel();
        this.myTagsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)12));
        this.myDataPanel = new DataPanel();
        this.myContainingBranchesPanel = new BranchesPanel();
        this.add(this.myRootPanel);
        this.add(this.myDataPanel);
        this.add(this.myBranchesPanel);
        this.add(this.myTagsPanel);
        this.add(this.myContainingBranchesPanel);
        this.setBorder((Border)CommitPanel.getDetailsBorder());
    }

    public void setCommit(@NotNull CommitId commit, @NotNull CommitPresentationUtil.CommitPresentation presentation) {
        if (commit == null) {
            CommitPanel.$$$reportNull$$$0(3);
        }
        if (presentation == null) {
            CommitPanel.$$$reportNull$$$0(4);
        }
        if (!commit.equals((Object)this.myCommit) || presentation.isResolved()) {
            this.myCommit = commit;
            this.myDataPanel.setData(presentation);
            if (this.myColorManager.isMultipleRoots()) {
                this.myRootPanel.setRoot(commit.getRoot().getName(), (Color)VcsLogGraphTable.getRootBackgroundColor(commit.getRoot(), this.myColorManager));
            } else {
                this.myRootPanel.setRoot("", null);
            }
        }
        List<String> branches = this.myLogData.getContainingBranchesGetter().requestContainingBranches(commit.getRoot(), commit.getHash());
        this.myContainingBranchesPanel.setBranches(branches);
        this.myDataPanel.update();
        this.myContainingBranchesPanel.update();
        this.revalidate();
    }

    public void setRefs(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            CommitPanel.$$$reportNull$$$0(5);
        }
        List<VcsRef> references = this.sortRefs(refs);
        this.myBranchesPanel.setReferences(references.stream().filter(ref -> ref.getType().isBranch()).collect(Collectors.toList()));
        this.myTagsPanel.setReferences(references.stream().filter(ref -> !ref.getType().isBranch()).collect(Collectors.toList()));
    }

    public void update() {
        this.myDataPanel.update();
        this.myRootPanel.update();
        this.myBranchesPanel.update();
        this.myTagsPanel.update();
        this.myContainingBranchesPanel.update();
    }

    public void updateBranches() {
        if (this.myCommit != null) {
            this.myContainingBranchesPanel.setBranches(this.myLogData.getContainingBranchesGetter().getContainingBranchesFromCache(this.myCommit.getRoot(), this.myCommit.getHash()));
        } else {
            this.myContainingBranchesPanel.setBranches(null);
        }
        this.myContainingBranchesPanel.update();
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Collection<VcsRef> refs) {
        VcsRef ref;
        if (refs == null) {
            CommitPanel.$$$reportNull$$$0(6);
        }
        if ((ref = (VcsRef)ContainerUtil.getFirstItem(refs)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                CommitPanel.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List list3 = ContainerUtil.sorted(refs, (Comparator)this.myLogData.getLogProvider(ref.getRoot()).getReferenceManager().getLabelsOrderComparator());
        if (list3 == null) {
            CommitPanel.$$$reportNull$$$0(8);
        }
        return list3;
    }

    @NotNull
    public static JBEmptyBorder getDetailsBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        if (jBEmptyBorder == null) {
            CommitPanel.$$$reportNull$$$0(9);
        }
        return jBEmptyBorder;
    }

    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    public boolean isExpanded() {
        return this.myContainingBranchesPanel.isExpanded();
    }

    @NotNull
    public static Color getCommitDetailsBackground() {
        Color color = UIUtil.getTableBackground();
        if (color == null) {
            CommitPanel.$$$reportNull$$$0(10);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPanel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sortRefs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailsBorder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitDetailsBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCommit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRefs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortRefs";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootPanel
    extends JPanel {
        private static final int RIGHT_BORDER = Math.max(UIUtil.getScrollBarWidth(), JBUI.scale((int)14));
        @NotNull
        private final RectanglePainter myLabelPainter;
        @NotNull
        private String myText = "";
        @NotNull
        private Color myColor = CommitPanel.getCommitDetailsBackground();

        RootPanel() {
            this.myLabelPainter = new RectanglePainter(true){

                @Override
                protected Font getLabelFont() {
                    return RootPanel.getLabelFont();
                }
            };
            this.setOpaque(false);
        }

        @NotNull
        private static Font getLabelFont() {
            Font font = VcsHistoryUtil.getCommitDetailsFont();
            Font font2 = font.deriveFont((float)font.getSize() - 2.0f);
            if (font2 == null) {
                RootPanel.$$$reportNull$$$0(0);
            }
            return font2;
        }

        public void setRoot(@NotNull String text, @Nullable Color color) {
            if (text == null) {
                RootPanel.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myColor = text.isEmpty() || color == null ? CommitPanel.getCommitDetailsBackground() : color;
        }

        public void update() {
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.myText.isEmpty()) {
                Dimension painterSize = this.myLabelPainter.calculateSize(this.myText, this.getFontMetrics(RootPanel.getLabelFont()));
                JBScrollPane scrollPane = (JBScrollPane)UIUtil.getParentOfType(JBScrollPane.class, (Component)this);
                int width = scrollPane == null ? this.getWidth() : scrollPane.getViewport().getViewRect().x + scrollPane.getWidth();
                this.myLabelPainter.paint((Graphics2D)g, this.myText, width - painterSize.width - RIGHT_BORDER, 0, this.myColor);
            }
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.myText.isEmpty()) {
                return new JBDimension(0, 4);
            }
            Dimension size = this.myLabelPainter.calculateSize(this.myText, this.getFontMetrics(RootPanel.getLabelFont()));
            return new Dimension(size.width + JBUI.scale((int)RIGHT_BORDER), size.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPanel$RootPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabelFont";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPanel$RootPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setRoot";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BranchesPanel
    extends HtmlPanel {
        @Nullable
        private List<String> myBranches;
        private boolean myExpanded = false;

        BranchesPanel() {
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.setBorder((Border)JBUI.Borders.empty((int)12, (int)4, (int)2, (int)0));
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "show-hide-branches".equals(e.getDescription())) {
                this.myExpanded = !this.myExpanded;
                this.update();
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.update();
        }

        void setBranches(@Nullable List<String> branches) {
            this.myBranches = branches == null ? null : branches;
            this.myExpanded = false;
        }

        void update() {
            this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)VcsHistoryUtil.getCommitDetailsFont()) + "</head><body>" + CommitPresentationUtil.getBranchesText(this.myBranches, this.myExpanded) + "</body></html>");
            this.revalidate();
            this.repaint();
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }
    }

    private class DataPanel
    extends HtmlPanel {
        @Nullable
        private CommitPresentationUtil.CommitPresentation myPresentation;

        DataPanel() {
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)2, (int)0));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.update();
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            if (e == null) {
                DataPanel.$$$reportNull$$$0(0);
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getDescription().startsWith("go-to-hash:")) {
                CommitId commitId = ((CommitPresentationUtil.CommitPresentation)ObjectUtils.notNull((Object)this.myPresentation)).parseTargetCommit(e);
                if (commitId != null) {
                    CommitPanel.this.myNavigate.consume((Object)commitId);
                }
            } else {
                BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
            }
        }

        void setData(@Nullable CommitPresentationUtil.CommitPresentation presentation) {
            this.myPresentation = presentation;
        }

        private void customizeLinksStyle() {
            Document document = this.getDocument();
            if (document instanceof HTMLDocument) {
                StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
                String linkColor = "#" + ColorUtil.toHex((Color)JBColor.link());
                styleSheet.addRule("a { color: " + linkColor + "; text-decoration: none;}");
            }
        }

        void update() {
            if (this.myPresentation == null) {
                this.setText("");
            } else {
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)VcsHistoryUtil.getCommitDetailsFont()) + "</head><body>" + this.myPresentation.getText() + "</body></html>");
            }
            this.customizeLinksStyle();
            this.revalidate();
            this.repaint();
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "hyperlinkUpdate"));
        }
    }
}

