/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerCopyPastePreprocessor;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.function.Function;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerExpressionComboBox
extends XDebuggerEditorBase {
    private final JComponent myComponent;
    private final ComboBox<XExpression> myComboBox;
    private final CollectionComboBoxModel<XExpression> myModel;
    private XDebuggerComboBoxEditor myEditor;
    private XExpression myExpression;
    private Function<Document, Document> myDocumentProcessor;

    public XDebuggerExpressionComboBox(@NotNull Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, boolean showEditor, boolean languageInside) {
        if (project == null) {
            XDebuggerExpressionComboBox.$$$reportNull$$$0(0);
        }
        if (debuggerEditorsProvider == null) {
            XDebuggerExpressionComboBox.$$$reportNull$$$0(1);
        }
        super(project, debuggerEditorsProvider, EvaluationMode.EXPRESSION, historyId, sourcePosition);
        this.myModel = new CollectionComboBoxModel();
        this.myDocumentProcessor = Function.identity();
        this.myComboBox = new ComboBox(this.myModel, 100);
        this.myComboBox.setEditable(true);
        this.myExpression = XExpressionImpl.EMPTY_EXPRESSION;
        Dimension minimumSize = new Dimension(this.myComboBox.getMinimumSize());
        minimumSize.width = 100;
        this.myComboBox.setMinimumSize(minimumSize);
        this.initEditor(showEditor, languageInside);
        this.fillComboBox();
        this.myComponent = JBUI.Panels.simplePanel().addToTop(this.myComboBox);
    }

    public ComboBox getComboBox() {
        return this.myComboBox;
    }

    @Override
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor.getEditorTextField().getEditor();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myEditor.getEditorTextField();
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable == this.myComboBox.isEnabled()) {
            return;
        }
        UIUtil.setEnabled((Component)this.myComponent, (boolean)enable, (boolean)true);
        if (!enable) {
            this.myExpression = this.getExpression();
        }
        super.setEnabled(enable);
    }

    private void initEditor(boolean showMultiline, boolean languageInside) {
        this.myEditor = new XDebuggerComboBoxEditor(showMultiline, languageInside);
        this.myComboBox.setEditor((ComboBoxEditor)this.myEditor);
        this.myComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)this.myEditor));
        this.myComboBox.setMaximumRowCount(10);
    }

    @Override
    protected void onHistoryChanged() {
        this.fillComboBox();
    }

    private void fillComboBox() {
        this.myModel.replaceAll(this.getRecentExpressions());
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
    }

    @Override
    protected void doSetText(XExpression text) {
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
        this.myEditor.setItem(text);
        this.myExpression = text;
    }

    @Override
    public XExpression getExpression() {
        XExpression item = this.myEditor.getItem();
        return item != null ? item : this.myExpression;
    }

    @Override
    protected Document createDocument(XExpression text) {
        return this.myDocumentProcessor.apply(super.createDocument(text));
    }

    public void setDocumentProcessor(Function<Document, Document> documentProcessor) {
        this.myDocumentProcessor = documentProcessor;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getEditorTextField();
    }

    @Override
    public void selectAll() {
        this.myComboBox.getEditor().selectAll();
    }

    @Override
    protected void prepareEditor(Editor editor) {
        super.prepareEditor(editor);
        editor.getColorsScheme().setEditorFontSize(Math.min(this.myComboBox.getFont().getSize(), EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debuggerEditorsProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/ui/XDebuggerExpressionComboBox";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class XDebuggerComboBoxEditor
    implements ComboBoxEditor {
        private final JComponent myPanel;
        private final EditorComboBoxEditor myDelegate;

        public XDebuggerComboBoxEditor(final boolean showMultiline, boolean languageInside) {
            this.myDelegate = new EditorComboBoxEditor(XDebuggerExpressionComboBox.this.getProject(), XDebuggerExpressionComboBox.this.getEditorsProvider().getFileType()){

                @Override
                protected void onEditorCreate(EditorEx editor) {
                    editor.putUserData(DebuggerCopyPastePreprocessor.REMOVE_NEWLINES_ON_PASTE, true);
                    XDebuggerExpressionComboBox.this.prepareEditor(editor);
                    if (showMultiline) {
                        XDebuggerExpressionComboBox.this.setExpandable(editor);
                    }
                    XDebuggerEditorBase.foldNewLines(editor);
                }
            };
            this.myDelegate.getEditorComponent().setFontInheritedFromLAF(false);
            Object comp = this.myDelegate.getEditorComponent();
            if (languageInside) {
                comp = XDebuggerExpressionComboBox.this.addChooser((JComponent)comp);
            }
            if (showMultiline) {
                comp = XDebuggerExpressionComboBox.this.addExpand((JComponent)comp, true);
            }
            this.myPanel = comp;
        }

        public EditorTextField getEditorTextField() {
            return this.myDelegate.getEditorComponent();
        }

        @Override
        public JComponent getEditorComponent() {
            return this.myPanel;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null) {
                anObject = XExpressionImpl.EMPTY_EXPRESSION;
            }
            XExpression expression = (XExpression)anObject;
            this.myDelegate.getEditorComponent().setNewDocumentAndFileType(XDebuggerExpressionComboBox.this.getFileType(expression), XDebuggerExpressionComboBox.this.createDocument(expression));
        }

        public XExpression getItem() {
            Object document = this.myDelegate.getItem();
            if (document instanceof Document) {
                return XDebuggerExpressionComboBox.this.getEditorsProvider().createExpression(XDebuggerExpressionComboBox.this.getProject(), (Document)document, XDebuggerExpressionComboBox.this.myExpression.getLanguage(), XDebuggerExpressionComboBox.this.myExpression.getMode());
            }
            return null;
        }

        @Override
        public void selectAll() {
            this.myDelegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.myDelegate.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.myDelegate.removeActionListener(l);
        }
    }
}

