/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDeclareIdInCommentAction
implements LocalQuickFix {
    private final String myId;

    public XmlDeclareIdInCommentAction(@NotNull String id) {
        if (id == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(0);
        }
        this.myId = id;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("declare.id.in.comment.quickfix", new Object[0]);
        if (string == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getImplicitlyDeclaredId(@NotNull PsiComment comment) {
        String text;
        if (comment == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(2);
        }
        if ((text = XmlDeclareIdInCommentAction.getUncommentedText(comment)) == null) {
            return null;
        }
        if (text.startsWith("@declare id=\"")) {
            String result2 = text.substring("@declare id=\"".length() - 1);
            return StringUtil.unquoteString((String)result2);
        }
        return null;
    }

    @Nullable
    private static String getUncommentedText(@NotNull PsiComment comment) {
        PsiFile psiFile;
        Language language;
        Commenter commenter;
        if (comment == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(3);
        }
        if ((commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language = (psiFile = comment.getContainingFile()).getViewProvider().getBaseLanguage())) != null) {
            String text = comment.getText();
            String prefix = commenter.getBlockCommentPrefix();
            if (prefix != null && text.startsWith(prefix)) {
                text = text.substring(prefix.length());
                String suffix = commenter.getBlockCommentSuffix();
                if (suffix != null && text.length() > suffix.length()) {
                    return text.substring(0, text.length() - suffix.length()).trim();
                }
            }
        }
        return null;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(5);
        }
        final PsiElement psiElement = descriptor.getPsiElement();
        final PsiFile psiFile = psiElement.getContainingFile();
        new WriteCommandAction(project, new PsiFile[]{psiFile}){

            protected void run(@NotNull Result result2) throws Throwable {
                PsiElement element;
                PsiFile psi;
                XmlTag[] tags;
                XmlTag tag;
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class)) == null) {
                    return;
                }
                Language language = psiFile.getViewProvider().getBaseLanguage();
                Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
                if (commenter == null) {
                    return;
                }
                PsiFile tempFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (FileType)language.getAssociatedFileType(), (CharSequence)(commenter.getBlockCommentPrefix() + "@declare id=\"" + XmlDeclareIdInCommentAction.this.myId + "\"" + commenter.getBlockCommentSuffix() + "\n"));
                XmlTag parent = tag.getParentTag();
                if (parent != null && parent.isValid() && (tags = parent.getSubTags()).length > 0 && (psi = tempFile.getViewProvider().getPsi(language)) != null && (element = psi.findElementAt(1)) instanceof PsiComment) {
                    parent.getNode().addChild(element.getNode(), tags[0].getNode());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xml/util/XmlDeclareIdInCommentAction$1", "run"));
            }
        }.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/XmlDeclareIdInCommentAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/XmlDeclareIdInCommentAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitlyDeclaredId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUncommentedText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

