/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.H2dbExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.H2dbIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;

public class H2dbIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final H2dbIntermediateProvider INSTANCE = new H2dbIntermediateProvider();
    static final Pattern H2DB_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:h2:.+$");
    static final String H2DB_CONNECTION_STRING_EXAMPLE = "jdbc:h2:mem:test";
    private static final String H2DB_DRIVER_CLASS_NAME = "org.h2.Driver";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return H2DB_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver() {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(H2DB_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("H2dbSQL Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return H2db.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return H2DB_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected H2dbIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new H2dbIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, H2dbExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return H2dbExceptionRecognizer.INSTANCE;
    }
}

