/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalMatchingVisitor
extends AbstractMatchingVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor");
    public static final Key<List<? extends PsiElement>> UNMATCHED_ELEMENTS_KEY = Key.create((String)"UnmatchedElements");
    private PsiElement myElement;
    private boolean myResult;
    private MatchContext matchContext;
    private final Map<Language, PsiElementVisitor> myLanguage2MatchingVisitor = new HashMap<Language, PsiElementVisitor>(1);

    public PsiElement getElement() {
        return this.myElement;
    }

    public boolean getResult() {
        return this.myResult;
    }

    @Contract(value="true->true;false->false")
    public boolean setResult(boolean result) {
        this.myResult = result;
        return this.myResult;
    }

    public MatchContext getMatchContext() {
        return this.matchContext;
    }

    @Override
    protected boolean doMatchInAnyOrder(NodeIterator elements, NodeIterator elements2) {
        return this.matchContext.getPattern().getHandler(elements.current()).matchInAnyOrder(elements, elements2, this.matchContext);
    }

    @Override
    @NotNull
    protected NodeFilter getNodeFilter() {
        NodeFilter nodeFilter = LexicalNodesFilter.getInstance();
        if (nodeFilter == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(0);
        }
        return nodeFilter;
    }

    public final boolean handleTypedElement(PsiElement typedElement, PsiElement match) {
        MatchingHandler handler;
        MatchingHandler initialHandler = handler = this.matchContext.getPattern().getHandler(typedElement);
        if (handler instanceof DelegatingHandler) {
            handler = ((DelegatingHandler)((Object)handler)).getDelegate();
        }
        assert (handler instanceof SubstitutionHandler) : handler != null ? handler.getClass() : "null " + (initialHandler != null ? initialHandler.getClass() : "null");
        return ((SubstitutionHandler)handler).handle(match, this.matchContext);
    }

    public boolean allowsAbsenceOfMatch(PsiElement element) {
        MatchingHandler handler = this.getMatchContext().getPattern().getHandler(element);
        return handler instanceof SubstitutionHandler && ((SubstitutionHandler)handler).getMinOccurs() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(PsiElement el1, PsiElement el2) {
        if (el1 == el2) {
            return true;
        }
        if (el1 == null) {
            return true;
        }
        if (el2 == null) {
            return this.allowsAbsenceOfMatch(el1);
        }
        PsiElement prevElement = this.myElement;
        this.myElement = el2;
        try {
            PsiElementVisitor visitor = this.getVisitorForElement(el1);
            if (visitor != null) {
                el1.accept(visitor);
            }
        }
        catch (ClassCastException ex) {
            this.myResult = false;
        }
        finally {
            this.myElement = prevElement;
        }
        return this.myResult;
    }

    @Nullable
    private PsiElementVisitor getVisitorForElement(PsiElement element) {
        Language language = element.getLanguage();
        PsiElementVisitor visitor = this.myLanguage2MatchingVisitor.get(language);
        if (visitor == null) {
            visitor = this.createMatchingVisitor(language);
            this.myLanguage2MatchingVisitor.put(language, visitor);
        }
        return visitor;
    }

    @Nullable
    private PsiElementVisitor createMatchingVisitor(Language language) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByLanguage(language);
        if (profile == null) {
            LOG.warn("there is no StructuralSearchProfile for language " + language.getID());
            return null;
        }
        return profile.createMatchingVisitor(this);
    }

    @Override
    public boolean matchSequentially(NodeIterator nodes, NodeIterator nodes2) {
        if (!nodes.hasNext()) {
            return !nodes2.hasNext();
        }
        return this.matchContext.getPattern().getHandler(nodes.current()).matchSequentially(nodes, nodes2, this.matchContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchContext(NodeIterator elements) {
        if (this.matchContext == null) {
            return;
        }
        CompiledPattern pattern = this.matchContext.getPattern();
        NodeIterator patternNodes = pattern.getNodes().clone();
        MatchResultImpl saveResult = this.matchContext.hasResult() ? this.matchContext.getResult() : null;
        List<PsiElement> saveMatchedNodes = this.matchContext.getMatchedNodes();
        try {
            this.matchContext.setResult(null);
            this.matchContext.setMatchedNodes(null);
            if (!patternNodes.hasNext()) {
                return;
            }
            MatchingHandler firstMatchingHandler = pattern.getHandler(patternNodes.current());
            while (elements.hasNext()) {
                MatchingHandler matchingHandler;
                PsiElement elementNode = elements.current();
                boolean matched = firstMatchingHandler.matchSequentially(patternNodes, elements, this.matchContext);
                if (matched && (matchingHandler = this.matchContext.getPattern().getHandler("__context__")) != null) {
                    matched = ((SubstitutionHandler)matchingHandler).handle(elementNode, this.matchContext);
                }
                List<PsiElement> matchedNodes = this.matchContext.getMatchedNodes();
                if (matched && matchedNodes != null) {
                    this.dispatchMatched(matchedNodes, this.matchContext.getResult());
                }
                this.matchContext.setMatchedNodes(null);
                this.matchContext.setResult(null);
                patternNodes.reset();
                if (matchedNodes != null && !matchedNodes.isEmpty() && matched) {
                    elements.rewind();
                }
                elements.advance();
            }
        }
        finally {
            this.matchContext.setResult(saveResult);
            this.matchContext.setMatchedNodes(saveMatchedNodes);
        }
    }

    private void dispatchMatched(List<PsiElement> matchedNodes, MatchResultImpl result) {
        if (!this.matchContext.getOptions().isResultIsContextMatch() && this.doDispatch(result, result)) {
            return;
        }
        GlobalMatchingVisitor.processNoSubstitutionMatch(matchedNodes, result);
        this.matchContext.getSink().newMatch(result);
    }

    private boolean doDispatch(MatchResult result, MatchResultImpl context) {
        boolean ret = false;
        for (MatchResult r : result.getAllSons()) {
            if (r.isScopeMatch() && !r.isTarget() || r.isMultipleMatch()) {
                ret |= this.doDispatch(r, context);
                continue;
            }
            if (!r.isTarget()) continue;
            ((MatchResultImpl)r).setContext(context);
            this.matchContext.getSink().newMatch(r);
            ret = true;
        }
        return ret;
    }

    private static void processNoSubstitutionMatch(List<PsiElement> matchedNodes, MatchResultImpl result) {
        boolean complexMatch = matchedNodes.size() > 1;
        PsiElement match = matchedNodes.get(0);
        if (!complexMatch) {
            result.setMatchRef(new SmartPsiPointer(match));
            result.setMatchImage(match.getText());
        } else {
            for (PsiElement matchStatement : matchedNodes) {
                result.getMatches().add(new MatchResultImpl("__line__", matchStatement.getText(), new SmartPsiPointer(matchStatement), true));
            }
            result.setMatchRef(new SmartPsiPointer(match));
            result.setMatchImage(match.getText());
            result.setName("__multi_line__");
        }
    }

    public void setMatchContext(MatchContext matchContext) {
        this.matchContext = matchContext;
    }

    @Override
    public boolean isLeftLooseMatching() {
        return this.matchContext.getOptions().isLooseMatching();
    }

    @Override
    public boolean isRightLooseMatching() {
        return false;
    }

    public boolean matchText(@Nullable PsiElement left, @Nullable PsiElement right) {
        if (left == null) {
            return right == null;
        }
        return right != null && this.matchText(left.getText(), right.getText());
    }

    public boolean matchText(String left, String right) {
        return this.matchContext.getOptions().isCaseSensitiveMatch() ? left.equals(right) : left.equalsIgnoreCase(right);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/GlobalMatchingVisitor", "getNodeFilter"));
    }
}

