/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface WordOptimizer {
    default public boolean handleWord(@Nullable String word, CompileContext compileContext) {
        OptimizingSearchHelper searchHelper = compileContext.getSearchHelper();
        if (!searchHelper.doOptimizing()) {
            return false;
        }
        if (word == null) {
            return true;
        }
        CompiledPattern pattern = compileContext.getPattern();
        if (pattern.isTypedVar(word)) {
            SubstitutionHandler handler = (SubstitutionHandler)pattern.getHandler(word);
            if (handler == null || handler.getMinOccurs() == 0) {
                return false;
            }
            RegExpPredicate predicate = handler.findRegExpPredicate();
            if (predicate != null && predicate.couldBeOptimized()) {
                if (handler.isStrictSubtype() || handler.isSubtype()) {
                    List<String> descendants = this.getDescendantsOf(predicate.getRegExp(), handler.isSubtype(), compileContext.getProject());
                    for (String descendant : descendants) {
                        searchHelper.addWordToSearchInCode(descendant);
                    }
                    searchHelper.endTransaction();
                } else {
                    GlobalCompilingVisitor.addFilesToSearchForGivenWord(predicate.getRegExp(), true, GlobalCompilingVisitor.OccurenceKind.CODE, compileContext);
                }
            }
        } else {
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(word, true, GlobalCompilingVisitor.OccurenceKind.CODE, compileContext);
        }
        return true;
    }

    default public List<String> getDescendantsOf(String className, boolean includeSelf, Project project) {
        return Collections.emptyList();
    }
}

