/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssUnknownPropertyInspectionBase
extends CssBaseInspection {
    @NonNls
    public static final Key<CssUnknownPropertyInspectionBase> SHORT_NAME_KEY = Key.create((String)"CssUnknownProperty");
    protected static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.css.inspections.CssUnknownPropertyInspection");
    public boolean myCustomPropertiesEnabled;
    public boolean myIgnoreVendorSpecificProperties;
    public JDOMExternalizableStringList myCustomPropertiesList = new JDOMExternalizableStringList();
    protected JCheckBox myIgnoreVendorSpecificPropertiesCheckBox;
    protected JCheckBox myCheckBox;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.unknown.property", (Object[])new Object[0]);
        if (string == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(1);
        }
        UnknownPropertyVisitor unknownPropertyVisitor = new UnknownPropertyVisitor(holder);
        if (unknownPropertyVisitor == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(2);
        }
        return unknownPropertyVisitor;
    }

    protected String createPropertiesString() {
        return StringUtil.join((Collection)this.myCustomPropertiesList, (String)",");
    }

    public boolean isCustomProperty(@NotNull String property) {
        if (property == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(3);
        }
        return this.myCustomPropertiesList.contains((Object)property.toLowerCase(Locale.US));
    }

    public boolean isIgnoreVendorSpecificProperties() {
        return this.myIgnoreVendorSpecificProperties;
    }

    public boolean isCustomPropertiesEnabled() {
        return this.myCustomPropertiesEnabled;
    }

    public JDOMExternalizableStringList getCustomPropertiesList() {
        return this.myCustomPropertiesList;
    }

    protected void reparseProperties(@NotNull String properties) {
        if (properties == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(4);
        }
        this.myCustomPropertiesList = new JDOMExternalizableStringList();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            this.myCustomPropertiesList.add((Object)tokenizer.nextToken().toLowerCase(Locale.US).trim());
        }
    }

    public void addCustomPropertyName(@NotNull String text) {
        String s;
        if (text == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(5);
        }
        if (!this.isCustomProperty(s = text.trim().toLowerCase(Locale.US))) {
            this.myCustomPropertiesList.add((Object)s);
        }
        if (!this.isCustomPropertiesEnabled()) {
            this.myCustomPropertiesEnabled = true;
        }
    }

    private static LocalQuickFix createUnknownPropertyFix(String postfix) {
        return CssFixFactory.getInstance().cssUnknownPropertyIntentionAction(postfix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCustomProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reparseProperties";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCustomPropertyName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UnknownPropertyVisitor
    extends CssElementVisitor {
        private final ProblemsHolder myHolder;

        public UnknownPropertyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitCssDeclaration(CssDeclaration declaration) {
            if (declaration.isCustomProperty()) {
                return;
            }
            PsiElement propertyNameElement = declaration.getPropertyNameElement();
            if (propertyNameElement == null) {
                return;
            }
            Collection descriptors = declaration.getDescriptors();
            if (!descriptors.isEmpty()) {
                descriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, propertyNameElement, this.myHolder);
                CssInspectionsUtil.filterDescriptorsByMediaTypeAndCheck(descriptors, propertyNameElement, this.myHolder);
                return;
            }
            if (!CssInspectionsUtil.isPureCssPropertyName(propertyNameElement)) {
                return;
            }
            if (!propertyNameElement.getLanguage().isKindOf((Language)CSSLanguage.INSTANCE) || PsiTreeUtil.hasErrorElements((PsiElement)declaration)) {
                return;
            }
            String propertyName = declaration.getPropertyName();
            ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
            boolean reportError = false;
            if (CssPropertyUtil.isVendorSpecificElement(propertyName)) {
                if (!CssUnknownPropertyInspectionBase.this.isIgnoreVendorSpecificProperties()) {
                    quickFixes.add(new CssIgnoreVendorSpecificPropertiesQuickFix());
                    String postfix = CssPropertyUtil.getElementNameWithoutVendorPrefix(propertyName);
                    if (this.isReallyUnknownProperty(declaration, postfix)) {
                        propertyName = postfix;
                        quickFixes.add(CssUnknownPropertyInspectionBase.createUnknownPropertyFix(postfix));
                        reportError = true;
                    } else {
                        reportError = false;
                    }
                }
            } else if (this.isReallyUnknownProperty(declaration, propertyName)) {
                quickFixes.add(CssUnknownPropertyInspectionBase.createUnknownPropertyFix(propertyName));
                reportError = true;
            }
            if (reportError) {
                quickFixes.addAll(CssDescriptorsUtil.getQuickFixesForUnknownProperty((String)propertyName, (PsiElement)declaration, (boolean)this.myHolder.isOnTheFly()));
                this.myHolder.registerProblem(propertyNameElement, CssBundle.message((String)"css.inspections.unknown.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private boolean isReallyUnknownProperty(CssDeclaration declaration, String propertyName) {
            return (!CssUnknownPropertyInspectionBase.this.isCustomPropertiesEnabled() || !CssUnknownPropertyInspectionBase.this.isCustomProperty(propertyName)) && !this.isToIgnore(propertyName, declaration);
        }

        private boolean isToIgnore(String propertyName, CssDeclaration declaration) {
            return propertyName != null && declaration != null && propertyName.equals("src") && CssUtil.isInsideFontFace((PsiElement)declaration);
        }
    }

    private static class CssIgnoreVendorSpecificPropertiesQuickFix
    implements LocalQuickFix {
        private CssIgnoreVendorSpecificPropertiesQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.unknown.vendor.property.fix.name", (Object[])new Object[0]);
            if (string == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            profile.modifyToolSettings(SHORT_NAME_KEY, element, inspection -> {
                inspection.myIgnoreVendorSpecificProperties = true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase$CssIgnoreVendorSpecificPropertiesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase$CssIgnoreVendorSpecificPropertiesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

