/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class CssSimpleSelectorReference
extends PsiPolyVariantCachingReference
implements CssReference {
    private static final InsertHandler<LookupElement> SIMPLE_SELECTOR_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            int offset = context.getStartOffset();
            PsiElement current = context.getFile().findElementAt(offset);
            if (current != null) {
                char completionChar = context.getCompletionChar();
                context.setAddCompletionChar(completionChar == '.' || completionChar == '#' || completionChar == ' ' || completionChar == ',');
            }
        }
    };
    protected final PsiElement myElement;
    private final TextRange myRange;

    public CssSimpleSelectorReference(PsiElement element) {
        this(element, null);
    }

    public CssSimpleSelectorReference(PsiElement element, TextRange range) {
        this.myElement = element;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange != null ? this.myRange : new TextRange(0, this.myElement.getTextLength());
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement.getText();
        String string = this.myRange == null ? text : text.substring(this.myRange.getStartOffset(), this.myRange.getEndOffset());
        if (string == null) {
            CssSimpleSelectorReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        return manipulator == null ? null : manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CssSimpleSelectorReference.$$$reportNull$$$0(1);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        ResolveResult[] results;
        for (ResolveResult result : results = this.multiResolve(false)) {
            if (!this.getElement().getManager().areElementsEquivalent(element, result.getElement())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = ContainerUtil.map2Array((Object[])CssDescriptorsUtil.getSimpleSelectors((PsiElement)this.myElement), name -> CssSimpleSelectorReference.lookup(name));
        if (objectArray == null) {
            CssSimpleSelectorReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"invalid.css.selector", (Object[])new Object[0]);
        if (string == null) {
            CssSimpleSelectorReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected ResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            CssSimpleSelectorReference.$$$reportNull$$$0(4);
        }
        if (CssDescriptorsUtil.isPossibleSelector((String)this.getCanonicalText(), (PsiElement)this.myElement)) {
            CssElementDescriptorProvider provider;
            PsiElement parent = this.myElement.getParent();
            if (parent instanceof CssSimpleSelector && (provider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)this.myElement)) != null) {
                CssSimpleSelector selector = (CssSimpleSelector)parent;
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])provider.getDeclarationsForSimpleSelector(selector));
                if (resolveResultArray == null) {
                    CssSimpleSelectorReference.$$$reportNull$$$0(5);
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(parent)};
            if (resolveResultArray == null) {
                CssSimpleSelectorReference.$$$reportNull$$$0(6);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            CssSimpleSelectorReference.$$$reportNull$$$0(7);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @NotNull
    public static LookupElement lookup(@NotNull String name) {
        if (name == null) {
            CssSimpleSelectorReference.$$$reportNull$$$0(8);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)name).withIcon(AllIcons.Nodes.Tag).withInsertHandler(SIMPLE_SELECTOR_INSERT_HANDLER);
        if (lookupElementBuilder == null) {
            CssSimpleSelectorReference.$$$reportNull$$$0(9);
        }
        return lookupElementBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/CssSimpleSelectorReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/CssSimpleSelectorReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "lookup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lookup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

