/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.jest.JestPkgInfo;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestUtil {
    private static final Logger LOG = Logger.getInstance(JestUtil.class);
    private static final String PACKAGE_NAME = "jest";
    private static Map<String, JestPkgInfo> PKG_INFO_MAP = ContainerUtil.newLinkedHashMap((Pair)Pair.create((Object)"react-scripts-ts", (Object)new JestPkgInfo("scripts/test.js", true)), (Pair[])new Pair[]{Pair.create((Object)"react-super-scripts", (Object)new JestPkgInfo("scripts/test.js", true)), Pair.create((Object)"react-awesome-scripts", (Object)new JestPkgInfo("scripts/test.js", true)), Pair.create((Object)"custom-react-scripts", (Object)new JestPkgInfo("scripts/test.js", true)), Pair.create((Object)"react-scripts", (Object)new JestPkgInfo("scripts/test.js", true)), Pair.create((Object)"jest", (Object)new JestPkgInfo("bin/jest.js", false)), Pair.create((Object)"jest-cli", (Object)new JestPkgInfo("bin/jest.js", false))});
    public static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor(new ArrayList<String>(PKG_INFO_MAP.keySet()), "path to jest, react-scripts (or their alternative) package directory");
    private static final String TAG__CONFIG_FILE = "config-file";
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    private static final String TAG__NODE_OPTIONS = "node-options";
    private static final String KEY__JEST_PACKAGE_DIR = "nodejs.jest.jest_package";
    private static final String TAG__WORKING_DIR = "working-dir";
    private static final String TAG__JEST_OPTIONS = "jest-options";
    private static final String TAG__SCOPE_KIND = "scope-kind";
    private static final String TAG__TEST_FILE = "test-file";
    private static final String TAG__TEST_NAMES = "test-names";
    private static final String TAG__TEST_NAME = "test-name";

    private JestUtil() {
    }

    @NotNull
    public static JestRunSettings readXml(@NotNull Element element) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(0);
        }
        JestRunSettings.Builder builder = JestRunSettings.builder();
        builder.setConfigFilePath(JestUtil.readValue(element, TAG__CONFIG_FILE));
        String interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__NODE_INTERPRETER);
        builder.setInterpreterRef(NodeJsInterpreterRef.create(interpreterRefName));
        builder.setNodeOptions(JestUtil.readValue(element, TAG__NODE_OPTIONS));
        builder.setWorkingDir(JestUtil.readValue(element, TAG__WORKING_DIR));
        builder.setJestOptions(JestUtil.readValue(element, TAG__JEST_OPTIONS));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        JestScopeKind scopeKind = JestUtil.readScopeKind(element);
        builder.setScopeKind(scopeKind);
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            builder.setTestFilePath(JestUtil.readValue(element, TAG__TEST_FILE));
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            builder.setTestNames(JestUtil.readTestNames(element));
        }
        JestRunSettings jestRunSettings = builder.build();
        if (jestRunSettings == null) {
            JestUtil.$$$reportNull$$$0(1);
        }
        return jestRunSettings;
    }

    @NotNull
    private static JestScopeKind readScopeKind(@NotNull Element element) {
        JestScopeKind jestScopeKind;
        if (element == null) {
            JestUtil.$$$reportNull$$$0(2);
        }
        String scopeKindStr = JestUtil.readValue(element, TAG__SCOPE_KIND);
        try {
            jestScopeKind = JestScopeKind.valueOf(scopeKindStr);
        }
        catch (Exception ignored) {
            JestScopeKind jestScopeKind2 = JestScopeKind.ALL;
            if (jestScopeKind2 == null) {
                JestUtil.$$$reportNull$$$0(4);
            }
            return jestScopeKind2;
        }
        if (jestScopeKind == null) {
            JestUtil.$$$reportNull$$$0(3);
        }
        return jestScopeKind;
    }

    @NotNull
    private static String readValue(@NotNull Element element, @NotNull String key) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(5);
        }
        if (key == null) {
            JestUtil.$$$reportNull$$$0(6);
        }
        String string = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)key));
        if (string == null) {
            JestUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static List<String> readTestNames(@NotNull Element parent) {
        Element testNamesElement;
        if (parent == null) {
            JestUtil.$$$reportNull$$$0(8);
        }
        if ((testNamesElement = parent.getChild(TAG__TEST_NAMES)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JestUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TAG__TEST_NAME);
        if (list == null) {
            JestUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static void writeValue(@NotNull Element element, @NotNull String tagName, @Nullable String value) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(11);
        }
        if (tagName == null) {
            JestUtil.$$$reportNull$$$0(12);
        }
        if (value != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)tagName, (String)value);
        }
    }

    public static void writeXml(@NotNull Element element, @NotNull JestRunSettings settings) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            JestUtil.$$$reportNull$$$0(14);
        }
        if (!StringUtil.isEmptyOrSpaces((String)settings.getConfigFileSystemDependentPath())) {
            JestUtil.writeValue(element, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings.getConfigFileSystemDependentPath()));
        }
        JestUtil.writeValue(element, TAG__NODE_INTERPRETER, settings.getInterpreterRef().getReferenceName());
        JestUtil.writeValue(element, TAG__NODE_OPTIONS, settings.getNodeOptions());
        JestUtil.writeValue(element, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDirSystemDependentPath()));
        if (StringUtil.isNotEmpty((String)settings.getJestOptions())) {
            JestUtil.writeValue(element, TAG__JEST_OPTIONS, settings.getJestOptions());
        }
        settings.getEnvData().writeExternal(element);
        JestScopeKind scopeKind = settings.getScopeKind();
        JestUtil.writeValue(element, TAG__SCOPE_KIND, scopeKind.name());
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            JestUtil.writeValue(element, TAG__TEST_FILE, FileUtil.toSystemIndependentName((String)settings.getTestFileSystemDependentPath()));
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            Element testNamesElement = new Element(TAG__TEST_NAMES);
            if (!settings.getTestNames().isEmpty()) {
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TAG__TEST_NAME, settings.getTestNames());
            }
            element.addContent(testNamesElement);
        }
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(15);
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            JestUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    public static boolean isJestConfigFile(@NotNull CharSequence sequence) {
        if (sequence == null) {
            JestUtil.$$$reportNull$$$0(17);
        }
        return StringUtil.equals((CharSequence)"jest.conf.json", (CharSequence)sequence) || StringUtil.equals((CharSequence)"jest.config", (CharSequence)sequence);
    }

    @NotNull
    public static NodePackage getJestPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        NodePackage pkg;
        String packagePath;
        if (project == null) {
            JestUtil.$$$reportNull$$$0(18);
        }
        if ((packagePath = JestUtil.getPackagePath(project)) == null && !(pkg = PKG_DESCRIPTOR.findFirstDirectDependencyPackage(project, interpreter, null)).getSystemIndependentPath().isEmpty()) {
            JestUtil.setPackagePath(project, pkg.getSystemIndependentPath());
            NodePackage nodePackage = pkg;
            if (nodePackage == null) {
                JestUtil.$$$reportNull$$$0(19);
            }
            return nodePackage;
        }
        NodePackage nodePackage = new NodePackage(StringUtil.notNullize((String)packagePath));
        if (nodePackage == null) {
            JestUtil.$$$reportNull$$$0(20);
        }
        return nodePackage;
    }

    public static void setJestPackage(@NotNull Project project, @NotNull NodePackage jestPackage) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(21);
        }
        if (jestPackage == null) {
            JestUtil.$$$reportNull$$$0(22);
        }
        JestUtil.setPackagePath(project, jestPackage.getSystemIndependentPath());
    }

    private static void setPackagePath(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(23);
        }
        if (value == null) {
            JestUtil.$$$reportNull$$$0(24);
        }
        PropertiesComponent.getInstance((Project)project).setValue(KEY__JEST_PACKAGE_DIR, value);
    }

    @Nullable
    private static String getPackagePath(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(25);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(KEY__JEST_PACKAGE_DIR);
    }

    @NotNull
    public static File getJestMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        File bin;
        JestPkgInfo info;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(26);
        }
        if ((info = PKG_INFO_MAP.get(pkg.getName())) != null && (bin = new File(pkg.getSystemDependentPath(), info.getBinFilePath())).isFile()) {
            File file = bin;
            if (file == null) {
                JestUtil.$$$reportNull$$$0(27);
            }
            return file;
        }
        File file = JestUtil.getReactScriptsMainFile(pkg);
        if (file != null) {
            File file2 = file;
            if (file2 == null) {
                JestUtil.$$$reportNull$$$0(28);
            }
            return file2;
        }
        File binFile = pkg.findBinFile();
        if (binFile != null) {
            File file3 = binFile;
            if (file3 == null) {
                JestUtil.$$$reportNull$$$0(29);
            }
            return file3;
        }
        throw new ExecutionException("Cannot find bin file for '" + pkg.getName() + "' package");
    }

    @Nullable
    private static File getReactScriptsMainFile(@NotNull NodePackage pkg) {
        File file;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(30);
        }
        return (file = new File(pkg.getSystemDependentPath(), "scripts/test.js")).isFile() ? file : null;
    }

    @NotNull
    public static String escapeJavaScriptRegexp(@NotNull String str) {
        if (str == null) {
            JestUtil.$$$reportNull$$$0(31);
        }
        String string = JestUtil.escapeJavaScriptRegexp(str, "\\.?*+^$[](){}|");
        if (string == null) {
            JestUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public static String escapeJavaScriptRegexp(@NotNull String str, @NotNull String charsToEscape) {
        if (str == null) {
            JestUtil.$$$reportNull$$$0(33);
        }
        if (charsToEscape == null) {
            JestUtil.$$$reportNull$$$0(34);
        }
        for (int i = 0; i < charsToEscape.length(); ++i) {
            char ch = charsToEscape.charAt(i);
            str = str.replace(String.valueOf(ch), "\\" + ch);
        }
        String string = str;
        if (string == null) {
            JestUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    public static void checkRunConfiguration(@NotNull JestRunConfiguration configuration) throws RuntimeConfigurationException {
        JestRunSettings settings;
        if (configuration == null) {
            JestUtil.$$$reportNull$$$0(36);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(settings = configuration.getRunSettings()).getConfigFileSystemDependentPath())) {
            JestUtil.validatePath(false, "configuration file", settings.getConfigFileSystemDependentPath());
        }
        JestUtil.validatePath(true, "working directory", settings.getWorkingDirSystemDependentPath());
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(configuration.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration(interpreter);
        configuration.getJestPackage().validateForRunConfiguration(PACKAGE_NAME);
        JestUtil.validatePath(true, "working directory", settings.getWorkingDirSystemDependentPath());
        JestScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            JestUtil.validatePath(false, "test file", settings.getTestFileSystemDependentPath());
            if (scopeKind == JestScopeKind.SUITE && settings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified suite name");
            }
            if (scopeKind == JestScopeKind.TEST && settings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified test name");
            }
        }
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String pathLabelName, @Nullable String path) throws RuntimeConfigurationException {
        boolean exists;
        if (pathLabelName == null) {
            JestUtil.$$$reportNull$$$0(37);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + pathLabelName);
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new RuntimeConfigurationError("No such " + pathLabelName);
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            throw new RuntimeConfigurationError("No such " + pathLabelName);
        }
    }

    public static boolean isReactScriptsFamilyPackage(@NotNull NodePackage pkg) {
        JestPkgInfo info;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(38);
        }
        if ((info = PKG_INFO_MAP.get(pkg.getName())) != null) {
            return info.isReactScriptsFamily();
        }
        return JestUtil.getReactScriptsMainFile(pkg) != null;
    }

    public static void emitNewLineToFlushTrailingOutput(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            JestUtil.$$$reportNull$$$0(39);
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final String LINE = "Watch Usage: Press w to show more.";
            private Alarm myAlarm;
            private int myInd = 0;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ProcessOutputType.isStdout((Key)outputType)) {
                    this.disposeAlarm();
                    String text = event.getText();
                    if (LINE.regionMatches(this.myInd, text, 0, text.length())) {
                        this.myInd += text.length();
                        if (this.myInd == LINE.length()) {
                            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
                            alarm.addRequest(() -> {
                                if (processHandler == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                if (outputType == null) {
                                    1.$$$reportNull$$$0(3);
                                }
                                processHandler.notifyTextAvailable("\n", outputType);
                                this.disposeAlarm();
                            }, 100);
                            this.myAlarm = alarm;
                        }
                    } else {
                        this.myInd = 0;
                    }
                }
            }

            private void disposeAlarm() {
                if (this.myAlarm != null) {
                    Disposer.dispose((Disposable)this.myAlarm);
                    this.myAlarm = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processHandler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/jest/JestUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onTextAvailable$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static String getTestFilePathPattern(@NotNull String filePath) {
        block5: {
            String string;
            if (filePath == null) {
                JestUtil.$$$reportNull$$$0(40);
            }
            try {
                Path path = Paths.get(filePath, new String[0]);
                Path realPath = path.toRealPath(new LinkOption[0]);
                String pathStr = path.toString();
                String realPathStr = realPath.toString();
                if (pathStr.equals(realPathStr)) break block5;
                string = JestUtil.createTestPathPattern(pathStr) + "|" + JestUtil.createTestPathPattern(realPathStr);
            }
            catch (IOException | InvalidPathException e) {
                LOG.debug((Throwable)e);
            }
            if (string == null) {
                JestUtil.$$$reportNull$$$0(41);
            }
            return string;
        }
        String string = JestUtil.createTestPathPattern(filePath);
        if (string == null) {
            JestUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private static String createTestPathPattern(@NotNull String testFilePath) {
        if (testFilePath == null) {
            JestUtil.$$$reportNull$$$0(43);
        }
        if (SystemInfo.isWindows) {
            String pattern = "^" + JestUtil.escapeJavaScriptRegexp(testFilePath.replace('\\', '\u0000'), ".") + "$";
            String string = pattern.replace('\u0000', '.');
            if (string == null) {
                JestUtil.$$$reportNull$$$0(44);
            }
            return string;
        }
        String string = "^" + JestUtil.escapeJavaScriptRegexp(testFilePath) + "$";
        if (string == null) {
            JestUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestPackage";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: 
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsToEscape";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathLabelName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readXml";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readScopeKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readTestNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleConfigFilesInProject";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestPackage";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestMainJsFile";
                break;
            }
            case 32: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeJavaScriptRegexp";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFilePathPattern";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestPathPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readXml";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readScopeKind";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readTestNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeXml";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleConfigFilesInProject";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isJestConfigFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJestPackage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setJestPackage";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setPackagePath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getJestMainJsFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getReactScriptsMainFile";
                break;
            }
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "escapeJavaScriptRegexp";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkRunConfiguration";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isReactScriptsFamilyPackage";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "emitNewLineToFlushTrailingOutput";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTestFilePathPattern";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createTestPathPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

