/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeStackTraceFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new NodeStacktraceFinder();
    private final NodeJsCoreLibraryManager myCoreLibraryManager;

    public NodeStackTraceFilter(@NotNull Project project) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(0);
        }
        this(project, (String)null);
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(1);
        }
        this(project, baseDir != null ? baseDir.getAbsolutePath() : null);
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable String baseDir) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(2);
        }
        this(project, NodeStackTraceFilter.findDir((String)baseDir));
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable VirtualFile baseDir) {
        if (project == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(3);
        }
        super(project, baseDir);
        this.myCoreLibraryManager = NodeJsCoreLibraryManager.getInstance(project);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(4);
        }
        List list = FINDER.find(line);
        if (list == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public VirtualFile findFile(@NotNull String filePath) {
        VirtualFile file;
        if (filePath == null) {
            NodeStackTraceFilter.$$$reportNull$$$0(6);
        }
        if ((file = super.findFile(filePath)) == null) {
            file = this.myCoreLibraryManager.findCoreModuleFileByName(FileUtilRt.getNameWithoutExtension((String)filePath));
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeStackTraceFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeStackTraceFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeStacktraceFinder
    implements FileHyperlinkRawDataFinder {
        private static final String BABEL_SYNTAX_ERROR = "SyntaxError:";
        private static final PatternBasedFileHyperlinkRawDataFinder PATTERN_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^(?:\\s*>>)?\\s*at\\s+(.+?):(\\d+)(:\\d+)?\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^(?:\\s*>>)?\\s*at\\s+.*\\((.+?):(\\d+)(:\\d+)?\\)\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        private NodeStacktraceFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            List result2;
            if (line == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(0);
            }
            if (!(result2 = PATTERN_FINDER.find(line)).isEmpty()) {
                List list = result2;
                if (list == null) {
                    NodeStacktraceFinder.$$$reportNull$$$0(1);
                }
                return list;
            }
            FileHyperlinkRawData data = NodeStacktraceFinder.parseAsBabelError(line);
            List list = ContainerUtil.createMaybeSingletonList((Object)data);
            if (list == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        private static FileHyperlinkRawData parseAsBabelError(@NotNull String line) {
            int pathStartInd;
            int syntaxErrorInd;
            if (line == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(3);
            }
            if ((syntaxErrorInd = line.indexOf(BABEL_SYNTAX_ERROR)) == -1) {
                return null;
            }
            if (syntaxErrorInd > 0 && !Character.isWhitespace(line.charAt(syntaxErrorInd - 1))) {
                return null;
            }
            for (pathStartInd = syntaxErrorInd + BABEL_SYNTAX_ERROR.length(); pathStartInd < line.length() && Character.isWhitespace(line.charAt(pathStartInd)); ++pathStartInd) {
            }
            int pathEndInd = line.indexOf(": ", pathStartInd + 1);
            if (pathEndInd == -1) {
                return null;
            }
            while (pathEndInd > 0 && Character.isWhitespace(line.charAt(pathEndInd - 1))) {
                --pathEndInd;
            }
            int columnEndInd = line.lastIndexOf(41);
            if (columnEndInd == -1) {
                return null;
            }
            int columnStartInd = NodeStacktraceFinder.findNumberStartInd(line, columnEndInd);
            if (columnStartInd == -1) {
                return null;
            }
            int lineEndInd = columnStartInd - 1;
            if (line.charAt(lineEndInd) != ':') {
                return null;
            }
            int lineStartInd = NodeStacktraceFinder.findNumberStartInd(line, lineEndInd);
            if (lineStartInd == -1) {
                return null;
            }
            int lineNumber = NodeStacktraceFinder.parseNumber(line, lineStartInd, lineEndInd);
            int columnNumber = NodeStacktraceFinder.parseNumber(line, columnStartInd, columnEndInd);
            if (lineNumber <= 0 || columnNumber <= 0) {
                return null;
            }
            return new FileHyperlinkRawData(line.substring(pathStartInd, pathEndInd), lineNumber - 1, columnNumber - 1, pathStartInd, columnEndInd + 1);
        }

        private static int findNumberStartInd(@NotNull String line, int digitEndInd) {
            int digitStartInd;
            if (line == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(4);
            }
            if ((digitStartInd = digitEndInd - 1) < 0 || !Character.isDigit(line.charAt(digitStartInd))) {
                return -1;
            }
            while (digitStartInd > 0 && Character.isDigit(line.charAt(digitStartInd - 1))) {
                --digitStartInd;
            }
            return digitStartInd;
        }

        private static int parseNumber(@NotNull String line, int startInd, int endInd) {
            if (line == null) {
                NodeStacktraceFinder.$$$reportNull$$$0(5);
            }
            if (startInd < 0 || startInd >= endInd || endInd > line.length()) {
                return -1;
            }
            return StringUtil.parseInt((String)line.substring(startInd, endInd), (int)-1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/NodeStackTraceFilter$NodeStacktraceFinder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "find";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "parseAsBabelError";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findNumberStartInd";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parseNumber";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

