/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.psi.TypeScriptExcludeSourcesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModulesLibraryDirectory {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibraryDirectory.class);
    private static final Set<String> EXCLUDED_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"test", "tests", "spec", "specs", "node_modules"});
    private static final String TYPESCRIPT_DEPENDENCY = "typescript";
    private static final String ANGULAR_SERVICE_DEPENDENCY = "@angular/language-service";
    private final Project myProject;
    private final VirtualFile myNodeModulesDir;
    private final String myLibraryName;
    private final AtomicInteger myLibraryCalcCount;
    private volatile SyntheticLibrary myLibrary;

    public NodeModulesLibraryDirectory(@NotNull Project project, @NotNull VirtualFile nodeModulesDir, @NotNull String libraryName) {
        if (project == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(0);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(2);
        }
        this.myLibraryCalcCount = new AtomicInteger(0);
        this.myProject = project;
        this.myNodeModulesDir = nodeModulesDir;
        this.myLibraryName = libraryName;
    }

    @NotNull
    public VirtualFile getNodeModulesDir() {
        VirtualFile virtualFile = this.myNodeModulesDir;
        if (virtualFile == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public boolean isForApplicationSourceCode() {
        return NodeModulesDirectoryManager.isForApplicationSourceCode(this.myNodeModulesDir);
    }

    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invalidateRoots() {
        this.myLibrary = null;
        this.myLibraryCalcCount.set(0);
    }

    @NotNull
    public SyntheticLibrary getLibrary() {
        SyntheticLibrary library = this.myLibrary;
        if (library == null) {
            this.myLibrary = library = this.createLibrary();
        }
        SyntheticLibrary syntheticLibrary = library;
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(5);
        }
        return syntheticLibrary;
    }

    @NotNull
    private SyntheticLibrary createLibrary() {
        int calcCount = this.myLibraryCalcCount.incrementAndGet();
        if (calcCount > 1) {
            LOG.warn("Concurrent node_modules roots calculation: " + calcCount);
        }
        SyntheticLibrary syntheticLibrary = this.doCreateLibrary();
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(6);
        }
        return syntheticLibrary;
    }

    @NotNull
    private SyntheticLibrary doCreateLibrary() {
        if (!this.myNodeModulesDir.isValid()) {
            LOG.warn("Invalid " + this.myNodeModulesDir.getPath());
            SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(Collections.emptySet());
            if (syntheticLibrary == null) {
                NodeModulesLibraryDirectory.$$$reportNull$$$0(7);
            }
            return syntheticLibrary;
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> excludedRoots = new HashSet<VirtualFile>();
        VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(this.myNodeModulesDir);
        if (packageJson != null && packageJson.isValid()) {
            PackageJsonData data = (PackageJsonData)ProjectLocator.computeWithPreferredProject((VirtualFile)packageJson, (Project)this.myProject, () -> PackageJsonUtil.getOrCreateData(packageJson));
            Set<String> dependencies = data.getAllDependencies();
            for (String dependency : dependencies) {
                VirtualFile dir;
                if (!NodeModulesLibraryDirectory.isDependencyIndexed(data, dependency) || (dir = this.myNodeModulesDir.findFileByRelativePath(dependency)) == null || !dir.isValid() || !dir.isDirectory()) continue;
                roots.add(dir);
                this.collectExcludedRoots(dir, excludedRoots);
            }
            VirtualFile types = this.myNodeModulesDir.findChild("@types");
            if (types != null && types.isValid() && types.isDirectory()) {
                roots.add(types);
            }
            NodeModulesDirectoryManager.getInstance(this.myProject).setProvidedPackageJsonRoots(packageJson, data);
        } else {
            VirtualFile[] children;
            for (VirtualFile child : children = (VirtualFile[])ObjectUtils.notNull((Object)this.myNodeModulesDir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
                String name = child.getName();
                if (name.startsWith(".") || name.startsWith("_")) continue;
                roots.add(child);
                this.collectExcludedRoots(child, excludedRoots);
            }
        }
        Condition<VirtualFile> excludeCondition = this.getExcludeConditionForJSSources(roots);
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(roots, excludedRoots, excludeCondition);
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(8);
        }
        return syntheticLibrary;
    }

    @Nullable
    private Condition<VirtualFile> getExcludeConditionForJSSources(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(9);
        }
        if (!TypeScriptExcludeSourcesUtil.isExcludingJSSourcesEnabled()) {
            return null;
        }
        HashSet excludeForRoots = ContainerUtil.newHashSet();
        for (VirtualFile root : roots) {
            PackageJsonData dependency;
            VirtualFile packageJson;
            if ("@types".equals(root.getName()) || (packageJson = NodeModulesLibraryDirectory.findPackageJsonForDependency(root)) == null || (dependency = this.getPackageJsonDataForDependency(packageJson)) == null || !TypeScriptExcludeSourcesUtil.arePackageSourcesExcluded(this.myProject, dependency)) continue;
            excludeForRoots.add(root);
        }
        if (excludeForRoots.isEmpty()) {
            return null;
        }
        HashSet rootSet = ContainerUtil.newHashSet(roots);
        return file -> {
            VirtualFile parent;
            if (file.isDirectory()) {
                return false;
            }
            String name = file.getName();
            if (!name.endsWith(".js")) {
                return false;
            }
            for (parent = file.getParent(); parent != null && !rootSet.contains(parent); parent = parent.getParent()) {
            }
            return parent != null && excludeForRoots.contains(parent);
        };
    }

    private static boolean isDependencyIndexed(@NotNull PackageJsonData data, @NotNull String dependencyName) {
        if (data == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(10);
        }
        if (dependencyName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(11);
        }
        if (TYPESCRIPT_DEPENDENCY.equals(dependencyName) || ANGULAR_SERVICE_DEPENDENCY.equals(dependencyName)) {
            return data.isDependencyOfAnyTypeExcludeDev(dependencyName);
        }
        return data.isDependencyOfAnyType(dependencyName);
    }

    private void collectExcludedRoots(@NotNull VirtualFile dependency, @NotNull Set<VirtualFile> excludedRoots) {
        VirtualFile[] children;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(12);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(13);
        }
        for (VirtualFile child : children = (VirtualFile[])ObjectUtils.notNull((Object)dependency.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
            String name = child.getName();
            if (!StringUtil.startsWith((CharSequence)name, (CharSequence)".") && !EXCLUDED_NAMES.contains(name)) continue;
            excludedRoots.add(child);
        }
        this.collectExcludedAdditionalMainFiles(dependency, excludedRoots);
    }

    @Nullable
    private PackageJsonData getPackageJsonDataForDependency(@Nullable VirtualFile dependencyPackageJson) {
        if (dependencyPackageJson == null) {
            return null;
        }
        return (PackageJsonData)ProjectLocator.computeWithPreferredProject((VirtualFile)dependencyPackageJson, (Project)this.myProject, () -> PackageJsonUtil.getOrCreateData(dependencyPackageJson));
    }

    @Nullable
    private static VirtualFile findPackageJsonForDependency(@NotNull VirtualFile dependency) {
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(14);
        }
        return PackageJsonUtil.findChildPackageJsonFile(dependency);
    }

    private void collectExcludedAdditionalMainFiles(@NotNull VirtualFile dependency, @NotNull Set<VirtualFile> excludedRoots) {
        PackageJsonData data;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(15);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(16);
        }
        if ((data = this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(dependency))) == null) {
            return;
        }
        Collection<String> additionalMainPaths = data.getAdditionalMains();
        if (additionalMainPaths.isEmpty()) {
            return;
        }
        String preferableMainFile = data.getJsNextMain();
        if (preferableMainFile == null) {
            preferableMainFile = data.getMain();
        }
        if (preferableMainFile == null) {
            return;
        }
        VirtualFile defaultFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, preferableMainFile);
        if (defaultFile == null) {
            return;
        }
        ArrayList modules = ContainerUtil.newArrayListWithCapacity((int)(additionalMainPaths.size() + 1));
        String main = data.getMain();
        if (main != null) {
            modules.add(main);
        }
        modules.addAll(additionalMainPaths);
        for (String mainToExclude : modules) {
            VirtualFile candidateFile;
            if (preferableMainFile.equals(mainToExclude) || StringUtil.isEmptyOrSpaces((String)mainToExclude) || (candidateFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, mainToExclude)) == null || defaultFile.equals(candidateFile) || candidateFile.isDirectory()) continue;
            excludedRoots.add(candidateFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDir";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeConditionForJSSources";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyIndexed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findPackageJsonForDependency";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedAdditionalMainFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

