/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageManagerUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmManager {
    private static final Logger LOG = Logger.getInstance(NpmManager.class);
    private static final String PACKAGE_MANAGER_PACKAGE_REF = "nodejs_package_manager_path";
    private final Project myProject;
    private volatile NodePackageRef myPackageManagerPackageRef;

    public NpmManager(@NotNull Project project) {
        if (project == null) {
            NpmManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public static NpmManager getInstance(@NotNull Project project) {
        if (project == null) {
            NpmManager.$$$reportNull$$$0(1);
        }
        NpmManager npmManager = (NpmManager)ServiceManager.getService((Project)project, NpmManager.class);
        if (npmManager == null) {
            NpmManager.$$$reportNull$$$0(2);
        }
        return npmManager;
    }

    public void setPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NpmManager.$$$reportNull$$$0(3);
        }
        if (NodePackageManagerUtil.isProjectPackageManagerPackageRef(packageRef)) {
            LOG.warn("Project package manager cannot be set to itself");
        }
        this.myPackageManagerPackageRef = packageRef;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue(PACKAGE_MANAGER_PACKAGE_REF, packageRef.getIdentifier());
    }

    @NotNull
    public NodePackageRef getPackageRef() {
        NodePackageRef packageRef = this.myPackageManagerPackageRef;
        if (packageRef == null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String value = propertiesComponent.getValue(PACKAGE_MANAGER_PACKAGE_REF);
            packageRef = StringUtil.isEmpty((String)value) ? this.detectPackageRef() : NodePackageManagerUtil.DESCRIPTOR.createPackageRef(value);
            this.myPackageManagerPackageRef = packageRef;
        }
        NodePackageRef nodePackageRef = packageRef;
        if (nodePackageRef == null) {
            NpmManager.$$$reportNull$$$0(4);
        }
        return nodePackageRef;
    }

    @NotNull
    public NodePackage getPackage() throws ExecutionException {
        NodeJsInterpreter interpreter;
        NodePackageRef ref = this.getPackageRef();
        NodePackage pkg = NodePackageManagerUtil.resolveRef(ref, this.myProject, interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter());
        if (pkg == null) {
            throw new InvalidNpmPackageException(this.myProject, "Cannot find package manager '" + ref.getIdentifier() + "'<p/>Please specify <a href=''>Package Manager</a>.", null);
        }
        NodePackage nodePackage = pkg;
        if (nodePackage == null) {
            NpmManager.$$$reportNull$$$0(5);
        }
        return nodePackage;
    }

    @NotNull
    private NodePackageRef detectPackageRef() {
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null && baseDir.findChild("yarn.lock") != null) {
            NodePackageRef nodePackageRef = NodePackageRef.create("yarn");
            if (nodePackageRef == null) {
                NpmManager.$$$reportNull$$$0(6);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = NodePackageRef.create("npm");
        if (nodePackageRef == null) {
            NpmManager.$$$reportNull$$$0(7);
        }
        return nodePackageRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "detectPackageRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPackageRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidNpmPackageException
    extends ExecutionException
    implements HyperlinkListener {
        private final Project myProject;
        private final Runnable myExtraAction;

        public InvalidNpmPackageException(@NotNull Project project, @NotNull String details, @Nullable Runnable extraAction) {
            if (project == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(0);
            }
            if (details == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(1);
            }
            super(details);
            this.myProject = project;
            this.myExtraAction = extraAction;
        }

        public InvalidNpmPackageException(@NotNull InvalidNpmPackageException e, @NotNull Runnable extraAction) {
            if (e == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(2);
            }
            if (extraAction == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(3);
            }
            this(e.myProject, e.getMessage(), extraAction);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event != null && event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                NodeJSSettingsManager.editSettingsAppropriately(this.myProject);
                if (this.myExtraAction != null) {
                    try {
                        NpmManager.getInstance(this.myProject).getPackage();
                        this.myExtraAction.run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "details";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extraAction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/npm/NpmManager$InvalidNpmPackageException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

