/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateListener;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesVerifier;
import com.intellij.javascript.nodejs.packageJson.PackageJsonGetDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.PackageJsonNotifierConfiguration;
import com.intellij.javascript.nodejs.packageJson.PackageJsonSeveralFilesAction;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang.StringEscapeUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PackageJsonUpdateNotifier", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PackageJsonUpdateNotifier
implements PersistentStateComponent<Element> {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Dependencies from package.json", NotificationDisplayType.STICKY_BALLOON, false, null);
    private static final String PACKAGE_JSON_HREF = "package.json";
    private static final String DISMISSED = "dismissed";
    private static final long MERGING_DELAY_MILLIS = 1000L;
    private final Project myProject;
    private final ProjectFileIndex myFileIndex;
    private final PackageJsonNotifierConfiguration myNotifierConfiguration;
    private final Set<VirtualFile> myDismissedFiles;
    private final Set<VirtualFile> myOpenedPackageJsonFiles;
    private final Map<VirtualFile, Notification> myShownNotifications;
    private final VolatileNotNullLazyValue<Boolean> myNodeInterpreterFound;
    private final Alarm mySchedulingAlarm;
    private final Set<VirtualFile> myScheduledPackageJsonFiles;

    public PackageJsonUpdateNotifier(@NotNull Project project, @NotNull ProjectFileIndex fileIndex, @NotNull PackageJsonNotifierConfiguration notifierConfiguration, @NotNull PackageJsonDependenciesExternalUpdateManager externalUpdateManager) {
        if (project == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(1);
        }
        if (notifierConfiguration == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(2);
        }
        if (externalUpdateManager == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(3);
        }
        this.myDismissedFiles = Collections.synchronizedSet(new HashSet());
        this.myOpenedPackageJsonFiles = Collections.newSetFromMap(new ConcurrentHashMap());
        this.myShownNotifications = ContainerUtil.createWeakValueMap();
        this.myScheduledPackageJsonFiles = new HashSet<VirtualFile>();
        this.myProject = project;
        this.myFileIndex = fileIndex;
        this.myNotifierConfiguration = notifierConfiguration;
        this.myNodeInterpreterFound = VolatileNotNullLazyValue.createValue(() -> {
            NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
            return interpreter != null;
        });
        this.mySchedulingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        externalUpdateManager.addListener(new PackageJsonDependenciesExternalUpdateListener(){

            @Override
            public void externalUpdateStarted(@Nullable VirtualFile packageJson) {
                if (packageJson != null) {
                    PackageJsonUpdateNotifier.this.scheduleProcessing(packageJson);
                }
            }

            @Override
            public void externalUpdateFinished(@Nullable VirtualFile packageJson) {
                if (packageJson != null) {
                    PackageJsonUpdateNotifier.this.scheduleProcessing(packageJson);
                }
            }
        });
    }

    public void onPackageJsonContentChanged(@NotNull VirtualFile packageJson) {
        VirtualFile projectPackageJson;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(4);
        }
        if ((projectPackageJson = this.findProjectPackageJson(packageJson)) != null) {
            this.scheduleProcessing(projectPackageJson);
        }
    }

    public void onPackageJsonAdded(@NotNull VirtualFile packageJson) {
        VirtualFile projectPackageJson;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(5);
        }
        if ((projectPackageJson = this.findProjectPackageJson(packageJson)) != null) {
            this.scheduleProcessing(projectPackageJson);
        }
    }

    public void scheduleProcessing(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(6);
        }
        this.scheduleProcessing(Collections.singleton(packageJson), 1000L);
    }

    @Nullable
    private VirtualFile findProjectPackageJson(@NotNull VirtualFile packageJson) {
        VirtualFile projectPackageJson;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(7);
        }
        if (this.myFileIndex.isInContent(packageJson)) {
            return packageJson;
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(packageJson);
        if (nodeModulesDir != null && (projectPackageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) != null && this.myFileIndex.isInContent(projectPackageJson)) {
            return projectPackageJson;
        }
        return null;
    }

    private void scheduleProcessing(@NotNull Collection<VirtualFile> packageJsonFiles, long delayMillis) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(8);
        }
        ReadAction.run(() -> {
            if (packageJsonFiles == null) {
                PackageJsonUpdateNotifier.$$$reportNull$$$0(28);
            }
            if (!this.myProject.isDisposed()) {
                this.mySchedulingAlarm.cancelAllRequests();
                Set<VirtualFile> set = this.myScheduledPackageJsonFiles;
                synchronized (set) {
                    this.myScheduledPackageJsonFiles.addAll(packageJsonFiles);
                }
                this.mySchedulingAlarm.addRequest(() -> {
                    HashSet<VirtualFile> copy;
                    Set<VirtualFile> set = this.myScheduledPackageJsonFiles;
                    synchronized (set) {
                        copy = new HashSet<VirtualFile>(this.myScheduledPackageJsonFiles);
                        this.myScheduledPackageJsonFiles.clear();
                    }
                    ReadAction.run(() -> this.processPackageJsonFiles(copy));
                }, delayMillis);
            }
        });
    }

    @NotNull
    public static PackageJsonUpdateNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(9);
        }
        PackageJsonUpdateNotifier packageJsonUpdateNotifier = (PackageJsonUpdateNotifier)ServiceManager.getService((Project)project, PackageJsonUpdateNotifier.class);
        if (packageJsonUpdateNotifier == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(10);
        }
        return packageJsonUpdateNotifier;
    }

    public void onProjectOpened() {
        this.myNotifierConfiguration.detectPackageJsonFiles().done(packageJsonFiles -> this.init((List<VirtualFile>)ImmutableList.copyOf((Collection)packageJsonFiles)));
    }

    private void init(@NotNull List<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (packageJsonFiles == null) {
                PackageJsonUpdateNotifier.$$$reportNull$$$0(27);
            }
            List openedPackageJsonFiles = Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()).filter(PackageJsonUtil::isPackageJsonFile).collect(Collectors.toList());
            this.scheduleProcessing(ContainerUtil.union((Collection)packageJsonFiles, openedPackageJsonFiles), 0L);
            this.myOpenedPackageJsonFiles.addAll(openedPackageJsonFiles);
            this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

                public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                    if (source == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (file == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (PackageJsonUtil.isPackageJsonFile(file)) {
                        PackageJsonUpdateNotifier.this.myOpenedPackageJsonFiles.add(file);
                        PackageJsonUpdateNotifier.this.scheduleProcessing(file);
                    }
                }

                public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                    if (source == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (file == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    PackageJsonUpdateNotifier.this.myOpenedPackageJsonFiles.remove(file);
                    if (PackageJsonUtil.isPackageJsonFile(file) && !PackageJsonUpdateNotifier.this.myNotifierConfiguration.isEssential(file)) {
                        PackageJsonUpdateNotifier.this.hideNotificationLater(file);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "source";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fileOpened";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fileClosed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }, this.myProject.getDisposed());
    }

    private void processPackageJsonFiles(@NotNull Set<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return;
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        boolean externalUpdateRunning = PackageJsonDependenciesExternalUpdateManager.getInstance(this.myProject).isExternalUpdateRunning();
        for (VirtualFile file : packageJsonFiles) {
            PackageJsonDependencies deps;
            VirtualFile nodeModulesDir;
            ThreeState enabled = this.isPackageJsonNotificationEnabled(file);
            if (enabled == ThreeState.NO || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file)) == null && !this.myNotifierConfiguration.isEssential(file) && !this.myOpenedPackageJsonFiles.contains(file) || PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)file) || (deps = PackageJsonDependencies.getOrCreate(this.myProject, file)) == null || deps.isEmpty()) continue;
            if (externalUpdateRunning) {
                this.hideNotificationLater(file);
                continue;
            }
            if (PackageJsonUpdateNotifier.isNodeModulesUpdatingExternally(file)) {
                this.hideNotificationLater(file);
                continue;
            }
            if (nodeModulesDir != null) {
                boolean depsMatched = new PackageJsonDependenciesVerifier(this.myProject, file).verify();
                if (depsMatched) {
                    this.hideNotificationLater(file);
                    continue;
                }
                result2.add(file);
                continue;
            }
            result2.add(file);
        }
        if (!result2.isEmpty() && ((Boolean)this.myNodeInterpreterFound.getValue()).booleanValue()) {
            this.showNotification(result2);
        }
    }

    @Nullable
    private ThreeState isPackageJsonNotificationEnabled(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(13);
        }
        if (this.myDismissedFiles.contains(packageJson)) {
            return ThreeState.NO;
        }
        if (!this.isInWebModule(packageJson)) {
            return ThreeState.NO;
        }
        return null;
    }

    private static boolean isNodeModulesUpdatingExternally(@NotNull VirtualFile packageJson) {
        File parent;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(14);
        }
        if ((parent = VfsUtilCore.virtualToIoFile((VirtualFile)packageJson).getParentFile()) == null) {
            return true;
        }
        return new File(parent, "node_modules" + File.separator + ".staging").isDirectory();
    }

    private void showNotification(@NotNull List<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(15);
        }
        if (packageJsonFiles.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (packageJsonFiles == null) {
                PackageJsonUpdateNotifier.$$$reportNull$$$0(26);
            }
            if (packageJsonFiles.size() > 1) {
                Notification notification2 = NOTIFICATION_GROUP.createNotification("Install Dependencies", "From " + packageJsonFiles.size() + " package.json files", NotificationType.INFORMATION, null);
                notification2.addAction((AnAction)new PackageJsonSeveralFilesAction(this.myProject, packageJsonFiles, notification2));
                notification2.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification2));
                notification2.notify(this.myProject);
            } else {
                VirtualFile packageJson = (VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem((List)packageJsonFiles));
                if (this.isNotificationShownFor(packageJson)) {
                    return;
                }
                VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
                String packageJsonPath = JsbtUtil.getRelativePath(this.myProject, packageJson, false);
                if (nodeModulesDir == null) {
                    Notification notification3 = NOTIFICATION_GROUP.createNotification("Install Dependencies", "From " + PackageJsonUpdateNotifier.createLink(PACKAGE_JSON_HREF, packageJsonPath), NotificationType.INFORMATION, (NotificationListener)new MyNotificationListener(packageJson));
                    notification3.addAction((AnAction)new PackageJsonGetDependenciesAction(this.myProject, packageJson, notification3));
                    notification3.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification3));
                    notification3.notify(this.myProject);
                    this.register(packageJson, notification3);
                } else {
                    Notification notification4 = NOTIFICATION_GROUP.createNotification("Update Dependencies", "From " + PackageJsonUpdateNotifier.createLink(PACKAGE_JSON_HREF, packageJsonPath), NotificationType.INFORMATION, (NotificationListener)new MyNotificationListener(packageJson));
                    notification4.addAction((AnAction)new PackageJsonGetDependenciesAction(this.myProject, packageJson, notification4));
                    notification4.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification4));
                    notification4.notify(this.myProject);
                    this.register(packageJson, notification4);
                }
            }
        }, this.myProject.getDisposed());
    }

    private boolean isNotificationShownFor(@NotNull VirtualFile packageJson) {
        Notification notification2;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(16);
        }
        if ((notification2 = this.myShownNotifications.get(packageJson)) != null) {
            Balloon balloon = notification2.getBalloon();
            return balloon != null && !balloon.isDisposed();
        }
        return false;
    }

    private void hideNotificationLater(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Notification notification2;
            if (packageJson == null) {
                PackageJsonUpdateNotifier.$$$reportNull$$$0(25);
            }
            if ((notification2 = this.myShownNotifications.get(packageJson)) != null && !notification2.isExpired()) {
                notification2.expire();
            }
        }, this.myProject.getDisposed());
    }

    private void register(final @NotNull VirtualFile packageJson, @NotNull Notification notification2) {
        Balloon balloon;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(18);
        }
        if (notification2 == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(19);
        }
        if ((balloon = notification2.getBalloon()) != null) {
            this.myShownNotifications.put(packageJson, notification2);
            balloon.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    PackageJsonUpdateNotifier.this.myShownNotifications.remove(packageJson);
                }
            });
        }
    }

    @NotNull
    private static String createLink(@NotNull String href, @NotNull String linkText) {
        if (href == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(20);
        }
        if (linkText == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(21);
        }
        String string = "<a href='" + StringEscapeUtils.escapeXml((String)href) + "'>" + StringEscapeUtils.escapeXml((String)linkText) + "</a>";
        if (string == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(22);
        }
        return string;
    }

    private boolean isInWebModule(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(23);
        }
        if (this.myFileIndex.getContentRootForFile(packageJson, true) == null) {
            return false;
        }
        Module module = this.myFileIndex.getModuleForFile(packageJson, true);
        if (module == null || module.isDisposed() || !ModuleTypeWithWebFeatures.isAvailable((Module)module)) {
            return false;
        }
        VirtualFile file = packageJson;
        while (this.myFileIndex.getModuleForFile(file, true) == module) {
            if (NodeModulesDirectoryManager.isNodeModulesDir(file)) {
                return false;
            }
            file = file.getParent();
        }
        return true;
    }

    @Nullable
    public Element getState() {
        Element root = new Element("root");
        ArrayList paths = ContainerUtil.newArrayList();
        for (VirtualFile file : this.myDismissedFiles) {
            if (!file.isValid()) continue;
            paths.add(file.getPath());
        }
        Collections.sort(paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)DISMISSED, (List)paths);
        return root;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(24);
        }
        List paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)DISMISSED);
        paths = ContainerUtil.newArrayList((Iterable)paths);
        ArrayList<VirtualFile> dismissedFiles = new ArrayList<VirtualFile>();
        for (String path : paths) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null || !file.isValid() || !PackageJsonUtil.isPackageJsonFile(file)) continue;
            dismissedFiles.add(file);
        }
        this.myDismissedFiles.clear();
        this.myDismissedFiles.addAll(dismissedFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notifierConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalUpdateManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "href";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonContentChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonAdded";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scheduleProcessing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findProjectPackageJson";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 10: 
            case 22: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processPackageJsonFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPackageJsonNotificationEnabled";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isNodeModulesUpdatingExternally";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationShownFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hideNotificationLater";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createLink";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInWebModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hideNotificationLater$7";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showNotification$6";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$init$5";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleProcessing$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyNotificationListener
    implements NotificationListener {
        private final VirtualFile myPackageJson;

        public MyNotificationListener(VirtualFile packageJson) {
            if (packageJson == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            this.myPackageJson = packageJson;
        }

        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            FileEditorManager fileManager;
            if (notification2 == null) {
                MyNotificationListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                MyNotificationListener.$$$reportNull$$$0(2);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (fileManager = FileEditorManager.getInstance((Project)PackageJsonUpdateNotifier.this.myProject)) != null && this.myPackageJson.isValid()) {
                fileManager.openFile(this.myPackageJson, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$MyNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PackageJsonDismissAction
    extends DumbAwareAction {
        private final Collection<VirtualFile> myPackageJsonFiles;
        private final Notification myNotification;

        public PackageJsonDismissAction(@NotNull Collection<VirtualFile> packageJsonFiles, Notification notification2) {
            if (packageJsonFiles == null) {
                PackageJsonDismissAction.$$$reportNull$$$0(0);
            }
            if (notification2 == null) {
                PackageJsonDismissAction.$$$reportNull$$$0(1);
            }
            super("Don't ask again");
            this.myPackageJsonFiles = packageJsonFiles;
            this.myNotification = notification2;
        }

        public void actionPerformed(AnActionEvent e) {
            this.execute();
        }

        private void execute() {
            this.myNotification.expire();
            PackageJsonUpdateNotifier.this.myDismissedFiles.addAll(this.myPackageJsonFiles);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageJsonFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonUpdateNotifier$PackageJsonDismissAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

