/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestFileIndexingHandler;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testing.JSTestRunLineMarkersProvider$WhenMappings;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/testing/JSTestRunLineMarkersProvider;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "()V", "getIcon", "Ljavax/swing/Icon;", "elementPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "locationUrl", "", "test", "", "locationPath", "", "intellij.javascript.impl"})
public final class JSTestRunLineMarkersProvider
extends RunLineMarkerContributor {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        AbstractTestFileStructure it$iv$iv;
        AbstractTestFileStructure abstractTestFileStructure;
        AbstractTestFileStructureBuilder it;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!element.isValid()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof JSFile)) {
            psiFile = null;
        }
        JSFile jSFile = (JSFile)psiFile;
        if (jSFile == null) {
            return null;
        }
        JSFile containingFile = jSFile;
        if (!containingFile.isTestFile()) {
            return null;
        }
        if (!JsTestRunConfigurationProducer.isTestRunnerPackageAvailableFor((PsiFile)containingFile)) {
            return null;
        }
        Iterable $receiver$iv = JsTestFileIndexingHandler.getFileStructureBuilders();
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            element$iv$iv = element$iv$iv$iv;
            it = (AbstractTestFileStructureBuilder)element$iv$iv;
            if (it.fetchCachedTestFileStructure(containingFile) == null) continue;
            it$iv$iv = abstractTestFileStructure;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            element$iv$iv = element$iv$iv$iv;
            it = (AbstractTestFileStructure)element$iv$iv;
            if (it.findTestElementPath(element) == null) continue;
            it$iv$iv = abstractTestFileStructure;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterator = $receiver$iv.iterator();
        if (iterator.hasNext()) {
            JsTestElementPath it2;
            Object element$iv = iterator.next();
            JsTestElementPath jsTestElementPath = it2 = (JsTestElementPath)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsTestElementPath, (String)"it");
            return new RunLineMarkerContributor.Info(this.getIcon(jsTestElementPath), ExecutorAction.Companion.getActions$default((ExecutorAction.Companion)ExecutorAction.Companion, (int)0, (int)1, null), RunLineMarkerContributor.RUN_TEST_TOOLTIP_PROVIDER);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Icon getIcon(JsTestElementPath elementPath) {
        Icon icon;
        TestStateInfo.Magnitude magnitude;
        TestStateStorage instance;
        TestStateStorage.Record state;
        boolean test;
        ArrayList<String> locationPath = new ArrayList<String>(elementPath.getSuiteNames());
        boolean bl = test = elementPath.getTestName() != null;
        if (test) {
            locationPath.add(elementPath.getTestName());
        }
        if ((state = (instance = TestStateStorage.getInstance((Project)elementPath.getTestElement().getProject())).getState(this.locationUrl(test, (List<String>)locationPath))) == null) {
            String filePath = FileUtil.toSystemDependentName((String)elementPath.getTestElement().getContainingFile().getVirtualFile().getPath());
            state = instance.getState(this.locationUrl(test, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)filePath), (Iterable)locationPath)));
        }
        TestStateInfo.Magnitude magnitude2 = magnitude = state != null ? TestIconMapper.getMagnitude((int)state.magnitude) : null;
        if (magnitude2 != null) {
            switch (JSTestRunLineMarkersProvider$WhenMappings.$EnumSwitchMapping$0[magnitude2.ordinal()]) {
                case 1: 
                case 2: {
                    Icon icon2 = AllIcons.RunConfigurations.TestState.Red2;
                    icon = icon2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.RunConfigurations.TestState.Red2");
                    return icon;
                }
                case 3: 
                case 4: {
                    Icon icon3 = AllIcons.RunConfigurations.TestState.Green2;
                    icon = icon3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.RunConfigurations.TestState.Green2");
                    return icon;
                }
                case 5: 
                case 6: {
                    Icon icon4 = AllIcons.RunConfigurations.TestState.Yellow2;
                    icon = icon4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.RunConfigurations.TestState.Yellow2");
                    return icon;
                }
            }
        }
        Icon icon5 = !test ? AllIcons.RunConfigurations.TestState.Run_run : AllIcons.RunConfigurations.TestState.Run;
        icon = icon5;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon5, (String)"if (!test) AllIcons.RunC\u2026figurations.TestState.Run");
        return icon;
    }

    private final String locationUrl(boolean test, List<String> locationPath) {
        return (test ? "test://" : "suite://") + EscapeUtils.join((Collection)locationPath, (char)'.');
    }
}

