/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.navigation;

import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFinder
implements TestFinder {
    private static final String[] SUFFIXES = new String[]{"-spec", "_spec", ".spec", "Spec", ".Spec", "-test", "_test", ".test", "Test", ".Test", "-tests", "_tests", ".tests", "Tests", ".Tests"};
    private static final String[] TEST_DIR_NAMES = new String[]{"spec", "test", "specs", "tests", "testSrc", "__tests__"};
    private static final MultiMap<String, String> SRC_EXT_TO_EXTRA_TEST_EXT_MAP = MultiMap.create();
    private static final MultiMap<String, String> TEST_EXT_TO_EXTRA_SRC_EXT_MAP;

    @Nullable
    public PsiElement findSourceElement(@NotNull PsiElement from) {
        if (from == null) {
            JsTestFinder.$$$reportNull$$$0(0);
        }
        return JsTestFinder.getSourceFile(from);
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        PsiFile psiFile;
        VirtualFile file;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = file = (psiFile = JsTestFinder.getSourceFile(element)) != null ? psiFile.getVirtualFile() : null;
        if (file == null || psiFile instanceof JSFile && ((JSFile)psiFile).isTestFile()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JsTestFinder.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<VirtualFile> testFiles = JsTestFinder.findTestFiles(element.getProject(), file);
        List<PsiElement> list = JsTestFinder.toPsiFiles(element.getManager(), testFiles);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> findTestFiles(@NotNull Project project, @NotNull VirtualFile srcFile) {
        Collection extraTestExtensions;
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(4);
        }
        if (srcFile == null) {
            JsTestFinder.$$$reportNull$$$0(5);
        }
        String nameWithoutExtension = srcFile.getNameWithoutExtension();
        String extension = srcFile.getExtension();
        ArrayList result2 = ContainerUtil.newArrayList();
        VirtualFile srcDir = srcFile.getParent();
        if (srcDir == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                JsTestFinder.$$$reportNull$$$0(6);
            }
            return list;
        }
        for (String suffix : SUFFIXES) {
            JsTestFinder.addTestFilesWithSuffixRelative(result2, srcDir, nameWithoutExtension, suffix, extension);
            extraTestExtensions = SRC_EXT_TO_EXTRA_TEST_EXT_MAP.get((Object)extension);
            for (String extraTestExtension : extraTestExtensions) {
                JsTestFinder.addTestFilesWithSuffix(result2, project, nameWithoutExtension, suffix, extraTestExtension);
            }
        }
        if (result2.isEmpty()) {
            for (String suffix : SUFFIXES) {
                JsTestFinder.addTestFilesWithSuffix(result2, project, nameWithoutExtension, suffix, extension);
                extraTestExtensions = SRC_EXT_TO_EXTRA_TEST_EXT_MAP.get((Object)extension);
                for (String extraTestExtension : extraTestExtensions) {
                    JsTestFinder.addTestFilesWithSuffix(result2, project, nameWithoutExtension, suffix, extraTestExtension);
                }
            }
        }
        List<VirtualFile> testFiles = JsTestFinder.findSameNamedFiles(project, srcFile, true);
        result2.addAll(testFiles);
        List<VirtualFile> list = JsTestFinder.sortAndUnique(project, result2, srcFile);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static void addTestFilesWithSuffixRelative(@NotNull List<VirtualFile> result2, @NotNull VirtualFile sourceFileDir, @NotNull String sourceFileNameWithoutExtension, @NotNull String testFileNameSuffix, @Nullable String testFileExtension) {
        if (result2 == null) {
            JsTestFinder.$$$reportNull$$$0(8);
        }
        if (sourceFileDir == null) {
            JsTestFinder.$$$reportNull$$$0(9);
        }
        if (sourceFileNameWithoutExtension == null) {
            JsTestFinder.$$$reportNull$$$0(10);
        }
        if (testFileNameSuffix == null) {
            JsTestFinder.$$$reportNull$$$0(11);
        }
        String testFileName = sourceFileNameWithoutExtension + testFileNameSuffix;
        if (testFileExtension != null) {
            testFileName = testFileName + "." + testFileExtension;
        }
        JsTestFinder.tryAdd(sourceFileDir.findChild(testFileName), result2);
        for (String testDirName : TEST_DIR_NAMES) {
            VirtualFile testDir = sourceFileDir.findChild(testDirName);
            if (testDir == null || !testDir.isValid() || !testDir.isDirectory()) continue;
            JsTestFinder.tryAdd(testDir.findChild(testFileName), result2);
        }
    }

    private static void addTestFilesWithSuffix(@NotNull List<VirtualFile> result2, @NotNull Project project, @NotNull String sourceFileNameWithoutExtension, @NotNull String testFileNameSuffix, @Nullable String testFileExtension) {
        if (result2 == null) {
            JsTestFinder.$$$reportNull$$$0(12);
        }
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(13);
        }
        if (sourceFileNameWithoutExtension == null) {
            JsTestFinder.$$$reportNull$$$0(14);
        }
        if (testFileNameSuffix == null) {
            JsTestFinder.$$$reportNull$$$0(15);
        }
        String testFileName = sourceFileNameWithoutExtension + testFileNameSuffix;
        if (testFileExtension != null) {
            testFileName = testFileName + "." + testFileExtension;
        }
        result2.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)testFileName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
    }

    @NotNull
    private static List<VirtualFile> findSameNamedFiles(@NotNull Project project, @NotNull VirtualFile file, boolean searchForTest) {
        ProjectFileIndex fileIndex;
        VirtualFile contentRoot;
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(16);
        }
        if (file == null) {
            JsTestFinder.$$$reportNull$$$0(17);
        }
        if ((contentRoot = (fileIndex = ProjectFileIndex.getInstance((Project)project)).getContentRootForFile(file, false)) == null || !contentRoot.isValid()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                JsTestFinder.$$$reportNull$$$0(18);
            }
            return list;
        }
        ArrayList path = ContainerUtil.newArrayList();
        for (VirtualFile dir = file.getParent(); dir != null; dir = dir.getParent()) {
            path.add(dir);
            if (contentRoot.equals(dir)) break;
        }
        Collections.reverse(path);
        List result2 = ContainerUtil.newSmartList();
        if (searchForTest) {
            for (int i = 0; i < path.size() - 1; ++i) {
                VirtualFile srcDir = (VirtualFile)path.get(i + 1);
                List<VirtualFile> testDirs = JsTestFinder.findTestDirs((VirtualFile)path.get(i));
                for (VirtualFile testDir : testDirs) {
                    VirtualFile testFile;
                    if (testDir.equals(srcDir) || (testFile = JsTestFinder.findFileWithSameRelativePath(file, srcDir, testDir)) == null) continue;
                    result2.add(testFile);
                }
            }
        } else {
            for (int i = 0; i < path.size() - 1; ++i) {
                VirtualFile testDir = (VirtualFile)path.get(i + 1);
                if (!ArrayUtil.contains((String)testDir.getName(), (String[])TEST_DIR_NAMES)) continue;
                for (VirtualFile child : ((VirtualFile)path.get(i)).getChildren()) {
                    VirtualFile srcFile;
                    if (testDir.equals(child) || (srcFile = JsTestFinder.findFileWithSameRelativePath(file, testDir, child)) == null) continue;
                    result2.add(srcFile);
                }
            }
        }
        List list = result2;
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    private static VirtualFile findFileWithSameRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile oldBaseDir, @NotNull VirtualFile newBaseDir) {
        String relativePath;
        if (file == null) {
            JsTestFinder.$$$reportNull$$$0(20);
        }
        if (oldBaseDir == null) {
            JsTestFinder.$$$reportNull$$$0(21);
        }
        if (newBaseDir == null) {
            JsTestFinder.$$$reportNull$$$0(22);
        }
        return (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)oldBaseDir)) != null ? newBaseDir.findFileByRelativePath(relativePath) : null;
    }

    @NotNull
    private static List<VirtualFile> findTestDirs(@NotNull VirtualFile commonParent) {
        if (commonParent == null) {
            JsTestFinder.$$$reportNull$$$0(23);
        }
        List result2 = ContainerUtil.newSmartList();
        for (String name : TEST_DIR_NAMES) {
            VirtualFile testDir = commonParent.findChild(name);
            if (testDir == null || !testDir.isDirectory() || !testDir.isValid()) continue;
            result2.add(testDir);
        }
        List list = result2;
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        JSFile psiFile;
        VirtualFile file;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(25);
        }
        VirtualFile virtualFile = file = (psiFile = JsTestFinder.getTestFile(element)) != null ? psiFile.getVirtualFile() : null;
        if (file == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JsTestFinder.$$$reportNull$$$0(26);
            }
            return list;
        }
        List<VirtualFile> testFiles = JsTestFinder.findSourceFiles(element.getProject(), file);
        List<PsiElement> list = JsTestFinder.toPsiFiles(element.getManager(), testFiles);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> findSourceFiles(@NotNull Project project, @NotNull VirtualFile testFile) {
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(28);
        }
        if (testFile == null) {
            JsTestFinder.$$$reportNull$$$0(29);
        }
        String nameWithoutExtension = testFile.getNameWithoutExtension();
        String extension = testFile.getExtension();
        ArrayList result2 = ContainerUtil.newArrayList();
        VirtualFile testFileDir = testFile.getParent();
        if (testFileDir == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                JsTestFinder.$$$reportNull$$$0(30);
            }
            return list;
        }
        for (String suffix : SUFFIXES) {
            if (!nameWithoutExtension.endsWith(suffix)) continue;
            String srcName = nameWithoutExtension.substring(0, nameWithoutExtension.length() - suffix.length());
            JsTestFinder.addSourceFilesWithoutSuffixRelative(result2, testFileDir, srcName, extension);
            Collection extraSrcExtensions = TEST_EXT_TO_EXTRA_SRC_EXT_MAP.get((Object)extension);
            for (String extraSrcExtension : extraSrcExtensions) {
                JsTestFinder.addSourceFilesWithoutSuffixRelative(result2, testFileDir, srcName, extraSrcExtension);
            }
        }
        if (result2.isEmpty()) {
            for (String suffix : SUFFIXES) {
                if (!nameWithoutExtension.endsWith(suffix)) continue;
                JsTestFinder.addSourceFilesWithoutSuffix(result2, project, nameWithoutExtension, suffix, extension);
                Collection extraSrcExtensions = TEST_EXT_TO_EXTRA_SRC_EXT_MAP.get((Object)extension);
                for (String extraSrcExtension : extraSrcExtensions) {
                    JsTestFinder.addSourceFilesWithoutSuffix(result2, project, nameWithoutExtension, suffix, extraSrcExtension);
                }
            }
        }
        List<VirtualFile> srcFiles = JsTestFinder.findSameNamedFiles(project, testFile, false);
        result2.addAll(srcFiles);
        List<VirtualFile> list = JsTestFinder.sortAndUnique(project, result2, testFile);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static void addSourceFilesWithoutSuffix(@NotNull List<VirtualFile> result2, @NotNull Project project, @NotNull String testFileNameWithoutExtension, @NotNull String testFileNameSuffix, @Nullable String sourceFileExtension) {
        if (result2 == null) {
            JsTestFinder.$$$reportNull$$$0(32);
        }
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(33);
        }
        if (testFileNameWithoutExtension == null) {
            JsTestFinder.$$$reportNull$$$0(34);
        }
        if (testFileNameSuffix == null) {
            JsTestFinder.$$$reportNull$$$0(35);
        }
        if (testFileNameWithoutExtension.endsWith(testFileNameSuffix)) {
            String srcName = testFileNameWithoutExtension.substring(0, testFileNameWithoutExtension.length() - testFileNameSuffix.length());
            if (sourceFileExtension != null) {
                srcName = srcName + "." + sourceFileExtension;
            }
            result2.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)srcName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        }
    }

    private static void addSourceFilesWithoutSuffixRelative(@NotNull List<VirtualFile> result2, @NotNull VirtualFile testFileDir, @NotNull String srcName, @Nullable String sourceFileExtension) {
        VirtualFile dir;
        if (result2 == null) {
            JsTestFinder.$$$reportNull$$$0(36);
        }
        if (testFileDir == null) {
            JsTestFinder.$$$reportNull$$$0(37);
        }
        if (srcName == null) {
            JsTestFinder.$$$reportNull$$$0(38);
        }
        if (sourceFileExtension != null) {
            srcName = srcName + "." + sourceFileExtension;
        }
        JsTestFinder.tryAdd(testFileDir.findChild(srcName), result2);
        if (ArrayUtil.contains((String)testFileDir.getName(), (String[])TEST_DIR_NAMES) && (dir = testFileDir.getParent()) != null && dir.isValid()) {
            JsTestFinder.tryAdd(dir.findChild(srcName), result2);
        }
    }

    private static void tryAdd(@Nullable VirtualFile file, @NotNull List<VirtualFile> result2) {
        if (result2 == null) {
            JsTestFinder.$$$reportNull$$$0(39);
        }
        if (file != null && file.isValid() && !file.isDirectory()) {
            result2.add(file);
        }
    }

    public boolean isTest(@NotNull PsiElement element) {
        JSFile file;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(40);
        }
        return (file = JsTestFinder.getTestFile(element)) != null && file.isTestFile();
    }

    @Nullable
    private static JSFile getTestFile(@NotNull PsiElement element) {
        JSFile jsFile;
        PsiFile psiFile;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(41);
        }
        if ((psiFile = element.getContainingFile()) != null) {
            psiFile = psiFile.getOriginalFile();
        }
        return (jsFile = (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class)) != null && jsFile.getVirtualFile() != null ? jsFile : null;
    }

    @Nullable
    private static PsiFile getSourceFile(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(42);
        }
        if ((psiFile = element.getContainingFile()) != null) {
            psiFile = psiFile.getOriginalFile();
        }
        if (psiFile == null || psiFile.getVirtualFile() == null) {
            return null;
        }
        return psiFile instanceof JSFile || psiFile.getName().endsWith(".vue") ? psiFile : null;
    }

    @NotNull
    private static List<PsiElement> toPsiFiles(@NotNull PsiManager manager, @NotNull List<VirtualFile> testFiles) {
        if (manager == null) {
            JsTestFinder.$$$reportNull$$$0(43);
        }
        if (testFiles == null) {
            JsTestFinder.$$$reportNull$$$0(44);
        }
        List psiFiles = ContainerUtil.map(testFiles, arg_0 -> ((PsiManager)manager).findFile(arg_0));
        List list = ContainerUtil.filter((Collection)psiFiles, (Condition)Condition.NOT_NULL);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> sortAndUnique(@NotNull Project project, @NotNull Collection<VirtualFile> relatedFiles, @NotNull VirtualFile contextFile) {
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(46);
        }
        if (relatedFiles == null) {
            JsTestFinder.$$$reportNull$$$0(47);
        }
        if (contextFile == null) {
            JsTestFinder.$$$reportNull$$$0(48);
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile contentRoot = fileIndex.getContentRootForFile(contextFile, true);
        List list = ContainerUtil.map((Collection)ContainerUtil.newHashSet(relatedFiles), file -> {
            VirtualFile cr = fileIndex.getContentRootForFile(file, false);
            return new Data((VirtualFile)file, ComparatorUtil.equalsNullable((Object)cr, (Object)contentRoot));
        });
        Collections.sort(list, (d1, d2) -> {
            if (((Data)d1).myFromTheSameContentRoot != ((Data)d2).myFromTheSameContentRoot) {
                return ((Data)d1).myFromTheSameContentRoot ? -1 : 1;
            }
            return ((Data)d1).myFile.getPath().compareTo(((Data)d2).myFile.getPath());
        });
        List list2 = ContainerUtil.map((Collection)list, data -> ((Data)data).myFile);
        if (list2 == null) {
            JsTestFinder.$$$reportNull$$$0(49);
        }
        return list2;
    }

    static {
        SRC_EXT_TO_EXTRA_TEST_EXT_MAP.put((Object)"vue", (Collection)ContainerUtil.newArrayList((Object[])new String[]{"js", "ts"}));
        TEST_EXT_TO_EXTRA_SRC_EXT_MAP = new MultiMap();
        for (Map.Entry entry : SRC_EXT_TO_EXTRA_TEST_EXT_MAP.entrySet()) {
            for (String value : (Collection)entry.getValue()) {
                TEST_EXT_TO_EXTRA_SRC_EXT_MAP.putValue((Object)value, entry.getKey());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 45: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 45: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 25: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/navigation/JsTestFinder";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 28: 
            case 33: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 8: 
            case 12: 
            case 32: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileDir";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileNameWithoutExtension";
                break;
            }
            case 11: 
            case 15: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFileNameSuffix";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBaseDir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBaseDir";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonParent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFileNameWithoutExtension";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFileDir";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFiles";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedFiles";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/navigation/JsTestFinder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findSameNamedFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestDirs";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceFiles";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiFiles";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndUnique";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 45: 
            case 49: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTestFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTestFilesWithSuffixRelative";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTestFilesWithSuffix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSameNamedFiles";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findFileWithSameRelativePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findTestDirs";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFiles";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFilesWithoutSuffix";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFilesWithoutSuffixRelative";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "tryAdd";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTestFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "toPsiFiles";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sortAndUnique";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 45: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Data {
        private final VirtualFile myFile;
        private final boolean myFromTheSameContentRoot;

        public Data(@NotNull VirtualFile file, boolean fromTheSameContentRoot) {
            if (file == null) {
                Data.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.myFromTheSameContentRoot = fromTheSameContentRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testing/navigation/JsTestFinder$Data", "<init>"));
        }
    }
}

