/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ES6ClassMemberCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement parent;
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(1);
        }
        if (!((parent = parameters.getPosition().getParent()) instanceof JSField)) {
            return;
        }
        JSField field = (JSField)parent;
        final JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)field);
        if (containingClass == null) {
            return;
        }
        final HashSet existingMembers = ContainerUtil.newHashSet();
        for (JSElement o : containingClass.getMembers()) {
            String name = o.getName();
            if (name == null) continue;
            existingMembers.add(name);
        }
        final HashMap forCompletion = ContainerUtil.newHashMap();
        final HashMap typeSubstitutors = ContainerUtil.newHashMap();
        TypeScriptUtil.JSClassHierarchyProcessor processor = new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (aClass.isEquivalentTo((PsiElement)containingClass)) {
                    return true;
                }
                for (JSFunction function : aClass.getFunctions()) {
                    JSContext jsContext;
                    String name;
                    if (function.isConstructor() || (name = function.getName()) == null || existingMembers.contains(name) || forCompletion.containsKey(name) || (jsContext = function.getJSContext()) == JSContext.STATIC) continue;
                    forCompletion.put(name, function);
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ecmascript6/completion/ES6ClassMemberCompletionProvider$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSClassUtils.processClassesInHierarchy(containingClass, true, processor);
        forCompletion.values().forEach(el -> {
            if (result2 == null) {
                ES6ClassMemberCompletionProvider.$$$reportNull$$$0(3);
            }
            result2.consume(ES6ClassMemberCompletionProvider.createLookupElement(el));
        });
    }

    private static LookupElement createLookupElement(@NotNull JSElement function) {
        if (function == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(2);
        }
        String name = function.getName();
        assert (name != null);
        return LookupElementBuilder.create((Object)function, (String)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6ClassMemberCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addCompletions$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

