/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.ES6ImportOptimizer;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.intentions.TypeScriptImportAction;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CreateImportUtil {
    private static final TokenSet EXPORT_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});

    public static boolean checkSymbolInFile(@NotNull Project project, @NotNull VirtualFile fileToCheck, @NotNull PsiElement elementToImport, @NotNull PsiElement place) {
        PsiFile possiblePsiFile;
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(0);
        }
        if (fileToCheck == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(1);
        }
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(3);
        }
        if (!((possiblePsiFile = PsiManager.getInstance((Project)project).findFile(fileToCheck)) instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)possiblePsiFile;
        if (!(elementToImport instanceof JSQualifiedNamedElement)) {
            return elementToImport instanceof PsiFile && possiblePsiFile.isEquivalentTo(elementToImport);
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile((PsiFile)file);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return false;
        }
        return ES6CreateImportUtil.resolveSymbolInModule((JSQualifiedNamedElement)elementToImport, place, (JSElement)file) != null;
    }

    @Nullable
    public static ResolveResult resolveSymbolInModule(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place, @NotNull JSElement module) {
        String name;
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(4);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(6);
        }
        if ((name = elementToImport.getQualifiedName()) == null) {
            return null;
        }
        ResolveResult[] results = ES6PsiUtil.resolveSymbolInModule(name, place, module);
        return Arrays.stream(results).filter(el -> el.isValidResult()).filter(el -> {
            if (elementToImport == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(53);
            }
            return elementToImport.isEquivalentTo(el.getElement());
        }).findAny().orElse(null);
    }

    @Nullable
    public static Pair<VirtualFile, VirtualFile> findParentLibraryDirectory(@NotNull Project project, @NotNull VirtualFile dstFile, @NotNull String[] directories) {
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(7);
        }
        if (dstFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(8);
        }
        if (directories == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(9);
        }
        VirtualFile prevDirectory = null;
        VirtualFile prevDirectoryWithPackageJson = null;
        Object[] stopDirs = ProjectRootManager.getInstance((Project)project).getContentRoots();
        for (VirtualFile currentDirectory = dstFile.getParent(); currentDirectory != null; currentDirectory = currentDirectory.getParent()) {
            if (ArrayUtil.contains((String)currentDirectory.getName(), (String[])directories)) {
                VirtualFile module = prevDirectoryWithPackageJson == null ? prevDirectory : prevDirectoryWithPackageJson;
                return Pair.create(module, (Object)currentDirectory);
            }
            if (ArrayUtil.contains((Object)currentDirectory, (Object[])stopDirs)) break;
            if (null != currentDirectory.findChild("package.json")) {
                prevDirectoryWithPackageJson = currentDirectory;
            }
            prevDirectory = currentDirectory;
        }
        return null;
    }

    public static GlobalSearchScope createSymbolToImportSearchScope(final @NotNull Project project, @NotNull PsiElement context) {
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(10);
        }
        if (context == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(11);
        }
        if (DialectDetector.isTypeScript(context)) {
            return TypeScriptAutoImportUtil.createSymbolToImportSearchScope(project, context);
        }
        final ProjectFileIndex instance = ProjectFileIndex.getInstance((Project)project);
        return new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(context)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile(file, project) && !instance.isInLibrary(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$1", "contains"));
            }
        };
    }

    public static boolean isAvailableForImport(@NotNull PsiElement candidate, @NotNull PsiElement context) {
        if (candidate == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(12);
        }
        if (context == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(13);
        }
        return ES6CreateImportUtil.isAvailableForImport(candidate, new JSImportPlaceInfo(context.getOriginalElement()));
    }

    public static ES6ImportAction createImportAction(@Nullable Editor editor, @NotNull PsiElement context, @Nullable String name, @Nullable JSQualifiedNamedElement toImport, @NotNull ES6ImportAction.ImportElementFilter filter) {
        PsiElement module;
        if (context == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(14);
        }
        if (filter == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(15);
        }
        if (DialectDetector.isTypeScript(context)) {
            return new TypeScriptImportAction(editor, context, name, filter);
        }
        if (toImport != null && DialectDetector.isTypeScript((PsiElement)toImport) && (module = ES6PsiUtil.findExternalModule((PsiElement)toImport)) instanceof TypeScriptModule) {
            return new TypeScriptImportAction(editor, context, name, filter);
        }
        return new ES6ImportAction(editor, context, name, filter);
    }

    public static void insertExport(@NotNull JSQualifiedNamedElement elementToImport, @NotNull ES6ImportPsiUtil.ImportExportType type, @NotNull String importedName, @Nullable String exportedName, @NotNull PsiElement place) {
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(16);
        }
        if (type == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(17);
        }
        if (importedName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(18);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSModuleNameInfo moduleNameInfo = ES6CreateImportUtil.getModuleNameInfo(place.getProject(), elementToImport, place);
        if (moduleNameInfo == null) {
            return;
        }
        PsiElement scope = ES6CreateImportUtil.getScopeToAdd(place, true);
        if (scope == null) {
            return;
        }
        ES6ImportPsiUtil.CreateImportExportInfo createInfo = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type, false, false);
        ES6ImportExportDeclaration exportDeclaration = ES6ImportPsiUtil.createImportExport(place, createInfo, moduleNameInfo.getPath());
        if (exportDeclaration == null) {
            return;
        }
        Pair<Boolean, PsiElement> placeForAnchor = ES6ImportPsiUtil.findAnchorToInsert(scope, EXPORT_ELEMENT_TYPES, false);
        ES6CreateImportUtil.insertPsiElementToScope((PsiElement)exportDeclaration, scope, placeForAnchor, null);
    }

    public static void insertExportName(@NotNull ES6ImportPsiUtil.ImportExportType type, @NotNull String importedName, @Nullable String exportedName, @NotNull PsiElement place) {
        PsiElement scope;
        if (type == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(20);
        }
        if (importedName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(21);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(22);
        }
        if ((scope = ES6CreateImportUtil.getScopeToAdd(place, true)) == null) {
            return;
        }
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type, true, false);
        StringBuilder builder = new StringBuilder("export ");
        if (type == ES6ImportPsiUtil.ImportExportType.DEFAULT) {
            builder.append("default ");
        }
        builder.append(info.getRawText(JSCodeStyleSettings.getSettings((PsiElement)place).SPACES_WITHIN_IMPORTS));
        builder.append(JSCodeStyleSettings.getSemicolon((PsiElement)place.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(builder.toString(), place);
        if (importNode == null) {
            return;
        }
        Pair<Boolean, PsiElement> placeForAnchor = ES6ImportPsiUtil.findAnchorToInsert(scope, EXPORT_ELEMENT_TYPES, false);
        ES6CreateImportUtil.insertPsiElementToScope(importNode.getPsi(), scope, placeForAnchor, null);
    }

    public static JSModuleNameInfo getModuleNameInfo(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(23);
        }
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(24);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(25);
        }
        if (DialectDetector.isTypeScript(place)) {
            return ES6CreateImportUtil.getExternalFileModuleName((JSElement)elementToImport, place);
        }
        VirtualFile placeFile = place.getContainingFile().getVirtualFile();
        PsiFile targetPsiFile = elementToImport.getContainingFile();
        VirtualFile targetFile = targetPsiFile.getVirtualFile();
        VirtualFile root = NodeModuleUtil.findMainModuleRoot(project, placeFile);
        if (root == null) {
            return ES6CreateImportUtil.getExternalFileModuleName((PsiElement)elementToImport, targetFile, place);
        }
        return NodeJSModulesSearcher.getModuleInfo(place, root, (PsiElement)elementToImport, elementToImport.getContainingFile());
    }

    public static boolean isAvailableForImport(@NotNull PsiElement candidate, @NotNull JSImportPlaceInfo info) {
        if (candidate == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(26);
        }
        if (info == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(27);
        }
        if (DialectDetector.isTypeScript(info.getPlace()) && DialectDetector.isTypeScript(candidate)) {
            return TypeScriptAutoImportUtil.isAvailableForImport(candidate, info);
        }
        return ES6ImportHandler.isExportedWithNameOrDefault(candidate) && ES6PsiUtil.isExternalModule((PsiElement)candidate.getContainingFile());
    }

    public static void insertImport(@NotNull PsiElement place, @NotNull JSQualifiedNamedElement toImport, @Nullable String importedName) {
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(28);
        }
        if (toImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(29);
        }
        ES6ImportAction action = ES6CreateImportUtil.createImportAction(null, place, importedName, toImport, new ES6ImportAction.ImportElementFilter(){

            @Override
            @NotNull
            public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result2) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                List<JSElement> list = result2;
                if (list == null) {
                    2.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            public boolean isValidContext(@NotNull PsiElement context) {
                if (context == null) {
                    2.$$$reportNull$$$0(3);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "filterByContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "filterByContext";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isValidContext";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        action.executeWithoutPrepare((JSElement)toImport);
    }

    public static PsiElement getExternalModuleScope(@NotNull PsiElement place) {
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(30);
        }
        return ES6CreateImportUtil.getScopeToAdd(place, true);
    }

    @Nullable
    public static PsiElement getScopeToAdd(@NotNull PsiElement place, boolean fromExternalModule) {
        JSEmbeddedContent content;
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(31);
        }
        if (!(place.getContainingFile() instanceof JSFile) && (content = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)place, JSEmbeddedContent.class)) != null) {
            return content;
        }
        if (fromExternalModule) {
            PsiElement module = ES6PsiUtil.findExternalModule(place);
            return module != null ? module : place.getContainingFile();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{PsiFile.class, TypeScriptModule.class});
    }

    public static void insertPsiElementToScope(final @NotNull PsiElement createdPsi, final @NotNull PsiElement scope, final @NotNull Pair<Boolean, PsiElement> placeFor, final @Nullable Editor editor) {
        if (createdPsi == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(33);
        }
        if (placeFor == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final PsiFile file = scope.getContainingFile();
        final Project project = scope.getProject();
        new WriteCommandAction.Simple<Void>(project, JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]), new PsiFile[]{file}){

            protected void run() {
                Boolean addAfter;
                Document document;
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                Document document2 = document = editor != null ? editor.getDocument() : manager.getDocument(file);
                if (document != null) {
                    manager.commitDocument(document);
                }
                if (Boolean.TRUE.equals(addAfter = (Boolean)placeFor.first)) {
                    scope.addAfter(createdPsi, (PsiElement)placeFor.second);
                } else {
                    PsiElement nodeInsertBefore = (PsiElement)placeFor.second;
                    boolean isFirstElement = PsiTreeUtil.skipSiblingsBackward((PsiElement)nodeInsertBefore, (Class[])new Class[]{PsiWhiteSpace.class}) == null;
                    PsiElement added = JSChangeUtil.doAddBefore(scope, createdPsi, nodeInsertBefore);
                    if (isFirstElement) {
                        JSChangeUtil.addWs(scope.getNode(), nodeInsertBefore.getNode(), "\n");
                        if (added.getPrevSibling() == null && scope instanceof JSEmbeddedContent) {
                            JSChangeUtil.addWs(scope.getNode(), added.getNode(), "\n");
                        }
                    }
                }
            }
        }.execute();
    }

    public static void findPlaceAndInsertES6Import(@NotNull PsiElement scope, @NotNull PsiElement created, @NotNull String moduleName, @Nullable Editor editor) {
        if (scope == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(35);
        }
        if (created == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(36);
        }
        if (moduleName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(37);
        }
        Pair<Boolean, PsiElement> anchor = ES6ImportPsiUtil.findPlaceByModuleName(scope, moduleName);
        ES6CreateImportUtil.insertPsiElementToScope(created, scope, anchor, editor);
    }

    public static void findPlaceAndInsertAnyImport(@NotNull PsiElement scope, @NotNull PsiElement created, @Nullable Editor editor) {
        if (scope == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(38);
        }
        if (created == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(39);
        }
        Pair<Boolean, PsiElement> anchor = ES6ImportPsiUtil.findPlaceForImport(scope);
        ES6CreateImportUtil.insertPsiElementToScope(created, scope, anchor, editor);
    }

    public static boolean insertFromClause(final @NotNull ES6ImportDeclaration originalDeclaration, @NotNull String quotedRefText) {
        PsiElement errorCandidate;
        if (originalDeclaration == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(40);
        }
        if (quotedRefText == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(41);
        }
        if ((errorCandidate = originalDeclaration.getLastChild()) instanceof ES6NamedImports) {
            errorCandidate = errorCandidate.getLastChild();
        }
        if (!(errorCandidate instanceof PsiErrorElement)) {
            return false;
        }
        String currentText = originalDeclaration.getText();
        final ASTNode originalNamedImports = originalDeclaration.getNode().findChildByType((IElementType)ES6ElementTypes.NAMED_IMPORTS);
        assert (originalNamedImports != null) : currentText;
        final PsiElement anchor = originalNamedImports.getPsi();
        final boolean hasCloseBrace = currentText.contains("}");
        String newText = currentText + (hasCloseBrace ? "" : "}") + " from " + quotedRefText + JSCodeStyleSettings.getSemicolon((PsiElement)originalDeclaration.getContainingFile());
        Project project = originalDeclaration.getProject();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)originalDeclaration);
        if (dialect == null) {
            return false;
        }
        PsiFile dummy = psiFileFactory.createFileFromText("dummy", (Language)dialect, (CharSequence)newText);
        if (!(dummy.getFirstChild() instanceof ES6ImportDeclaration) || dummy.getChildren().length > 1) {
            Logger.getInstance(ES6CreateImportUtil.class).error("Incorrect new import text", new Attachment[]{new Attachment("newText.txt", newText)});
            return false;
        }
        ES6ImportDeclaration declaration = (ES6ImportDeclaration)dummy.getFirstChild();
        ES6FromClause fromClause = declaration.getFromClause();
        assert (fromClause != null) : newText;
        ASTNode node = declaration.getNode();
        ASTNode importsNode = node.findChildByType((IElementType)ES6ElementTypes.NAMED_IMPORTS);
        assert (importsNode != null) : newText;
        final ASTNode closeBrace = hasCloseBrace ? null : importsNode.findChildByType(JSTokenTypes.RBRACE);
        final PsiElement fromPartStartRange = importsNode.getTreeNext().getPsi();
        assert (fromPartStartRange != null) : newText;
        final PsiElement fromPartEndRange = declaration.getLastChild();
        final PsiElement errorElement = errorCandidate;
        new WriteCommandAction.Simple<Void>(project, "Complete import statement", new PsiFile[]{originalDeclaration.getContainingFile()}){

            protected void run() {
                if (!hasCloseBrace) {
                    assert (closeBrace != null);
                    originalNamedImports.addChild(closeBrace);
                }
                originalDeclaration.addRangeAfter(fromPartStartRange, fromPartEndRange, anchor);
                errorElement.delete();
            }
        }.execute();
        return true;
    }

    @Nullable
    public static JSModuleNameInfo getExactExternalFileModuleName(@NotNull PsiElement place, @NotNull VirtualFile dstFile, @Nullable TypeScriptConfig configFile) {
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(42);
        }
        if (dstFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(43);
        }
        JSImportPathBuilder builder = JSImportPathBuilder.createBuilder(place, null, dstFile, configFile);
        Ref ref = Ref.create();
        Processor<JSModuleNameInfo> processor = JSImportPathBuilder.createSearchProcessor((Ref<JSModuleNameInfo>)ref, ArrayUtil.EMPTY_STRING_ARRAY);
        builder.processDirectModuleNames(false, processor);
        return (JSModuleNameInfo)ref.get();
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(44);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(45);
        }
        PsiFile originalFile = elementToImport.getContainingFile().getOriginalFile();
        return ES6CreateImportUtil.getExternalFileModuleName((PsiElement)elementToImport, originalFile.getVirtualFile(), place);
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@Nullable PsiElement elementToImport, @NotNull VirtualFile dstFile, @NotNull PsiElement place) {
        if (dstFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(46);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(47);
        }
        JSImportPathBuilder builder = JSImportPathBuilder.createBuilder(place, elementToImport, dstFile);
        return ES6CreateImportUtil.getExternalFileModuleName(builder);
    }

    public static JSModuleNameInfo getExternalFileModuleName(@NotNull JSImportPathBuilder builder) {
        if (builder == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(48);
        }
        Ref ref = Ref.create();
        String[] excludedNames = JSCodeStyleSettings.getSettings(builder.myPlace).getBlacklistImports();
        builder.processModuleNames(JSImportPathBuilder.createSearchProcessor((Ref<JSModuleNameInfo>)ref, excludedNames));
        return (JSModuleNameInfo)ref.get();
    }

    public static void addRequiredImports(@NotNull Collection<ES6ReferenceExpressionsInfo> infos, @NotNull Condition<PsiElement> isMovedCondition, @NotNull PsiElement destinationModule) {
        if (infos == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(49);
        }
        if (isMovedCondition == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(50);
        }
        if (destinationModule == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(51);
        }
        PsiElement destinationPlace = (PsiElement)ObjectUtils.coalesce((Object)destinationModule.getFirstChild(), (Object)destinationModule);
        for (ES6ReferenceExpressionsInfo info : infos) {
            Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports = info.getReferencedImports();
            for (Map.Entry<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> entry : imports.entrySet()) {
                JSElement assignmentElement;
                ES6ImportPsiUtil.CreateImportExportInfo createInfo = entry.getKey();
                PsiElement element = entry.getValue();
                PsiElement module = ES6PsiUtil.findExternalModule(element);
                if (destinationModule.isEquivalentTo(module)) continue;
                if (element instanceof JSExportAssignment && (assignmentElement = ((JSExportAssignment)element).getStubSafeElement()) != null) {
                    element = assignmentElement;
                }
                String name = (String)ObjectUtils.coalesce((Object)createInfo.getImportedName(), (Object)createInfo.getExportedName());
                if (element instanceof JSQualifiedNamedElement) {
                    ES6CreateImportUtil.insertImport(destinationPlace, (JSQualifiedNamedElement)element, name);
                    continue;
                }
                ES6ImportPsiUtil.insertJSImport(destinationPlace, createInfo, element, null);
            }
            for (PsiElement element : info.getExportedLocalReferencedElements()) {
                if (isMovedCondition.value((Object)element) || !(element instanceof JSQualifiedNamedElement)) continue;
                JSQualifiedNamedElement qualifiedNamedElement = (JSQualifiedNamedElement)element;
                ES6CreateImportUtil.insertImport(destinationPlace, qualifiedNamedElement, qualifiedNamedElement.getName());
            }
        }
    }

    public static void optimizeImports(@NotNull PsiElement toOptimize) {
        if (toOptimize == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(52);
        }
        PsiFile file = toOptimize.getContainingFile();
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file);
        for (ImportOptimizer optimizer : optimizers) {
            if (!optimizer.supports(file)) continue;
            optimizer.processFile(file).run();
            return;
        }
        new ES6ImportOptimizer().processFile(file).run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCheck";
                break;
            }
            case 2: 
            case 4: 
            case 16: 
            case 24: 
            case 44: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 3: 
            case 5: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 42: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdPsi";
                break;
            }
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFor";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDeclaration";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedRefText";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isMovedCondition";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationModule";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toOptimize";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSymbolInFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveSymbolInModule";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentLibraryDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createSymbolToImportSearchScope";
                break;
            }
            case 12: 
            case 13: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForImport";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createImportAction";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "insertExport";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "insertExportName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleNameInfo";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "insertImport";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "getExternalModuleScope";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "getScopeToAdd";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "insertPsiElementToScope";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "findPlaceAndInsertES6Import";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "findPlaceAndInsertAnyImport";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "insertFromClause";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "getExactExternalFileModuleName";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "getExternalFileModuleName";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "addRequiredImports";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "optimizeImports";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$resolveSymbolInModule$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

