/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.resolve.processors.JSCandidateResultProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessorBase;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PsiUtil {
    public static final int TAGGED_TEMPLATE_IMPLICIT_PARAMETERS_COUNT = 1;
    public static final TokenSet DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});
    public static final String DEFAULT_NAME = "default";

    @NotNull
    public static Collection<PsiElement> getBindingAllPossibleExports(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            ES6PsiUtil.$$$reportNull$$$0(0);
        }
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new PsiElement[]{assignment});
            if (arrayList == null) {
                ES6PsiUtil.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        Collection<PsiElement> collection = elements;
        if (collection == null) {
            ES6PsiUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Nullable
    public static JSElement findDefaultExport(@NotNull PsiElement scopeElement) {
        Stream<? extends PsiElement> stream;
        Optional<? extends PsiElement> exportDefaultAssignment;
        if (scopeElement == null) {
            ES6PsiUtil.$$$reportNull$$$0(3);
        }
        if ((exportDefaultAssignment = (stream = JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream(scopeElement, ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, ES6ExportDefaultAssignment.class)).findAny()).isPresent()) {
            PsiElement element = exportDefaultAssignment.get();
            return element instanceof JSElement ? (JSElement)element : null;
        }
        final Ref resultElement = Ref.create();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(DEFAULT_NAME){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof ES6ExportSpecifierAlias || element instanceof ES6ExportSpecifier || element instanceof ES6ExportedDefaultBinding) {
                    resultElement.set((Object)element);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(scopeElement, processor, false);
        PsiElement result2 = (PsiElement)resultElement.get();
        if (!(result2 instanceof JSElement)) {
            return null;
        }
        if (result2 instanceof ES6ExportSpecifier) {
            ResolveResult[] resultResultsForSpecifier = ((ES6ExportSpecifier)result2).multiResolve(false);
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(resultResultsForSpecifier));
            return item instanceof JSElement ? (JSElement)item : null;
        }
        return (JSElement)result2;
    }

    public static boolean isAsyncContext(@Nullable JSFunction function) {
        return JSPsiImplUtils.hasModifier((JSAttributeListOwner)function, JSAttributeList.ModifierType.ASYNC);
    }

    @Contract(value="null -> false")
    public static boolean isAwaitExpression(@Nullable PsiElement expression) {
        JSPrefixExpression prefixExpression;
        JSPrefixExpression jSPrefixExpression = prefixExpression = expression instanceof JSPrefixExpression ? (JSPrefixExpression)expression : null;
        if (prefixExpression != null) {
            return prefixExpression.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
        }
        return false;
    }

    public static boolean isGeneratorContext(@Nullable JSFunction parent) {
        if (parent != null) {
            return parent.isGenerator();
        }
        return false;
    }

    public static boolean processExportAllDeclarations(@NotNull JSElement owner, @NotNull JSModuleElementsProcessor processor, Collection<PsiElement> visited) {
        if (owner == null) {
            ES6PsiUtil.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(5);
        }
        if (!ES6PsiUtil.isExternalModule((PsiElement)owner)) {
            return true;
        }
        PsiElement[] children = JSStubBasedPsiTreeUtil.getChildrenByType(owner, DECLARATIONS);
        if (children == null) {
            return true;
        }
        for (PsiElement child : children) {
            ES6FromClause clause;
            ES6ExportDeclaration declaration;
            if (!(child instanceof ES6ExportDeclaration) || !(declaration = (ES6ExportDeclaration)child).isExportAll() || (clause = declaration.getFromClause()) == null) continue;
            Collection<PsiElement> elements = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement element : elements) {
                if (!(element instanceof JSElement) || element.isEquivalentTo((PsiElement)owner)) continue;
                if (visited == null) {
                    visited = ContainerUtil.newHashSet();
                }
                ES6PsiUtil.processExportDeclarationInScope((JSElement)element, processor, null, visited);
            }
        }
        return true;
    }

    private static Collection<PsiElement> getFromClauseResolvedReferences(@NotNull ES6FromClause clause) {
        if (clause == null) {
            ES6PsiUtil.$$$reportNull$$$0(6);
        }
        Collection elements = clause.resolveReferencedElements();
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) {
                result2.add(element);
                continue;
            }
            String name = assignment.getInitializerReference();
            if (name == null) continue;
            JSTypeResolveResult typeResolveResult = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)assignment);
            result2.addAll(typeResolveResult.getElements());
        }
        return result2;
    }

    @NotNull
    public static ResolveResult[] resolveDefaultExport(@Nullable ES6ImportExportDeclaration declaration) {
        ES6FromClause clause = declaration != null ? declaration.getFromClause() : null;
        Collection scopes = clause != null ? clause.resolveReferencedElements() : ContainerUtil.emptyList();
        ResolveResult[] resolveResultArray = ES6PsiUtil.resolveDefaultExport(scopes);
        if (resolveResultArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    @NotNull
    private static ResolveResult[] resolveDefaultExport(@NotNull Collection<PsiElement> scopes) {
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(8);
        }
        for (PsiElement element : scopes) {
            JSElement defaultExport;
            if (!(element instanceof JSElement) || (defaultExport = ES6PsiUtil.findDefaultExport(element)) == null) continue;
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)defaultExport)};
            if (resolveResultArray == null) {
                ES6PsiUtil.$$$reportNull$$$0(9);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            ES6PsiUtil.$$$reportNull$$$0(10);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @NotNull
    public static ResolveResult[] resolveSymbolInModule(@NotNull String name, @NotNull PsiElement context, @NotNull JSElement scope) {
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ES6PsiUtil.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            ES6PsiUtil.$$$reportNull$$$0(13);
        }
        ResolveResult[] resolveResultArray = ES6PsiUtil.resolveSymbolInModules(name, context, ContainerUtil.list((Object[])new PsiElement[]{scope}));
        if (resolveResultArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(14);
        }
        return resolveResultArray;
    }

    @NotNull
    private static ResolveResult[] resolveSymbolInModules(@NotNull String name, @NotNull PsiElement context, @NotNull Collection<PsiElement> scopes) {
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            ES6PsiUtil.$$$reportNull$$$0(16);
        }
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(17);
        }
        if (StringUtil.equals((CharSequence)name, (CharSequence)DEFAULT_NAME)) {
            ResolveResult[] resolveResultArray = ES6PsiUtil.resolveDefaultExport(scopes);
            if (resolveResultArray == null) {
                ES6PsiUtil.$$$reportNull$$$0(18);
            }
            return resolveResultArray;
        }
        ResolveResultSink sink = new ResolveResultSink(context, name, true);
        List<JSType> aliases = ES6PsiUtil.processExportedSymbols(context, scopes, sink);
        ResolveResult[] results = sink.getResultsAsResolveResults();
        ResolveResult[] resolveResultArray = Arrays.stream(results).noneMatch(ResolveResult::isValidResult) && !aliases.isEmpty() ? ES6PsiUtil.resolveWithAliases(name, context, aliases) : results;
        if (resolveResultArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(19);
        }
        return resolveResultArray;
    }

    @NotNull
    public static ResolveResult[] resolveSymbolForSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(20);
        }
        String name = specifier.getReferenceName();
        ES6ImportExportDeclaration declaration = specifier.getDeclaration();
        if (name == null || declaration == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(21);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause != null) {
            ResolveResult[] resolveResultArray = ES6PsiUtil.resolveSymbolInModules(name, (PsiElement)specifier, ES6PsiUtil.getFromClauseResolvedReferences(clause));
            if (resolveResultArray == null) {
                ES6PsiUtil.$$$reportNull$$$0(22);
            }
            return resolveResultArray;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)specifier, name, true);
        ES6PsiUtil.processSpecifier(specifier, sink);
        ResolveResult[] resolveResultArray = sink.getResultsAsResolveResults();
        if (resolveResultArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(23);
        }
        return resolveResultArray;
    }

    @NotNull
    public static List<JSType> processSpecifier(@NotNull ES6ImportExportSpecifier specifier, @NotNull ResultSink sink) {
        JSElement scope;
        ES6ImportExportDeclaration declaration;
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(24);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(25);
        }
        if ((declaration = specifier.getDeclaration()) == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(26);
            }
            return list;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause != null) {
            List<JSType> list = ES6PsiUtil.processExportedSymbols((PsiElement)specifier, ES6PsiUtil.getFromClauseResolvedReferences(clause), sink);
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(27);
            }
            return list;
        }
        if (specifier instanceof ES6ExportSpecifier && (scope = ES6PsiUtil.getExportScope((PsiElement)specifier)) != null) {
            final QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor((PsiElement)specifier, (PsiElement)scope, sink);
            JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor.getName()){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (element instanceof ES6ExportSpecifier || element instanceof ES6ExportSpecifierAlias) {
                        return true;
                    }
                    return processor.execute(element, state);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, delegatingProcessor, false);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ES6PsiUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static List<JSType> processExportedSymbols(@NotNull PsiElement context, @NotNull Collection<PsiElement> scopes, @NotNull ResultSink sink) {
        if (context == null) {
            ES6PsiUtil.$$$reportNull$$$0(29);
        }
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(30);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(31);
        }
        List<JSType> innerAliases = null;
        for (PsiElement scope : scopes) {
            QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor(context, scope, sink);
            JSDelegatingModuleElementsProcessor delegatingProcessor = new JSDelegatingModuleElementsProcessor(processor);
            ES6PsiUtil.processSpecifierForScope(delegatingProcessor, scope);
            innerAliases = delegatingProcessor.getInnerAliases();
        }
        List<JSType> list = innerAliases != null ? innerAliases : Collections.emptyList();
        if (list == null) {
            ES6PsiUtil.$$$reportNull$$$0(32);
        }
        return list;
    }

    private static void processSpecifierForScope(@NotNull JSModuleElementsProcessor processor, PsiElement scope) {
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(33);
        }
        if (!(scope instanceof JSElement)) {
            return;
        }
        if (scope instanceof JSVariable) {
            JSType possibleType = ((JSVariable)scope).getType();
            if (possibleType != null) {
                processor.process(possibleType, new JSEvaluateContext(scope.getContainingFile()), scope);
            }
        } else {
            ES6PsiUtil.processExportDeclarationInScope((JSElement)scope, processor);
        }
    }

    private static QualifiedItemProcessor<?> createSpecifierResolveProcessor(@NotNull PsiElement context, @NotNull PsiElement scope, @NotNull ResultSink sink) {
        if (context == null) {
            ES6PsiUtil.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            ES6PsiUtil.$$$reportNull$$$0(35);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(36);
        }
        QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement(scope).createCompletionItemProcessor(sink, context.getContainingFile());
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.setSkipImplicitDeclarations(true);
        return processor;
    }

    public static void addInnerAliases(@NotNull List<JSType> innerAliases, @NotNull BaseJSSymbolProcessor processor) {
        if (innerAliases == null) {
            ES6PsiUtil.$$$reportNull$$$0(37);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(38);
        }
        for (JSType type : innerAliases) {
            if (!(type instanceof JSNamespace)) continue;
            PsiFile scope = type.getSource().getScope();
            processor.addTypeHierarchy((JSNamespace)type, (PsiElement)scope);
        }
    }

    @Nullable
    public static JSElement getExportScope(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(39);
        }
        return element instanceof PsiFile || ES6PsiUtil.isEmbeddedBlock(element) ? null : ES6PsiUtil.getNonStrictExportScope(element.getContext());
    }

    @Nullable
    public static JSElement getNonStrictExportScope(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Ref ref = new Ref();
        PsiTreeUtil.findFirstContext((PsiElement)element, (boolean)false, scope -> {
            if (scope instanceof TypeScriptModule || scope instanceof JSFile || ES6PsiUtil.isEmbeddedBlock(scope)) {
                ref.set((Object)((JSElement)scope));
            }
            return !ref.isNull();
        });
        return (JSElement)ref.get();
    }

    public static boolean isEmbeddedBlock(@Nullable PsiElement scope) {
        return scope instanceof JSEmbeddedContent && JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(((JSEmbeddedContent)scope).getElementType());
    }

    public static boolean isEmbeddedModule(@Nullable PsiElement scope) {
        return scope instanceof JSEmbeddedContent && JSExtendedLanguagesTokenSetProvider.MODULE_EMBEDDED_CONTENTS.contains(((JSEmbeddedContent)scope).getElementType());
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull JSModuleElementsProcessor processor) {
        if (scope == null) {
            ES6PsiUtil.$$$reportNull$$$0(40);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(41);
        }
        return ES6PsiUtil.processExportDeclarationInScope(scope, processor, null, null);
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull JSModuleElementsProcessor processor, @Nullable JSEvaluationResultContext evaluateContext, @Nullable Collection<PsiElement> visited) {
        boolean isES6Module;
        if (scope == null) {
            ES6PsiUtil.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(43);
        }
        if (visited != null && !visited.add((PsiElement)scope)) {
            return true;
        }
        ProgressManager.checkCanceled();
        boolean hasIncompleteMatch = false;
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)scope);
        if (scope instanceof JSFile && !isTypeScript && ES6PsiUtil.isAcceptableContext(evaluateContext)) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)((JSFile)scope));
            QualifiedItemProcessor resolveProcessor = processor instanceof ResolveProcessor ? (QualifiedItemProcessor)processor : (processor instanceof JSDelegatingModuleElementsProcessor ? ((JSDelegatingModuleElementsProcessor)processor).myDelegate : null);
            boolean processingFromIndices = false;
            if (resolveProcessor != null) {
                processingFromIndices = resolveProcessor.isProcessingFromIndices();
                resolveProcessor.setSkipImplicitDeclarations(true);
            }
            Processor namespaceMembersProcessor = element -> {
                if (processor == null) {
                    ES6PsiUtil.$$$reportNull$$$0(59);
                }
                if (resolveProcessor != null && resolveProcessor.getName() == null && (element.getAccessType() == JSAttributeList.AccessType.PRIVATE || JSVisibilityUtil.seemsToBePrivateSymbol(element.getName()))) {
                    return true;
                }
                return processor.execute((PsiElement)element, ResolveState.initial());
            };
            JSClassResolver.getInstance().processNamespaceMembers("exports", fileScope, true, (Processor<JSPsiElementBase>)namespaceMembersProcessor);
            JSClassResolver.getInstance().processNamespaceMembers("module.exports", fileScope, true, (Processor<JSPsiElementBase>)namespaceMembersProcessor);
            if (resolveProcessor != null) {
                resolveProcessor.setSkipImplicitDeclarations(processingFromIndices);
            }
        }
        if (scope instanceof JSFile && !isTypeScript) {
            JSType exportsInnerAlias = ((JSFile)scope).getExportsInnerAlias();
            if (exportsInnerAlias != null) {
                if (visited == null) {
                    visited = ContainerUtil.newHashSet();
                }
                HashSet _visited = visited;
                JSApplyContextUtil.applyTypeToContext(exportsInnerAlias, evaluateContext, (newType, newContext) -> {
                    if (scope == null) {
                        ES6PsiUtil.$$$reportNull$$$0(55);
                    }
                    if (processor == null) {
                        ES6PsiUtil.$$$reportNull$$$0(56);
                    }
                    JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)typeComponent -> {
                        if (scope == null) {
                            ES6PsiUtil.$$$reportNull$$$0(57);
                        }
                        if (processor == null) {
                            ES6PsiUtil.$$$reportNull$$$0(58);
                        }
                        if (typeComponent instanceof JSRequireCallExpressionType) {
                            String referencedModule = ((JSRequireCallExpressionType)((Object)((Object)typeComponent))).getReferencedModule();
                            Collection<PsiElement> reexportedModules = JSFileReferencesUtil.resolveModuleReference((PsiFile)((JSFile)scope), referencedModule);
                            for (PsiElement reexportedModule : reexportedModules) {
                                if (!(reexportedModule instanceof JSElement)) continue;
                                ES6PsiUtil.processExportDeclarationInScope((JSElement)reexportedModule, processor, newContext, _visited);
                            }
                        }
                        return true;
                    }), newType);
                });
                JSEvaluateContext context = evaluateContext != null ? JSEvaluateContext.fromEvaluationResultContext(evaluateContext) : new JSEvaluateContext((PsiFile)scope);
                processor.process(exportsInnerAlias, context, (PsiElement)scope);
            }
            hasIncompleteMatch = exportsInnerAlias != null || !((JSFile)scope).hasES6Syntax();
        }
        ES6ExportedElementsProcessor exportedElementsProcessor = processor instanceof ES6ExportedElementsProcessor ? (ES6ExportedElementsProcessor)((Object)processor) : new ES6ExportedElementsProcessor(processor);
        boolean bl = isES6Module = isTypeScript || scope instanceof TypeScriptModule || scope instanceof JSFile && ((JSFile)scope).hasES6Syntax();
        if (isES6Module && ES6PsiUtil.isAcceptableContext(evaluateContext)) {
            JSElement defaultExport;
            boolean result2 = JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, exportedElementsProcessor, false);
            if (result2) {
                ES6PsiUtil.processExportAllDeclarations(scope, processor, visited);
            }
            if ((defaultExport = ES6PsiUtil.findDefaultExport((PsiElement)scope)) instanceof ES6ExportDefaultAssignment) {
                processor.execute((PsiElement)defaultExport, ResolveState.initial());
            }
        }
        return hasIncompleteMatch;
    }

    private static boolean isAcceptableContext(@Nullable JSEvaluationResultContext evaluateContext) {
        if (evaluateContext == null || evaluateContext.isJSElementsToApplyEmpty()) {
            return true;
        }
        JSApplyContextElement topElementToApply = evaluateContext.peekJSElementToApply();
        return !(topElementToApply instanceof JSApplyCallElement);
    }

    public static boolean isImportElement(PsiElement item) {
        return item instanceof ES6ImportedBinding || item instanceof ES6ImportExportSpecifierAlias || item instanceof TypeScriptImportStatement || item instanceof TypeScriptImplicitOverloadedAliasElement;
    }

    @Deprecated
    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String text, @Nullable PsiReferenceProvider provider2) {
        if (host == null) {
            ES6PsiUtil.$$$reportNull$$$0(44);
        }
        if (text == null) {
            ES6PsiUtil.$$$reportNull$$$0(45);
        }
        return JSFileReferencesUtil.createImportExportFromClauseReferences(host, offset, text, provider2);
    }

    public static boolean isElementCanBeExported(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(46);
        }
        return element instanceof JSAttributeListOwner && !(element instanceof TypeScriptTypeMember) && !(element instanceof JSParameter) && !(element instanceof JSProperty) && !(element instanceof JSField) && !(element instanceof TypeScriptType);
    }

    public static boolean isExternalModule(@Nullable PsiElement element) {
        if (element instanceof JSFile) {
            return ((JSFile)element).getModuleStatus() == JSFile.ModuleStatus.ES6;
        }
        if (ES6PsiUtil.isEmbeddedModule(element)) {
            return true;
        }
        return element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal();
    }

    @Nullable
    public static PsiElement findExternalModule(@NotNull PsiElement context) {
        if (context == null) {
            ES6PsiUtil.$$$reportNull$$$0(47);
        }
        JSElement container = ES6PsiUtil.getExportScope(context);
        while (container != null) {
            if (ES6PsiUtil.isExternalModule((PsiElement)container)) {
                return container;
            }
            if (container instanceof PsiFile) {
                return null;
            }
            container = ES6PsiUtil.getExportScope((PsiElement)container);
        }
        return null;
    }

    @NotNull
    private static ResolveResult[] resolveWithAliases(@NotNull String name, @NotNull PsiElement context, @NotNull List<JSType> innerAliases) {
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(48);
        }
        if (context == null) {
            ES6PsiUtil.$$$reportNull$$$0(49);
        }
        if (innerAliases == null) {
            ES6PsiUtil.$$$reportNull$$$0(50);
        }
        if (DialectDetector.isTypeScript(context)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(51);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (innerAliases.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(52);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(name, context.getContainingFile(), context);
        ES6PsiUtil.addInnerAliases(innerAliases, processor);
        processor.setAddOnlyCompleteMatches(true);
        JSReferenceExpressionResolver.processAllSymbols(processor);
        ResolveResult[] resolveResultArray = processor.getResults();
        if (resolveResultArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(53);
        }
        return resolveResultArray;
    }

    @Nullable
    public static ES6ImportCall getImportCallIfContinuationParameter(@NotNull JSParameterListElement parameterItem) {
        JSFunctionExpression functionExpression;
        if (parameterItem == null) {
            ES6PsiUtil.$$$reportNull$$$0(54);
        }
        if ((functionExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)parameterItem.getDeclaringFunction(), JSFunctionExpression.class)) == null) {
            return null;
        }
        PsiElement parent = JSUtils.getParentSkipParentheses((PsiElement)functionExpression);
        JSArgumentList argumentList = (JSArgumentList)ObjectUtils.tryCast((Object)parent, JSArgumentList.class);
        if (argumentList == null) {
            return null;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)argumentList.getParent(), JSCallExpression.class);
        if (callExpression == null) {
            return null;
        }
        JSReferenceExpression methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
        if (methodExpression == null) {
            return null;
        }
        JSExpression qualifier = JSUtils.unparenthesize(methodExpression.getQualifier());
        return qualifier instanceof ES6ImportCall && StringUtil.equals((CharSequence)methodExpression.getReferenceName(), (CharSequence)"then") ? (ES6ImportCall)qualifier : null;
    }

    @Contract(value="null -> null")
    public static JSClass getES6ConstructorClass(@Nullable PsiElement element) {
        if (!(element instanceof JSFunction)) {
            return null;
        }
        if (JSResolveUtil.isConstructorFunction(element) && "constructor".equals(((JSFunction)element).getName())) {
            return JSUtils.getMemberContainingClass(element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 51: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 51: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: 
            case 33: 
            case 38: 
            case 41: 
            case 43: 
            case 56: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 8: 
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 11: 
            case 15: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 16: 
            case 29: 
            case 34: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 35: 
            case 40: 
            case 42: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 25: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerAliases";
                break;
            }
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingAllPossibleExports";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDefaultExport";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolInModule";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolInModules";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolForSpecifier";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "processSpecifier";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "processExportedSymbols";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWithAliases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBindingAllPossibleExports";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultExport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processExportAllDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFromClauseResolvedReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveDefaultExport";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModule";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModules";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolForSpecifier";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processSpecifier";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processExportedSymbols";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processSpecifierForScope";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSpecifierResolveProcessor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addInnerAliases";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getExportScope";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processExportDeclarationInScope";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createImportExportFromClauseReferences";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isElementCanBeExported";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithAliases";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getImportCallIfContinuationParameter";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExportDeclarationInScope$3";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExportDeclarationInScope$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 51: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSDelegatingModuleElementsProcessor
    extends JSQualifiedItemProcessorBase
    implements JSModuleElementsProcessor {
        @NotNull
        private final List<JSType> myInnerAliases;
        @NotNull
        private final QualifiedItemProcessor<?> myDelegate;

        @NotNull
        public List<JSType> getInnerAliases() {
            List<JSType> list = this.myInnerAliases;
            if (list == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(0);
            }
            return list;
        }

        public JSDelegatingModuleElementsProcessor(@NotNull QualifiedItemProcessor<?> delegate) {
            if (delegate == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(1);
            }
            this.myInnerAliases = new SmartList();
            this.myDelegate = delegate;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(3);
            }
            return this.myDelegate.execute(element, state);
        }

        @Override
        @Nullable
        public String getName() {
            return this.myDelegate.getName();
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (type == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(4);
            }
            if (evaluateContext == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(5);
            }
            this.myDelegate.process(type, evaluateContext, source);
            this.myInnerAliases.add(type);
        }

        @Override
        public void executeCandidateResult(PsiElement element, String s) {
            this.myDelegate.executeCandidateResult(element, s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInnerAliases";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ES6ExportedElementsProcessor
    extends JSResolveProcessorBase {
        @NotNull
        private final PsiScopeProcessor myDelegate;

        public ES6ExportedElementsProcessor(@NotNull PsiScopeProcessor delegateProcessor) {
            if (delegateProcessor == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(0);
            }
            super(delegateProcessor instanceof JSResolveProcessor ? ((JSResolveProcessor)delegateProcessor).getName() : null);
            this.myDelegate = delegateProcessor;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(2);
            }
            if (element instanceof ES6ExportSpecifier) {
                ResolveResult[] results;
                ES6ExportDeclaration declaration = ((ES6ExportSpecifier)element).getDeclaration();
                if (declaration != null && declaration.getFromClause() == null) {
                    return true;
                }
                for (ResolveResult result2 : results = ((ES6ExportSpecifier)element).multiResolve(false)) {
                    PsiElement resultElement;
                    if (!result2.isValidResult() || (resultElement = result2.getElement()) == null || this.myDelegate.execute(resultElement, state)) continue;
                    return false;
                }
            } else {
                if (ES6ImportHandler.isExported(element)) {
                    return this.myDelegate.execute(element, state);
                }
                if (this.myDelegate instanceof JSCandidateResultProcessor) {
                    String key = element instanceof JSPsiElementBase && ((JSPsiElementBase)element).isExportedWithDefault() ? "javascript.element.default.instead.named" : "javascript.element.need.to.be.exported";
                    ((JSCandidateResultProcessor)this.myDelegate).executeCandidateResult(element, key);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$ES6ExportedElementsProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

