/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.dialects.JSLanguageLevelPusher;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSBlockStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.types.JavaScriptDialectFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialectDetector {
    public static final FileType[] JAVASCRIPT_FILE_TYPES_ARRAY = new FileType[]{JavaScriptSupportLoader.JAVASCRIPT, ES6FileType.INSTANCE, JSXHarmonyFileType.INSTANCE, FlowJSFileType.INSTANCE};
    public static final Collection<FileType> JAVASCRIPT_FILE_TYPES = Collections.unmodifiableList(ContainerUtil.newArrayList((Object[])JAVASCRIPT_FILE_TYPES_ARRAY));
    private static final Key<ParameterizedCachedValue<JSLanguageDialect, PsiFile>> KEY_DIALECT_HOLDER = Key.create((String)"JavaScript.Dialect.Holder");
    private static final ParameterizedCachedValueProvider<JSLanguageDialect, PsiFile> PROVIDER = new ParameterizedCachedValueProvider<JSLanguageDialect, PsiFile>(){

        @NotNull
        public CachedValueProvider.Result<JSLanguageDialect> compute(PsiFile file) {
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)((Object)DialectDetector.dialectOfFileNoCache(file)), (Object[])new Object[]{file});
            if (result2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector$1", "compute"));
        }
    };

    private DialectDetector() {
    }

    @Nullable
    public static DialectOptionHolder dialectOfElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Language language = DialectDetector.languageOfElement(element);
        return language instanceof JSLanguageDialect ? ((JSLanguageDialect)language).getOptionHolder() : null;
    }

    public static boolean hasFeature(@Nullable PsiElement element, @NotNull JSLanguageFeature feature) {
        if (feature == null) {
            DialectDetector.$$$reportNull$$$0(0);
        }
        if (element == null) {
            return false;
        }
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement(element);
        return optionHolder != null && optionHolder.hasFeature(feature);
    }

    @Nullable
    public static DialectOptionHolder dialectOfFile(@Nullable PsiFile file) {
        return DialectDetector.dialectOfElement((PsiElement)file);
    }

    @Nullable
    private static JSLanguageDialect dialectOfFileNoCache(@NotNull PsiFile file) {
        JSLanguageDialect dialect;
        Language language;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(1);
        }
        if ((language = file.getLanguage()) instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language;
        }
        if (language == HTMLLanguage.INSTANCE) {
            return null;
        }
        if (JavaScriptSupportLoader.isMxmlOrFxgFile(file)) {
            return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        VirtualFile virtualFile2 = virtualFile = virtualFile == null ? (VirtualFile)IndexingDataKeys.VIRTUAL_FILE.get((UserDataHolder)file) : virtualFile;
        if (virtualFile != null && ("swf".equalsIgnoreCase(virtualFile.getExtension()) || "swc".equalsIgnoreCase(virtualFile.getExtension()))) {
            return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        }
        if (virtualFile != null && (dialect = DialectDetector.getLanguageDialect(virtualFile, file.getProject())) != null) {
            return dialect;
        }
        return null;
    }

    @NotNull
    public static Language languageOfElement(@NotNull PsiElement element) {
        JSLanguageDialect dialect;
        PsiFile file;
        PsiElement context;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(2);
        }
        if (element instanceof LeafPsiElement && (context = element.getContext()) instanceof JSElement) {
            Language language = context.getLanguage();
            if (language == null) {
                DialectDetector.$$$reportNull$$$0(3);
            }
            return language;
        }
        if (element instanceof XmlElement && (file = element.getContainingFile()) != null && (dialect = DialectDetector.getJSDialectOfFileOrNull(file)) != null) {
            JSLanguageDialect jSLanguageDialect = dialect;
            if (jSLanguageDialect == null) {
                DialectDetector.$$$reportNull$$$0(4);
            }
            return jSLanguageDialect;
        }
        Language language = element.getLanguage();
        if (language == null) {
            DialectDetector.$$$reportNull$$$0(5);
        }
        return language;
    }

    @NotNull
    public static Language calculateJSLanguage(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(6);
        }
        if (element instanceof XmlBackedJSClass) {
            JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            if (jSLanguageDialect == null) {
                DialectDetector.$$$reportNull$$$0(7);
            }
            return jSLanguageDialect;
        }
        if (element instanceof PsiFile) {
            Language language = DialectDetector.getJSDialectOfFile((PsiFile)element);
            if (language == null) {
                DialectDetector.$$$reportNull$$$0(8);
            }
            return language;
        }
        if (element instanceof JSEmbeddedContent && !(parent instanceof JSElement)) {
            PsiFile file = element.getContainingFile();
            Object object = file instanceof JSFile ? file.getLanguage() : JSEmbeddedContentImpl.getLanguageForParser(((JSEmbeddedContent)element).getElementType(), file, element.getProject());
            if (object == null) {
                DialectDetector.$$$reportNull$$$0(9);
            }
            return object;
        }
        for (parent = element.getContext(); parent != null; parent = parent.getContext()) {
            if (parent instanceof JSStubElementImpl || parent instanceof JSBlockStatementImpl || parent instanceof JSEmbeddedContent) {
                Language language = parent.getLanguage();
                if (language == null) {
                    DialectDetector.$$$reportNull$$$0(10);
                }
                return language;
            }
            if (!(parent instanceof PsiFile)) continue;
            Language language = DialectDetector.getJSDialectOfFile((PsiFile)parent);
            if (language == null) {
                DialectDetector.$$$reportNull$$$0(11);
            }
            return language;
        }
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            DialectDetector.$$$reportNull$$$0(12);
        }
        return javascriptLanguage;
    }

    @NotNull
    private static Language getJSDialectOfFile(@NotNull PsiFile file) {
        JSLanguageDialect dialect;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(13);
        }
        JSLanguageDialect jSLanguageDialect = (dialect = DialectDetector.getJSDialectOfFileOrNull(file)) != null ? dialect : JavascriptLanguage.INSTANCE;
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(14);
        }
        return jSLanguageDialect;
    }

    @Nullable
    private static JSLanguageDialect getJSDialectOfFileOrNull(@NotNull PsiFile file) {
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(15);
        }
        return (JSLanguageDialect)((Object)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, KEY_DIALECT_HOLDER, PROVIDER, false, (Object)file));
    }

    @Nullable
    public static JSLanguageDialect languageDialectOfElement(@NotNull PsiElement element) {
        Language language;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(16);
        }
        return (language = DialectDetector.languageOfElement(element)) instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    public static boolean isTypeScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(17);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isTypeScript;
    }

    public static boolean isActionScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(18);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) == DialectOptionHolder.ECMA_4;
    }

    public static boolean isJavaScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(19);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) == null || dialect.isJavaScript();
    }

    public static boolean isJavaScriptFamily(@NotNull PsiElement element) {
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(20);
        }
        return !DialectDetector.isActionScript(element);
    }

    public static boolean isES6(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(21);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isECMA6;
    }

    public static boolean isFlow(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(22);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isFlow;
    }

    public static boolean isJSX(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(23);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isJSX;
    }

    @NotNull
    public static Language getJSLanguage(@NotNull VirtualFile file) {
        FileType type;
        Language language;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(24);
        }
        Language language2 = language = (type = file.getFileType()) instanceof LanguageFileType ? ((LanguageFileType)type).getLanguage() : null;
        Object object = JavaScriptSupportLoader.GWT_DIALECT.getFileExtension().equals(file.getExtension()) ? JavaScriptSupportLoader.GWT_DIALECT : (language instanceof JSLanguageDialect ? language : JavascriptLanguage.INSTANCE);
        if (object == null) {
            DialectDetector.$$$reportNull$$$0(25);
        }
        return object;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialect(@NotNull VirtualFile file, @NotNull Project project) {
        JSLanguageDialect jsDialect;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(26);
        }
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(27);
        }
        if ((jsDialect = DialectDetector.getLanguageDialectForJSFile(file, project)) != null) {
            return jsDialect;
        }
        Language language = DialectDetector.getJSLanguage(file);
        if (language instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language;
        }
        language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        return language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialectForJSFile(@NotNull VirtualFile file, @NotNull Project project) {
        FileType type;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(28);
        }
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(29);
        }
        if (JAVASCRIPT_FILE_TYPES.contains(type = file.getFileType())) {
            JSLanguageDialect configuredJSVersion = DialectDetector.getConfiguredJSVersion(file, project);
            if (type instanceof JavaScriptDialectFileType) {
                JSLanguageDialect language = ((JavaScriptDialectFileType)type).getDefaultLanguage();
                DialectOptionHolder defaultLevelHolder = language.getOptionHolder();
                if (!configuredJSVersion.getOptionHolder().isAtLeast(defaultLevelHolder)) {
                    return language;
                }
            }
            return configuredJSVersion;
        }
        return null;
    }

    @NotNull
    public static JSLanguageDialect getConfiguredJSVersion(@NotNull PsiFile file) {
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(30);
        }
        JSLanguageDialect jSLanguageDialect = DialectDetector.getConfiguredJSVersion(file.getViewProvider().getVirtualFile(), file.getProject());
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(31);
        }
        return jSLanguageDialect;
    }

    @NotNull
    public static JSLanguageDialect getConfiguredJSVersion(@NotNull VirtualFile file, @NotNull Project project) {
        VirtualFile delegate;
        VirtualFile originalFile;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(32);
        }
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(33);
        }
        if (file instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file).getOriginalFile()) != null) {
            file = originalFile;
        }
        if (file instanceof VirtualFileWindow && (delegate = ((VirtualFileWindow)file).getDelegate()) != null) {
            file = delegate;
        }
        Logger logger = Logger.getInstance(DialectDetector.class);
        logger.debug("getConfiguredJSVersion for file: " + file.getUrl());
        VirtualFile parent = file.getParent();
        JSLanguageLevel configuredLevel = (JSLanguageLevel)((Object)JSLanguageLevelPusher.KEY.get((UserDataHolder)parent));
        if (configuredLevel == null) {
            JSRootConfiguration configuration = JSRootConfiguration.getInstance(project);
            configuredLevel = configuration != null ? configuration.getLanguageLevel() : JSLanguageLevel.DEFAULT;
            logger.debug(String.format("Returning configured language level: %s for file: %s", configuredLevel.getId(), file.getName()));
        } else {
            logger.debug(String.format("Returning pushed language level: %s for file: %s", configuredLevel.getId(), file.getName()));
        }
        JSLanguageDialect jSLanguageDialect = configuredLevel.getDialect();
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(34);
        }
        return jSLanguageDialect;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialect(@NotNull PsiElement psi) {
        if (psi == null) {
            DialectDetector.$$$reportNull$$$0(35);
        }
        return DialectDetector.languageDialectOfElement(psi);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/DialectDetector";
                break;
            }
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/DialectDetector";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "languageOfElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateJSLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSDialectOfFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSLanguage";
                break;
            }
            case 31: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredJSVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasFeature";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dialectOfFileNoCache";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "languageOfElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 34: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateJSLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getJSDialectOfFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getJSDialectOfFileOrNull";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "languageDialectOfElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScript";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isActionScript";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScript";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScriptFamily";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isES6";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isFlow";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isJSX";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getJSLanguage";
                break;
            }
            case 26: 
            case 27: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialect";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialectForJSFile";
                break;
            }
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredJSVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

