/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSStringLiteralLexer
extends StringLiteralLexer {
    private final boolean myAllowUnicodeEscapesWithinBraces;

    public JSStringLiteralLexer(char quoteChar, IElementType originalLiteralToken, String additionalValidEscapes, boolean allowOctal, boolean allowUnicodeEscapesWithinBraces) {
        super(quoteChar, originalLiteralToken, true, additionalValidEscapes, allowOctal, true);
        this.myAllowUnicodeEscapesWithinBraces = allowUnicodeEscapesWithinBraces;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.myAllowUnicodeEscapesWithinBraces && this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            int i = this.myStart + 3;
            boolean foundHex = false;
            boolean hadDigitBefore = false;
            while (i < this.myEnd) {
                char c = this.myBuffer.charAt(i);
                if (hadDigitBefore && c == '_') {
                    ++i;
                    hadDigitBefore = false;
                    continue;
                }
                if (!StringUtil.isHexDigit((char)c)) break;
                foundHex = true;
                hadDigitBefore = true;
                ++i;
            }
            IElementType iElementType = foundHex && i < this.myEnd && this.myBuffer.charAt(i) == '}' ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                JSStringLiteralLexer.$$$reportNull$$$0(0);
            }
            return iElementType;
        }
        int digitsCount = 0;
        boolean hadDigitBefore = false;
        int i = this.myStart + 2;
        while (digitsCount < 4) {
            if (i >= this.myEnd) {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    JSStringLiteralLexer.$$$reportNull$$$0(1);
                }
                return iElementType;
            }
            char c = this.myBuffer.charAt(i);
            if (!StringUtil.isHexDigit((char)c)) {
                if (!hadDigitBefore || c != '_') {
                    IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                    if (iElementType == null) {
                        JSStringLiteralLexer.$$$reportNull$$$0(2);
                    }
                    return iElementType;
                }
                hadDigitBefore = false;
            } else {
                hadDigitBefore = true;
                ++digitsCount;
            }
            ++i;
        }
        IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        if (iElementType == null) {
            JSStringLiteralLexer.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        if (this.myAllowUnicodeEscapesWithinBraces && ++i < this.myBufferEnd && this.myBuffer.charAt(i) == '{') {
            ++i;
            boolean hadDigitBefore = false;
            while (i < this.myBufferEnd) {
                char c = this.myBuffer.charAt(i);
                if (!StringUtil.isHexDigit((char)c)) {
                    if (!hadDigitBefore || c != '_') break;
                    ++i;
                    hadDigitBefore = false;
                    continue;
                }
                hadDigitBefore = true;
                ++i;
            }
            if (i < this.myBufferEnd && this.myBuffer.charAt(i) == '}') {
                ++i;
            }
            return i;
        }
        int digitsCount = 0;
        while (digitsCount < 4) {
            if (i == this.myBufferEnd) {
                return i;
            }
            char c = this.myBuffer.charAt(i);
            if (c == '\n' || c == this.myQuoteChar) {
                return i;
            }
            if (StringUtil.isHexDigit((char)c)) {
                ++digitsCount;
            }
            ++i;
        }
        return i;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSStringLiteralLexer", "getUnicodeEscapeSequenceType"));
    }
}

