/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NpmPackageProjectGenerator
extends WebProjectTemplate<Settings>
implements ProjectTemplate {
    private static final String ID = "none";
    private static final Logger LOG = Logger.getInstance(NpmPackageProjectGenerator.class);

    @NotNull
    protected abstract Filter[] filters(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    protected abstract String executable(String var1);

    @NotNull
    protected abstract String[] generatorArgs(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract void customizeModule(@NotNull VirtualFile var1, ContentEntry var2);

    @NotNull
    protected abstract String packageName();

    @NotNull
    protected abstract String presentablePackageName();

    private void generateApp(@NotNull NodeJsLocalInterpreter node, @NotNull Settings settings, @NotNull VirtualFile baseDir, @NotNull Project project) throws IOException, ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(2);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(3);
        }
        File workingDir = this.workingDir(baseDir);
        NpmPackageProjectGenerator.generate(node, this.executable(settings.myPackagePath), baseDir, workingDir, project, this.postInstall(project, baseDir, workingDir), this.filters(project, baseDir), this.generatorArgs(project, baseDir, settings));
    }

    protected String[] generatorArgs(Project project, VirtualFile dir, Settings settings) {
        return this.generatorArgs(project, dir);
    }

    @NotNull
    protected Runnable postInstall(@NotNull NodeJsLocalInterpreter node, @NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(4);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(6);
        }
        Runnable runnable = this.postInstall(project, baseDir, workingDir);
        if (runnable == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(7);
        }
        return runnable;
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(8);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(9);
        }
        Runnable runnable = () -> {
            if (baseDir == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(33);
            }
            if (project == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(34);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (baseDir == null) {
                    NpmPackageProjectGenerator.$$$reportNull$$$0(35);
                }
                if (project == null) {
                    NpmPackageProjectGenerator.$$$reportNull$$$0(36);
                }
                if (this.generateInTemp()) {
                    try {
                        FileUtil.copyDir((File)new File(workingDir, baseDir.getName()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)baseDir));
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
                NpmPackageProjectGenerator.initBuildfiles(project);
            });
        };
        if (runnable == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(10);
        }
        return runnable;
    }

    private static void initBuildfiles(@NotNull Project project) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(11);
        }
        if (!project.isDisposed()) {
            NpmScriptsService instance = NpmScriptsService.getInstance();
            List<VirtualFile> buildfiles = instance.detectAllBuildfiles(project);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    NpmPackageProjectGenerator.$$$reportNull$$$0(32);
                }
                for (VirtualFile buildfile : buildfiles) {
                    instance.getFileManager(project).addBuildfile(buildfile);
                }
                instance.getToolWindowManager(project).setAvailable();
                JSLinterGuesser.guessLinters(project);
            }, project.getDisposed());
        }
    }

    public static void generate(@NotNull NodeJsLocalInterpreter node, @NotNull String path, final @NotNull VirtualFile baseDir, @NotNull File workingDir, @NotNull Project project, final @Nullable Runnable callback, @NotNull Filter[] filters, String ... args) throws ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(12);
        }
        if (path == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(13);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(14);
        }
        if (workingDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(15);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(16);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(17);
        }
        final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(project).externalUpdateStarted(null, null);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(node.getInterpreterSystemDependentPath());
        arguments.add(path);
        ContainerUtil.addAll(arguments, (Object[])args);
        GeneralCommandLine commandLine = new GeneralCommandLine(arguments);
        commandLine.setWorkDirectory(workingDir.getPath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        final KillableColoredProcessHandler handler = new KillableColoredProcessHandler(commandLine);
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(project);
        builder.setUsePredefinedMessageFilter(false);
        for (Filter filter : filters) {
            builder.addFilter(filter);
        }
        ConsoleView console = builder.getConsole();
        console.attachToProcess((ProcessHandler)handler);
        ConsoleProgress.install(console, (ProcessHandler)handler);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                baseDir.refresh(false, true);
                baseDir.getChildren();
                handler.notifyTextAvailable("Done\n", ProcessOutputTypes.SYSTEM);
                done.run();
                if (callback != null) {
                    callback.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$1", "processTerminated"));
            }
        });
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        String title = "Generating " + baseDir.getName();
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)project).create(ID, title, title, (Disposable)project);
        Content consoleContent = ui.createContent(ID, console.getComponent(), title, null, console.getPreferredFocusableComponent());
        ui.addContent(consoleContent);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)console, (ProcessHandler)handler, console.getComponent(), title);
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(defaultExecutor, descriptor2);
        handler.startNotify();
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Settings settings, @NotNull Module module) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(18);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(19);
        }
        if (settings == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(20);
        }
        if (module == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(21);
        }
        NodeJsInterpreter interpreter = settings.myInterpreterRef.resolve(project);
        NodeJsLocalInterpreter local = NodeJsLocalInterpreter.tryCast(interpreter);
        assert (local != null);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (project == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(27);
            }
            if (settings == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(28);
            }
            if (baseDir == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(29);
            }
            if (module == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(30);
            }
            try {
                NodeJsInterpreterManager.getInstance(project).setInterpreterRef(settings.myInterpreterRef);
                this.generateApp(local, settings, baseDir, project);
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir);
                this.customizeModule(baseDir, entry);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        NpmPackageProjectGenerator.$$$reportNull$$$0(31);
                    }
                    model.commit();
                    project.save();
                });
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<Settings> createPeer() {
        NpmPackageGeneratorPeer npmPackageGeneratorPeer = new NpmPackageGeneratorPeer();
        if (npmPackageGeneratorPeer == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(22);
        }
        return npmPackageGeneratorPeer;
    }

    @NotNull
    private File workingDir(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(23);
        }
        if (this.generateInTemp()) {
            File file = Files.createTempDir();
            if (file == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(24);
            }
            return file;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (file == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(25);
        }
        return file;
    }

    protected boolean generateInTemp() {
        return false;
    }

    protected String validateProjectPath(@NotNull String path) {
        if (path == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(26);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 22: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 22: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 23: 
            case 29: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 16: 
            case 18: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator";
                break;
            }
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateApp";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 7: 
            case 10: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initBuildfiles";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "workingDir";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$4";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initBuildfiles$2";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postInstall$1";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class NpmPackageGeneratorPeer
    implements WebProjectGenerator.GeneratorPeer<Settings> {
        public final JPanel myPanel = this.createPanel();
        private NodeJsInterpreterField myInterpreter;
        private NodePackageField myPackageField;
        private TextAccessor myLocation;

        protected JPanel createPanel() {
            Project project = ProjectManager.getInstance().getDefaultProject();
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            this.myInterpreter = new NodeJsInterpreterField(project, false){

                @Override
                public boolean isDefaultProjectInterpreterField() {
                    return true;
                }
            };
            this.myInterpreter.setInterpreterRef(NodeJsInterpreterManager.getInstance(project).getInterpreterRef());
            LabeledComponent component = LabeledComponent.create((JComponent)((Object)this.myInterpreter), (String)"Node &interpreter:");
            component.setLabelLocation("West");
            panel.add((Component)component);
            this.myPackageField = new NodePackageField(this.myInterpreter, NpmPackageProjectGenerator.this.packageName());
            this.myPackageField.setSelected(NodePackage.findPreferredPackage(project, NpmPackageProjectGenerator.this.packageName(), this.myInterpreter.getInterpreter()));
            component = LabeledComponent.create((JComponent)((Object)this.myPackageField), (String)NpmPackageProjectGenerator.this.presentablePackageName());
            component.setAnchor((JComponent)panel.getComponent(0));
            component.setLabelLocation("West");
            panel.add((Component)component);
            JPanel myPanel = panel;
            return myPanel;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(0);
            }
            return jPanel;
        }

        public void buildUI(@NotNull SettingsStep settingsStep) {
            ModuleNameLocationSettings field;
            if (settingsStep == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(1);
            }
            if ((field = settingsStep.getModuleNameLocationSettings()) != null) {
                this.myLocation = new TextAccessor(){

                    public void setText(String text) {
                        field.setModuleName(text);
                    }

                    public String getText() {
                        return field.getModuleName();
                    }
                };
            }
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)"Node &interpreter:"), (JComponent)((Object)this.myInterpreter));
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)NpmPackageProjectGenerator.this.presentablePackageName()), (JComponent)((Object)this.myPackageField));
        }

        @NotNull
        public Settings getSettings() {
            Settings settings = new Settings(this.myInterpreter.getInterpreterRef(), this.myPackageField.getSelected().getSystemDependentPath());
            if (settings == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(2);
            }
            return settings;
        }

        @Nullable
        public ValidationInfo validate() {
            String validateMessage;
            NodeJsInterpreter interpreter = this.myInterpreter.getInterpreter();
            String error = NodeJsLocalInterpreter.getErrorMessage(interpreter);
            if (error != null) {
                return new ValidationInfo(error);
            }
            String pkgError = this.myPackageField.getSelected().getErrorMessage(NpmPackageProjectGenerator.this.packageName());
            if (pkgError != null) {
                return new ValidationInfo(pkgError);
            }
            if (this.myLocation == null) {
                Component component = this.myInterpreter.getParent().getParent().getComponent(0);
                JComponent innerComponent = component instanceof LabeledComponent ? ((LabeledComponent)component).getComponent() : null;
                this.myLocation = innerComponent instanceof TextAccessor ? (TextAccessor)innerComponent : null;
            }
            String string = validateMessage = this.myLocation != null ? NpmPackageProjectGenerator.this.validateProjectPath(this.myLocation.getText()) : null;
            if (validateMessage != null) {
                return new ValidationInfo(validateMessage);
            }
            return null;
        }

        public boolean isBackgroundJobRunning() {
            return false;
        }

        public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener2) {
            if (listener2 == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(3);
            }
            this.myInterpreter.addChangeListener(interpreter -> {
                if (listener2 == null) {
                    NpmPackageGeneratorPeer.$$$reportNull$$$0(5);
                }
                listener2.stateChanged(this.validate() == null);
            });
            this.myPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)newPackage -> {
                if (listener2 == null) {
                    NpmPackageGeneratorPeer.$$$reportNull$$$0(4);
                }
                listener2.stateChanged(this.validate() == null);
            }));
            listener2.stateChanged(this.validate() == null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsStep";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "buildUI";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addSettingsStateListener";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addSettingsStateListener$1";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addSettingsStateListener$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Settings
    extends UserDataHolderBase {
        public NodeJsInterpreterRef myInterpreterRef;
        public String myPackagePath;

        public Settings(@NotNull NodeJsInterpreterRef interpreter, String text) {
            if (interpreter == null) {
                Settings.$$$reportNull$$$0(0);
            }
            this.myInterpreterRef = interpreter;
            this.myPackagePath = text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings", "<init>"));
        }
    }
}

