/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;

public class JSLookupElementInsertHandler
extends JSInsertHandler<LookupElement> {
    private final boolean myInsertAsIndexer;
    private boolean myForceQualify = false;

    public JSLookupElementInsertHandler(boolean insertAsIndexer) {
        this.myInsertAsIndexer = insertAsIndexer;
    }

    @Override
    public void handleInsert(InsertionContext context, LookupElement item) {
        Editor editor;
        Object object = item.getObject();
        if (!(object instanceof PsiElement)) {
            super.handleInsert(context, item);
            return;
        }
        PsiFile file = context.getFile();
        boolean doQualify = false;
        String packageName = null;
        if (this.myForceQualify) {
            String qName;
            PsiElement element = (PsiElement)object;
            PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)element, (PsiFile)file);
            if (originalElement != null) {
                element = originalElement;
            }
            String string = qName = element instanceof JSPsiElementBase ? ((JSPsiElementBase)element).getQualifiedName() : null;
            if (qName != null) {
                packageName = StringUtil.getPackageName((String)qName);
                doQualify = !packageName.isEmpty();
            }
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        super.handleInsert(context, item);
        if (doQualify) {
            editor = context.getEditor();
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
            PsiReference ref = file.findReferenceAt(editor.getCaretModel().getOffset() - 1);
            if (ref != null) {
                TextRange refRange = ref.getRangeInElement();
                TextRange elementRange = ref.getElement().getTextRange();
                editor.getDocument().insertString(elementRange.getStartOffset() + refRange.getStartOffset(), (CharSequence)(packageName + "."));
            }
        }
        if (this.myInsertAsIndexer) {
            editor = context.getEditor();
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
            PsiElement el = file.findElementAt(editor.getCaretModel().getOffset() - 1);
            if (el != null) {
                if (el.getNode().getElementType() == JSTokenTypes.RBRACKET) {
                    JSExpression index;
                    PsiElement parent = el.getParent();
                    if (parent instanceof JSIndexedPropertyAccessExpression && (index = ((JSIndexedPropertyAccessExpression)parent).getIndexExpression()) != null) {
                        editor.getDocument().deleteString(index.getTextOffset() - 2, index.getTextOffset() - 1);
                    }
                } else {
                    editor.getDocument().replaceString(el.getTextOffset() - 1, el.getTextOffset(), (CharSequence)"[");
                    int offset = el.getTextRange().getEndOffset();
                    editor.getDocument().insertString(offset, (CharSequence)"]");
                    editor.getCaretModel().moveToOffset(offset + 1);
                }
            }
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
            super.handleInsert(context, item);
        }
    }

    public void setForceQualify(boolean forceQualify) {
        this.myForceQualify = forceQualify;
    }
}

