/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSDocParamReferenceCompletion;
import com.intellij.lang.javascript.completion.JSReferenceCompletionUtil;
import com.intellij.lang.javascript.completion.JSTextReferenceCompletion;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdIterator;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(1);
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result2, (reference, set) -> {
            if (reference instanceof JSTextReference) {
                JSTextReferenceCompletion.addVariants((JSTextReference)reference, set);
            } else if (reference instanceof JSDocParamReference) {
                set.addAllElements(JSDocParamReferenceCompletion.getVariants((JSDocParamReference)reference));
            } else if (reference instanceof JSPropertyNameReference) {
                JSReferenceCompletionContributor.calcPropertyNameReferenceVariants((JSPropertyNameReference)reference, set);
            }
        });
    }

    public static void calcPropertyNameReferenceVariants(@NotNull JSPropertyNameReference reference, @NotNull CompletionResultSet resultSet) {
        boolean tooMuch;
        VariantsProcessor processor;
        JSProperty property;
        PsiElement context;
        if (reference == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((context = JSReferenceCompletionContributor.getShorthandedPropertyContext(property = reference.getElement(), processor = new VariantsProcessor(property.getContainingFile(), (PsiElement)property, false, resultSet))) != null) {
            if (DialectDetector.isTypeScript(context) && processor.addOnlyCompleteMatches()) {
                Collection<LookupElement> results = processor.getFinalResults();
                processor.populateCompletionList(results, false, resultSet);
                return;
            }
            CompletionResultSink sink = new CompletionResultSink(context);
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            JSReferenceExpressionImpl.doProcessLocalDeclarations(context, null, localProcessor, false, true, null);
            List<PsiElement> processorResults = sink.getResults();
            if (processorResults != null) {
                processor.populateCompletionList(sink.resultsToLookupElements(processorResults), false, resultSet);
            }
        }
        boolean bl = tooMuch = !JSReferenceCompletionContributor.processIndexedSymbols((PsiElement)property, processor, resultSet, null);
        if (tooMuch) {
            JSReferenceCompletionUtil.handleOverflow(resultSet);
        }
        Collection<LookupElement> results = processor.getFinalResults();
        processor.populateCompletionList(results, false, resultSet);
    }

    public static PsiElement getShorthandedPropertyContext(JSProperty property, VariantsProcessor processor) {
        if (processor.getTypeInfo().hasExplicitNamespace()) {
            return null;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)property);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES)) {
            return null;
        }
        if (property instanceof ES6Property && ((ES6Property)property).isShorthanded() && property.getValue() instanceof JSReferenceExpression) {
            return property.getValue();
        }
        if (property.getNextSibling() instanceof PsiErrorElement) {
            return property.getNameIdentifier();
        }
        return null;
    }

    public static boolean processIndexedSymbols(@NotNull PsiElement referenceElement, @NotNull VariantsProcessor processor, @NotNull CompletionResultSet resultSet, @Nullable List<Collection<LookupElement>> populatedResults) {
        if (referenceElement == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(5);
        }
        if (resultSet == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(6);
        }
        boolean tooMuch = !JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        Collection<LookupElement> completeMatchResults = processor.getCurrentResults();
        processor.populateCompletionList(completeMatchResults, false, resultSet);
        if (populatedResults != null) {
            populatedResults.add(completeMatchResults);
        }
        if (tooMuch) {
            return true;
        }
        Project project = referenceElement.getProject();
        PsiFile file = referenceElement.getContainingFile();
        if (!JSReferenceCompletionContributor.processElementsInInjectedContext(processor, file)) {
            return false;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(referenceElement);
        if (!processor.addOnlyCompleteMatches() && !JSReferenceCompletionContributor.processAllIndexedSymbols(processor, project, scope)) {
            return false;
        }
        if (DialectDetector.isActionScript(referenceElement)) {
            return true;
        }
        return JSReferenceCompletionContributor.processImplicitElements(processor, project, scope);
    }

    @Deprecated
    public static boolean processIndexedSymbols(@NotNull PsiElement referenceElement, JSCompletionProcessor processor, boolean skipSymbolIndex) {
        if (referenceElement == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(7);
        }
        Project project = referenceElement.getProject();
        PsiFile file = referenceElement.getContainingFile();
        if (!JSReferenceCompletionContributor.processElementsInInjectedContext(processor, file)) {
            return false;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(referenceElement);
        if (!skipSymbolIndex && !JSReferenceCompletionContributor.processAllIndexedSymbols(processor, project, scope)) {
            return false;
        }
        if (DialectDetector.isActionScript(referenceElement)) {
            return true;
        }
        return JSReferenceCompletionContributor.processImplicitElements(processor, project, scope);
    }

    public static boolean processElementsInInjectedContext(JSCompletionProcessor processor, PsiFile file) {
        return JSResolveUtil.tryProcessAllElementsInInjectedContext(file, (Processor<JSPsiElementBase>)((Processor)base -> processor.doAdd((JSPsiElementBase)base)));
    }

    public static boolean processImplicitElements(final JSCompletionProcessor processor, Project project, GlobalSearchScope scope) {
        return BaseJSSymbolProcessor.processImplicitElementProxies(null, scope, project, new BaseJSSymbolProcessor.JSSymbolProcessor(){

            @Override
            public boolean acceptsFile(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public boolean process(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                return processor.doAdd(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptsFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean processCompeteMatchedElements(@NotNull VariantsProcessor processor) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(8);
        }
        JSTypeInfo typeInfo = processor.getTypeInfo();
        boolean globalAdded = false;
        for (JSContextLevel level : typeInfo.myContextLevels) {
            globalAdded |= level.myNamespace.getQualifiedName() == null;
        }
        ArrayList contextLevels = typeInfo.myContextLevels;
        if (!globalAdded && typeInfo.isGlobalStatusHint()) {
            contextLevels = ContainerUtil.newArrayList(contextLevels);
            JSNamespace namespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("", null), JSContext.UNKNOWN, null, true);
            contextLevels.add(new JSContextLevel(namespace, 0));
        }
        if (typeInfo.isGlobalStatusHint() && typeInfo.isEmpty()) {
            processor.setAddOnlyCompleteMatches(true);
            for (String name : BaseJSSymbolProcessor.GLOBAL_OBJECT_NAMES) {
                contextLevels.add(new JSContextLevel(JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, null, true), 0));
            }
            for (String name : BaseJSSymbolProcessor.GLOBAL_TYPE_NAMES) {
                contextLevels.add(new JSContextLevel(JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, null), JSContext.INSTANCE, null, true), 0));
            }
        }
        GlobalSearchScope allScope = JSResolveUtil.getResolveScope(processor.getContext());
        THashSet visitedNamespaces = new THashSet();
        for (JSContextLevel level : contextLevels) {
            String namespace;
            JSQualifiedName name = level.myNamespace.getQualifiedName();
            String string = namespace = name != null ? name.getQualifiedName() : "";
            if (level.isGlobal() && !visitedNamespaces.add(namespace)) continue;
            PsiFile scopeFile = level.getScopeFile();
            GlobalSearchScope scope = scopeFile != null ? GlobalSearchScope.fileScope((PsiFile)scopeFile) : allScope;
            Collection<JSPsiElementBase> namespaceMembers = JSClassResolver.getInstance().findNamespaceMembers(namespace, scope, scopeFile != null);
            for (JSPsiElementBase element : namespaceMembers) {
                if (!processor.acceptsFile(element.getContainingFile()) || processor.doAdd(element, (JSTypeSubstitutor)level.myNamespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY))) continue;
                return false;
            }
        }
        return true;
    }

    private static TIntHashSet filterIds(Project project, GlobalSearchScope scope, PrefixMatcher matcher) {
        if (matcher.getPrefix().isEmpty()) {
            return null;
        }
        HashSet keys = new HashSet();
        StubIndex.getInstance().processAllKeys(JSSymbolIndex2.KEY, project, s -> {
            if (matcher.prefixMatches(s)) {
                keys.add(s);
            }
            return true;
        });
        TIntHashSet ids = new TIntHashSet();
        for (String key : keys) {
            IdIterator iterator = StubIndex.getInstance().getContainingIds(JSSymbolIndex2.KEY, (Object)key, project, scope);
            while (iterator.hasNext()) {
                ids.add(iterator.next());
            }
        }
        return ids;
    }

    private static boolean processAllIndexedSymbols(@NotNull JSCompletionProcessor processor, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(11);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PrefixMatcher matcher = processor.getPrefixMatcher();
        TIntHashSet ids = JSReferenceCompletionContributor.filterIds(project, scope, matcher);
        MyJSRecursiveWalkingElementVisitor visitor = new MyJSRecursiveWalkingElementVisitor(processor);
        PsiFile targetFile = processor.getTargetFile();
        JSReferenceCompletionContributor.processSymbolsInPsiFile(processor, visitor, targetFile);
        for (FileType fileType : JavaScriptIndex.getFileTypesForJSCompletion()) {
            for (VirtualFile vFile : FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)scope)) {
                PsiFile psi;
                if (!JavaScriptIndex.isAcceptableFile(vFile) || !StubUpdatingIndex.canHaveStub((VirtualFile)vFile) || ids != null && vFile instanceof VirtualFileWithId && !ids.contains(((VirtualFileWithId)vFile).getId()) || (psi = psiManager.findFile(vFile)) == null || psi == targetFile || !processor.acceptsFile(psi) || JSReferenceCompletionContributor.processSymbolsInPsiFile(processor, visitor, psi)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean processSymbolsInPsiFile(@NotNull JSCompletionProcessor processor, MyJSRecursiveWalkingElementVisitor visitor, PsiFile psi) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(12);
        }
        List stubbedRoots = StubTreeBuilder.getStubbedRoots((FileViewProvider)psi.getViewProvider());
        for (Pair stubbedRoot : stubbedRoots) {
            PsiFile root = (PsiFile)stubbedRoot.second;
            StubTree tree = ((PsiFileImpl)root).getStubTree();
            if (tree != null) {
                for (StubElement stubElement : tree.getPlainList()) {
                    PsiElement psiElement;
                    IStubElementType type = stubElement.getStubType();
                    if (!(type instanceof JSStubElementType) || JSReferenceCompletionContributor.processElement(processor, (JSElement)(psiElement = stubElement.getPsi()), (JSStubElementType)type)) continue;
                    return false;
                }
                continue;
            }
            root.accept((PsiElementVisitor)visitor);
        }
        return true;
    }

    private static <PsiT extends JSElement> boolean processElement(JSCompletionProcessor processor, PsiT element, JSStubElementType<?, PsiT> type) {
        if (element instanceof JSFunctionExpression) {
            return true;
        }
        if (element instanceof JSPsiElementBase && !StringUtil.isEmpty((String)element.getName()) && type.shouldIndexSymbol(element) && !processor.doAdd((JSPsiElementBase)element)) {
            return false;
        }
        if (element instanceof JSImplicitElementProvider) {
            Collection elements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                for (JSImplicitElement implicitElement : elements) {
                    if (!(implicitElement instanceof JSIndexableImplicitElement) || JSElementIndexingDataStructureImpl.indexImplicitElement(((JSIndexableImplicitElement)implicitElement).getStructure(), null) || processor.doAdd((JSPsiElementBase)implicitElement)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcPropertyNameReferenceVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processIndexedSymbols";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processCompeteMatchedElements";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllIndexedSymbols";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processSymbolsInPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyJSRecursiveWalkingElementVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSCompletionProcessor myProcessor;

        public MyJSRecursiveWalkingElementVisitor(JSCompletionProcessor processor) {
            this.myProcessor = processor;
        }

        public void visitElement(PsiElement element) {
            IElementType type;
            ASTNode node = element.getNode();
            IElementType iElementType = type = node != null ? node.getElementType() : null;
            if (type instanceof JSStubElementType && ((JSStubElementType)type).shouldCreateStub(node) && !JSReferenceCompletionContributor.processElement(this.myProcessor, (JSElement)element, (JSStubElementType)type)) {
                this.stopWalking();
            }
            super.visitElement(element);
        }
    }
}

